/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.config.ConfigUtilities;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.AbstractOverlayDataAction;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.RectangleOverlayMPR;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.util.message.Message;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class USRegionDataAction
extends AbstractOverlayDataAction {
    public static final String ID = "US_REGIONS";
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0.###");

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new USRegionAction(pDataScope, pDataProvider);
    }

    @Override
    public String getID() {
        return ID;
    }

    private class USRegionAction
    extends AbstractOverlayDataAction.AbstractOverlayAction {
        USRegionAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(USRegionDataAction.this, pDataScope, pDataProvider);
        }

        @Override
        public String getCaption() {
            return "US Region";
        }

        @Override
        public String getToolTipText() {
            return "Draw all US regions";
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(85);
        }

        @Override
        public boolean isAvailable() {
            return ConfigUtilities.isDebug();
        }

        protected Collection<Overlay> getOverlaysToBeAdded(View view) {
            ArrayList<Overlay> arrayList = new ArrayList<Overlay>(3);
            Sequence sequence = view.getImageInformation().getDataset().getSequence(1597457);
            if (sequence == null) {
                Message.info("Tag 'Sequence of Ultrasound Regions' missing.");
            } else {
                int n = 0;
                while (n < sequence.size()) {
                    Attributes attributes = (Attributes)sequence.get(n);
                    if (attributes.getInt(1597476, 0) == 3 && attributes.getInt(1597478, 0) == 3) {
                        int n2 = attributes.getInt(1597464, 0);
                        int n3 = attributes.getInt(1597466, 0);
                        int n4 = attributes.getInt(1597468, 0);
                        int n5 = attributes.getInt(1597470, 0);
                        RectangleOverlayMPR rectangleOverlayMPR = new RectangleOverlayMPR(n2, n3, n4 - n2, n5 - n3, AnnotationUnits.Pixel, true, false);
                        rectangleOverlayMPR.setEditable(false);
                        rectangleOverlayMPR.setSaved(true);
                        rectangleOverlayMPR.setColor(Color.orange);
                        arrayList.add(rectangleOverlayMPR);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("PixelSizeX = ");
                        stringBuilder.append(NUMBER_FORMAT.format(attributes.getDouble(1597484, 0.0)));
                        stringBuilder.append(" cm");
                        stringBuilder.append('\n');
                        stringBuilder.append("PixelSizeY = ");
                        stringBuilder.append(NUMBER_FORMAT.format(attributes.getDouble(1597486, 0.0)));
                        stringBuilder.append(" cm");
                        TextOverlay textOverlay = new TextOverlay(n2, n3, 0.0, 0.0, stringBuilder.toString(), "", AnnotationUnits.Pixel, true, null, null);
                        textOverlay.setEditable(false);
                        textOverlay.setSaved(true);
                        arrayList.add(textOverlay);
                    }
                    ++n;
                }
                if (arrayList.isEmpty()) {
                    Message.info("No US region with unit 'cm' present.");
                }
            }
            return arrayList;
        }
    }
}

