/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.tiani.jvision.overlay.OverlaySynchronizationMode;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SyncablePresentationObjectList
implements Iterable<SyncablePresentationObject> {
    private final List<SyncablePresentationObject> allElements;
    private final List<SyncablePresentationObject> syncedElements;
    private OverlaySynchronizationMode mode;

    SyncablePresentationObjectList(OverlaySynchronizationMode overlaySynchronizationMode) {
        if (overlaySynchronizationMode == null) {
            throw new IllegalArgumentException("No synchronization mode given.");
        }
        this.allElements = new ArrayList<SyncablePresentationObject>();
        this.syncedElements = new ArrayList<SyncablePresentationObject>();
        this.mode = overlaySynchronizationMode;
    }

    @Override
    public Iterator<SyncablePresentationObject> iterator() {
        return this.syncedElements.iterator();
    }

    List<SyncablePresentationObject> getAllElements() {
        return new ArrayList<SyncablePresentationObject>(this.allElements);
    }

    void remove(SyncablePresentationObject syncablePresentationObject) {
        this.allElements.remove(syncablePresentationObject);
        this.syncedElements.remove(syncablePresentationObject);
        if (this.getTotalSize() < 2) {
            this.allElements.clear();
            this.syncedElements.clear();
        }
    }

    void add(SyncablePresentationObject syncablePresentationObject) {
        this.allElements.add(syncablePresentationObject);
        this.syncedElements.add(syncablePresentationObject);
    }

    void activateSynchronization(SyncablePresentationObject syncablePresentationObject) {
        if (this.allElements.contains(syncablePresentationObject) && !this.syncedElements.contains(syncablePresentationObject)) {
            if (!this.syncedElements.isEmpty()) {
                this.mode.resetOverlayPoints(this.syncedElements.get(0), syncablePresentationObject);
            }
            this.syncedElements.add(syncablePresentationObject);
        }
    }

    void deactivateSynchronization(SyncablePresentationObject syncablePresentationObject) {
        this.syncedElements.remove(syncablePresentationObject);
    }

    boolean contains(SyncablePresentationObject syncablePresentationObject) {
        return this.allElements.contains(syncablePresentationObject);
    }

    boolean isSynchronizationActive(SyncablePresentationObject syncablePresentationObject) {
        return this.syncedElements.contains(syncablePresentationObject);
    }

    int getTotalSize() {
        return this.allElements.size();
    }

    OverlaySynchronizationMode getMode() {
        return this.mode;
    }

    void setMode(OverlaySynchronizationMode overlaySynchronizationMode) throws IllegalArgumentException {
        if (overlaySynchronizationMode == null) {
            throw new IllegalArgumentException("No synchronization mode given.");
        }
        if (this.getTotalSize() > 0 && overlaySynchronizationMode != this.mode) {
            throw new IllegalArgumentException("Synchronization mode mismatch (expected: " + (Object)((Object)overlaySynchronizationMode) + ", was: " + (Object)((Object)this.mode) + ')');
        }
        this.mode = overlaySynchronizationMode;
    }
}

