/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.statistics.IStatisticsChartData;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.OverlayInformation;
import com.tiani.jvision.overlay.OverlayInformationID;
import com.tiani.jvision.overlay.SyncableShutterPresentationObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class StatisticsPresentationObject
extends SyncableShutterPresentationObject
implements IStatisticsChartData {
    private IImageRegionProperties stats;
    private final List<IStatisticsListener> listeners = new CopyOnWriteArrayList<IStatisticsListener>();
    private boolean isRemoveable = true;

    public StatisticsPresentationObject(String string) {
        super(string);
    }

    @Override
    protected IImageRegionProperties updateHistogram(ImageRegion imageRegion) {
        this.stats = super.updateHistogram(imageRegion);
        for (IStatisticsListener iStatisticsListener : this.listeners) {
            iStatisticsListener.statisticsUpdated();
        }
        return this.stats;
    }

    public void addStatisticsListener(IStatisticsListener iStatisticsListener) {
        this.listeners.add(iStatisticsListener);
    }

    public void removeStatisticsListener(IStatisticsListener iStatisticsListener) {
        this.listeners.remove(iStatisticsListener);
    }

    @Override
    public IImageRegionProperties getStatistics() {
        if (this.stats == null) {
            return IImageRegionProperties.INVALID;
        }
        return this.stats;
    }

    protected OverlayInformation createAreaInformation(double d) {
        String string = this.dimensionUnit();
        if (!string.trim().isEmpty()) {
            string = String.valueOf(string) + "2";
        }
        OverlayInformation overlayInformation = this.stats.getHistogram() != null ? (this.dimensionUnit().equalsIgnoreCase(SpacingDef.Unit.pix.name()) ? new OverlayInformation(OverlayInformationID.AREA_PIXEL, Messages.getString("ROI_LEGEND_AREA"), this.stats.getHistogram().getPixelCount(), String.valueOf(SpacingDef.Unit.pix.name()) + "2") : new OverlayInformation(OverlayInformationID.AREA, Messages.getString("ROI_LEGEND_AREA"), d, string, new OverlayInformation(OverlayInformationID.AREA_PIXEL, this.stats.getHistogram().getPixelCount(), String.valueOf(SpacingDef.Unit.pix.name()) + "2"))) : new OverlayInformation(OverlayInformationID.AREA, Messages.getString("ROI_LEGEND_AREA"), d, string);
        return overlayInformation;
    }

    protected IOverlayInformation createOverlayInformation(OverlayInformationID overlayInformationID, double d) {
        return new OverlayInformation(overlayInformationID, d, this.dimensionUnit());
    }

    @Override
    public boolean isRemoveable() {
        return this.isRemoveable;
    }

    public void setRemovable(boolean bl) {
        this.isRemoveable = bl;
    }

    public boolean isUsableForStatisticsDiagram() {
        return this.supportsHistogram();
    }

    public static interface IStatisticsListener {
        public void statisticsUpdated();
    }
}

