/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.module.ps.ShutterShape;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.jvision.overlay.BMPShutter;
import com.tiani.jvision.overlay.BinBMPShutter;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.IMeasurementOverlay;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.OverlayInformationID;
import com.tiani.jvision.overlay.OverlayLengthInformation;
import com.tiani.jvision.overlay.PointSequence;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.Shutter;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.TranslationHandle;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public class PolygonOverlay
extends StatisticsPresentationObject
implements PointSequence,
IGraphicObjectContainer,
IMeasurementOverlay {
    protected double[] xp;
    protected double[] yp;
    protected int pointCount;
    protected int[] xpi;
    protected int[] ypi;
    protected int cx;
    protected int cy;
    protected BitSet invisibleEdges;
    protected boolean closed = false;
    private ImageRegion ir = new ImageRegion(this);
    private double a;
    private double u;

    public PolygonOverlay() {
        super("Polygon");
    }

    public PolygonOverlay(String string) {
        super(string);
    }

    public PolygonOverlay(double[] dArray, double[] dArray2, AnnotationUnits annotationUnits, boolean bl) {
        this(dArray, dArray2, annotationUnits, bl, false, true);
    }

    public PolygonOverlay(double[] dArray, double[] dArray2, AnnotationUnits annotationUnits, boolean bl, boolean bl2, boolean bl3) {
        this();
        this.setShutterMode(bl2);
        if (!bl2) {
            this.setSolid(bl);
        } else {
            this.setSolid(false);
        }
        this.xp = dArray;
        this.yp = dArray2;
        boolean bl4 = this.closed = this.xp.length != 1 && this.xp[0] == this.xp[this.xp.length - 1] && this.yp[0] == this.yp[this.yp.length - 1];
        if (this.closed) {
            this.xp = new double[this.xp.length - 1];
            this.yp = new double[this.yp.length - 1];
            System.arraycopy(dArray, 0, this.xp, 0, this.xp.length);
            System.arraycopy(dArray2, 0, this.yp, 0, this.yp.length);
        }
        if (bl2) {
            this.closed = true;
        }
        this.pointCount = this.xp.length;
        this.xpi = new int[this.xp.length];
        this.ypi = new int[this.xp.length];
        this.setSpacing(annotationUnits);
        this.makeHandles(bl3);
    }

    @Override
    public double[] getXCoordinates() {
        double[] dArray = new double[this.pointCount + (this.isSolid() || this.closed ? 1 : 0)];
        System.arraycopy(this.xp, 0, dArray, 0, this.pointCount);
        if (this.isSolid() || this.closed) {
            dArray[this.pointCount] = dArray[0];
        }
        return dArray;
    }

    @Override
    public double[] getYCoordinates() {
        double[] dArray = new double[this.pointCount + (this.isSolid() || this.closed ? 1 : 0)];
        System.arraycopy(this.yp, 0, dArray, 0, this.pointCount);
        if (this.isSolid() || this.closed) {
            dArray[this.pointCount] = dArray[0];
        }
        return dArray;
    }

    @Override
    public int getPointCount() {
        return this.pointCount + (this.isSolid() || this.closed ? 1 : 0);
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.makeHandles();
    }

    @Override
    public boolean isROI() {
        return !this.isShutter();
    }

    protected void makeHandles() {
        this.makeHandles(true);
    }

    protected void makeHandles(boolean bl) {
        this.cx = 0;
        this.cy = 0;
        if (this.pointCount == 0) {
            this.handles = new PresentationHandle[]{new TranslationHandle(this.cx, this.cy)};
            return;
        }
        this.handles = new PresentationHandle[bl ? this.pointCount + 1 : 1];
        int n = 0;
        while (n < this.pointCount) {
            if (bl) {
                this.handles[n] = new PresentationHandle(this.xpi[n], this.ypi[n]);
            }
            this.cx += this.xpi[n];
            this.cy += this.ypi[n];
            ++n;
        }
        this.cx /= this.pointCount;
        this.cy /= this.pointCount;
        this.handles[bl ? this.pointCount : 0] = new TranslationHandle(this.cx, this.cy);
    }

    @Override
    protected void toScreen() {
        double[] dArray = new double[2];
        this.cx = 0;
        this.cy = 0;
        int n = 100000;
        int n2 = 100000;
        int n3 = -100000;
        int n4 = -100000;
        int n5 = 0;
        while (n5 < this.pointCount) {
            dArray[0] = this.xp[n5];
            dArray[1] = this.yp[n5];
            dArray = this.toScreen(dArray);
            this.xpi[n5] = (int)(dArray[0] + 0.5);
            this.ypi[n5] = (int)(dArray[1] + 0.5);
            this.cx += this.xpi[n5];
            this.cy += this.ypi[n5];
            if (this.xpi[n5] > n4) {
                n4 = this.xpi[n5];
            }
            if (this.ypi[n5] > n3) {
                n3 = this.ypi[n5];
            }
            if (this.xpi[n5] < n2) {
                n2 = this.xpi[n5];
            }
            if (this.ypi[n5] < n) {
                n = this.ypi[n5];
            }
            ++n5;
        }
        this.cx /= this.pointCount;
        this.cy /= this.pointCount;
        n5 = 0;
        while (n5 < this.handles.length) {
            PresentationHandle presentationHandle = this.handles[n5];
            if (presentationHandle.isTranslationHandle()) {
                presentationHandle.setPosition(this.cx, this.cy);
            } else {
                presentationHandle.setPosition(this.xpi[n5], this.ypi[n5]);
            }
            ++n5;
        }
        this.translationHandleIndex = this.pointCount;
        this.bounds.x = n2 - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = n - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = n4 - n2 + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = n3 - n + 2 * PresentationHandle.HANDLE_SIZE;
        if (this.ownedCompanions != null && this.ownedCompanions.length > 0 && this.ownedCompanions[0] != null && this.spacingType == AnnotationUnits.Pixel) {
            double d;
            this.u = 0.0;
            this.a = 0.0;
            double d2 = this.getDataPixelSizeX();
            double d3 = this.getDataPixelSizeY();
            int n6 = 1;
            while (n6 < this.pointCount) {
                double d4 = this.xp[n6] - this.xp[n6 - 1];
                d = this.yp[n6] - this.yp[n6 - 1];
                this.u += Math.sqrt(d4 * d4 * d2 * d2 + d * d * d3 * d3);
                if (this.closed) {
                    this.a += this.xp[n6 - 1] * d2 * this.yp[n6] * d3 - this.yp[n6 - 1] * d2 * this.xp[n6] * d3;
                }
                ++n6;
            }
            if (this.closed) {
                double d5 = this.xp[this.pointCount - 1] - this.xp[0];
                d = this.yp[this.pointCount - 1] - this.yp[0];
                this.u += Math.sqrt(d5 * d5 * d2 * d2 + d * d * d3 * d3);
                this.a += this.xp[this.pointCount - 1] * d2 * d3 * this.yp[0] - this.yp[this.pointCount - 1] * this.xp[0] * d2 * d3;
            }
            this.a = Math.abs(this.a / 2.0);
            if (this.closed) {
                if (this.pointCount > 2 && this.shapeChanged && this.getImageState().window != null) {
                    this.shapeChanged = false;
                    IImageRegionProperties iImageRegionProperties = this.updateHistogram(this.ir);
                    ArrayList<IOverlayInformation> arrayList = new ArrayList<IOverlayInformation>();
                    arrayList.add(this.createAreaInformation(this.a));
                    arrayList.add(this.createOverlayInformation(OverlayInformationID.PERIMETER, this.u));
                    this.setNonEditableAnnotation(arrayList, iImageRegionProperties);
                }
            } else {
                OverlayLengthInformation overlayLengthInformation = new OverlayLengthInformation(this.u, this.dimensionUnit());
                this.setNonEditableAnnotation(Collections.singletonList(overlayLengthInformation), null);
            }
        }
        if (this.isShutter()) {
            if (this.shutterMask == null) {
                this.shutterMask = new BMPShutter(this.shutterValue);
            }
            this.shutterMask.update(this);
        }
    }

    public void setShutterMask(Shutter shutter) {
        this.shutterMask = shutter;
    }

    protected float getOpacity() {
        return 0.5f;
    }

    protected Color getSolidOutlineColor() {
        return solidOutlineColor;
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder, boolean bl) {
        if (this.isShutter() && (!this.isSelected() && this.isCompleted() || this.shutterMask instanceof BinBMPShutter)) {
            this.shutterMask.applyShutter(bufferedImageHolder.getImageArray(), bufferedImageHolder.width, bufferedImageHolder.height);
            if (!Shutter.displayOutline) {
                return;
            }
        }
        if (this.xpi != null) {
            if (bl && this.closed) {
                Color color = bufferedImageHolder.graphics.getColor();
                boolean bl2 = bufferedImageHolder.graphics.getComposite() instanceof AlphaComposite;
                if (bl2) {
                    bufferedImageHolder.graphics.setComposite(AlphaComposite.getInstance(3, this.getOpacity()));
                }
                bufferedImageHolder.graphics.fillPolygon(this.xpi, this.ypi, this.pointCount);
                if (bl2) {
                    bufferedImageHolder.graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
                }
                bufferedImageHolder.graphics.setColor(this.getSolidOutlineColor());
                if (this.invisibleEdges == null) {
                    bufferedImageHolder.graphics.drawPolygon(this.xpi, this.ypi, this.pointCount);
                } else {
                    this.drawPolygon(bufferedImageHolder);
                }
                bufferedImageHolder.graphics.setColor(color);
                bufferedImageHolder.graphics.setPaintMode();
            } else {
                this.paintOutlineOrOpenShape(bufferedImageHolder);
            }
        }
    }

    public void paintOutlineOrOpenShape(BufferedImageHolder bufferedImageHolder) {
        PolygonOverlay.paintOutlineOrOpenShape(bufferedImageHolder, this.objCol, this.xpi, this.ypi, this.pointCount, this.invisibleEdges, this.closed, this.isUseOutlineFont(), this.initStep > 2, this.lastx, this.lasty, this.getSnapHandleSize());
    }

    protected static void paintClosedShaped(BufferedImageHolder bufferedImageHolder, Color color, int[] nArray, int[] nArray2, int n) {
        PolygonOverlay.paintOutlineOrOpenShape(bufferedImageHolder, color, nArray, nArray2, nArray.length, null, true, true, false, 0, 0, n);
    }

    private static void paintOutlineOrOpenShape(BufferedImageHolder bufferedImageHolder, Color color, int[] nArray, int[] nArray2, int n, BitSet bitSet, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4) {
        Color color2 = bufferedImageHolder.graphics.getColor();
        if (bl2) {
            bufferedImageHolder.graphics.setColor(Color.black);
            int n5 = 1;
            while (n5 < n) {
                if (bitSet == null || !bitSet.get(n5 - 1)) {
                    if (nArray[n5] != nArray[n5 - 1] && Math.abs(nArray2[n5] - nArray2[n5 - 1]) / Math.abs(nArray[n5] - nArray[n5 - 1]) < 1) {
                        bufferedImageHolder.graphics.drawLine(nArray[n5 - 1], nArray2[n5 - 1] - 1, nArray[n5], nArray2[n5] - 1);
                        bufferedImageHolder.graphics.drawLine(nArray[n5 - 1], nArray2[n5 - 1] + 1, nArray[n5], nArray2[n5] + 1);
                    } else {
                        bufferedImageHolder.graphics.drawLine(nArray[n5 - 1] - 1, nArray2[n5 - 1], nArray[n5] - 1, nArray2[n5]);
                        bufferedImageHolder.graphics.drawLine(nArray[n5 - 1] + 1, nArray2[n5 - 1], nArray[n5] + 1, nArray2[n5]);
                    }
                }
                ++n5;
            }
            if (bl3) {
                bufferedImageHolder.graphics.setColor(color2);
                Rectangle rectangle = new Rectangle(nArray[0] - (n4 >> 1), nArray2[0] - (n4 >> 1), n4, n4);
                bufferedImageHolder.graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (rectangle.contains(n2, n3)) {
                    bufferedImageHolder.graphics.fillRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 3, rectangle.height - 3);
                }
                bufferedImageHolder.graphics.setColor(Color.black);
                bufferedImageHolder.graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
                bufferedImageHolder.graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
                bufferedImageHolder.graphics.setColor(color2);
            }
            if (bl && (bitSet == null || !bitSet.get(n - 1))) {
                if (nArray[0] != nArray[n - 1] && Math.abs(nArray2[0] - nArray2[n - 1]) / Math.abs(nArray[0] - nArray[n - 1]) < 1) {
                    bufferedImageHolder.graphics.drawLine(nArray[0], nArray2[0] - 1, nArray[n - 1], nArray2[n - 1] - 1);
                    bufferedImageHolder.graphics.drawLine(nArray[0], nArray2[0] + 1, nArray[n - 1], nArray2[n - 1] + 1);
                } else {
                    bufferedImageHolder.graphics.drawLine(nArray[0] - 1, nArray2[0], nArray[n - 1] - 1, nArray2[n - 1]);
                    bufferedImageHolder.graphics.drawLine(nArray[0] + 1, nArray2[0], nArray[n - 1] + 1, nArray2[n - 1]);
                }
            }
            bufferedImageHolder.graphics.setColor(color);
        }
        PolygonOverlay.drawPolygon(bufferedImageHolder, nArray, nArray2, n, bitSet, bl);
        bufferedImageHolder.graphics.setColor(color2);
    }

    private void drawPolygon(BufferedImageHolder bufferedImageHolder) {
        PolygonOverlay.drawPolygon(bufferedImageHolder, this.xpi, this.ypi, this.pointCount, this.invisibleEdges, this.closed);
    }

    private static void drawPolygon(BufferedImageHolder bufferedImageHolder, int[] nArray, int[] nArray2, int n, BitSet bitSet, boolean bl) {
        int n2 = 0;
        while (n2 < n - 1) {
            if (bitSet == null || !bitSet.get(n2)) {
                bufferedImageHolder.graphics.drawLine(nArray[n2], nArray2[n2], nArray[n2 + 1], nArray2[n2 + 1]);
            }
            ++n2;
        }
        if (bl && (bitSet == null || !bitSet.get(n - 1))) {
            bufferedImageHolder.graphics.drawLine(nArray[0], nArray2[0], nArray[n - 1], nArray2[n - 1]);
        }
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        if (!this.isCompleted() && n == this.pointCount) {
            --n;
        }
        if (n == this.pointCount || this.handles.length == 1) {
            double[] dArray2 = this.toImage(this.cx, this.cy);
            double[] dArray3 = new double[]{dArray[0] - dArray2[0], dArray[1] - dArray2[1]};
            int n2 = 0;
            while (n2 < this.pointCount) {
                int n3 = n2;
                this.xp[n3] = this.xp[n3] + dArray3[0];
                int n4 = n2++;
                this.yp[n4] = this.yp[n4] + dArray3[1];
            }
            this.toScreen();
        } else {
            this.xp[n] = dArray[0];
            this.yp[n] = dArray[1];
            this.toScreen();
        }
        this.setSaved(false);
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        double[] dArray2;
        if (this.xp == null) {
            this.xp = new double[100];
            this.yp = new double[100];
            this.xpi = new int[100];
            this.ypi = new int[100];
        }
        if (this.pointCount == this.xp.length) {
            dArray2 = new double[this.pointCount + 100];
            double[] dArray3 = new double[this.pointCount + 100];
            int[] nArray = new int[this.pointCount + 100];
            int[] nArray2 = new int[this.pointCount + 100];
            int n2 = 0;
            while (n2 < this.pointCount) {
                dArray2[n2] = this.xp[n2];
                dArray3[n2] = this.yp[n2];
                nArray[n2] = this.xpi[n2];
                nArray2[n2] = this.ypi[n2];
                ++n2;
            }
            this.xp = dArray2;
            this.yp = dArray3;
            this.xpi = nArray;
            this.ypi = nArray2;
        }
        dArray2 = this.toScreen(dArray);
        double d = dArray2[0];
        double d2 = dArray2[1];
        int n3 = this.getSnapHandleSize();
        if (this.pointCount > 2 && ((this.closed = Math.abs((double)this.xpi[0] - d) < (double)(n3 / 2) && Math.abs((double)this.ypi[0] - d2) < (double)(n3 / 2)) || Math.abs((double)this.xpi[this.pointCount - 2] - d) < (double)(n3 / 2) && Math.abs((double)this.ypi[this.pointCount - 2] - d2) < (double)(n3 / 2))) {
            --this.pointCount;
            if (Math.abs((double)this.xpi[this.pointCount - 1] - d) < (double)(n3 / 2) && Math.abs((double)this.ypi[this.pointCount - 1] - d2) < (double)(n3 / 2) && (this.isSolid() || this.isShutter())) {
                this.closed = true;
            }
            this.makeHandles();
            TextOverlay textOverlay = this.createAnnotation();
            if (this.closed && textOverlay != null) {
                textOverlay.setVisible(PolygonOverlay.getTextAnnotationLevel().isTextAnnotationVisible());
            }
            return -1;
        }
        if (this.pointCount > 0) {
            this.xp[this.pointCount - 1] = dArray[0];
            this.yp[this.pointCount - 1] = dArray[1];
        }
        this.xp[this.pointCount] = dArray[0];
        this.yp[this.pointCount] = dArray[1];
        this.handles = Arrays.copyOf(this.handles, this.handles.length + 1);
        this.handles[this.handles.length - 1] = this.handles[this.handles.length - 2];
        this.handles[this.handles.length - 2] = new PresentationHandle(0, 0);
        ++this.pointCount;
        this.toScreen();
        this.activeHandleIndex = this.pointCount - 1;
        return n + 1;
    }

    @Override
    protected boolean splitDragged() {
        return false;
    }

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(80, "ROI");
    }

    @Override
    public boolean supportsHistogram() {
        return this.closed;
    }

    @Override
    public boolean isInside(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.pointCount) {
            int n5 = (n4 + 1) % this.pointCount;
            if (this.yp[n4] < (double)n2 && this.yp[n5] >= (double)n2 || this.yp[n5] < (double)n2 && this.yp[n4] >= (double)n2) {
                if (this.xp[n4] == this.xp[n5]) {
                    if (this.xp[n4] <= (double)n) {
                        ++n3;
                    }
                } else if (this.xp[n4] <= (double)n && this.xp[n5] <= (double)n) {
                    ++n3;
                } else {
                    double d = (this.xp[n5] - this.xp[n4]) / (this.yp[n5] - this.yp[n4]);
                    if (this.xp[n4] + d * ((double)n2 - this.yp[n4]) <= (double)n) {
                        ++n3;
                    }
                }
            }
            ++n4;
        }
        return n3 & true;
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(1);
        int n = this.pointCount;
        if (this.closed) {
            ++n;
        }
        ArrayList<Float> arrayList2 = new ArrayList<Float>();
        float[] fArray = new float[n * 2];
        int n2 = 0;
        while (n2 < this.pointCount) {
            arrayList2.add(new Float(this.xp[n2]));
            arrayList2.add(new Float(this.yp[n2]));
            fArray[n2 * 2] = (float)this.xp[n2];
            fArray[n2 * 2 + 1] = (float)this.yp[n2];
            ++n2;
        }
        if (this.closed) {
            arrayList2.add(new Float(this.xp[0]));
            arrayList2.add(new Float(this.yp[0]));
            fArray[this.pointCount * 2] = (float)this.xp[0];
            fArray[this.pointCount * 2 + 1] = (float)this.yp[0];
        }
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setGraphicType(GraphicType.PolyLine);
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(n));
        graphicObject.setGraphicData(fArray);
        arrayList.add(graphicObject);
        return arrayList;
    }

    @Override
    public DisplayShutterModule getDisplayShutterModule() {
        if (this.shutterMask instanceof BMPShutter) {
            int[] nArray = new int[this.pointCount * 2];
            int n = 0;
            while (n < this.pointCount) {
                nArray[2 * n] = (int)this.yp[n];
                nArray[2 * n + 1] = (int)this.xp[n];
                ++n;
            }
            DisplayShutterModule displayShutterModule = new DisplayShutterModule();
            if (this.shutterMask != null) {
                displayShutterModule.setShutterPresentationValue(Integer.valueOf(this.shutterMask.getShutterValue()));
            }
            displayShutterModule.shutterShapes().add(ShutterShape.Polygonal);
            displayShutterModule.setVerticesOfPolygonalShutter(nArray);
            displayShutterModule.hasContent(true);
            return displayShutterModule;
        }
        return null;
    }

    @Override
    public boolean hasDisplayShutterModule() {
        return true;
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            super.cloneReferences(presentationObject);
            PolygonOverlay polygonOverlay = (PolygonOverlay)presentationObject;
            polygonOverlay.ir = new ImageRegion(polygonOverlay);
            polygonOverlay.setClonedParameters(ReferencedObjectsCloning.clone(this.xp), ReferencedObjectsCloning.clone(this.yp), ReferencedObjectsCloning.clone(this.xpi), ReferencedObjectsCloning.clone(this.ypi));
        }
        catch (Exception exception) {
            log.error("clone error", (Throwable)exception);
        }
        return presentationObject;
    }

    public void setClonedParameters(double[] dArray, double[] dArray2, int[] nArray, int[] nArray2) {
        this.xp = dArray;
        this.yp = dArray2;
        this.xpi = nArray;
        this.ypi = nArray2;
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) {
        PolygonOverlay polygonOverlay = (PolygonOverlay)iTransformableOverlay;
        double[] dArray = new double[2];
        int n = 0;
        while (n < polygonOverlay.xp.length) {
            dArray[0] = polygonOverlay.xp[n];
            dArray[1] = polygonOverlay.yp[n];
            dArray = iOverlayPointModifier.convert(dArray);
            this.xp[n] = dArray[0];
            this.yp[n] = dArray[1];
            ++n;
        }
    }

    @Override
    public double getMeasurementResult() {
        if (this.closed) {
            return this.a;
        }
        return this.u;
    }

    protected void createBoundingShape() {
        if (this.pointCount == 0) {
            return;
        }
        this.toScreen();
        Polygon polygon = new Polygon(this.xpi, this.ypi, this.pointCount);
        if (!this.closed) {
            polygon.addPoint(this.xpi[0], this.ypi[0]);
        }
        if (!this.isSolid()) {
            if (this.closed) {
                polygon.addPoint(this.xpi[0], this.ypi[0]);
            }
            int n = this.pointCount - 1;
            while (n > -1) {
                polygon.addPoint(this.xpi[n], this.ypi[n]);
                --n;
            }
        }
        this.outBounds = Collections.singletonList(polygon);
    }

    @Override
    public boolean inBounds(int n, int n2) {
        boolean bl = false;
        if (this.isSelected()) {
            bl = this.isHandleClicked(n, n2);
        }
        if (!bl) {
            this.createBoundingShape();
            return super.inBounds(n, n2);
        }
        return bl;
    }

    @Override
    public boolean isInterceptionAt(int n) {
        return false;
    }
}

