/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.IHandlePositionModifier;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayTransformationException;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public enum OverlaySynchronizationMode {
    OFF(false){

        @Override
        IOverlayPointModifier getOverlayPointModifier(PresentationObject presentationObject, View view) {
            return null;
        }

        @Override
        IHandlePositionModifier getHandlePositionModifier(PresentationObject presentationObject, double[] dArray) {
            return null;
        }
    }
    ,
    IMAGE_COORDINATES(true){

        @Override
        IOverlayPointModifier getOverlayPointModifier(PresentationObject presentationObject, View view) {
            return null;
        }

        @Override
        IHandlePositionModifier getHandlePositionModifier(PresentationObject presentationObject, double[] dArray) {
            return new IdentityHandlePositionModifier(dArray);
        }
    }
    ,
    WORLD_COORDINATES(true){

        @Override
        IOverlayPointModifier getOverlayPointModifier(PresentationObject presentationObject, View view) {
            return new WorldCoordinateOverlayPointModifier(presentationObject, view);
        }

        @Override
        IHandlePositionModifier getHandlePositionModifier(PresentationObject presentationObject, double[] dArray) {
            return OverlaySynchronizationMode.createWorldCoordinateHandlePositionModifier(presentationObject, dArray);
        }
    };

    private final boolean isSynchronizationActive;

    private OverlaySynchronizationMode(boolean bl) {
        this.isSynchronizationActive = bl;
    }

    public boolean isSynchronizationActive() {
        return this.isSynchronizationActive;
    }

    void resetOverlayPoints(SyncablePresentationObject syncablePresentationObject, SyncablePresentationObject syncablePresentationObject2) {
        IOverlayPointModifier iOverlayPointModifier = this.getOverlayPointModifier(syncablePresentationObject, syncablePresentationObject2.getView());
        if (iOverlayPointModifier == null) {
            iOverlayPointModifier = new IdentityOverlayPointModifier();
        }
        this.updateOverlayPointsImpl(syncablePresentationObject, syncablePresentationObject2, iOverlayPointModifier);
    }

    void updateOverlayPoints(SyncablePresentationObject syncablePresentationObject, SyncablePresentationObject syncablePresentationObject2) throws IllegalArgumentException {
        this.updateOverlayPointsImpl(syncablePresentationObject, syncablePresentationObject2, this.getOverlayPointModifier(syncablePresentationObject, syncablePresentationObject2.getView()));
    }

    private void updateOverlayPointsImpl(SyncablePresentationObject syncablePresentationObject, SyncablePresentationObject syncablePresentationObject2, IOverlayPointModifier iOverlayPointModifier) {
        if (iOverlayPointModifier != null) {
            try {
                syncablePresentationObject2.updateOverlayPoints(syncablePresentationObject, iOverlayPointModifier);
                Overlay[] overlayArray = syncablePresentationObject2.getCompanions();
                if (overlayArray != null) {
                    Overlay[] overlayArray2 = overlayArray;
                    int n = overlayArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Overlay overlay;
                        Overlay overlay2 = overlayArray2[n2];
                        if (overlay2 instanceof ITransformableOverlay && overlay2 instanceof PresentationObject && (overlay = OverlaySynchronizationMode.findOverlayByName(syncablePresentationObject.getCompanions(), ((PresentationObject)overlay2).getName())) instanceof ITransformableOverlay) {
                            ((ITransformableOverlay)((Object)overlay2)).updateOverlayPoints((ITransformableOverlay)((Object)overlay), iOverlayPointModifier);
                        }
                        ++n2;
                    }
                }
            }
            catch (OverlayTransformationException overlayTransformationException) {
                syncablePresentationObject2.removeFromSynclist();
                throw new IllegalArgumentException("Unsupported synchronization mode: " + (Object)((Object)this), overlayTransformationException);
            }
        }
    }

    abstract IOverlayPointModifier getOverlayPointModifier(PresentationObject var1, View var2);

    abstract IHandlePositionModifier getHandlePositionModifier(PresentationObject var1, double[] var2);

    private static IHandlePositionModifier createWorldCoordinateHandlePositionModifier(PresentationObject presentationObject, double[] dArray) {
        double[] dArray2 = presentationObject.toScreen(dArray);
        PickingResult pickingResult = presentationObject.getView().getRenderer().pick(dArray2[0], dArray2[1]);
        if (pickingResult == null) {
            return null;
        }
        return new WorldCoordinateHandlePositionModifier(pickingResult);
    }

    private static Overlay findOverlayByName(Overlay[] overlayArray, String string) {
        Overlay[] overlayArray2 = overlayArray;
        int n = overlayArray.length;
        int n2 = 0;
        while (n2 < n) {
            Overlay overlay = overlayArray2[n2];
            if (overlay instanceof PresentationObject && string.equals(((PresentationObject)overlay).getName())) {
                return overlay;
            }
            ++n2;
        }
        return null;
    }

    /* synthetic */ OverlaySynchronizationMode(String string, int n, boolean bl, OverlaySynchronizationMode overlaySynchronizationMode) {
        this(bl);
    }

    private static class IdentityHandlePositionModifier
    implements IHandlePositionModifier {
        private final double[] coords;

        IdentityHandlePositionModifier(double[] dArray) {
            this.coords = dArray;
        }

        @Override
        public double[] convertTo(View view) {
            return this.coords;
        }
    }

    private static class IdentityOverlayPointModifier
    implements IOverlayPointModifier {
        private IdentityOverlayPointModifier() {
        }

        @Override
        public double[] convert(double[] dArray) {
            return dArray;
        }
    }

    private static class WorldCoordinateHandlePositionModifier
    implements IHandlePositionModifier {
        private final PickingResult worldCoordinates;

        public WorldCoordinateHandlePositionModifier(PickingResult pickingResult) {
            this.worldCoordinates = pickingResult;
        }

        @Override
        public double[] convertTo(View view) {
            IImageInformation iImageInformation = view.getFrameData().getImageInformation();
            Vector3d vector3d = this.worldCoordinates.projectToPlane(iImageInformation);
            Vector2d vector2d = PickingResult.worldToImage((Tuple3d)vector3d, iImageInformation);
            return new double[]{vector2d.x, vector2d.y};
        }
    }

    private static class WorldCoordinateOverlayPointModifier
    implements IOverlayPointModifier {
        private final PresentationObject po;
        private final View destView;

        public WorldCoordinateOverlayPointModifier(PresentationObject presentationObject, View view) {
            this.po = presentationObject;
            this.destView = view;
        }

        @Override
        public double[] convert(double[] dArray) {
            IHandlePositionModifier iHandlePositionModifier = OverlaySynchronizationMode.createWorldCoordinateHandlePositionModifier(this.po, dArray);
            if (iHandlePositionModifier == null) {
                return dArray;
            }
            return iHandlePositionModifier.convertTo(this.destView);
        }
    }
}

