/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.AbstractImageOverlay;
import com.tiani.jvision.overlay.BitmapOverlay;
import javax.vecmath.Vector2d;

public class OverlayBitmap
extends AbstractImageOverlay {
    protected static final int bmpc = -1;
    protected static final byte bbmpc = -1;
    protected final BitmapOverlay ovl;
    private String providerUID;

    public OverlayBitmap(BitmapOverlay bitmapOverlay) {
        super(true);
        this.ovl = bitmapOverlay;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OverlayBitmap overlayBitmap = (OverlayBitmap)super.clone();
        return overlayBitmap;
    }

    @Override
    public String getLayerLabel() {
        if (this.ovl.getLabel() == null) {
            return super.getLayerLabel();
        }
        return this.ovl.getLabel();
    }

    public void setProviderUID(String string) {
        this.providerUID = string;
    }

    public String getProviderUID() {
        return this.providerUID;
    }

    @Override
    public void setLayerLabel(String string) {
        this.ovl.setLabel(string);
    }

    public BitmapOverlay getOverlayDefinition() {
        return this.ovl;
    }

    @Override
    public void paint(BufferedImageHolder bufferedImageHolder) {
        if (!this.isVisible()) {
            return;
        }
        Object object = bufferedImageHolder.getImageArray();
        ImageState imageState = this.getImageState();
        Vector2d vector2d = new Vector2d(imageState.cv[0], imageState.cv[1]);
        vector2d.normalize();
        Vector2d vector2d2 = new Vector2d(imageState.rv[0], imageState.rv[1]);
        vector2d2.normalize();
        try {
            int n = this.ovl.getOriginX();
            int n2 = this.ovl.getOriginY();
            int n3 = this.ovl.getColumns();
            int n4 = this.ovl.getRows();
            byte[] byArray = this.ovl.getData().toPackedBits();
            if (byArray.length == 0) {
                log.error("Bad Overlay");
                return;
            }
            int n5 = n3 * 256;
            int n6 = n4 * 256;
            int n7 = this.width;
            int n8 = this.height;
            int n9 = 0;
            int n10 = 0;
            if (object instanceof int[]) {
                int n11 = (int)(imageState.rv[0] * 256.0);
                int n12 = (int)(imageState.rv[1] * 256.0);
                int n13 = (int)(imageState.cv[0] * 256.0);
                int n14 = (int)(imageState.cv[1] * 256.0);
                int[] nArray = (int[])object;
                if (Math.abs(n13) <= 255 && Math.abs(n14) <= 255 || Math.abs(n11) <= 255 && Math.abs(n12) <= 255) {
                    int n15 = (int)((imageState.visOrig[0] - (double)n) * 256.0);
                    int n16 = (int)((imageState.visOrig[1] - (double)n2) * 256.0);
                    int n17 = 0;
                    while (n17 < n8) {
                        int n18 = n15 + n11 * n17;
                        int n19 = n16 + n12 * n17;
                        int n20 = 0;
                        while (n20 < n7) {
                            if (n18 >= 0 && n19 >= 0 && n18 < n5 && n19 < n6 && (byArray[(n10 = (n18 >> 8) + (n19 >> 8) * n3) >> 3] & 1 << (n10 & 7)) != 0) {
                                nArray[n9] = -1;
                            }
                            ++n9;
                            n18 += n13;
                            n19 += n14;
                            ++n20;
                        }
                        n9 += bufferedImageHolder.stride - bufferedImageHolder.width;
                        ++n17;
                    }
                } else {
                    float f = 1.0f;
                    if (vector2d.x != 0.0) {
                        f = (float)((double)f * vector2d.x);
                    }
                    if (vector2d.y != 0.0) {
                        f = (float)((double)f * vector2d.y);
                    }
                    if (vector2d2.x != 0.0) {
                        f = (float)((double)f * vector2d2.x);
                    }
                    if (vector2d2.y != 0.0) {
                        f = (float)((double)f * vector2d2.y);
                    }
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    float f4 = 0.0f;
                    float f5 = 0.0f;
                    if (imageState.rv[0] != 0.0) {
                        f2 = (float)(1.0 / imageState.rv[0]);
                    }
                    if (imageState.rv[1] != 0.0) {
                        f3 = (float)(1.0 / imageState.rv[1]);
                    }
                    if (imageState.cv[0] != 0.0) {
                        f4 = (float)(1.0 / imageState.cv[0]);
                    }
                    if (imageState.cv[1] != 0.0) {
                        f5 = (float)(1.0 / imageState.cv[1]);
                    }
                    float f6 = (float)((double)n - imageState.visOrig[0]);
                    float f7 = (float)((double)n2 - imageState.visOrig[1]);
                    float f8 = f6 * f4 + f7 * (f2 *= f);
                    float f9 = f6 * (f5 *= f) + f7 * f3;
                    int n21 = 0;
                    int n22 = 0;
                    while (n22 < n4) {
                        int n23 = 0;
                        while (n23 < n3) {
                            if ((byArray[n21 >> 3] & 1 << (n21 & 7)) != 0) {
                                int n24 = (int)(f8 + (float)n23 * f4 + (float)n22 * f2 + 0.5f);
                                int n25 = (int)(f9 + (float)n23 * f5 + (float)n22 * f3 + 0.5f);
                                if (n24 >= 0 && n24 < n7 && n25 >= 0 && n25 < n8) {
                                    nArray[n24 + n25 * n7] = -1;
                                }
                            }
                            ++n21;
                            ++n23;
                        }
                        ++n22;
                    }
                }
            } else if (object instanceof byte[] && bufferedImageHolder.locked) {
                int n26 = (int)(imageState.rv[0] * 256.0);
                int n27 = (int)(imageState.rv[1] * 256.0);
                int n28 = (int)(imageState.cv[0] * 256.0);
                int n29 = (int)(imageState.cv[1] * 256.0);
                byte[] byArray2 = (byte[])object;
                if (n28 <= 255 && n29 <= 255 || n26 <= 255 && n27 <= 255) {
                    int n30 = (int)((imageState.visOrig[0] - (double)n) * 256.0);
                    int n31 = (int)((imageState.visOrig[1] - (double)n2) * 256.0);
                    int n32 = 0;
                    while (n32 < n8) {
                        int n33 = n30 + n26 * n32;
                        int n34 = n31 + n27 * n32;
                        int n35 = 0;
                        while (n35 < n7) {
                            if (n33 >= 0 && n34 >= 0 && n33 < n5 && n34 < n6 && (byArray[(n10 = (n33 >> 8) + (n34 >> 8) * n3) >> 3] & 1 << (n10 & 7)) != 0) {
                                byArray2[n9] = -1;
                            }
                            ++n9;
                            n33 += n28;
                            n34 += n29;
                            ++n35;
                        }
                        ++n32;
                    }
                } else {
                    double d = 1.0;
                    if (vector2d.x != 0.0) {
                        d *= vector2d.x;
                    }
                    if (vector2d.y != 0.0) {
                        d *= vector2d.y;
                    }
                    if (vector2d2.x != 0.0) {
                        d *= vector2d2.x;
                    }
                    if (vector2d2.y != 0.0) {
                        d *= vector2d2.y;
                    }
                    int n36 = 0;
                    int n37 = 0;
                    int n38 = 0;
                    int n39 = 0;
                    if (imageState.rv[0] != 0.0) {
                        n36 = (int)(1.0 / imageState.rv[0] * 256.0);
                    }
                    if (imageState.rv[1] != 0.0) {
                        n37 = (int)(1.0 / imageState.rv[1] * 256.0);
                    }
                    if (imageState.cv[0] != 0.0) {
                        n38 = (int)(1.0 / imageState.cv[0] * 256.0);
                    }
                    if (imageState.cv[1] != 0.0) {
                        n39 = (int)(1.0 / imageState.cv[1] * 256.0);
                    }
                    double d2 = (double)n - imageState.visOrig[0];
                    double d3 = (double)n2 - imageState.visOrig[1];
                    n36 = (int)((double)n36 * d);
                    n39 = (int)((double)n39 * d);
                    int n40 = (int)(d2 * (double)n38 + d3 * (double)n36);
                    int n41 = (int)(d2 * (double)n39 + d3 * (double)n37);
                    int n42 = 0;
                    int n43 = 0;
                    while (n43 < n4) {
                        int n44 = 0;
                        while (n44 < n3) {
                            int n45 = n40 + n44 * n38 + n43 * n36 >> 8;
                            int n46 = n41 + n44 * n39 + n43 * n37 >> 8;
                            if (n45 >= 0 && n45 < n7 && n46 >= 0 && n46 < n8 && (byArray[n42 >> 3] & 1 << (n42 & 7)) != 0) {
                                byArray2[n45 + n46 * n7] = -1;
                            }
                            ++n42;
                            ++n44;
                        }
                        ++n43;
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error("OverlayBitmap: There is a problem with the Overlay", (Throwable)exception);
            log.error("ovl.getOriginX() = " + this.ovl.getOriginX());
            log.error("ovl.getOriginY() = " + this.ovl.getOriginY());
            log.error("ovl.getColumns() = " + this.ovl.getColumns());
            log.error("ovl.getRows() = " + this.ovl.getRows());
            log.error("ovl.getData() = " + this.ovl.getData());
            log.error("dataO = " + object);
            log.error("nc " + vector2d.x + " " + vector2d.y + " - nr " + vector2d2.x + " " + vector2d2.y + " - vo " + imageState.visOrig[0] + " " + imageState.visOrig[1]);
            this.setActive(false);
        }
    }
}

