/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.tiani.jvision.overlay.OutlineFontLarge;
import com.tiani.jvision.overlay.OutlineFontSmall;
import com.tiani.jvision.overlay.OverlayConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;

public abstract class OutlineFont {
    private static OutlineFont[] fontCache = new OutlineFont[20];
    private static int fcIndex = 0;
    protected static final int bdc = -16777216;
    private static final int fgc = OverlayConfig.mappingColor.getRGB();
    protected int height;
    protected int fillc = (fgc + -16777216) / 2;
    protected FontMetrics myFM;
    protected FontMap fontMap;

    protected OutlineFont(Font font, FontMetrics fontMetrics) {
        this.myFM = fontMetrics;
        this.height = fontMetrics.getHeight();
        this.fontMap = new FontMap(font, fontMetrics);
    }

    public static OutlineFont getInstance(Font font, FontMetrics fontMetrics) {
        int n = 0;
        while (n < fontCache.length) {
            if (fontCache[n] != null && fontCache[n].getFontMetrics().getFont().equals(font)) {
                return fontCache[n];
            }
            ++n;
        }
        OutlineFont outlineFont = fontMetrics.getHeight() < 20 ? new OutlineFontSmall(font, fontMetrics) : new OutlineFontLarge(font, fontMetrics);
        OutlineFont.fontCache[OutlineFont.fcIndex] = outlineFont;
        fcIndex = (fcIndex + 1) % fontCache.length;
        return outlineFont;
    }

    public FontMetrics getFontMetrics() {
        return this.myFM;
    }

    protected int getBaseline() {
        return this.height - this.myFM.getMaxDescent() + 2;
    }

    protected int getOffset() {
        return (int)Math.ceil(0.6111111111111112 + (double)this.myFM.getFont().getSize() / 23.0);
    }

    protected abstract FontMapEntry createFontMapEntry(int var1, RGBBufferedImageHolder var2, int var3);

    public int bytesWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            n3 += this.fontMap.getFontMapEntry((char)cArray[n4]).width[cArray[n4] & 0xFF];
            ++n4;
        }
        return n3;
    }

    public void drawBytes(char[] cArray, BufferedImageHolder bufferedImageHolder, int n, int n2) {
        this.drawBytes(cArray, 0, cArray.length, bufferedImageHolder, n, n2, fgc);
    }

    public void drawBytes(char[] cArray, Color color, int n, int n2, BufferedImageHolder bufferedImageHolder, int n3, int n4) {
        int n5 = color != null ? color.getRGB() : fgc;
        this.drawBytes(cArray, n, n2, bufferedImageHolder, n3, n4, n5);
    }

    protected abstract void drawBytes(char[] var1, int var2, int var3, BufferedImageHolder var4, int var5, int var6, int var7);

    public void drawBytes(char[] cArray, Color color, BufferedImageHolder bufferedImageHolder, int n, int n2) {
        int n3 = color != null ? color.getRGB() : fgc;
        this.drawBytes(cArray, 0, cArray.length, bufferedImageHolder, n, n2, n3);
    }

    protected class FontMap {
        private FontMapEntry[] entries = new FontMapEntry[256];
        private Font font;

        public FontMap() {
            int n = 0;
            while (n < 256) {
                this.entries[n] = null;
                ++n;
            }
        }

        public FontMap(Font font, FontMetrics fontMetrics) {
            this();
            this.font = font;
        }

        public FontMapEntry getFontMapEntry(char c) {
            int n = c >> 8 & 0xFF;
            if (this.entries[n] == null) {
                RGBBufferedImageHolder rGBBufferedImageHolder = new RGBBufferedImageHolder(OutlineFont.this.height * 3, OutlineFont.this.height + 8);
                rGBBufferedImageHolder.graphics.setFont(this.font);
                rGBBufferedImageHolder.graphics.setColor(OverlayConfig.mappingColor);
                this.entries[n] = OutlineFont.this.createFontMapEntry(n, rGBBufferedImageHolder, fgc);
                rGBBufferedImageHolder.release();
            }
            return this.entries[n];
        }
    }

    protected class FontMapEntry {
        public int[] width = new int[256];
    }
}

