/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.math.Matrix2d;
import com.tiani.jvision.image.View;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.OrientationMapping;
import com.tiani.jvision.overlay.OverlayConfig;
import java.awt.Color;
import javax.vecmath.Vector3d;

public class OrientationMapping2D
extends OrientationMapping {
    public double[] cosines;
    private int mst = 0;
    private int msl = 0;

    public OrientationMapping2D() {
    }

    public OrientationMapping2D(View view) {
        super(view);
    }

    private void checkCosinuses() {
        if (this.cosines != null) {
            int n = 0;
            while (n < this.cosines.length) {
                if (Math.abs(this.cosines[n]) > 1.0) {
                    log.error("Orientation outside of range:" + this.cosines[n]);
                    this.cosines = null;
                    return;
                }
                ++n;
            }
        }
    }

    @Override
    protected void updateMapping(ImageState imageState) {
        this.setCosines(this.getView().getImageInformation().getImageOrientation());
        this.setMapping(imageState.transform);
    }

    public void setCosines(double[] dArray) {
        this.cosines = dArray;
        this.checkCosinuses();
    }

    public void setMapping(Matrix2d matrix2d) {
        if (!(this.cosines == null || this.cosines[0] == 0.0 && this.cosines[1] == 0.0 && this.cosines[2] == 0.0 || this.cosines[3] == 0.0 && this.cosines[4] == 0.0 && this.cosines[5] == 0.0)) {
            float f;
            double[] dArray = new double[]{this.cosines[0], this.cosines[3]};
            double[] dArray2 = new double[]{this.cosines[1], this.cosines[4]};
            double[] dArray3 = new double[]{this.cosines[2], this.cosines[5]};
            if (this.isShownOnRight()) {
                dArray[0] = -dArray[0];
                dArray2[0] = -dArray2[0];
                dArray3[0] = -dArray3[0];
            }
            matrix2d.transform(dArray2);
            matrix2d.transform(dArray);
            matrix2d.transform(dArray3);
            int n = -1;
            float f2 = 0.0f;
            f2 = f = (float)Math.abs(dArray[1]);
            this.mst = 0;
            this.t1 = new Color((int)((float)OverlayConfig.mappingColor.getRed() * f), (int)((float)OverlayConfig.mappingColor.getGreen() * f), (int)((float)OverlayConfig.mappingColor.getBlue() * f));
            dArray[1] = Math.signum(dArray[1]);
            this.top1 = 1 + n * (int)dArray[1];
            if ((double)f < 0.1) {
                this.top1 = 1;
            }
            if (f2 < (f = (float)Math.abs(dArray2[1]))) {
                f2 = f;
                this.mst = 1;
            }
            this.t2 = new Color((int)((float)OverlayConfig.mappingColor.getRed() * f), (int)((float)OverlayConfig.mappingColor.getGreen() * f), (int)((float)OverlayConfig.mappingColor.getBlue() * f));
            dArray2[1] = Math.signum(dArray2[1]);
            this.top2 = 1 + n * (int)dArray2[1];
            if ((double)f < 0.1) {
                this.top2 = 1;
            }
            if (f2 < (f = (float)Math.abs(dArray3[1]))) {
                this.mst = 2;
            }
            this.t3 = new Color((int)((float)OverlayConfig.mappingColor.getRed() * f), (int)((float)OverlayConfig.mappingColor.getGreen() * f), (int)((float)OverlayConfig.mappingColor.getBlue() * f));
            dArray3[1] = Math.signum(dArray3[1]);
            this.top3 = 1 + n * (int)dArray3[1];
            if ((double)f < 0.1) {
                this.top3 = 1;
            }
            f2 = f = (float)Math.abs(dArray[0]);
            this.msl = 0;
            this.l1 = new Color((int)((float)OverlayConfig.mappingColor.getRed() * f), (int)((float)OverlayConfig.mappingColor.getGreen() * f), (int)((float)OverlayConfig.mappingColor.getBlue() * f));
            dArray[0] = Math.signum(dArray[0]);
            this.left1 = 1 + n * (int)dArray[0];
            if ((double)f < 0.1) {
                this.left1 = 1;
            }
            if (f2 < (f = (float)Math.abs(dArray2[0]))) {
                f2 = f;
                this.msl = 1;
            }
            this.l2 = new Color((int)((float)OverlayConfig.mappingColor.getRed() * f), (int)((float)OverlayConfig.mappingColor.getGreen() * f), (int)((float)OverlayConfig.mappingColor.getBlue() * f));
            dArray2[0] = Math.signum(dArray2[0]);
            this.left2 = 1 + n * (int)dArray2[0];
            if ((double)f < 0.1) {
                this.left2 = 1;
            }
            if (f2 < (f = (float)Math.abs(dArray3[0]))) {
                this.msl = 2;
            }
            this.l3 = new Color((int)((float)OverlayConfig.mappingColor.getRed() * f), (int)((float)OverlayConfig.mappingColor.getGreen() * f), (int)((float)OverlayConfig.mappingColor.getBlue() * f));
            dArray3[0] = Math.signum(dArray3[0]);
            this.left3 = 1 + n * (int)dArray3[0];
            if ((double)f < 0.1) {
                this.left3 = 1;
            }
        } else {
            this.top1 = 1;
            this.top2 = 1;
            this.top3 = 1;
            this.left1 = 1;
            this.left2 = 1;
            this.left3 = 1;
        }
    }

    public String getMajorTopDirection() {
        return this.getMajorTopDirection(true);
    }

    @Override
    public ImageState getImageState() {
        if (this.owner != null) {
            return this.owner.getImageState();
        }
        return null;
    }

    public String getMajorTopDirection(boolean bl) {
        ImageState imageState = this.getImageState();
        if (imageState != null && bl) {
            this.updateMapping(imageState);
        }
        if (this.mst == 0) {
            return lr[this.top1];
        }
        if (this.mst == 1) {
            return pa[this.top2];
        }
        return fh[this.top3];
    }

    public String getMajorLeftDirection() {
        return this.getMajorLeftDirection(true);
    }

    public String getMajorLeftDirection(boolean bl) {
        ImageState imageState = this.getImageState();
        if (imageState != null && bl) {
            this.updateMapping(imageState);
        }
        if (this.msl == 0) {
            return lr[this.left1];
        }
        if (this.msl == 1) {
            return pa[this.left2];
        }
        return fh[this.left3];
    }

    public void getImageOrientation(Matrix2d matrix2d, Vector3d vector3d, Vector3d vector3d2) {
        this.updateMapping(this.getImageState());
        if (this.cosines != null) {
            double[] dArray = new double[]{this.cosines[0], this.cosines[3]};
            double[] dArray2 = new double[]{this.cosines[1], this.cosines[4]};
            double[] dArray3 = new double[]{this.cosines[2], this.cosines[5]};
            matrix2d.transform(dArray2);
            matrix2d.transform(dArray);
            matrix2d.transform(dArray3);
            vector3d.x = dArray[0];
            vector3d.y = dArray2[0];
            vector3d.z = dArray3[0];
            vector3d2.x = dArray[1];
            vector3d2.y = dArray2[1];
            vector3d2.z = dArray3[1];
        }
    }

    protected boolean isShownOnRight() {
        return false;
    }

    @Override
    protected final int getLeftMarkerHorizontalPosition() {
        if (this.isShownOnRight()) {
            return this.width - this.getCurrentFontMetrics().charWidth('R') - 4;
        }
        return super.getLeftMarkerHorizontalPosition();
    }
}

