/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.tiani.jvision.image.View;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayConfig;
import java.awt.Color;

public abstract class OrientationMapping
extends Overlay {
    protected static final String[] pa = new String[]{"A", " ", "P"};
    protected static final String[] lr = new String[]{"R", " ", "L"};
    protected static final String[] fh = new String[]{"F", " ", "H"};
    protected int top1 = 1;
    protected int top2 = 1;
    protected int top3 = 1;
    protected int left1 = 1;
    protected int left2 = 1;
    protected int left3 = 1;
    protected Color t1;
    protected Color t2;
    protected Color t3;
    protected Color l1;
    protected Color l2 = this.l3 = OverlayConfig.mappingColor;
    protected Color l3;

    public OrientationMapping(View view) {
        this();
        this.owner = view;
    }

    public OrientationMapping() {
        this.l1 = this.l3;
        this.t3 = this.l3;
        this.t2 = this.l3;
        this.t1 = this.l3;
    }

    @Override
    public void paint(BufferedImageHolder bufferedImageHolder) {
        int n;
        if (!this.visible) {
            return;
        }
        if (this.owner != null) {
            ImageState imageState = this.owner.getImageState();
            if (imageState.transform == null) {
                return;
            }
            this.updateMapping(imageState);
        }
        if (bufferedImageHolder == null) {
            return;
        }
        bufferedImageHolder.graphics.setFont(this.getCurrentFont());
        int n2 = this.getFontHeight();
        if (this.width > this.getMinSize()) {
            int n3 = (this.width >> 1) - 3 * n2 / 2;
            n = n2;
            this.drawString(lr[this.top1], this.t1, bufferedImageHolder, n3, n);
            this.drawString(pa[this.top2], this.t2, bufferedImageHolder, n3 += n2, n);
            this.drawString(fh[this.top3], this.t3, bufferedImageHolder, n3 += n2, n);
        }
        if (this.height > this.getMinSize()) {
            int n4 = this.getLeftMarkerHorizontalPosition();
            n = (this.height >> 1) - 3 * n2 / 2 + this.getLeftMarkerVerticalOffset();
            this.drawString(lr[this.left1], this.l1, bufferedImageHolder, n4, n);
            this.drawString(pa[this.left2], this.l2, bufferedImageHolder, n4, n += n2);
            this.drawString(fh[this.left3], this.l3, bufferedImageHolder, n4, n += n2);
        }
    }

    protected int getLeftMarkerHorizontalPosition() {
        return 2;
    }

    protected int getLeftMarkerVerticalOffset() {
        return 0;
    }

    protected abstract void updateMapping(ImageState var1);
}

