/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.LocalizerLineOverlay;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.SyncableRendererOverlay;
import com.tiani.jvision.overlay.localizer.LocalizerManager;
import com.tiani.jvision.overlay.localizer.MiniLocalizerSyncData;
import java.awt.Color;

public class MiniLocalizerOverlay
extends SyncableRendererOverlay {
    private static final String MINI_LOCALIZER_NAME = "Mini Localizer";
    private LocalizerLineOverlay line;
    protected MiniLocalizerSyncData sync;

    public MiniLocalizerOverlay(MiniLocalizerSyncData miniLocalizerSyncData, LocalizerLineOverlay localizerLineOverlay) {
        super(MINI_LOCALIZER_NAME, miniLocalizerSyncData.renderer, miniLocalizerSyncData);
        this.line = localizerLineOverlay;
        this.sync = miniLocalizerSyncData;
    }

    @Override
    public boolean isShowOnSmallViews() {
        return true;
    }

    @Override
    protected void paintOverlay(BufferedImageHolder bufferedImageHolder) {
        int n = this.p0x;
        int n2 = this.p0y;
        int n3 = this.getDisplayedWidth();
        int n4 = this.getDisplayedHeight();
        super.paintOverlay(bufferedImageHolder);
        bufferedImageHolder.graphics.translate(n, n2);
        bufferedImageHolder.graphics.setClip(0, 0, n3, n4);
        this.line.paint(bufferedImageHolder, this.renderer.getImageState());
        bufferedImageHolder.graphics.translate(-n, -n2);
        bufferedImageHolder.graphics.setClip(0, 0, bufferedImageHolder.width, bufferedImageHolder.height);
        bufferedImageHolder.graphics.setColor(Color.gray);
        bufferedImageHolder.graphics.drawRect(n, n2, n3, n4);
        bufferedImageHolder.graphics.setColor(OverlayConfig.mappingColor);
    }

    @Override
    public void presentationObjectRemoved(View view) {
        super.presentationObjectRemoved(view);
        LocalizerManager.removeMiniLocalizerFrom(view.getDisplay(), this);
    }

    public MiniLocalizerSyncData getSync() {
        return this.sync;
    }
}

