/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.math.GeomUtil;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewEventHandler;
import com.tiani.jvision.overlay.Localizer;
import com.tiani.jvision.overlay.LocalizerLineOverlay;
import com.tiani.jvision.overlay.Overlay;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Set;

public class LocalizerHighlight
extends Overlay
implements ViewEventHandler {
    private Localizer localizerOverlay = null;
    private LocalizerLineOverlay mouseOnLine = null;
    private boolean isDragged = false;
    private static final String LOCALIZER_CLICK_ACTION_ID = "LOCALIZER_CLICK";
    private static final String LOCALIZER_DRAG_ACTION_ID = "LOCALIZER_DRAG";
    private static boolean localizerClickRecorded = false;
    private static boolean localizerDragRecorded = false;

    public LocalizerHighlight(Localizer localizer) {
        this.localizerOverlay = localizer;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int handleTEvent(TEvent tEvent, Object object, int n, View view) {
        return 0;
    }

    public int getActiveSequenceID() {
        return this.localizerOverlay.getActiveSequenceID();
    }

    @Override
    public void paint(BufferedImageHolder bufferedImageHolder) {
        if (this.owner == null) {
            return;
        }
        if (!this.getView().isLockBackground()) {
            return;
        }
        if (!this.localizerOverlay.isVisible()) {
            return;
        }
        if (((ImgView2)this.getView()).isMagnifierOn()) {
            return;
        }
        Set<LocalizerLineOverlay> set = this.localizerOverlay.getHighlightedLines();
        if (set.size() > 0) {
            Iterator<LocalizerLineOverlay> iterator = set.iterator();
            Color color = bufferedImageHolder.graphics.getColor();
            Color color2 = new Color(255, 255, 255);
            bufferedImageHolder.graphics.setColor(color2);
            while (iterator.hasNext()) {
                LocalizerLineOverlay localizerLineOverlay = iterator.next();
                int[] nArray = localizerLineOverlay.getScreenCoordinates();
                if (!set.contains(localizerLineOverlay)) continue;
                Stroke stroke = null;
                if (this.mouseOnLine == localizerLineOverlay || this.isDragged) {
                    stroke = bufferedImageHolder.graphics.getStroke();
                    bufferedImageHolder.graphics.setStroke(new BasicStroke(2.0f));
                }
                bufferedImageHolder.graphics.drawLine(nArray[0], nArray[1], nArray[2], nArray[3]);
                if (this.mouseOnLine != localizerLineOverlay && !this.isDragged) continue;
                bufferedImageHolder.graphics.setStroke(stroke);
            }
            bufferedImageHolder.graphics.setColor(color);
        }
    }

    private boolean isOnLocalizerLine(LocalizerLineOverlay localizerLineOverlay, int n, int n2) {
        int[] nArray = localizerLineOverlay.getScreenCoordinates();
        double d = Math.abs(GeomUtil.getSignedDistanceFromLine((double)nArray[0], (double)nArray[1], (double)nArray[2], (double)nArray[3], (double)n, (double)n2));
        double d2 = GeomUtil.getPerpendicularPositionOnLine((int)nArray[0], (int)nArray[1], (int)nArray[2], (int)nArray[3], (int)n, (int)n2);
        return d <= 5.0 && d2 >= 0.0 && d2 <= 1.0;
    }

    private boolean mouseMoved(int n, int n2) {
        this.isDragged = false;
        Set<LocalizerLineOverlay> set = this.localizerOverlay.getHighlightedLines();
        if (set.size() > 0) {
            for (LocalizerLineOverlay localizerLineOverlay : set) {
                if (!this.isOnLocalizerLine(localizerLineOverlay, n, n2)) continue;
                if (this.mouseOnLine != localizerLineOverlay) {
                    this.mouseOnLine = localizerLineOverlay;
                    this.getView().repaint();
                }
                return true;
            }
        }
        if (this.mouseOnLine != null) {
            this.mouseOnLine = null;
            this.getView().repaint();
        }
        return false;
    }

    private boolean mousePressed(int n, int n2) {
        boolean bl;
        Set<LocalizerLineOverlay> set = this.localizerOverlay.getHighlightedLines();
        if (set.size() > 0) {
            for (LocalizerLineOverlay localizerLineOverlay : set) {
                if (!this.isOnLocalizerLine(localizerLineOverlay, n, n2)) continue;
                return true;
            }
        }
        if ((bl = this.localizerOverlay.mousePressed(n, n2)) && !localizerClickRecorded) {
            localizerClickRecorded = true;
            AbstractPAction.notifyNonPActionPerformed(LOCALIZER_CLICK_ACTION_ID);
        }
        this.mouseMoved(n, n2);
        return bl;
    }

    private boolean mouseDragged(int n, int n2) {
        if (this.mouseOnLine != null) {
            this.isDragged = true;
            this.localizerOverlay.localizerDragged(n, n2);
            return true;
        }
        return false;
    }

    private boolean mouseReleased() {
        if (this.isDragged && !localizerDragRecorded) {
            localizerDragRecorded = true;
            AbstractPAction.notifyNonPActionPerformed(LOCALIZER_DRAG_ACTION_ID);
        }
        this.isDragged = false;
        this.localizerOverlay.mouseReleased();
        return false;
    }

    public boolean handleMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 503) {
            return this.mouseMoved(mouseEvent.getX(), mouseEvent.getY());
        }
        if (ModifierKeys.isLMB((MouseEvent)mouseEvent)) {
            switch (mouseEvent.getID()) {
                case 501: {
                    return this.mousePressed(mouseEvent.getX(), mouseEvent.getY());
                }
                case 506: {
                    return this.mouseDragged(mouseEvent.getX(), mouseEvent.getY());
                }
                case 502: {
                    return this.mouseReleased();
                }
            }
        }
        return false;
    }
}

