/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.PointSequence;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.TranslationHandle;
import java.awt.Color;

public class LineOverlay
extends PresentationObject
implements PointSequence {
    protected double[] p;
    protected double[] q = new double[2];
    protected boolean highLighted = false;
    protected int pxi;
    protected int pyi;
    protected int qxi;
    protected int qyi;

    public LineOverlay() {
        super("Line");
        this.p = new double[2];
        this.q[1] = 0.0;
        this.q[0] = 0.0;
        this.p[1] = 0.0;
        this.p[0] = 0.0;
    }

    public LineOverlay(double d, double d2, double d3, double d4, AnnotationUnits annotationUnits) {
        this();
        this.p[0] = d;
        this.p[1] = d2;
        this.q[0] = d3;
        this.q[1] = d4;
        this.setSpacing(annotationUnits);
        this.makeHandles();
    }

    public int[] getScreenCoordinates() {
        int[] nArray = new int[]{this.pxi, this.pyi, this.qxi, this.qyi};
        return nArray;
    }

    @Override
    public double[] getXCoordinates() {
        double[] dArray = new double[]{this.p[0], this.q[0]};
        return dArray;
    }

    @Override
    public double[] getYCoordinates() {
        double[] dArray = new double[]{this.p[1], this.q[1]};
        return dArray;
    }

    @Override
    public int getPointCount() {
        return 2;
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.q = new double[2];
        this.p = new double[2];
        this.makeHandles();
    }

    protected void makeHandles() {
        this.handles = new PresentationHandle[3];
        this.handles[0] = new PresentationHandle(this.pxi, this.pyi);
        this.handles[1] = new PresentationHandle(this.qxi, this.qyi);
        this.handles[2] = new TranslationHandle((this.pxi + this.qxi) / 2, (this.pyi + this.qyi) / 2);
        this.translationHandleIndex = 2;
    }

    @Override
    protected void toScreen() {
        double[] dArray = this.toScreen(this.p);
        this.pxi = (int)dArray[0];
        this.pyi = (int)dArray[1];
        dArray = this.toScreen(this.q);
        this.qxi = (int)dArray[0];
        this.qyi = (int)dArray[1];
        this.handles[0].setPosition(this.pxi, this.pyi);
        this.handles[1].setPosition(this.qxi, this.qyi);
        double[] dArray2 = new double[]{(this.p[0] + this.q[0]) / 2.0, (this.p[1] + this.q[1]) / 2.0};
        dArray2 = this.toScreen(dArray2);
        this.handles[2].setPosition((int)dArray2[0], (int)dArray2[1]);
        this.bounds.x = Math.min(this.pxi, this.qxi) - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = Math.min(this.pyi, this.qyi) - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = Math.abs(this.pxi - this.qxi) + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = Math.abs(this.pyi - this.qyi) + 2 * PresentationHandle.HANDLE_SIZE;
        double[] dArray3 = new double[]{this.q[0] - this.p[0], this.q[1] - this.p[1]};
        double d = Math.sqrt((this.pxi - this.qxi) * (this.pxi - this.qxi) + (this.pyi - this.qyi) * (this.pyi - this.qyi));
        dArray3[0] = dArray3[0] / d;
        dArray3[1] = dArray3[1] / d;
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        Color color = bufferedImageHolder.graphics.getColor();
        if (this.highLighted) {
            bufferedImageHolder.graphics.setColor(OverlayConfig.highlightColor);
        }
        bufferedImageHolder.graphics.drawLine(this.pxi, this.pyi, this.qxi, this.qyi);
        bufferedImageHolder.graphics.setColor(color);
    }

    @Override
    protected void handleDragged(int n, double[] dArray) {
        if (super.isHandleOutsideView(dArray)) {
            return;
        }
        switch (n) {
            case 0: {
                this.p = (double[])dArray.clone();
                this.toScreen();
                break;
            }
            case 1: {
                this.q = (double[])dArray.clone();
                this.toScreen();
                break;
            }
            case 2: {
                if (!this.isCompleted()) {
                    this.handleDragged(1, dArray);
                    return;
                }
                double d = dArray[0] - (this.q[0] + this.p[0]) / 2.0;
                double d2 = dArray[1] - (this.q[1] + this.p[1]) / 2.0;
                this.p[0] = this.p[0] + d;
                this.p[1] = this.p[1] + d2;
                this.q[0] = this.q[0] + d;
                this.q[1] = this.q[1] + d2;
                this.toScreen();
            }
        }
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        int n2 = n;
        switch (n) {
            case 1: {
                this.handleDragged(0, dArray);
                this.handleDragged(1, dArray);
                this.createAnnotation();
                ++n2;
                break;
            }
            case 2: {
                this.activeHandleIndex = 1;
                ++n2;
                break;
            }
            case 3: {
                this.handleDragged(1, dArray);
                n2 = -1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(30, "ROI");
    }

    @Override
    protected void translationAction(int n, int n2, PresentationObject presentationObject) {
        if (this.fireing) {
            return;
        }
        log.debug("T:" + n + "/" + n2 + " at " + this);
        this.fireTranslation(n, n2);
        if (presentationObject instanceof TextOverlay) {
            PresentationHandle presentationHandle = this.handles[0];
            this.handleDragged(0, this.toImage(presentationHandle.getX() + n, presentationHandle.getY() + n2));
        } else {
            this.p[0] = this.p[0] + ((double)n * this.unitx[0] + (double)n2 * this.unity[0]);
            this.p[1] = this.p[1] + ((double)n * this.unitx[1] + (double)n2 * this.unity[1]);
            this.q[0] = this.q[0] + ((double)n * this.unitx[0] + (double)n2 * this.unity[0]);
            this.q[1] = this.q[1] + ((double)n * this.unitx[1] + (double)n2 * this.unity[1]);
            this.toScreen();
        }
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            super.cloneReferences(presentationObject);
            LineOverlay lineOverlay = (LineOverlay)presentationObject;
            lineOverlay.setClonedParameters(ReferencedObjectsCloning.clone(this.p), ReferencedObjectsCloning.clone(this.q));
        }
        catch (Exception exception) {
            log.error("clone error", (Throwable)exception);
        }
        return presentationObject;
    }

    public void setClonedParameters(double[] dArray, double[] dArray2) {
        this.p = dArray;
        this.q = dArray2;
    }

    public boolean isHighLighted() {
        return this.highLighted;
    }

    public void setHighLighted(boolean bl) {
        this.highLighted = bl;
    }

    @Override
    public boolean isInterceptionAt(int n) {
        return false;
    }
}

