/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.jvision.overlay.AbstractLengthOverlay;
import com.tiani.jvision.overlay.AbstractRegionSpacingOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.TranslationHandle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LengthOverlay
extends AbstractLengthOverlay
implements IGraphicObjectContainer {
    protected double[] p;
    protected double[] q = new double[2];
    protected int d1x;
    protected int d1y;
    protected int d2x;
    protected int d2y;
    protected int pxi;
    protected int pyi;
    protected int qxi;
    protected int qyi;

    public LengthOverlay() {
        super("Length", AbstractRegionSpacingOverlay.ImageRegionSpacingMode.ENABLED_FULLY);
        this.p = new double[2];
        this.q[1] = 0.0;
        this.q[0] = 0.0;
        this.p[1] = 0.0;
        this.p[0] = 0.0;
    }

    public LengthOverlay(double d, double d2, double d3, double d4, AnnotationUnits annotationUnits) {
        this();
        this.p[0] = d;
        this.p[1] = d2;
        this.q[0] = d3;
        this.q[1] = d4;
        this.setSpacing(annotationUnits);
        this.makeHandles();
    }

    @Override
    public double[] getXCoordinates() {
        double[] dArray = new double[]{this.p[0], this.q[0]};
        return dArray;
    }

    @Override
    public double[] getYCoordinates() {
        double[] dArray = new double[]{this.p[1], this.q[1]};
        return dArray;
    }

    @Override
    public int getPointCount() {
        return 2;
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.q = new double[2];
        this.p = new double[2];
        this.makeHandles();
    }

    @Override
    public boolean isROI() {
        return true;
    }

    protected void makeHandles() {
        this.handles = new PresentationHandle[3];
        this.handles[0] = new PresentationHandle(this.pxi, this.pyi);
        this.handles[1] = new PresentationHandle(this.qxi, this.qyi);
        this.handles[2] = new TranslationHandle((this.pxi + this.qxi) / 2, (this.pyi + this.qyi) / 2);
        this.translationHandleIndex = 2;
    }

    @Override
    double calculateMeasurementResult() {
        return this.calculateLength(this.p, this.pxi, this.pyi, this.q, this.qxi, this.qyi);
    }

    @Override
    void toScreenImpl() {
        double[] dArray = this.toScreen(this.p);
        this.pxi = (int)dArray[0];
        this.pyi = (int)dArray[1];
        dArray = this.toScreen(this.q);
        this.qxi = (int)dArray[0];
        this.qyi = (int)dArray[1];
        this.handles[0].setPosition(this.pxi, this.pyi);
        this.handles[1].setPosition(this.qxi, this.qyi);
        double[] dArray2 = new double[]{(this.p[0] + this.q[0]) / 2.0, (this.p[1] + this.q[1]) / 2.0};
        dArray2 = this.toScreen(dArray2);
        this.handles[2].setPosition((int)dArray2[0], (int)dArray2[1]);
        this.bounds.x = Math.min(this.pxi, this.qxi) - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = Math.min(this.pyi, this.qyi) - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = Math.abs(this.pxi - this.qxi) + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = Math.abs(this.pyi - this.qyi) + 2 * PresentationHandle.HANDLE_SIZE;
        double[] dArray3 = new double[]{this.q[0] - this.p[0], this.q[1] - this.p[1]};
        double d = Math.sqrt((this.pxi - this.qxi) * (this.pxi - this.qxi) + (this.pyi - this.qyi) * (this.pyi - this.qyi));
        if (d > 0.0) {
            dArray3[0] = dArray3[0] / d;
            dArray3[1] = dArray3[1] / d;
            double[] dArray4 = new double[]{-dArray3[1], dArray3[0]};
            double[] dArray5 = new double[]{this.q[0] + dArray4[0] * 5.0 - dArray3[0] * 5.0, this.q[1] + dArray4[1] * 5.0 - dArray3[1] * 5.0};
            dArray5 = this.toScreen(dArray5);
            this.d1x = (int)dArray5[0] - this.qxi;
            this.d1y = (int)dArray5[1] - this.qyi;
            dArray5[0] = this.q[0] + dArray4[0] * 5.0 + dArray3[0] * 5.0;
            dArray5[1] = this.q[1] + dArray4[1] * 5.0 + dArray3[1] * 5.0;
            dArray5 = this.toScreen(dArray5);
            this.d2x = (int)dArray5[0] - this.qxi;
            this.d2y = (int)dArray5[1] - this.qyi;
        }
    }

    public double getLength() {
        return this.getMeasurementResult();
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        if (this.isUseOutlineFont()) {
            bufferedImageHolder.graphics.setColor(Color.black);
            if (this.pxi != this.qxi && Math.abs(this.pyi - this.qyi) / Math.abs(this.pxi - this.qxi) < 1) {
                bufferedImageHolder.graphics.drawLine(this.pxi, this.pyi - 1, this.qxi, this.qyi - 1);
                bufferedImageHolder.graphics.drawLine(this.pxi, this.pyi + 1, this.qxi, this.qyi + 1);
            } else {
                bufferedImageHolder.graphics.drawLine(this.pxi - 1, this.pyi, this.qxi - 1, this.qyi);
                bufferedImageHolder.graphics.drawLine(this.pxi + 1, this.pyi, this.qxi + 1, this.qyi);
            }
            if (this.d1x != 0 && Math.abs(this.d1y) / Math.abs(this.d1x) < 1) {
                bufferedImageHolder.graphics.drawLine(this.pxi - this.d1x, this.pyi - this.d1y - 1, this.pxi + this.d1x, this.pyi + this.d1y - 1);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.d2x - 1, this.pyi - this.d2y, this.pxi + this.d2x - 1, this.pyi + this.d2y);
                bufferedImageHolder.graphics.drawLine(this.qxi - this.d1x, this.qyi - this.d1y - 1, this.qxi + this.d1x, this.qyi + this.d1y - 1);
                bufferedImageHolder.graphics.drawLine(this.qxi - this.d2x - 1, this.qyi - this.d2y, this.qxi + this.d2x - 1, this.qyi + this.d2y);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.d1x, this.pyi - this.d1y + 1, this.pxi + this.d1x, this.pyi + this.d1y + 1);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.d2x + 1, this.pyi - this.d2y, this.pxi + this.d2x + 1, this.pyi + this.d2y);
                bufferedImageHolder.graphics.drawLine(this.qxi - this.d1x, this.qyi - this.d1y + 1, this.qxi + this.d1x, this.qyi + this.d1y + 1);
                bufferedImageHolder.graphics.drawLine(this.qxi - this.d2x + 1, this.qyi - this.d2y, this.qxi + this.d2x + 1, this.qyi + this.d2y);
            } else {
                bufferedImageHolder.graphics.drawLine(this.pxi - this.d2x, this.pyi - this.d2y - 1, this.pxi + this.d2x, this.pyi + this.d2y - 1);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.d1x - 1, this.pyi - this.d1y, this.pxi + this.d1x - 1, this.pyi + this.d1y);
                bufferedImageHolder.graphics.drawLine(this.qxi - this.d2x, this.qyi - this.d2y - 1, this.qxi + this.d2x, this.qyi + this.d2y - 1);
                bufferedImageHolder.graphics.drawLine(this.qxi - this.d1x - 1, this.qyi - this.d1y, this.qxi + this.d1x - 1, this.qyi + this.d1y);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.d2x, this.pyi - this.d2y + 1, this.pxi + this.d2x, this.pyi + this.d2y + 1);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.d1x + 1, this.pyi - this.d1y, this.pxi + this.d1x + 1, this.pyi + this.d1y);
                bufferedImageHolder.graphics.drawLine(this.qxi - this.d2x, this.qyi - this.d2y + 1, this.qxi + this.d2x, this.qyi + this.d2y + 1);
                bufferedImageHolder.graphics.drawLine(this.qxi - this.d1x + 1, this.qyi - this.d1y, this.qxi + this.d1x + 1, this.qyi + this.d1y);
            }
            bufferedImageHolder.graphics.setColor(this.objCol);
        }
        bufferedImageHolder.graphics.drawLine(this.pxi, this.pyi, this.qxi, this.qyi);
        bufferedImageHolder.graphics.drawLine(this.pxi - this.d1x, this.pyi - this.d1y, this.pxi + this.d1x, this.pyi + this.d1y);
        bufferedImageHolder.graphics.drawLine(this.pxi - this.d2x, this.pyi - this.d2y, this.pxi + this.d2x, this.pyi + this.d2y);
        bufferedImageHolder.graphics.drawLine(this.qxi - this.d1x, this.qyi - this.d1y, this.qxi + this.d1x, this.qyi + this.d1y);
        bufferedImageHolder.graphics.drawLine(this.qxi - this.d2x, this.qyi - this.d2y, this.qxi + this.d2x, this.qyi + this.d2y);
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        switch (n) {
            case 0: {
                this.p = (double[])dArray.clone();
                this.toScreen();
                break;
            }
            case 1: {
                this.q = (double[])dArray.clone();
                TextOverlay textOverlay = this.getAnnotation();
                if (textOverlay != null && !this.isCompleted()) {
                    textOverlay.setAnchor(this.q[0], this.q[1]);
                }
                this.toScreen();
                break;
            }
            case 2: {
                if (!this.isCompleted()) {
                    this.handleDragged(1, dArray);
                    return;
                }
                double d = dArray[0] - (this.q[0] + this.p[0]) / 2.0;
                double d2 = dArray[1] - (this.q[1] + this.p[1]) / 2.0;
                this.p[0] = this.p[0] + d;
                this.p[1] = this.p[1] + d2;
                this.q[0] = this.q[0] + d;
                this.q[1] = this.q[1] + d2;
                this.toScreenOnTranslation();
            }
        }
        this.setSaved(false);
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        int n2 = n;
        switch (n) {
            case 1: {
                this.handleDragged(0, dArray);
                this.handleDragged(1, dArray);
                if (!this.hasAnnotation()) {
                    this.createAnnotation();
                }
                this.activeHandleIndex = 1;
                ++n2;
                break;
            }
            case 2: {
                this.activeHandleIndex = 1;
                ++n2;
                break;
            }
            case 3: {
                this.handleDragged(1, dArray);
                n2 = -1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(30, " ");
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(1);
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.Length);
        graphicObject.setGraphicType(GraphicType.PolyLine);
        graphicObject.setGraphicData(new float[]{(float)this.p[0], (float)this.p[1], (float)this.q[0], (float)this.q[1]});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(2));
        arrayList.add(graphicObject);
        return arrayList;
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            super.cloneReferences(presentationObject);
            LengthOverlay lengthOverlay = (LengthOverlay)presentationObject;
            lengthOverlay.setClonedParameters(ReferencedObjectsCloning.clone(this.p), ReferencedObjectsCloning.clone(this.q));
        }
        catch (Exception exception) {
            log.error("clone error", (Throwable)exception);
        }
        return presentationObject;
    }

    public void setClonedParameters(double[] dArray, double[] dArray2) {
        this.p = dArray;
        this.q = dArray2;
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) {
        LengthOverlay lengthOverlay = (LengthOverlay)iTransformableOverlay;
        this.p = iOverlayPointModifier.convert(lengthOverlay.p);
        this.q = iOverlayPointModifier.convert(lengthOverlay.q);
    }

    protected void createBoundingShape() {
        this.toScreen();
        this.outBounds = Collections.singletonList(this.createBoundingLine(this.pxi, this.pyi, this.qxi, this.qyi));
    }

    @Override
    public boolean inBounds(int n, int n2) {
        boolean bl = false;
        if (this.isSelected()) {
            bl = this.isHandleClicked(n, n2);
        }
        if (!bl) {
            this.createBoundingShape();
            return super.inBounds(n, n2);
        }
        return bl;
    }

    @Override
    public boolean isInterceptionAt(int n) {
        return false;
    }
}

