/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

public class EditTextOverlayContent {
    public static final int EDIT_TEXT_INT = 1;
    public static final int EDIT_TEXT_DOUBLE = 2;
    public static final int EDIT_TEXT_STRING = 3;
    private String prefixText;
    private String suffixText;
    private int mode = 0;
    private int iEditValue;
    private double dMin;
    private double dMax;
    private double dCurrent;
    private double dComma;
    private double dEditValue;
    private String[] strList = null;
    private int strCurrent = -1;

    public EditTextOverlayContent(String[] stringArray) {
        this("", stringArray, "");
    }

    public EditTextOverlayContent(String string, double d, double d2, double d3, String string2) {
        this.init(string, string2, 2);
        this.dMin = d;
        this.dMax = d2;
        this.dCurrent = this.dEditValue = this.dMin;
        this.dComma = 0.0;
        double d4 = Math.abs(d3) - (double)Math.round(Math.abs(d3));
        if (d4 <= 1.0E-5) {
            this.dComma = 1.0;
        } else {
            double d5 = 1.0;
            while (!(d5 <= d4)) {
                d5 /= 10.0;
                this.dComma += 10.0;
            }
        }
    }

    public EditTextOverlayContent(String string, double d, double d2, double d3, String string2, int n) {
        this.init(string, string2, 2);
        this.dComma = Math.pow(10.0, n);
        this.dMin = this.niceNumber(d);
        this.dMax = this.niceNumber(d2);
        this.dCurrent = this.dEditValue = this.dMin;
    }

    public EditTextOverlayContent(String string, String[] stringArray, String string2) {
        this.init(string, string2, 3);
        this.strList = stringArray == null ? new String[1] : stringArray;
        this.strCurrent = 0;
    }

    private void init(String string, String string2, int n) {
        this.mode = n;
        this.prefixText = string;
        this.suffixText = string2;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean setCurrentValue(double d) {
        if (this.mode != 2) {
            return false;
        }
        if (d >= this.dMin && d <= this.dMax) {
            this.dCurrent = this.dEditValue = this.niceNumber(d);
            return true;
        }
        return false;
    }

    public boolean setCurrentValue(String string) {
        if (this.mode != 3) {
            return false;
        }
        int n = 0;
        while (n < this.strList.length) {
            if (this.strList[n].equals(string)) {
                this.strCurrent = n;
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getTextLine() {
        switch (this.mode) {
            case 3: {
                return String.valueOf(this.prefixText) + this.strList[this.strCurrent] + this.suffixText;
            }
            case 1: {
                return String.valueOf(this.prefixText) + String.valueOf(this.iEditValue) + this.suffixText;
            }
            case 2: {
                return String.valueOf(this.prefixText) + String.valueOf(this.dEditValue) + this.suffixText;
            }
        }
        return null;
    }

    protected double niceNumber(double d) {
        return (double)((int)(d * this.dComma + 0.5)) / this.dComma;
    }

    public double getCurrentDoubleValue() {
        if (this.mode == 2) {
            return this.dCurrent;
        }
        return Double.MIN_VALUE;
    }

    public String getCurrentStringValue() {
        if (this.mode == 3) {
            return this.strList[this.strCurrent];
        }
        return null;
    }
}

