/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.data.shared.valuemapping.IValueMapping;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.YN;
import com.tiani.base.data.ImageRegion;
import com.tiani.jvision.image.DoubleRectangle;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.OverlayContainer;
import com.tiani.jvision.overlay.PointSequence;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.chart.ChartFloatChannel;
import com.tiani.jvision.overlay.chart.LineChart;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DataProfile
extends LineChart
implements IGraphicObjectContainer {
    private static final String TYPE = "Data Profile";
    PointSequence pointSequence = null;
    ChartFloatChannel channel;
    List<Marker> markers = new ArrayList<Marker>();
    double[] lastPx;
    double[] lastPy;
    double lastLength;
    int lastPc;
    Rectangle lastSourceBBox;
    private IValueMapping lastValueMapping;

    public DataProfile(double d, double d2, double d3, double d4, AnnotationUnits annotationUnits, PointSequence pointSequence, OverlayContainer.AnchorPosition anchorPosition, boolean bl) {
        this(d, d2, d3, d4, annotationUnits, anchorPosition);
        this.pointSequence = pointSequence;
        this.addMarker(new Marker(0.5f, 0, 0));
        super.setOnlyTranslateAnchor(true);
        this.visible = bl;
    }

    public DataProfile(double d, double d2, double d3, double d4, AnnotationUnits annotationUnits, OverlayContainer.AnchorPosition anchorPosition) {
        super(TYPE, d, d2, d3, d4, annotationUnits, anchorPosition);
        this.init();
    }

    DataProfile(DoubleRectangle doubleRectangle, AnnotationUnits annotationUnits, OverlayContainer.AnchorPosition anchorPosition) {
        super(TYPE, doubleRectangle, annotationUnits, anchorPosition);
        this.init();
    }

    private void init() {
        this.showBox(false);
        this.addMarker(new Marker(0.5f, 0, 0));
        super.setOnlyTranslateAnchor(true);
    }

    @Override
    public PresentationObject cloneAll() {
        double[] dArray = this.getTopLeft();
        DataProfile dataProfile = new DataProfile(dArray[0], dArray[1], this.w, this.h, this.spacingType, this.anchor);
        dataProfile.setVisible(this.visible);
        dataProfile.setAllowDragOutOfBounds(this.bAllowDragOutOfBounds);
        dataProfile.setOnlyTranslateAnchor(this.getOnlyTranslateAnchor());
        dataProfile.setMarkerPosition(0, this.getMarkerPosition(0));
        dataProfile.setClonedParameters((double[])this.a.clone(), (double[])this.o.clone());
        dataProfile.setPointSequence(this.pointSequence);
        dataProfile.setShapeChanged(true);
        return dataProfile;
    }

    public void setPointSequence(PointSequence pointSequence) {
        this.pointSequence = pointSequence;
    }

    public PointSequence getPointSequence() {
        return this.pointSequence;
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        if (this.pointSequence == null) {
            return;
        }
        this.recalcPlot();
        super.paintShape(bufferedImageHolder);
        this.updateMarkers();
        Iterator<Marker> iterator = this.markers.iterator();
        while (iterator.hasNext()) {
            iterator.next().paint(bufferedImageHolder, this.p0x, this.p1x, this.p0y, this.p2y);
        }
    }

    @Override
    protected void toScreen() {
        double[] dArray;
        double[] dArray2;
        if (this.pointSequence == null) {
            return;
        }
        if (this.w == 0.0) {
            dArray2 = new double[]{0.0, 0.0};
            dArray2 = this.toImage(dArray2);
            dArray = new double[]{200.0, 200.0};
            dArray = this.toImage(dArray);
            this.w = (int)(dArray[0] - dArray2[0]);
        }
        if (this.h == 0.0) {
            dArray2 = new double[]{0.0, 0.0};
            dArray2 = this.toImage(dArray2);
            dArray = new double[]{200.0, 200.0};
            dArray = this.toImage(dArray);
            this.h = (int)(dArray[1] - dArray2[1]);
        }
        super.toScreen();
    }

    private void addMarker(Marker marker) {
        if (this.markers != null && this.markers.size() == 0) {
            this.markers.add(marker);
            this.handles = Arrays.copyOf(this.handles, this.handles.length + 2);
            this.handles[this.handles.length - 2] = marker.lineH;
            this.handles[this.handles.length - 1] = marker.plotH;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void recalcPlot() {
        var1_1 = this.getImageState();
        var2_2 = var1_1.getCurrentValueMapping();
        if (this.pointSequence instanceof PresentationObject && this.pointSequence.getPointCount() < 3) {
            var3_3 /* !! */  = (double[])((PresentationObject)this.pointSequence).getBoundingBox();
            if (var2_2.equals(this.lastValueMapping) && this.lastSourceBBox != null && this.lastSourceBBox.x == var3_3 /* !! */ .x && this.lastSourceBBox.y == var3_3 /* !! */ .y && this.lastSourceBBox.width == var3_3 /* !! */ .width && this.lastSourceBBox.height == var3_3 /* !! */ .height) {
                return;
            }
            this.lastSourceBBox = new Rectangle((Rectangle)var3_3 /* !! */ );
            this.lastValueMapping = var2_2;
        }
        var3_3 /* !! */  = this.pointSequence.getXCoordinates();
        var4_4 = this.pointSequence.getYCoordinates();
        var5_5 = this.pointSequence.getPointCount();
        if (var5_5 < 2) {
            return;
        }
        var6_6 = new double[]{0.0, 0.0};
        var7_7 = new double[]{0.0, 0.0};
        var8_8 = ((PresentationObject)this.pointSequence).getImageState();
        var9_9 = ((PresentationObject)this.pointSequence).getContext();
        var10_10 = 0;
        while (var10_10 < var3_3 /* !! */ .length) {
            if (this.pointSequence.isInterceptionAt(var10_10)) {
                ++var10_10;
            }
            var6_6[0] = var3_3 /* !! */ [var10_10];
            var6_6[1] = var4_4[var10_10];
            var8_8.imageToScreen(var6_6, var7_7, var9_9);
            var1_1.screenToImage(var7_7, var6_6, null);
            var3_3 /* !! */ [var10_10] = var6_6[0];
            var4_4[var10_10] = var6_6[1];
            ++var10_10;
        }
        var10_11 = 0.0;
        var12_12 = 1;
        while (var12_12 < var5_5) {
            var10_11 += Math.sqrt((var3_3 /* !! */ [var12_12] - var3_3 /* !! */ [var12_12 - 1]) * (var3_3 /* !! */ [var12_12] - var3_3 /* !! */ [var12_12 - 1]) + (var4_4[var12_12] - var4_4[var12_12 - 1]) * (var4_4[var12_12] - var4_4[var12_12 - 1]));
            ++var12_12;
        }
        var12_12 = (int)(var10_11 + 1.0);
        var13_13 = new float[var12_12 * 2];
        var14_14 = new ImageRegion();
        var15_15 = 1;
        var16_16 = Math.sqrt((var3_3 /* !! */ [var15_15] - var3_3 /* !! */ [var15_15 - 1]) * (var3_3 /* !! */ [var15_15] - var3_3 /* !! */ [var15_15 - 1]) + (var4_4[var15_15] - var4_4[var15_15 - 1]) * (var4_4[var15_15] - var4_4[var15_15 - 1]));
        var18_17 = 1.0;
        var20_18 = var16_16;
        var22_19 = 0x7FFFFFFF;
        var23_20 = -2147483648;
        var24_21 = 0;
        ** GOTO lbl65
        {
            var20_18 = Math.sqrt((var3_3 /* !! */ [++var15_15] - var3_3 /* !! */ [var15_15 - 1]) * (var3_3 /* !! */ [var15_15] - var3_3 /* !! */ [var15_15 - 1]) + (var4_4[var15_15] - var4_4[var15_15 - 1]) * (var4_4[var15_15] - var4_4[var15_15 - 1]));
            var16_16 += var20_18;
            do {
                if ((double)var24_21 * var18_17 >= var16_16 && var15_15 < var5_5 - 1) continue block2;
                var25_22 = (var16_16 - (double)var24_21 * var18_17) / var20_18;
                var14_14.x = (int)(var3_3 /* !! */ [var15_15 - 1] * var25_22 + var3_3 /* !! */ [var15_15] * (1.0 - var25_22));
                var14_14.y = (int)(var4_4[var15_15 - 1] * var25_22 + var4_4[var15_15] * (1.0 - var25_22));
                var27_23 = this.getRegionSource();
                var28_24 = var27_23.getImageRegionProperties(var14_14, this.width, this.height, var2_2);
                var29_25 = (float)var28_24.getMean();
                var13_13[var24_21 * 2] = var24_21;
                var13_13[var24_21 * 2 + 1] = var29_25;
                var30_26 = (int)var29_25;
                if (var30_26 > var23_20) {
                    var23_20 = var30_26;
                }
                if (var30_26 < var22_19) {
                    var22_19 = var30_26;
                }
                ++var24_21;
lbl65:
                // 2 sources

            } while (var24_21 < var12_12 && var15_15 < var5_5);
        }
        this.yAxis.setMin(var22_19);
        this.yAxis.setMax(var23_20);
        this.xAxis.setMin(0.0);
        this.xAxis.setMax(var24_21);
        if (this.channel != null) {
            this.removeChannel(this.channel);
        }
        this.channel = new ChartFloatChannel("", var13_13);
        this.channel.setColor(this.objCol);
        this.addChannel(this.channel);
        this.lastPx = var3_3 /* !! */ ;
        this.lastPy = var4_4;
        this.lastPc = var5_5;
        this.lastLength = var10_11;
        this.updateMarkers();
    }

    private void updateMarkers() {
        double d;
        if (this.markers.size() == 0) {
            return;
        }
        Iterator<Marker> iterator = this.markers.iterator();
        int n = 1;
        double[] dArray = this.lastPx;
        double[] dArray2 = this.lastPy;
        int n2 = this.lastPc;
        double d2 = this.lastLength;
        int n3 = (int)(d2 + 1.0);
        double d3 = d = Math.sqrt((dArray[n] - dArray[n - 1]) * (dArray[n] - dArray[n - 1]) + (dArray2[n] - dArray2[n - 1]) * (dArray2[n] - dArray2[n - 1]));
        double d4 = 0.0;
        while (n < n2 && iterator.hasNext()) {
            Marker marker = iterator.next();
            d4 = marker.pos * (float)n3;
            while (d4 >= d && n < n2 - 1) {
                d3 = Math.sqrt((dArray[++n] - dArray[n - 1]) * (dArray[n] - dArray[n - 1]) + (dArray2[n] - dArray2[n - 1]) * (dArray2[n] - dArray2[n - 1]));
                d += d3;
            }
            double d5 = (d - d4) / d3;
            double[] dArray3 = new double[]{dArray[n - 1] * d5 + dArray[n] * (1.0 - d5), dArray2[n - 1] * d5 + dArray2[n] * (1.0 - d5)};
            dArray3 = this.toScreen(dArray3);
            marker.setLinePoint((int)dArray3[0], (int)dArray3[1]);
            int n4 = this.channel.getPointCount();
            if (d4 >= (double)n4) {
                d4 = n4 - 1;
            }
            marker.value = (float)this.channel.getValueAt((int)d4 * 2 + 1);
        }
    }

    private float findClosestPointOfPolyline(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double[] dArray2 = this.lastPx;
        double[] dArray3 = this.lastPy;
        int n = this.lastPc;
        double d3 = this.lastLength;
        double d4 = 0.0;
        double d5 = Double.MAX_VALUE;
        double d6 = 0.0;
        int n2 = 0;
        while (n2 < n - 1) {
            double d7;
            double d8;
            if (this.pointSequence.isInterceptionAt(n2)) {
                d8 = Math.sqrt((dArray2[n2] - dArray2[n2 + 1]) * (dArray2[n2] - dArray2[n2 + 1]) + (dArray3[n2] - dArray3[n2 + 1]) * (dArray3[n2] - dArray3[n2 + 1]));
                d6 += d8 / d3;
                ++n2;
            }
            d8 = Math.sqrt((dArray2[n2] - dArray2[n2 + 1]) * (dArray2[n2] - dArray2[n2 + 1]) + (dArray3[n2] - dArray3[n2 + 1]) * (dArray3[n2] - dArray3[n2 + 1]));
            double d9 = dArray3[n2] - dArray3[n2 + 1];
            double d10 = dArray2[n2 + 1] - dArray2[n2];
            double d11 = d - dArray2[n2];
            double d12 = d2 - dArray3[n2];
            double d13 = d9 * d11 + d10 * d12;
            if ((d13 = d13 * d13 / (d9 * d9 + d10 * d10)) < d5 && (d7 = ((d9 = dArray2[n2 + 1] - dArray2[n2]) * d11 + (d10 = dArray3[n2 + 1] - dArray3[n2]) * d12) / (d9 * d9 + d10 * d10)) >= 0.0 && d7 <= 1.0) {
                d5 = d13;
                d4 = d6 + d7 * d8 / d3;
            }
            if ((d13 = d11 * d11 + d12 * d12) < d5) {
                d5 = d13;
                d4 = d6;
            }
            d6 += d8 / d3;
            ++n2;
        }
        double d14 = (d - dArray2[n - 1]) * (d - dArray2[n - 1]) + (d2 - dArray3[n - 1]) * (d2 - dArray3[n - 1]);
        if (d14 < d5) {
            d4 = 1.0;
        }
        return (float)d4;
    }

    @Override
    public boolean isROI() {
        return true;
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>();
        this.recalcPlot();
        GraphicObject graphicObject = this.createGraphicObject();
        if (this.channel == null) {
            return null;
        }
        int n = this.channel.getPointCount();
        double[] dArray = this.channel.getPointCoordinates(this.xAxis, this.yAxis);
        double[] dArray2 = new double[]{0.0, 0.0};
        float[] fArray = new float[n * 2];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray2[0] = dArray[n2];
            dArray2[1] = dArray[n2 + 1];
            dArray2 = this.toImage(dArray2);
            fArray[n2] = (float)dArray2[0];
            fArray[n2 + 1] = (float)dArray2[1];
            n2 += 2;
        }
        double[] dArray3 = this.getTopLeft();
        graphicObject.setTianiPositionData(dArray3[0] / (double)this.width, dArray3[1] / (double)this.height, this.w / (double)this.width, this.h / (double)this.height);
        graphicObject.setGraphicType(GraphicType.PolyLine);
        graphicObject.setGraphicFilled(YN.No);
        graphicObject.setTianiROIID("P" + this.id);
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(n));
        graphicObject.setGraphicData(fArray);
        arrayList.add(graphicObject);
        return arrayList;
    }

    public float getMarkerPosition(int n) {
        float f = 0.0f;
        if (this.markers != null && this.markers.size() > n) {
            f = this.markers.get((int)n).pos;
        }
        return f;
    }

    public void setMarkerPosition(int n, float f) {
        if (this.markers != null && this.markers.size() > n) {
            this.markers.get((int)n).pos = f;
        }
    }

    @Override
    protected int getClickedHandleIndex(int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.handles.length) {
            PresentationHandle presentationHandle = this.handles[n4];
            if (presentationHandle.mousePressed(n, n2)) {
                n3 = n4;
            }
            ++n4;
        }
        return n3;
    }

    @Override
    public void handleDragged(int n, double[] dArray) {
        super.handleDragged(n, dArray);
        if (n > 4) {
            this.markers.get((n - 5) / 2).handleDragged((n - 5) % 2, dArray);
        }
        this.setSaved(false);
    }

    @Override
    public boolean inBounds(int n, int n2) {
        if (this.isHandleClicked(n, n2)) {
            return true;
        }
        return super.inBounds(n, n2);
    }

    protected double getValidPos(double d) {
        double d2 = 0.0;
        int n = this.pointSequence.getPointCount();
        double d3 = this.lastLength;
        double[] dArray = this.lastPx;
        double[] dArray2 = this.lastPy;
        double d4 = 0.0;
        double d5 = d * d3;
        int n2 = 0;
        while (n2 < n - 1) {
            double d6 = Math.sqrt((dArray[n2] - dArray[n2 + 1]) * (dArray[n2] - dArray[n2 + 1]) + (dArray2[n2] - dArray2[n2 + 1]) * (dArray2[n2] - dArray2[n2 + 1]));
            if ((d4 += d6) > d5) {
                if (this.pointSequence.isInterceptionAt(n2)) {
                    d2 = d5 < d4 - d6 / 2.0 ? d4 - d6 : d4;
                    return d2 / d3;
                }
                return d;
            }
            ++n2;
        }
        return d;
    }

    @Override
    public boolean isShowConnections() {
        return false;
    }

    class Marker {
        float pos;
        float value;
        PresentationHandle lineH;
        PresentationHandle plotH;

        public Marker(float f, int n, int n2) {
            this.pos = f;
            this.lineH = new PresentationHandle(n, n2);
            this.plotH = new PresentationHandle(0, 0);
        }

        public void setLinePoint(int n, int n2) {
            this.lineH.x = n;
            this.lineH.y = n2;
        }

        public void paint(BufferedImageHolder bufferedImageHolder, int n, int n2, int n3, int n4) {
            int n5;
            int n6 = n + (int)((float)(n2 - n) * this.pos);
            bufferedImageHolder.graphics.setColor(Color.BLACK);
            int n7 = n5 = this.lineH.y < n4 ? n3 : n4;
            if (Math.abs(this.lineH.x - n6) < Math.abs(this.lineH.y - n3)) {
                bufferedImageHolder.graphics.drawLine(this.lineH.x - 1, this.lineH.y, n6 - 1, n5);
                bufferedImageHolder.graphics.drawLine(this.lineH.x + 1, this.lineH.y, n6 + 1, n5);
            } else {
                bufferedImageHolder.graphics.drawLine(this.lineH.x, this.lineH.y - 1, n6, n5 - 1);
                bufferedImageHolder.graphics.drawLine(this.lineH.x, this.lineH.y + 1, n6, n5 + 1);
            }
            bufferedImageHolder.graphics.setColor(DataProfile.this.objCol);
            bufferedImageHolder.graphics.drawLine(this.lineH.x, this.lineH.y, n6, n5);
            n5 = this.lineH.y < n4 ? n3 + DataProfile.this.getFontHeight() - DataProfile.this.getCurrentFontMetrics().getDescent() : n4 - DataProfile.this.getCurrentFontMetrics().getDescent();
            DataProfile.this.drawString(DataProfile.formatValue(this.value, DataProfile.this.getImageState().getCurrentValueMapping().getUnit()), DataProfile.this.objCol, bufferedImageHolder, n6, n5);
            bufferedImageHolder.graphics.drawLine(n6, n3, n6, n4);
            this.plotH.x = n6;
            this.plotH.y = this.lineH.y < n4 ? n4 : DataProfile.this.p1y;
        }

        public void handleDragged(int n, double[] dArray) {
            switch (n) {
                case 0: {
                    this.pos = DataProfile.this.findClosestPointOfPolyline(dArray);
                    if (this.pos < 0.0f) {
                        this.pos = 0.0f;
                    }
                    if (this.pos > 1.0f) {
                        this.pos = 1.0f;
                    }
                    DataProfile.this.updateMarkers();
                    break;
                }
                case 1: {
                    double[] dArray2 = DataProfile.this.toScreen(dArray);
                    double d = (dArray2[0] - (double)DataProfile.this.p0x) / (double)(DataProfile.this.p1x - DataProfile.this.p0x);
                    this.pos = (float)DataProfile.this.getValidPos(d);
                    if (this.pos < 0.0f) {
                        this.pos = 0.0f;
                    }
                    if (this.pos > 1.0f) {
                        this.pos = 1.0f;
                    }
                    DataProfile.this.updateMarkers();
                }
            }
        }
    }
}

