/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.tiani.jvision.image.PaletteColorLUT;
import com.tiani.jvision.image.SegmentedPaletteColorLUT;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;

public class ColorBarOverlay
extends PresentationObject {
    private double[] top_left = new double[2];
    private double[] bottom_right = new double[2];
    private int[] rgbLut;
    private String units = "";
    int offset;
    int length;
    protected int top_left_x;
    protected int top_left_y;
    protected int bottom_right_x;
    protected int bottom_right_y;
    private String description;

    public ColorBarOverlay() {
        super("Color Bar");
    }

    public ColorBarOverlay(double d, double d2, double d3, double d4, AnnotationUnits annotationUnits) {
        this();
        this.top_left[1] = d2;
        this.top_left[0] = d;
        this.bottom_right[1] = d4;
        this.bottom_right[0] = d3;
        this.toScreen();
        this.setSpacing(annotationUnits);
    }

    public void init(PaletteColorLUT paletteColorLUT, String string, String string2) {
        this.units = " " + string;
        this.description = string2;
        if (this.description == null) {
            this.description = "";
        }
        int[] nArray = paletteColorLUT.getRGB(false);
        this.rgbLut = new int[nArray.length];
        System.arraycopy(nArray, 0, this.rgbLut, 0, nArray.length);
        if (paletteColorLUT instanceof SegmentedPaletteColorLUT) {
            int n = ((SegmentedPaletteColorLUT)paletteColorLUT).getCenter();
            int n2 = ((SegmentedPaletteColorLUT)paletteColorLUT).getWidth();
            this.offset = n - (n2 >> 1);
            this.length = n2;
        } else {
            this.offset = 0;
            this.length = this.rgbLut.length;
        }
    }

    @Override
    protected void toScreen() {
        double[] dArray = this.toScreen(this.top_left);
        this.top_left_x = (int)dArray[0];
        this.top_left_y = (int)dArray[1];
        dArray = this.toScreen(this.bottom_right);
        this.bottom_right_x = (int)dArray[0];
        this.bottom_right_y = (int)dArray[1];
        this.bounds.x = Math.min(this.top_left_x, this.bottom_right_x) - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = Math.min(this.top_left_y, this.bottom_right_y) - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = Math.max(this.top_left_x, this.bottom_right_x) - this.bounds.x + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = Math.max(this.top_left_y, this.bottom_right_y) - this.bounds.y + 2 * PresentationHandle.HANDLE_SIZE;
    }

    @Override
    public PresentationObject cloneAll() {
        return this;
    }

    @Override
    protected void handleDragged(int n, double[] dArray) {
    }

    @Override
    protected void paintShape(BufferedImageHolder bufferedImageHolder) {
        bufferedImageHolder.graphics.setColor(this.objCol);
        ImageState imageState = this.getImageState();
        if (imageState.window == null) {
            return;
        }
        int n = imageState.window.getDataCenter();
        int n2 = imageState.window.getDataWidth();
        String string = this.description;
        String string2 = n + (n2 >> 1) + this.units;
        String string3 = n - (n2 >> 1) + this.units;
        FontMetrics fontMetrics = bufferedImageHolder.graphics.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string2, bufferedImageHolder.graphics);
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(string3, bufferedImageHolder.graphics);
        Rectangle2D rectangle2D3 = fontMetrics.getStringBounds(string, bufferedImageHolder.graphics);
        int n3 = this.top_left_x + (this.bottom_right_x - this.top_left_x >> 1);
        int n4 = (int)Math.min((double)n3 - rectangle2D3.getWidth() / 2.0, (double)bufferedImageHolder.width - rectangle2D3.getWidth());
        int n5 = (int)((double)n3 - rectangle2D.getWidth() / 2.0);
        int n6 = (int)((double)n3 - rectangle2D2.getWidth() / 2.0);
        if (string != null) {
            bufferedImageHolder.graphics.drawString(string, n4, this.top_left_y - 4 - fontMetrics.getHeight());
        }
        bufferedImageHolder.graphics.drawString(string2, n5, this.top_left_y - 2);
        bufferedImageHolder.graphics.drawString(string3, n6, this.bottom_right_y + (bufferedImageHolder.graphics.getFont().getSize() + 2));
        double d = this.bottom_right_y - this.top_left_y;
        try {
            int n7 = this.top_left_y;
            while (n7 <= this.bottom_right_y) {
                bufferedImageHolder.graphics.setColor(new Color(this.rgbLut[this.offset + (int)(((double)n7 - (double)this.top_left_y) / d * (double)this.length)]));
                int n8 = n7 + (int)d - (n7 - this.top_left_y << 1);
                bufferedImageHolder.graphics.drawLine(this.top_left_x, n8, this.bottom_right_x, n8);
                ++n7;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        return 0;
    }
}

