/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.jvision.overlay.AngleOverlay;
import com.tiani.jvision.overlay.PointToLineProjection;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CobbAngleOverlay
extends AngleOverlay {
    private AuxiliaryLine aux1;
    private AuxiliaryLine aux2;
    private double[] i;
    private int ix;
    private int iy;
    private double[] iTmp;
    private int intersectionPointHandleIndex;
    private boolean hasUserDefinedIntersectionPoint;

    public CobbAngleOverlay() {
        this.i = new double[2];
    }

    public CobbAngleOverlay(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, AnnotationUnits annotationUnits) {
        super(d, d2, d3, d4, d5, d6, d7, d8, annotationUnits);
        this.setEditable(!Product.isCDViewer());
        this.i = new double[2];
        this.iTmp = new double[]{d9, d10};
    }

    @Override
    protected void makeHandles() {
        super.makeHandles();
        this.intersectionPointHandleIndex = this.handles.length;
        this.handles = Arrays.copyOf(this.handles, this.handles.length + 1);
        this.handles[this.intersectionPointHandleIndex] = new PresentationHandle(0, 0);
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        if (n == this.intersectionPointHandleIndex) {
            this.hasUserDefinedIntersectionPoint = true;
            this.setIntersectionPointFromImage((double[])dArray.clone());
        } else {
            super.handleInteraction(n, dArray);
        }
        this.setSaved(false);
    }

    @Override
    void onTranslation(double d, double d2) {
        if (this.hasUserDefinedIntersectionPoint) {
            this.i[0] = this.i[0] + d;
            this.i[1] = this.i[1] + d2;
        }
    }

    @Override
    void toScreenImpl() {
        super.toScreenImpl();
        if (this.hasUserDefinedIntersectionPoint) {
            this.setIntersectionPointFromImage(this.i);
            return;
        }
        LineData lineData = new LineData(this.pxi, this.pyi, this.qxi, this.qyi);
        LineData lineData2 = new LineData(this.rxi, this.ryi, this.sxi, this.syi);
        double d = (double)(lineData.x1 + 9 * lineData.x2) / 10.0;
        double d2 = (double)(lineData.y1 + 9 * lineData.y2) / 10.0;
        double d3 = (double)(lineData2.x1 + 9 * lineData2.x2) / 10.0;
        double d4 = (double)(lineData2.y1 + 9 * lineData2.y2) / 10.0;
        Point2D point2D = this.intersectPerpendiculars(d, d2, d3, d4);
        if (this.isInBounds(lineData, lineData2, point2D.getX(), point2D.getY())) {
            this.aux1 = new AuxiliaryLine(d, d2);
            this.aux2 = new AuxiliaryLine(d3, d4);
            this.ix = CobbAngleOverlay.roundToInt(point2D.getX());
            this.iy = CobbAngleOverlay.roundToInt(point2D.getY());
            this.i = this.toImage(new double[]{this.ix, this.iy});
            this.updateIntersectionPointHandlePosition();
        } else {
            this.setIntersectionPointFromScreen((d + d3) / 2.0, (d2 + d4) / 2.0);
        }
        if (this.iTmp != null) {
            if (CobbAngleOverlay.roundToInt(this.i[0]) != CobbAngleOverlay.roundToInt(this.iTmp[0]) || CobbAngleOverlay.roundToInt(this.i[1]) != CobbAngleOverlay.roundToInt(this.iTmp[1])) {
                this.hasUserDefinedIntersectionPoint = true;
                this.setIntersectionPointFromImage(this.iTmp);
            }
            this.iTmp = null;
        }
    }

    private void setIntersectionPointFromImage(double[] dArray) {
        double[] dArray2 = this.toScreen(dArray);
        this.setIntersectionPoint(dArray, dArray2[0], dArray2[1]);
    }

    private void setIntersectionPointFromScreen(double d, double d2) {
        double[] dArray = new double[]{d, d2};
        this.setIntersectionPoint(this.toImage(dArray), d, d2);
    }

    private void setIntersectionPoint(double[] dArray, double d, double d2) {
        this.i = dArray;
        this.ix = CobbAngleOverlay.roundToInt(d);
        this.iy = CobbAngleOverlay.roundToInt(d2);
        this.aux1 = AuxiliaryLine.create(PointToLineProjection.project(this.pxi, this.pyi, this.qxi, this.qyi, this.ix, this.iy));
        this.aux2 = AuxiliaryLine.create(PointToLineProjection.project(this.rxi, this.ryi, this.sxi, this.syi, this.ix, this.iy));
        this.updateIntersectionPointHandlePosition();
    }

    private void updateIntersectionPointHandlePosition() {
        this.handles[this.intersectionPointHandleIndex].setPosition(this.ix, this.iy);
    }

    private Point2D intersectPerpendiculars(double d, double d2, double d3, double d4) {
        double d5 = d - (double)(this.qyi - this.pyi);
        double d6 = d2 + (double)(this.qxi - this.pxi);
        double d7 = d3 - (double)(this.syi - this.ryi);
        double d8 = d4 + (double)(this.sxi - this.rxi);
        double d9 = ((d7 - d3) * (d2 - d4) - (d8 - d4) * (d - d3)) / ((d8 - d4) * (d5 - d) - (d7 - d3) * (d6 - d2));
        double d10 = d + d9 * (d5 - d);
        double d11 = d2 + d9 * (d6 - d2);
        return new Point2D.Double(d10, d11);
    }

    private boolean isInBounds(LineData lineData, LineData lineData2, double d, double d2) {
        boolean bl;
        if (!this.isInBounds(d, d2)) {
            return false;
        }
        if (lineData.isHorizontal != lineData2.isHorizontal) {
            bl = true;
        } else if (lineData.isHorizontal) {
            int n = Math.min(Math.min(lineData.y1, lineData.y2), Math.min(lineData2.y1, lineData2.y2));
            int n2 = Math.max(Math.max(lineData.y1, lineData.y2), Math.max(lineData2.y1, lineData2.y2));
            bl = (double)n <= d2 && d2 <= (double)n2;
        } else {
            int n = Math.min(Math.min(lineData.x1, lineData.x2), Math.min(lineData2.x1, lineData2.x2));
            int n3 = Math.max(Math.max(lineData.x1, lineData.x2), Math.max(lineData2.x1, lineData2.x2));
            bl = (double)n <= d && d <= (double)n3;
        }
        return bl;
    }

    private boolean isInBounds(double d, double d2) {
        return 0.0 <= d && d <= (double)this.width && 0.0 <= d2 && d2 <= (double)this.height;
    }

    private static int roundToInt(double d) {
        return (int)(d + 0.5);
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        super.paintShape(bufferedImageHolder);
        if (this.isCompleted()) {
            Color color = bufferedImageHolder.graphics.getColor();
            Stroke stroke = bufferedImageHolder.graphics.getStroke();
            if (this.isUseOutlineFont()) {
                bufferedImageHolder.graphics.setColor(Color.black);
                bufferedImageHolder.graphics.setStroke(AUXILIARY_LINE_OUTLINE_STROKE);
                this.paintAuxiliaryLines(bufferedImageHolder);
            }
            bufferedImageHolder.graphics.setColor(color);
            bufferedImageHolder.graphics.setStroke(AUXILIARY_LINE_STROKE);
            this.paintAuxiliaryLines(bufferedImageHolder);
            bufferedImageHolder.graphics.setStroke(stroke);
        }
    }

    private void paintAuxiliaryLines(BufferedImageHolder bufferedImageHolder) {
        this.paintAuxiliaryLine(bufferedImageHolder, this.aux1, this.pxi, this.pyi, this.qxi, this.qyi);
        this.paintAuxiliaryLine(bufferedImageHolder, this.aux2, this.rxi, this.ryi, this.sxi, this.syi);
    }

    private void paintAuxiliaryLine(BufferedImageHolder bufferedImageHolder, AuxiliaryLine auxiliaryLine, int n, int n2, int n3, int n4) {
        if (auxiliaryLine != null) {
            bufferedImageHolder.graphics.drawLine(this.ix, this.iy, auxiliaryLine.x, auxiliaryLine.y);
            switch (auxiliaryLine.location) {
                case BEFORE_LINE_START: {
                    bufferedImageHolder.graphics.drawLine(auxiliaryLine.x, auxiliaryLine.y, n, n2);
                    break;
                }
                case AFTER_LINE_END: {
                    bufferedImageHolder.graphics.drawLine(auxiliaryLine.x, auxiliaryLine.y, n3, n4);
                    break;
                }
            }
        }
    }

    @Override
    void paintAdditionalConnections(BufferedImageHolder bufferedImageHolder) {
    }

    @Override
    protected void createBoundingShape() {
        super.createBoundingShape();
        this.createBoundingShape(this.pxi, this.pyi, this.qxi, this.qyi, this.aux1);
        this.createBoundingShape(this.rxi, this.ryi, this.sxi, this.syi, this.aux2);
    }

    private void createBoundingShape(int n, int n2, int n3, int n4, AuxiliaryLine auxiliaryLine) {
        if (auxiliaryLine != null) {
            this.outBounds.add(this.createBoundingLine(this.ix, this.iy, auxiliaryLine.x, auxiliaryLine.y));
            switch (auxiliaryLine.location) {
                case BEFORE_LINE_START: {
                    this.outBounds.add(this.createBoundingLine(n, n2, auxiliaryLine.x, auxiliaryLine.y));
                    break;
                }
                case AFTER_LINE_END: {
                    this.outBounds.add(this.createBoundingLine(n3, n4, auxiliaryLine.x, auxiliaryLine.y));
                    break;
                }
            }
        }
    }

    @Override
    public List<GraphicObject> storeROI() {
        List list = super.storeROI();
        List<double[]> list2 = this.collectAuxiliaryLinePoints();
        int n = list2.size();
        float[] fArray = new float[2 * n];
        int n2 = 0;
        while (n2 < n) {
            double[] dArray = list2.get(n2);
            fArray[2 * n2] = (float)dArray[0];
            fArray[2 * n2 + 1] = (float)dArray[1];
            ++n2;
        }
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.CobbAngle);
        graphicObject.setGraphicType(GraphicType.PolyLine);
        graphicObject.setGraphicData(fArray);
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(n));
        list.add(0, graphicObject);
        return list;
    }

    @Override
    public PresentationObject cloneAll() {
        CobbAngleOverlay cobbAngleOverlay = (CobbAngleOverlay)super.cloneAll();
        cobbAngleOverlay.i = ReferencedObjectsCloning.clone(this.i);
        return cobbAngleOverlay;
    }

    private List<double[]> collectAuxiliaryLinePoints() {
        ArrayList<double[]> arrayList = new ArrayList<double[]>(5);
        double[] dArray = new double[2];
        if (this.aux1.location == PointToLineProjection.Location.BEFORE_LINE_START) {
            dArray[0] = this.pxi;
            dArray[1] = this.pyi;
        } else {
            dArray[0] = this.qxi;
            dArray[1] = this.qyi;
        }
        arrayList.add(this.toImage(dArray));
        dArray[0] = this.aux1.x;
        dArray[1] = this.aux1.y;
        arrayList.add(this.toImage(dArray));
        arrayList.add(this.i);
        dArray[0] = this.aux2.x;
        dArray[1] = this.aux2.y;
        arrayList.add(this.toImage(dArray));
        if (this.aux2.location == PointToLineProjection.Location.BEFORE_LINE_START) {
            dArray[0] = this.rxi;
            dArray[1] = this.ryi;
        } else {
            dArray[0] = this.sxi;
            dArray[1] = this.syi;
        }
        arrayList.add(this.toImage(dArray));
        return arrayList;
    }

    private static class AuxiliaryLine {
        final int x;
        final int y;
        final PointToLineProjection.Location location;

        AuxiliaryLine(double d, double d2) {
            this(d, d2, PointToLineProjection.Location.WITHIN_LINE);
        }

        private AuxiliaryLine(double d, double d2, PointToLineProjection.Location location) {
            this.x = CobbAngleOverlay.roundToInt(d);
            this.y = CobbAngleOverlay.roundToInt(d2);
            this.location = location;
        }

        static AuxiliaryLine create(PointToLineProjection pointToLineProjection) {
            if (pointToLineProjection == null) {
                return null;
            }
            return new AuxiliaryLine(pointToLineProjection.getX(), pointToLineProjection.getY(), pointToLineProjection.getLocation());
        }
    }

    private static class LineData {
        final int x1;
        final int y1;
        final int x2;
        final int y2;
        final boolean isHorizontal;

        LineData(int n, int n2, int n3, int n4) {
            boolean bl = this.isHorizontal = Math.abs(n3 - n) > Math.abs(n4 - n2);
            if (n < n3) {
                this.x1 = n;
                this.y1 = n2;
                this.x2 = n3;
                this.y2 = n4;
            } else {
                this.x1 = n3;
                this.y1 = n4;
                this.x2 = n;
                this.y2 = n2;
            }
        }
    }
}

