/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.base.data.IImageRegionSpacing;
import com.tiani.jvision.overlay.IMeasurementOverlay;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.PointSequence;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import java.util.List;

abstract class AbstractRegionSpacingOverlay
extends SyncablePresentationObject
implements PointSequence,
IImageRegionSpacing,
IMeasurementOverlay {
    private double measurementResult;
    private boolean isUpdateMeasurementResultEnabled = true;
    private IImageRegionSpacing currentImageRegionSpacing = this;
    private final ImageRegionSpacingMode mode;

    AbstractRegionSpacingOverlay(String string, ImageRegionSpacingMode imageRegionSpacingMode) {
        super(string);
        this.mode = imageRegionSpacingMode;
    }

    protected IImageRegionSpacing getCurrentImageRegionSpacing() {
        return this.currentImageRegionSpacing;
    }

    @Override
    double calculateLength(double[] dArray, int n, int n2, double[] dArray2, int n3, int n4) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.spacingType == AnnotationUnits.Pixel) {
            d = (dArray2[0] - dArray[0]) * this.currentImageRegionSpacing.getDataPixelSizeX();
            d2 = (dArray2[1] - dArray[1]) * this.currentImageRegionSpacing.getDataPixelSizeY();
        } else {
            d = (double)(n - n3) * this.getPixelSizeX();
            d2 = (double)(n2 - n4) * this.getPixelSizeY();
        }
        return Math.sqrt(d * d + d2 * d2);
    }

    private void updateCurrentImageRegionSpacing() {
        IImageRegionSpacing iImageRegionSpacing = null;
        if (this.mode.isImageRegionSpacingSupported && this.isPixelUnit() && (iImageRegionSpacing = this.getView().getImageInformation().getImageRegionSpacing(this)) != null && !this.mode.isUnequalImageRegionSpacingSupported && !DoubleEquals.equals((double)iImageRegionSpacing.getDataPixelSizeX(), (double)iImageRegionSpacing.getDataPixelSizeY())) {
            iImageRegionSpacing = null;
        }
        if (iImageRegionSpacing == null) {
            iImageRegionSpacing = this;
        }
        this.currentImageRegionSpacing = iImageRegionSpacing;
    }

    @Override
    protected final void toScreen() {
        this.toScreenImpl();
        if (this.isUpdateMeasurementResultEnabled) {
            this.updateCurrentImageRegionSpacing();
            this.measurementResult = this.calculateMeasurementResult();
        }
        this.isUpdateMeasurementResultEnabled = true;
        this.setNonEditableAnnotation(this.updateAnnotation(), null);
    }

    abstract void toScreenImpl();

    @Override
    public double getMeasurementResult() {
        return this.measurementResult;
    }

    abstract double calculateMeasurementResult();

    abstract List<IOverlayInformation> updateAnnotation();

    protected void toScreenOnTranslation() {
        boolean bl;
        this.isUpdateMeasurementResultEnabled = bl = this.getView().getImageInformation().hasImageRegionSpacing() && this.isPixelUnit();
        this.toScreen();
        this.isUpdateMeasurementResultEnabled = bl;
    }

    @Override
    public String dimensionUnit() {
        return this.currentImageRegionSpacing.getUnit();
    }

    @Override
    public String getUnit() {
        return super.dimensionUnit();
    }

    static enum ImageRegionSpacingMode {
        DISABLED(false, false),
        ENABLED_EQUAL_PIXEL_SPACING(true, false),
        ENABLED_FULLY(true, true);

        final boolean isImageRegionSpacingSupported;
        final boolean isUnequalImageRegionSpacingSupported;

        private ImageRegionSpacingMode(boolean bl, boolean bl2) {
            this.isImageRegionSpacingSupported = bl;
            this.isUnequalImageRegionSpacingSupported = bl2;
        }
    }
}

