/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.base.util.ProcessorUtilities;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.main.GuiUsageListener;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MouseIdleChecker
implements AWTEventListener {
    private static final ALogger log = ALogger.getLogger(MouseIdleChecker.class);
    private static final int GUI_IDLE = 0;
    private static final int GUI_BUSY = 99;
    private static OwnIdleTimer mouseIdleTimer;
    private static final long mouseIdleTime = 1000L;
    private long mousePressedTimeout = 10000L;
    private List<GuiUsageListener> guiUsageListeners;
    private static MouseIdleChecker instance;
    private volatile int degreeOfUsage;
    private volatile int lastBroadcastedValue = 0;

    private MouseIdleChecker() {
        instance = this;
        this.guiUsageListeners = new CopyOnWriteArrayList<GuiUsageListener>();
        if (mouseIdleTimer == null && ProcessorUtilities.hasOnePhysicalCore()) {
            log.warn("Only one physical core detected. Starting MouseIdleChecker.");
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
            mouseIdleTimer = new OwnIdleTimer();
            Thread thread = new Thread(mouseIdleTimer);
            thread.setName("MouseIdleTimer");
            thread.setPriority(1);
            thread.start();
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 501) {
            mouseIdleTimer.startLongTimer();
            this.degreeOfUsage = 99;
            this.informListeners();
        } else if (aWTEvent.getID() == 502 || aWTEvent.getID() == 500) {
            mouseIdleTimer.startTimer();
        }
    }

    public void idleTimeout() {
        this.degreeOfUsage = 0;
        this.informListeners();
    }

    private void informListeners() {
        if (this.lastBroadcastedValue != this.degreeOfUsage) {
            for (GuiUsageListener guiUsageListener : this.guiUsageListeners) {
                guiUsageListener.guiUsageChanged(this.degreeOfUsage);
            }
            this.lastBroadcastedValue = this.degreeOfUsage;
        }
    }

    public void registerGuiUsageListener(GuiUsageListener guiUsageListener) {
        this.guiUsageListeners.add(guiUsageListener);
    }

    public void unregisterGuiUsageListener(GuiUsageListener guiUsageListener) {
        this.guiUsageListeners.remove(guiUsageListener);
    }

    public static MouseIdleChecker getInstance() {
        if (instance == null) {
            instance = new MouseIdleChecker();
        }
        return instance;
    }

    class OwnIdleTimer
    implements Runnable {
        private long timer;
        private boolean timerSet;
        private boolean timerRunning;

        OwnIdleTimer() {
            this.timer = MouseIdleChecker.this.mousePressedTimeout;
            this.timerSet = false;
            this.timerRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                OwnIdleTimer ownIdleTimer;
                try {
                    ownIdleTimer = this;
                    synchronized (ownIdleTimer) {
                        this.wait(this.timer);
                    }
                }
                catch (Exception exception) {}
                ownIdleTimer = this;
                synchronized (ownIdleTimer) {
                    if (this.timerRunning) {
                        instance.idleTimeout();
                    }
                    if (!this.timerSet) {
                        this.timer = MouseIdleChecker.this.mousePressedTimeout;
                        this.timerRunning = false;
                    } else {
                        this.timerRunning = true;
                    }
                    this.timerSet = false;
                }
            }
        }

        public synchronized void startTimer() {
            this.timerSet = true;
            this.timerRunning = false;
            this.timer = 1000L;
            this.notify();
        }

        public synchronized void startLongTimer() {
            this.timerSet = true;
            this.timerRunning = false;
            this.timer = MouseIdleChecker.this.mousePressedTimeout;
            this.notify();
        }

        public synchronized void stopTimer() {
            this.timerRunning = false;
            this.notify();
        }
    }
}

