/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.base.swing.IComponentFactoryProvider;
import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.FocusUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigUtilities;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequester;
import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.PerformanceProfiler;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.frameofreference.FrameOfReferenceManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.impl.HangingCaseDisplay;
import com.agfa.pacs.impaxee.hanging.impl.HangingCaseScreen;
import com.agfa.pacs.impaxee.hanging.model.DisplayState;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.enums.OrderHangingScreenStartDSStrategy;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHangingScreen;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHangingScreen;
import com.agfa.pacs.impaxee.hanging.runtime.DisplayLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingDefinitionRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.LayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.ScreenLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.plugin.IDisplayPlugin;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.agfa.pacs.impaxee.plugin.PluginManager;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.sessions.SessionDisplay;
import com.agfa.pacs.impaxee.sessions.SessionSnapshotRuntime;
import com.agfa.pacs.impaxee.setlive.SetLive;
import com.agfa.pacs.impaxee.setlive.SetLiveUtil;
import com.agfa.pacs.impaxee.toptoolbar.TopToolbarPane;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.dicomobject.iod.ps.SoftcopyPresentationStateInformationObject;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationStateRelationship;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationStateRelationshipModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.ReferencedSeries;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateSource;
import com.agfa.pacs.listtext.dicomobject.presentationstate.IPresentationStateInfo;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.agfa.pacs.listtext.swingx.util.ContextSensitiveHelpUtilities;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IStudyData;
import com.tiani.config.LayoutConfig;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import com.tiani.config.xml.minijaxb.XmlUtil;
import com.tiani.gui.dialog.GUIMessageHandler;
import com.tiani.gui.dialog.HideableDialogFactory;
import com.tiani.gui.util.panel.flexible.FlexiblePanel;
import com.tiani.gui.util.panel.flexible.util.DockingSynchronizeListener;
import com.tiani.jvision.actioncontext.ActionContextManager;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.FrameBar;
import com.tiani.jvision.main.ISeriesPalette;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2KeyListener;
import com.tiani.jvision.main.MainToolBar2;
import com.tiani.jvision.main.Modes;
import com.tiani.jvision.main.MouseIdleChecker;
import com.tiani.jvision.main.StudyAwareIterator;
import com.tiani.jvision.main.VisDisplayUtils;
import com.tiani.jvision.patinfo.DisplaySetPanel;
import com.tiani.jvision.plugin.DefaultPlugin;
import com.tiani.jvision.seriespalette.SeriesPalette;
import com.tiani.jvision.toolbox.PluginToolbox;
import com.tiani.jvision.toptoolbar.LayoutChangeAction;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.IStateLytScreen;
import com.tiani.jvision.vis.layout.LytMain;
import com.tiani.jvision.vis.layout.LytMainFilm;
import com.tiani.jvision.vis.layout.LytMainStripe;
import com.tiani.jvision.vis.layout.LytMainVariable;
import com.tiani.jvision.vis.layout.StateLytScreen;
import com.tiani.util.message.Message;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.color.ColorSpace;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.dcm4che3.data.Attributes;
import sun.awt.SunToolkit;

public class MainFrame2
extends JFrame
implements ComponentListener,
IConfigurationChangeListener,
IComponentFactoryProvider {
    private static final int QA_MINIMUM_FRAME_WIDTH = 1020;
    private static final int QA_MINIMUM_FRAME_HEIGHT = 760;
    private static final int QA_MINIMUM_BITS_PER_GRAY_PIXEL = 8;
    private static ALogger log = ALogger.getLogger(MainFrame2.class);
    private static final IFetcher fetcher = DataManager.getInstance().getFetcher();
    private Dimension startSettingSize = new Dimension();
    private Point startSettingLocation = new Point();
    private MainLayoutType lytMode = null;
    private LytMain lyt;
    private LytMainVariable lytVariable;
    private LytMainFilm lytFilm;
    private LytMainStripe lytStripe;
    private List<VisScreen2> screens = new Vector<VisScreen2>();
    private List<VisScreen2> allScreens = new Vector<VisScreen2>();
    private List<MainToolBar2> toolBars = new Vector<MainToolBar2>();
    private List<MainToolBar2> allToolBars = new Vector<MainToolBar2>();
    private List<FrameBar> frameBars = new ArrayList<FrameBar>();
    private int toolBarMode = 0;
    private boolean initialized = false;
    private MainContentPane jvisionContentPane;
    private JPanel seriesPaletteContentPane;
    private FlexiblePanel topToolbar;
    private SeriesPalette leftSeriesPalette;
    private SeriesPalette rightSeriesPalette;
    private volatile PluginToolbox pluginToolbox;
    private boolean QAwarningDisplayed = false;
    private MainFrame2KeyListener keyListener;
    private Modes.PaletteOrientation orientation = Modes.PaletteOrientation.valueOf(Config.impaxee.workstation.MONITORS.SeriesPaletteOrientation.get());
    private Rectangle savedBounds = null;
    private boolean isJumpToFirstKeyImageEnabled;

    public MainFrame2(LayoutConfig layoutConfig) {
        super(String.valueOf(Product.getProductName()) + "  " + Product.getVersionString() + Product.getReleaseConstraintsText(), layoutConfig.getImageAreaGraphicsConfiguration());
        Object object;
        this.toolBarMode = (int)Config.impaxee.jvision.STARTUP.CommanderMode.get();
        PIcon pIcon = PIconFactory.createdFixedSizeIconFactory((boolean)false, (int[])new int[]{64}).loadIcon(MainFrame2.class, "2270_Agfa-rhombus.svg");
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(pIcon.scaleToHeight(64).getImage());
        arrayList.add(pIcon.scaleToHeight(32).getImage());
        arrayList.add(pIcon.scaleToHeight(16).getImage());
        this.setIconImages(arrayList);
        this.setUndecorated(!JVision2.showTitleBar());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            try {
                object = toolkit.getClass().getMethod("disableBackgroundErase", Component.class);
                ((Method)object).invoke((Object)toolkit, this.getContentPane());
            }
            catch (Exception exception) {
                log.info("method to disable background erasing not found");
            }
        }
        this.keyListener = new MainFrame2KeyListener(this);
        KeyboardFocusManager.setCurrentKeyboardFocusManager(this.keyListener);
        this.jvisionContentPane = new MainContentPane();
        this.jvisionContentPane.setDoubleBuffered(false);
        this.seriesPaletteContentPane = new JPanel(new BorderLayout());
        this.seriesPaletteContentPane.add((Component)this.jvisionContentPane, "Center");
        object = new JPanel(new BorderLayout());
        ContextSensitiveHelpUtilities.setFallbackHelpTopicId((JComponent)object, (ContextSensitiveHelpUtilities.HelpTopic)ContextSensitiveHelpUtilities.HelpTopic.IMAGEAREA);
        ((Container)object).add((Component)this.seriesPaletteContentPane, "Center");
        this.setContentPane((Container)object);
        this.jvisionContentPane.setLayout(null);
        this.setBackground(Color.black);
        this.setResizable(Config.impaxee.jvision.MAIN.ShowTitlebar.get());
        this.addComponentListener(this);
        MouseIdleChecker.getInstance();
        ConfigurationProviderFactory.getConfig().registerConfigurationChangeListener(Config.impaxee.jvision.DISPLAY.jumpToFirstKeyImage.getKey(), (IConfigurationChangeListener)this);
        this.configurationChanged(Config.impaxee.jvision.DISPLAY.jumpToFirstKeyImage.getKey());
    }

    public JComponent getJVisionContentPane() {
        return this.jvisionContentPane;
    }

    public ComponentFactory getComponentFactory() {
        return ComponentFactory.instance;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    void initDone() {
        log.info("Init done.");
        this.initialized = true;
        if (!JVision2.showTitleBar()) {
            this.savedBounds = this.getBounds();
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paintAll(Graphics graphics) {
        if (!this.initialized) {
            return;
        }
        super.paintAll(graphics);
    }

    @Override
    public void repaint(long l) {
        if (!this.initialized) {
            return;
        }
        super.repaint(l);
    }

    @Override
    public void repaint(int n, int n2, int n3, int n4) {
        if (!this.initialized) {
            return;
        }
        super.repaint(n, n2, n3, n4);
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (!this.initialized) {
            return;
        }
        super.repaint(l, n, n2, n3, n4);
    }

    public void repaintSeriesPalettes() {
        if (this.leftSeriesPalette != null) {
            this.leftSeriesPalette.repaint();
        }
        if (this.rightSeriesPalette != null) {
            this.rightSeriesPalette.repaint();
        }
    }

    @Override
    public void paintComponents(Graphics graphics) {
        if (!this.initialized) {
            return;
        }
        super.paintComponents(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        if (!this.initialized) {
            return;
        }
        super.update(graphics);
    }

    @Override
    public void repaint() {
        if (!this.initialized) {
            return;
        }
        super.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.initialized) {
            return;
        }
        super.paint(graphics);
    }

    int getStartSettingLocationX() {
        return this.startSettingLocation.x;
    }

    int getStartSettingLocationY() {
        return this.startSettingLocation.y;
    }

    void setStartSettingLocationX(int n) {
        this.startSettingLocation.x = n;
    }

    void setStartSettingLocationY(int n) {
        this.startSettingLocation.y = n;
    }

    int getStartSettingSizeWidth() {
        return this.startSettingSize.width;
    }

    int getStartSettingSizeHeight() {
        return this.startSettingSize.height;
    }

    void setStartSettingSizeW(int n) {
        this.startSettingSize.width = n;
    }

    void setStartSettingSizeH(int n) {
        this.startSettingSize.height = n;
    }

    public void addScreen() {
        VisScreen2 visScreen2 = new VisScreen2();
        JPanel jPanel = new JPanel();
        FrameBar frameBar = new FrameBar(jPanel);
        this.frameBars.add(frameBar);
        visScreen2.getToolBar().addGlobalActions(jPanel);
        this.addScreen(visScreen2);
    }

    public void addScreen(VisScreen2 visScreen2) {
        if (!this.allScreens.contains(visScreen2)) {
            this.allScreens.add(visScreen2);
        }
        if (this.getLyt().allowsOneMoreScreen(this.getJVisionContentPane())) {
            if (!this.screens.contains(visScreen2)) {
                this.screens.add(visScreen2);
            }
            this.getJVisionContentPane().add(visScreen2.getToolBar());
            this.getJVisionContentPane().add(visScreen2);
            visScreen2.setActive(true);
            visScreen2.setVisible(true);
            visScreen2.setEnabled(true);
        } else {
            visScreen2.setActive(false);
            visScreen2.setVisible(false);
            visScreen2.setEnabled(false);
        }
    }

    void installTopToolbar() {
        if (this.topToolbar != null) {
            return;
        }
        try {
            int n;
            this.topToolbar = this.createTopToolbar((JComponent)this.getContentPane());
            int n2 = (int)Config.impaxee.jvision.STARTUP.CommanderMode.get();
            final int n3 = (int)Config.impaxee.jvision.STARTUP.SeriesPalette.dialog.x.get();
            final int n4 = (int)Config.impaxee.jvision.STARTUP.SeriesPalette.dialog.y.get();
            final int n5 = (int)Config.impaxee.jvision.STARTUP.SeriesPalette.dialog.width.get();
            final int n6 = (int)Config.impaxee.jvision.STARTUP.SeriesPalette.dialog.height.get();
            int n7 = n2 == 1 ? 16 : (n2 == 2 ? 8 : (n = n2 == 0 ? 2 : 1));
            if (this.orientation.isHorizontal() && n == 8) {
                n = 2;
            }
            this.leftSeriesPalette = new SeriesPalette(this.seriesPaletteContentPane, this.getToolBar(0).getSeqPanel(), this.orientation, this.orientation.getBorderOrientation(), n);
            SeriesPaletteStateListener seriesPaletteStateListener = new SeriesPaletteStateListener();
            this.leftSeriesPalette.addChangeListener(seriesPaletteStateListener);
            seriesPaletteStateListener.init(this.leftSeriesPalette);
            if (LayoutConfig.getInstance().getScreenColumns() > 1 && !this.orientation.isHorizontal()) {
                this.rightSeriesPalette = new SeriesPalette(this.seriesPaletteContentPane, this.getToolBar(1).getSeqPanel(), this.orientation, "East", n == 1 && this.orientation.isHorizontal() || n == 8 ? 16 : n);
            }
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MainFrame2.this.locateAndResizeSeriesPalette(true, MainFrame2.this.leftSeriesPalette, n3, n4, n5, n6);
                    MainFrame2.this.leftSeriesPalette.revalidate();
                    MainFrame2.this.leftSeriesPalette.repaint();
                    if (MainFrame2.this.rightSeriesPalette != null) {
                        MainFrame2.this.locateAndResizeSeriesPalette(false, MainFrame2.this.rightSeriesPalette, n3, n4, n5, n6);
                        new DockingSynchronizeListener(MainFrame2.this.leftSeriesPalette, MainFrame2.this.rightSeriesPalette);
                        MainFrame2.this.rightSeriesPalette.revalidate();
                        MainFrame2.this.rightSeriesPalette.repaint();
                    }
                }
            };
            if (this.isShowing()) {
                EventUtil.invoke((Runnable)runnable);
            } else {
                ComponentAdapter componentAdapter = new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent componentEvent) {
                        runnable.run();
                        MainFrame2.this.removeComponentListener(this);
                    }
                };
                this.addComponentListener(componentAdapter);
            }
            return;
        }
        catch (Exception exception) {
            this.topToolbar = null;
            log.error("Looks like some callback method was not provided!", (Throwable)exception);
            return;
        }
    }

    private FlexiblePanel createTopToolbar(JComponent jComponent) throws Exception {
        return new TopToolbarPane(jComponent);
    }

    public ISeriesPalette getSeriesPalette(boolean bl) {
        SeriesPalette seriesPalette;
        SeriesPalette seriesPalette2 = seriesPalette = bl ? this.leftSeriesPalette : this.rightSeriesPalette;
        if (seriesPalette == null) {
            seriesPalette = this.leftSeriesPalette;
        }
        return seriesPalette;
    }

    private void locateAndResizeSeriesPalette(boolean bl, SeriesPalette seriesPalette, int n, int n2, int n3, int n4) {
        int n5 = LytMainVariable.getCommanderWidth(this.orientation);
        assert (n5 > 0) : "Must have some initial width for series palette";
        int n6 = this.getHeight() - 97;
        assert (n6 > 0) : "Must have some initial height for series palette";
        Dimension dimension = this.orientation.isHorizontal() ? new Dimension(this.getWidth(), n5) : new Dimension(n5, n6);
        seriesPalette.setPreferredSize(dimension);
        if (n != -1 && n2 != -1) {
            if (n3 > 0 && n4 > 0) {
                seriesPalette.setDialogBounds(new Rectangle(n, n2, n3, n4), false);
            } else {
                seriesPalette.setDialogLocation(new Point(n, n2));
            }
            if (seriesPalette.getBehaviour() == 8) {
                seriesPalette.revalidate();
                seriesPalette.setHidden(false);
            }
        } else {
            Point point = this.seriesPaletteContentPane.getLocationOnScreen();
            if (!bl) {
                point.x += this.seriesPaletteContentPane.getWidth() - seriesPalette.getPreferredSize().width;
            }
            if (n3 > 0 && n4 > 0) {
                seriesPalette.setDialogBounds(new Rectangle(point.x, point.y, n3, n4), false);
            } else {
                seriesPalette.setDialogLocation(point);
            }
            if (seriesPalette.getBehaviour() == 8) {
                seriesPalette.revalidate();
                seriesPalette.setHidden(false);
            }
            log.debug("located series palette " + seriesPalette.hashCode() + " at " + point + ", having size " + seriesPalette.getPreferredSize());
        }
    }

    public FlexiblePanel getTopToolbar() {
        return this.topToolbar;
    }

    public void setSeriesPaletteToolBarPanel(JPanel jPanel) {
        if (this.leftSeriesPalette != null) {
            this.leftSeriesPalette.setToolBarPanel(jPanel);
        }
        if (this.rightSeriesPalette != null) {
            this.rightSeriesPalette.setToolBarPanel(jPanel);
        }
    }

    public void showLeftSeriesPaletteAsDialog() {
        this.toggleVisibility(this.leftSeriesPalette);
    }

    public void showRightSeriesPaletteAsDialog() {
        this.toggleVisibility(this.rightSeriesPalette);
    }

    public int getLeftSeriesPaletteWidth() {
        return this.getSeriesPaletteWidth(this.leftSeriesPalette);
    }

    public int getSeriesPaletteHeight() {
        return this.getSeriesPaletteHeight(this.leftSeriesPalette);
    }

    public int getRightSeriesPaletteWidth() {
        return this.getSeriesPaletteWidth(this.rightSeriesPalette);
    }

    private int getSeriesPaletteWidth(SeriesPalette seriesPalette) {
        return seriesPalette != null && seriesPalette.getBehaviour() == 2 ? seriesPalette.getSize().width : 0;
    }

    private int getSeriesPaletteHeight(SeriesPalette seriesPalette) {
        return seriesPalette != null && seriesPalette.getBehaviour() == 2 ? seriesPalette.getSize().height : 0;
    }

    private void toggleVisibility(SeriesPalette seriesPalette) {
        if (seriesPalette.getBehaviour() == 2 || seriesPalette.getBehaviour() == 8) {
            seriesPalette.setBehaviour(1);
        } else if (seriesPalette.getBehaviour() == 1 || seriesPalette.getBehaviour() == 16) {
            if (seriesPalette.getPreviousBehaviour() == 2 || seriesPalette.getPreviousBehaviour() == 8) {
                seriesPalette.setBehaviour(seriesPalette.getPreviousBehaviour());
            } else if (this.orientation.isHorizontal()) {
                seriesPalette.setBehaviour(2);
            } else {
                seriesPalette.setBehaviour(8);
            }
        } else {
            throw new IllegalStateException("Unknown SeriesPalette behaviour: " + seriesPalette.getBehaviour());
        }
    }

    public PluginToolbox getPluginToolbox() {
        if (this.pluginToolbox == null) {
            EventUtil.invokeSynchronous((Runnable)new Runnable(){

                @Override
                public void run() {
                    MainFrame2.this.pluginToolbox = new PluginToolbox(MainFrame2.this);
                }
            });
        }
        return this.pluginToolbox;
    }

    private void addToolBar() {
        MainToolBar2 mainToolBar2 = new MainToolBar2();
        this.addToolBar(mainToolBar2);
    }

    private void addToolBar(MainToolBar2 mainToolBar2) {
        boolean bl;
        if (!this.allToolBars.contains(mainToolBar2)) {
            this.allToolBars.add(mainToolBar2);
        }
        boolean bl2 = !this.possiblyMoreThanOneToolbar();
        boolean bl3 = bl = bl2 && this.toolBars.size() > 0;
        if (!bl && this.getLyt().allowsOneMoreToolBar(this.getJVisionContentPane())) {
            if (!this.toolBars.contains(mainToolBar2)) {
                this.toolBars.add(mainToolBar2);
            }
            mainToolBar2.setActive(true);
            mainToolBar2.setVisible(true);
            mainToolBar2.setEnabled(true);
            mainToolBar2.setHidden();
        } else {
            mainToolBar2.setActive(false);
            mainToolBar2.setVisible(false);
            mainToolBar2.setEnabled(false);
        }
    }

    public int getToolBarCount() {
        return this.toolBars.size();
    }

    public List<VisScreen2> getScreens() {
        return this.screens;
    }

    public List<VisScreen2> getAllScreens() {
        return this.allScreens;
    }

    public List<VisDisplay2> getDisplays() {
        ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>();
        for (VisScreen2 visScreen2 : this.screens) {
            arrayList.addAll(visScreen2.getDisplays());
        }
        return arrayList;
    }

    public int getIndexOfDisplay(VisDisplay2 visDisplay2) {
        int n = 0;
        for (VisScreen2 visScreen2 : this.screens) {
            int n2 = visScreen2.getDisplays().indexOf(visDisplay2);
            if (n2 >= 0) {
                return n + n2;
            }
            n += 100;
        }
        return -1;
    }

    public int[] getDisplayIndexOfScreen(VisDisplay2 visDisplay2) {
        int n = 0;
        while (n < this.screens.size()) {
            int n2 = this.screens.get(n).getDisplays().indexOf(visDisplay2);
            if (n2 >= 0) {
                return new int[]{n, n2};
            }
            ++n;
        }
        return null;
    }

    public List<VisDisplay2> getAllDisplays() {
        ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>();
        for (VisScreen2 visScreen2 : this.allScreens) {
            arrayList.addAll(visScreen2.getAllDisplays());
        }
        return arrayList;
    }

    public List<Vis2> getAllVis() {
        ArrayList<Vis2> arrayList = new ArrayList<Vis2>();
        for (VisDisplay2 visDisplay2 : this.getAllDisplays()) {
            arrayList.addAll(visDisplay2.getVisViews());
        }
        return arrayList;
    }

    public List<VisData> getAllVisDatas() {
        ArrayList<VisData> arrayList = new ArrayList<VisData>();
        for (VisDisplay2 visDisplay2 : this.getDisplays()) {
            arrayList.addAll(visDisplay2.getData().getVis());
        }
        return arrayList;
    }

    private List<VisDisplay2> getEmptyDisplays() {
        ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>();
        for (VisDisplay2 visDisplay2 : this.getDisplays()) {
            if (visDisplay2.hasData()) continue;
            arrayList.add(visDisplay2);
        }
        return arrayList;
    }

    public List<VisDisplay2> getFilledDisplays() {
        ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>();
        for (VisDisplay2 visDisplay2 : this.getDisplays()) {
            if (!visDisplay2.hasData()) continue;
            arrayList.add(visDisplay2);
        }
        return arrayList;
    }

    public VisDisplay2 getFirstDisplay() {
        return this.screens.isEmpty() || this.screens.get(0).getDisplays().size() <= 0 ? null : this.screens.get(0).getDisplays().get(0);
    }

    public VisDisplay2 getFirstFilledDisplay() {
        for (VisScreen2 visScreen2 : this.screens) {
            for (VisDisplay2 visDisplay2 : visScreen2.getDisplays()) {
                if (!visDisplay2.hasData()) continue;
                return visDisplay2;
            }
        }
        return null;
    }

    public VisDisplay2 getFirstEmptyDisplay() {
        for (VisScreen2 visScreen2 : this.screens) {
            for (VisDisplay2 visDisplay2 : visScreen2.getDisplays()) {
                if (visDisplay2.hasData()) continue;
                return visDisplay2;
            }
        }
        return null;
    }

    public VisDisplay2 getLastModifiedDisplay() {
        VisData visData = VisData.getLastModified();
        if (visData == null) {
            return null;
        }
        return visData.getParent().getVisDisplay();
    }

    public MainToolBar2 getToolBar(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.toolBars.size()) {
            return this.allToolBars.get(n);
        }
        return this.toolBars.get(n);
    }

    public DisplaySetPanel getSeqPanel(int n) {
        return this.getToolBar(n).getSeqPanel();
    }

    public LytMain getLyt() {
        return this.lyt;
    }

    public MainLayoutType getLytMode() {
        return this.lytMode;
    }

    public void setLytMode(MainLayoutType mainLayoutType) {
        this.setLytMode(mainLayoutType, 1, 1, false);
    }

    public void setLytMode(MainLayoutType mainLayoutType, int n, int n2, boolean bl) {
        this.setWaitCursor();
        boolean bl2 = mainLayoutType != this.lytMode;
        this.lytMode = mainLayoutType;
        if (bl2) {
            switch (mainLayoutType) {
                case variable: {
                    if (this.lytVariable == null) {
                        this.lytVariable = new LytMainVariable(this.orientation);
                    }
                    this.lyt = this.lytVariable;
                    break;
                }
                case stripe: {
                    if (this.lytStripe == null) {
                        this.lytStripe = new LytMainStripe(this.orientation);
                    }
                    this.lyt = this.lytStripe;
                    break;
                }
                case film: {
                    if (this.lytFilm == null) {
                        this.lytFilm = new LytMainFilm(this.orientation);
                    }
                    this.lyt = this.lytFilm;
                    break;
                }
                default: {
                    this.lytMode = mainLayoutType = MainLayoutType.variable;
                    if (this.lytVariable == null) {
                        this.lytVariable = new LytMainVariable(this.orientation);
                    }
                    this.lyt = this.lytVariable;
                }
            }
        }
        this.getJVisionContentPane().setLayout(this.lyt);
        VisScreen2[] visScreen2Array = new VisScreen2[this.allScreens.size()];
        int n3 = 0;
        while (n3 < visScreen2Array.length) {
            visScreen2Array[n3] = this.allScreens.get(n3);
            visScreen2Array[n3].setActive(true);
            ++n3;
        }
        this.toolBars.clear();
        this.screens.clear();
        Component[] componentArray = this.getJVisionContentPane().getComponents();
        int n4 = 0;
        while (n4 < componentArray.length) {
            if (componentArray[n4] instanceof VisScreen2) {
                VisScreen2 visScreen2 = (VisScreen2)componentArray[n4];
                this.getJVisionContentPane().remove(visScreen2.getToolBar());
                this.getJVisionContentPane().remove(visScreen2);
            }
            if (componentArray[n4] instanceof MainToolBar2) {
                this.getJVisionContentPane().remove(componentArray[n4]);
            }
            ++n4;
        }
        n4 = this.lyt.getMissingScreenCount(this.getJVisionContentPane());
        int n5 = 0;
        int n6 = 0;
        while (n6 < visScreen2Array.length) {
            if (visScreen2Array[n6].isActive()) {
                ++n5;
            }
            ++n6;
        }
        n6 = -1;
        int n7 = -1;
        VisData visData = VisData.getLastModified();
        VisScreen2 visScreen2 = null;
        if (visData != null && visData.getVisual() != null) {
            VisDisplay2 visDisplay2 = (VisDisplay2)visData.getVisual().getParent();
            visScreen2 = visDisplay2.getScreen();
        }
        if (n5 > n4) {
            int n8 = 0;
            while (n8 < visScreen2Array.length) {
                if (visScreen2Array[n8] == visScreen2) {
                    n7 = n8;
                }
                if (visScreen2Array[n8].isActive() && !visScreen2Array[n8].hasData()) {
                    visScreen2Array[n8].setActive(false);
                    --n5;
                }
                ++n8;
            }
        }
        int n9 = 0;
        while (n9 < visScreen2Array.length) {
            if (visScreen2Array[n9].isActive() && n6 == -1) {
                n6 = n9;
            }
            ++n9;
        }
        if (n4 > 0 && n7 >= 0 && visScreen2Array[n7].isActive()) {
            this.addScreen(visScreen2Array[n7]);
            --n4;
        }
        if (n4 > 0) {
            n9 = 0;
            while (n9 < visScreen2Array.length) {
                if (n9 != n7 && visScreen2Array[n9].isActive()) {
                    this.addScreen(visScreen2Array[n9]);
                    if (--n4 < 1) break;
                }
                ++n9;
            }
        }
        n4 = this.lyt.getMissingScreenCount(this.getJVisionContentPane());
        n9 = 0;
        while (n9 < visScreen2Array.length) {
            if (!visScreen2Array[n9].isActive()) {
                this.addScreen(visScreen2Array[n9]);
                if (--n4 < 1) break;
            }
            ++n9;
        }
        n4 = this.lyt.getMissingScreenCount(this.getJVisionContentPane());
        while (n4 > 0) {
            this.addScreen();
            --n4;
        }
        visScreen2Array = new VisScreen2[this.allScreens.size()];
        n9 = 0;
        while (n9 < visScreen2Array.length) {
            visScreen2Array[n9] = this.allScreens.get(n9);
            ++n9;
        }
        n4 = this.lyt.getMissingToolBarCount(this.getJVisionContentPane());
        n9 = 0;
        while (n9 < visScreen2Array.length) {
            if (visScreen2Array[n9].isActive() && (n9 == 0 || n9 == visScreen2Array.length - 1)) {
                this.addToolBar(visScreen2Array[n9].getMainToolBar());
                if (--n4 < 1) break;
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < visScreen2Array.length) {
            if (!(visScreen2Array[n9].isActive() || n9 != 0 && n9 != visScreen2Array.length - 1)) {
                this.addToolBar(visScreen2Array[n9].getMainToolBar());
                if (--n4 < 1) break;
            }
            ++n9;
        }
        while (n4 > 0) {
            this.addToolBar();
            --n4;
        }
        n9 = 0;
        while (n9 < this.allScreens.size()) {
            VisScreen2 visScreen22 = this.allScreens.get(n9);
            if (visScreen22.isActive()) {
                visScreen22.setLytMode(mainLayoutType, n, n2, bl);
            }
            ++n9;
        }
        if (bl2) {
            LayoutChangeAction.notifyMainLayoutChanged();
        }
        if (bl) {
            this.getJVisionContentPane().doLayout();
            this.getJVisionContentPane().repaint();
        }
        this.setDefaultCursor();
    }

    public void setWaitCursor() {
        CursorUtil.setWaitCursor((Component)this);
    }

    public void setDefaultCursor() {
        CursorUtil.resetWaitCursor((Component)this);
    }

    public void invalidateAll() {
        this.invalidateAll(this.getContentPane());
    }

    public void invalidateAll(Container container) {
        container.invalidate();
        int n = 0;
        while (n < container.getComponentCount()) {
            Component component = container.getComponent(n);
            if (component instanceof Container) {
                this.invalidateAll((Container)component);
            } else {
                component.invalidate();
            }
            ++n;
        }
    }

    public int getToolBarMode() {
        return this.toolBarMode;
    }

    public boolean possiblyMoreThanOneToolbar() {
        int n = this.getToolBarMode();
        return n == 0 || n == 3;
    }

    public void updateMouseModeCursor() {
        for (VisScreen2 visScreen2 : this.getScreens()) {
            for (VisDisplay2 visDisplay2 : visScreen2.getDisplays()) {
                int n = 0;
                while (n < visDisplay2.getVisViewCount()) {
                    Vis2 vis2 = visDisplay2.getVisView(n);
                    vis2.getMouseHandler().setCursor(visDisplay2.getData().getDisplayPlugin().getMouseModeInfo().getCursor(vis2));
                    ++n;
                }
            }
        }
    }

    public void updateLytHRs() {
        for (FrameBar frameBar : this.frameBars) {
            frameBar.updateLytHRs();
        }
    }

    public void removeEmptyDisplays() {
        log.info("Removing empty displays.");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getScreens().size();
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        boolean bl2 = false;
        n = 0;
        while (n < n5) {
            VisScreen2 visScreen2 = this.getScreens().get(n);
            n6 = visScreen2.getDisplays().size();
            n3 = 0;
            while (n3 < n6) {
                VisDisplay2 visDisplay2 = visScreen2.getDisplays().get(n3);
                if (!visDisplay2.hasData()) {
                    boolean bl3 = false;
                    n2 = n;
                    while (n2 < n5) {
                        VisScreen2 visScreen22 = this.getScreens().get(n2);
                        n7 = visScreen22.getDisplays().size();
                        int n8 = 0;
                        if (n2 == n) {
                            n8 = n3 + 1;
                        }
                        n4 = n8;
                        while (n4 < n7) {
                            VisDisplay2 visDisplay22 = visScreen22.getDisplays().get(n4);
                            if (visDisplay22.hasData()) {
                                bl2 = true;
                                bl3 = true;
                                VisDisplayUtils.swapDisplays(visScreen2, n3, visScreen22, n4);
                                break;
                            }
                            ++n4;
                        }
                        if (bl3) break;
                        ++n2;
                    }
                    if (!bl3) {
                        bl = true;
                    }
                    if (bl) break;
                }
                ++n3;
            }
            if (bl) break;
            ++n;
        }
        if (bl2) {
            this.getJVisionContentPane().validate();
            this.getJVisionContentPane().repaint();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        Rectangle rectangle = component.getBounds();
        log.debug("Resized to: x=" + rectangle.x + ", y=" + rectangle.y + ", width=" + rectangle.width + ", height=" + rectangle.height);
        if (this.isShowing()) {
            this.checkDisplayRequirements();
        }
        if (!JVision2.showTitleBar() && this.savedBounds != null && !componentEvent.getComponent().getBounds().equals(this.savedBounds)) {
            this.setBounds(this.savedBounds);
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (!JVision2.showTitleBar() && this.savedBounds != null && !componentEvent.getComponent().getBounds().equals(this.savedBounds)) {
            this.setBounds(this.savedBounds);
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void checkDisplayRequirements() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        ColorModel colorModel = graphicsConfiguration.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n = 8;
        if (colorSpace.getType() != 6 && !(colorModel instanceof IndexColorModel)) {
            n *= 3;
        }
        log.debug("Checking for minimum display requirements: (1020x760, " + n + "bpp)");
        DisplayMode displayMode = graphicsDevice.getDisplayMode();
        Dimension dimension = this.getSize();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (dimension.width < 1020 || dimension.height < 760) {
            stringBuffer.append("\nCurrent resolution (" + dimension.width + "x" + dimension.height + ") " + "does not meet minimum requirements of " + 1020 + "x" + 760);
            bl = true;
        }
        if (displayMode.getBitDepth() < n && displayMode.getBitDepth() != -1) {
            stringBuffer.append("\nCurrent display's bit depth (" + displayMode.getBitDepth() + ") " + "does not meet minimum requirement of " + n);
            bl = true;
        }
        if (bl && !this.QAwarningDisplayed) {
            this.QAwarningDisplayed = true;
            String string = String.valueOf(Messages.getString("INSUFFICIENT_DISPLAY_QUALITY")) + stringBuffer;
            log.warn("Show user notification: " + string);
            Message.warning(Messages.getString("WARNING"), string);
        }
        this.QAwarningDisplayed = bl;
    }

    void logMonitorData() {
        int n;
        if (log.isInfoEnabled()) {
            log.info("MainFrame size=" + this.getSize() + ", location=" + this.getLocation());
            log.info("workstation->MONITORS, NumberOfMonitorsInUse=" + Config.impaxee.local.MONITORS.NumberOfMonitorsInUse.get() + ", UseDynamicMonitorDetection=" + Config.impaxee.workstation.MONITORS.UseDynamicMonitorDetection.get() + ", ScreenSizeX=" + Config.impaxee.workstation.MONITORS.ScreenSizeX.get() + ", ScreenSizeY=" + Config.impaxee.workstation.MONITORS.ScreenPixelSizeY.get() + ", ScreenOffsetX=" + Config.impaxee.workstation.MONITORS.ScreenOffsetX.get() + ", ScreenOffsetY=" + Config.impaxee.workstation.MONITORS.ScreenOffsetY.get());
        }
        log.info("" + LayoutConfig.getInstance());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n2 = n = graphicsDeviceArray != null ? graphicsDeviceArray.length : -1;
        if (log.isDebugEnabled()) {
            log.debug("Number of GraphicsDevice objects: " + n);
            int n3 = 0;
            while (graphicsDeviceArray != null && n3 < graphicsDeviceArray.length) {
                log.debug("\tGraphicsDevice[" + n3 + "] (default " + (graphicsDeviceArray[n3] == graphicsDevice) + "): id=" + graphicsDeviceArray[n3].getIDstring() + ", type=" + (graphicsDeviceArray[n3].getType() == 2 ? "TYPE_IMAGE_BUFFER" : (graphicsDeviceArray[n3].getType() == 1 ? "TYPE_PRINTER" : (graphicsDeviceArray[n3].getType() == 0 ? "TYPE_RASTER_SCREEN" : "(unknown type)"))) + ", displayChangeSupported=" + graphicsDeviceArray[n3].isDisplayChangeSupported() + ", fullScreenSupported=" + graphicsDeviceArray[n3].isFullScreenSupported());
                log.debug("\t\tAWT Toolkit insets " + Toolkit.getDefaultToolkit().getScreenInsets(graphicsDeviceArray[n3].getDefaultConfiguration()));
                GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[n3].getDefaultConfiguration();
                log.debug("\t\tdefault GraphicsConfiguration: bounds=" + graphicsConfiguration.getBounds() + ", accelerated=" + graphicsConfiguration.getImageCapabilities().isAccelerated() + ", trueVolatile=" + graphicsConfiguration.getImageCapabilities().isTrueVolatile());
                DisplayMode displayMode = graphicsDeviceArray[n3].getDisplayMode();
                log.info("\t\tDisplayMode: height=" + displayMode.getHeight() + ", width=" + displayMode.getWidth() + ", bitDepth=" + displayMode.getBitDepth() + ", refreshRate=" + displayMode.getRefreshRate());
                ColorModel colorModel = graphicsConfiguration.getColorModel();
                log.debug("\t\tColorModel: bitsPerPixel=" + colorModel.getPixelSize() + ", transparency=" + (colorModel.getTransparency() == 3 ? "TRANSLUCENT" : (colorModel.getTransparency() == 1 ? "OPAQUE" : (colorModel.getTransparency() == 2 ? "BITMASK" : "(unknown)"))) + ", transferType=" + colorModel.getTransferType() + ", hasAlpha=" + colorModel.hasAlpha() + ", alphaPremultiplied=" + colorModel.isAlphaPremultiplied());
                ColorSpace colorSpace = colorModel.getColorSpace();
                log.debug("\t\tColorSpace: type=" + colorSpace.getType());
                ++n3;
            }
        }
    }

    void shutdownPending() {
        Point serializable2;
        Integer n = this.topToolbar != null ? Integer.valueOf(this.topToolbar.getBehaviour()) : null;
        int n2 = 2;
        if (n != null && n == 1) {
            n2 = 1;
        }
        Config.impaxee.jvision.STARTUP.TopToolbarMode.set(n2);
        Integer n3 = this.leftSeriesPalette != null ? Integer.valueOf(this.leftSeriesPalette.getBehaviour()) : null;
        Integer n4 = this.rightSeriesPalette != null ? Integer.valueOf(this.rightSeriesPalette.getBehaviour()) : null;
        int n5 = 16;
        Rectangle rectangle = null;
        if (n3 != null && n3 == 8) {
            n5 = 8;
            rectangle = this.leftSeriesPalette.getDialogBounds();
        } else if (n4 != null && n4 == 8) {
            n5 = 8;
            rectangle = this.rightSeriesPalette.getDialogBounds();
        } else if (n3 != null) {
            n5 = n3;
        }
        if (rectangle == null && ((rectangle = this.leftSeriesPalette.getDialogBounds()) == null || rectangle.x == -1 && rectangle.y == -1)) {
            rectangle = this.rightSeriesPalette.getDialogBounds();
        }
        Config.impaxee.jvision.STARTUP.CommanderMode.set(n5 == 16 ? 1 : (n5 == 8 ? 2 : (n5 == 2 ? 0 : 3)));
        if (rectangle != null) {
            Config.impaxee.jvision.STARTUP.SeriesPalette.dialog.x.set(rectangle.x);
            Config.impaxee.jvision.STARTUP.SeriesPalette.dialog.y.set(rectangle.y);
            Config.impaxee.jvision.STARTUP.SeriesPalette.dialog.width.set(rectangle.width);
            Config.impaxee.jvision.STARTUP.SeriesPalette.dialog.height.set(rectangle.height);
        }
        if (Config.impaxee.jvision.STARTUP.Toolbox.StorePosition.get() && (serializable2 = PluginToolbox.getPosition()) != null) {
            Config.impaxee.local.Toolbox.storedPosition.x.set(serializable2.x);
            Config.impaxee.local.Toolbox.storedPosition.y.set(serializable2.y);
        }
        for (VisDisplay2 visDisplay2 : this.getAllDisplays()) {
            IDisplayPlugin iDisplayPlugin;
            if (visDisplay2.getData() == null || !visDisplay2.getData().hasData() || (iDisplayPlugin = visDisplay2.getData().getDisplayPlugin()) == null) continue;
            iDisplayPlugin.cleanUp();
        }
    }

    public void configurationChanged(String string) {
        this.isJumpToFirstKeyImageEnabled = Config.impaxee.jvision.DISPLAY.jumpToFirstKeyImage.get();
    }

    public boolean isJumpToFirstKeyImageEnabled() {
        return this.isJumpToFirstKeyImageEnabled;
    }

    public void hangup(IHanging iHanging, String string) {
        if (PerformanceProfiler.active) {
            Vis2.countFirstImage = true;
        }
        VisData.blockLastModifiedChange(true);
        try {
            if (iHanging instanceof HangingProtocolRuntime) {
                HangingProtocolRuntime object = (HangingProtocolRuntime)iHanging;
                this.hangupHangingCaseSnapshot(object, string);
            } else if (iHanging instanceof Session) {
                this.hangupSessionSnapshot((Session)iHanging, string);
            }
            for (VisDisplay2 visDisplay2 : this.getDisplays()) {
                if (!visDisplay2.hasData()) continue;
                visDisplay2.getData().getDisplayPlugin().notifyHangupCompleted();
            }
        }
        finally {
            VisData.blockLastModifiedChange(false);
            if (iHanging != null && iHanging.getStudyContainer() != null) {
                this.handleLastModifiedAfterHangup(iHanging.getStudyContainer().getBaseStudy());
            } else {
                VisData.resetLastModified();
            }
        }
    }

    private void makeDisplayActive(VisDisplay2 visDisplay2) {
        Vis2 vis2 = visDisplay2.getVisView(0);
        if (vis2 != null) {
            vis2.makeTheLastModified();
            ActionContextManager.singleton.contextChanged(visDisplay2.getData());
        }
    }

    private void handleLastModifiedAfterHangup(IStudyData iStudyData) {
        for (VisDisplay2 visDisplay2 : this.getDisplays()) {
            IStudyData iStudyData2;
            if (!visDisplay2.hasData() || (iStudyData2 = visDisplay2.getData().getDisplaySet().getOneObject().getParent().getParent()) != iStudyData) continue;
            this.makeDisplayActive(visDisplay2);
            return;
        }
        for (VisDisplay2 visDisplay2 : this.getDisplays()) {
            if (!visDisplay2.hasData()) continue;
            this.makeDisplayActive(visDisplay2);
            break;
        }
    }

    public void clearAllDisplays() {
        VisData.resetLastModified();
        VisData.blockLastModifiedChange(true);
        try {
            for (VisDisplay2 visDisplay2 : this.getAllDisplays()) {
                if (!visDisplay2.hasData()) continue;
                visDisplay2.clear(false, false);
            }
        }
        finally {
            VisData.blockLastModifiedChange(false);
        }
        FrameOfReferenceManager.clearAllFrames();
    }

    private void hangupSessionSnapshot(IHangingSession iHangingSession, String string) {
        SessionSnapshotRuntime sessionSnapshotRuntime = (SessionSnapshotRuntime)iHangingSession.getSnapshotModel().get(string);
        if (sessionSnapshotRuntime != null) {
            PresentationStateRelationshipModule presentationStateRelationshipModule;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            this.establishMainFrameLayout(sessionSnapshotRuntime);
            List<VisDisplay2> list = this.getDisplays();
            int n = Math.min(this.getDisplays().size(), sessionSnapshotRuntime.displays().size());
            int n2 = 0;
            while (n2 < n) {
                SessionDisplay sessionDisplay = sessionSnapshotRuntime.displays().get(n2);
                if (sessionDisplay.getSessionDisplaySet() == null) {
                    sessionDisplay.setVisDisplay(null);
                } else {
                    sessionDisplay.setVisDisplay(list.get(n2));
                }
                ++n2;
            }
            HashMap<SessionDisplay, Object> hashMap = new HashMap<SessionDisplay, Object>();
            for (SessionDisplay sessionDisplay : sessionSnapshotRuntime.displays()) {
                object7 = new HashMap();
                object6 = sessionDisplay.getPresentationStates();
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    object4 = object5.next();
                    object3 = SoftcopyPresentationStateInformationObject.createInstance((Attributes)object4);
                    object2 = DataManager.getInstance().getStudyByStudyInstanceUID(object3.getStudyIdentifier().getStudyInstanceUID());
                    if (object2 == null) continue;
                    object = object2.getFramePresentationStateProviderContainer().add((SoftcopyPresentationStateInformationObject)object3, false);
                    presentationStateRelationshipModule = (PresentationStateRelationshipModule)object3.getModule(PresentationStateRelationshipModule.class);
                    PresentationStateRelationship presentationStateRelationship = presentationStateRelationshipModule.getPresentationStateRelationship();
                    for (ReferencedSeries referencedSeries : presentationStateRelationship.referencedSeries()) {
                        for (ReferencedImage referencedImage : referencedSeries.referencedImages().values()) {
                            object7.put(referencedImage.getSOPInstanceUID(), object);
                        }
                    }
                }
                hashMap.put(sessionDisplay, object7);
            }
            this.clearAllDisplays();
            for (SessionDisplay sessionDisplay : sessionSnapshotRuntime.displays()) {
                if (sessionDisplay.getSessionDisplaySet() == null) continue;
                object7 = sessionDisplay.getSessionDisplaySet().getDisplaySet();
                object6 = sessionDisplay.getVisDisplay();
                if (object6 == null) continue;
                ((VisDisplay2)object6).initVisDisplay((IDisplaySet)object7, sessionDisplay.getNavigPos(), true, ActivationMode.HANGUP);
                ((VisDisplay2)object6).setSynchronized(sessionDisplay.isSynced());
                object4 = ((VisDisplay2)object6).getVis();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object5 = (VisData)object3.next();
                    object2 = ((VisData)object5).getView();
                    object = (Map)hashMap.get(sessionDisplay);
                    presentationStateRelationshipModule = (IPresentationStateInfo)object.get(((View)object2).getFrameData().getSOPInstanceUID());
                    if (presentationStateRelationshipModule == null) continue;
                    ((View)object2).applyPresentationState((IFramePresentationStateSource)presentationStateRelationshipModule);
                }
                if (!Config.impaxee.jvision.PLUGINS.AutoSetLive.get() || !SetLiveUtil.isSetLiveCapable((VisDisplay2)object6)) continue;
                EventQueue.invokeLater(new SetLive((VisDisplay2)object6));
            }
            this.doLayout();
        } else {
            log.warn("No snapshot available for session '" + iHangingSession.getVisibleName() + "', no hangup!");
        }
    }

    private void hangupHangingCaseSnapshot(HangingProtocolRuntime hangingProtocolRuntime, String string) {
        if (hangingProtocolRuntime != null) {
            HangingDefinitionRuntime hangingDefinitionRuntime;
            if (log.isDebugEnabled()) {
                log.debug("Going to hang up snapshot \"" + string + "\" from hanging case: " + hangingProtocolRuntime.getVisibleName());
            }
            if ((hangingDefinitionRuntime = hangingProtocolRuntime.getHangingDefinition()) != null) {
                HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime = hangingDefinitionRuntime.snapshotForName(string);
                if (hangingProtocolSnapshotRuntime.isHangingApplied()) {
                    this.hangupSnapshotRuntime(hangingProtocolSnapshotRuntime);
                    if (hangingProtocolSnapshotRuntime.getClearCachedDSAfterFirstUse()) {
                        hangingProtocolSnapshotRuntime.setHangingApplied(false);
                        hangingProtocolSnapshotRuntime.setClearCachedDSAfterFirstUse(false);
                    }
                } else {
                    IDicomDataRequester iDicomDataRequester = DicomDataRequester.getInstance();
                    try {
                        try {
                            iDicomDataRequester.setIdleState(false);
                            this.applyHangingForSnapshot(hangingProtocolRuntime, hangingProtocolSnapshotRuntime);
                        }
                        catch (Exception exception) {
                            log.error("Error hanging up", (Throwable)exception);
                            iDicomDataRequester.setIdleState(true);
                        }
                    }
                    finally {
                        iDicomDataRequester.setIdleState(true);
                    }
                }
            } else {
                log.warn("No hanging definition present for hanging case " + hangingProtocolRuntime.getVisibleName());
            }
        }
    }

    private void hangupSnapshotRuntime(HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime) {
        LayoutRuntime layoutRuntime = hangingProtocolSnapshotRuntime.getLayout();
        if (layoutRuntime != null) {
            List<HangingCaseScreen> list = this.establishMainFrameLayout(hangingProtocolSnapshotRuntime);
            Iterator<HangingCaseScreen> iterator = list.iterator();
            ScreenLayoutRuntime[] screenLayoutRuntimeArray = layoutRuntime.screenLayouts();
            int n = screenLayoutRuntimeArray.length;
            int n2 = 0;
            while (n2 < n && iterator.hasNext()) {
                HangingCaseScreen hangingCaseScreen = iterator.next();
                Iterator iterator2 = hangingCaseScreen.iterator();
                ScreenLayoutRuntime screenLayoutRuntime = screenLayoutRuntimeArray[n2];
                DisplayLayoutRuntime[] displayLayoutRuntimeArray = screenLayoutRuntime.displayLayouts();
                int n3 = displayLayoutRuntimeArray.length;
                VisDisplay2.setWarnOnlyOnceOnNextPatientMixture(true);
                int n4 = 0;
                while (iterator2.hasNext() && n4 < n3) {
                    Integer n5;
                    DisplayLayoutRuntime displayLayoutRuntime = displayLayoutRuntimeArray[n4];
                    IDisplaySet iDisplaySet = displayLayoutRuntime.getDisplaySet();
                    HangingCaseDisplay hangingCaseDisplay = (HangingCaseDisplay)iterator2.next();
                    if (iDisplaySet == null && (n5 = displayLayoutRuntime.getDisplayState().getKeyImageOverviewStudyIndex()) != null && n5 >= 0) {
                        HangingProtocolRuntime hangingProtocolRuntime = hangingProtocolSnapshotRuntime.getHangingDefinitionRuntime().getHangingProtocolRuntime();
                        IStudyContainer iStudyContainer = hangingProtocolRuntime.getStudyContainer();
                        IStudyData iStudyData = null;
                        iStudyData = n5 == 0 ? iStudyContainer.getBaseStudy() : iStudyContainer.loadRelevantPrior(n5 - 1);
                        if (iStudyData != null) {
                            iDisplaySet = hangingProtocolRuntime.getSplitAndSortRuntime().getKeyImageDisplaySet(iStudyData);
                        }
                    }
                    if (iDisplaySet != null) {
                        this.hangDisplaySetIntoHangingCaseDisplay(iDisplaySet, hangingCaseDisplay);
                    }
                    ++n4;
                }
                VisDisplay2.setWarnOnlyOnceOnNextPatientMixture(false);
                ++n2;
            }
            HangingCaseDisplay.setHPPrepareFinished();
        } else {
            log.warn("Cannot hangup snapshot runtime since there is no layout runtime: " + hangingProtocolSnapshotRuntime.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyHangingForSnapshot(HangingProtocolRuntime hangingProtocolRuntime, HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime) {
        hangingProtocolRuntime.ensurePriorsLoaded();
        if (hangingProtocolSnapshotRuntime != null) {
            if (log.isTraceEnabled()) {
                log.trace("Hanging up snapshot:\n" + XmlUtil.getObjectAsXML((XmlSaveable)((XmlSaveable)hangingProtocolSnapshotRuntime.getDelegate())));
            }
            assert (hangingProtocolSnapshotRuntime.getLayout() != null) : "Every snapshot must contain the layout!";
            List<HangingCaseScreen> list = this.establishMainFrameLayout(hangingProtocolSnapshotRuntime);
            if (hangingProtocolSnapshotRuntime.getOrderHanging() != null) {
                OrderHanging orderHanging = hangingProtocolSnapshotRuntime.getOrderHanging();
                if (orderHanging.getIsReverseDisplayOrder().booleanValue()) {
                    Collections.reverse(list);
                    for (HangingCaseScreen listIterator2 : list) {
                        Collections.reverse(listIterator2);
                    }
                }
                ListIterator<IDisplaySet> bl = hangingProtocolRuntime.getDisplaySets().listIterator();
                int n = 0;
                while (n < list.size()) {
                    void var5_10;
                    HangingCaseScreen hangingCaseScreen = list.get(n);
                    OrderHangingScreen orderHangingScreen = orderHanging.getOrderHangingScreen(n);
                    Iterator iterator = hangingCaseScreen.iterator();
                    if (orderHangingScreen != null) {
                        ListIterator<IDisplaySet> listIterator = this.getIteratorForOrderHangingStrategy((ListIterator<IDisplaySet>)var5_10, orderHangingScreen.getOrderHangingScreenStartDSStrategy(), hangingProtocolRuntime.getDisplaySets(), hangingProtocolRuntime.getStudyContainer(), n);
                    }
                    if (var5_10 != null) {
                        IStudyData iStudyData = null;
                        while (iterator.hasNext() && var5_10.hasNext()) {
                            IDisplaySet iDisplaySet = (IDisplaySet)var5_10.next();
                            if (!iDisplaySet.getOneObject().getParent().getParent().equals(iStudyData) && iStudyData != null && orderHangingScreen != null && orderHangingScreen.getOrderHangingScreenStartDSStrategy() != null && orderHangingScreen.getOrderHangingScreenStartDSStrategy() != OrderHangingScreenStartDSStrategy.CURRENT_DISPLAY_SET) {
                                if (!log.isDebugEnabled()) break;
                                log.debug("Stopping hanging of screen " + n + " due to study end reached.");
                                break;
                            }
                            HangingCaseDisplay hangingCaseDisplay = (HangingCaseDisplay)iterator.next();
                            this.hangDisplaySetIntoHangingCaseDisplay(iDisplaySet, hangingCaseDisplay);
                            iStudyData = iDisplaySet.getOneObject().getParent().getParent();
                        }
                    }
                    ++n;
                }
                this.doLayout();
                HangingCaseDisplay.setHPPrepareFinished();
            } else if (hangingProtocolSnapshotRuntime.getConditionalHanging() != null) {
                ConditionalHanging conditionalHanging = hangingProtocolSnapshotRuntime.getConditionalHanging();
                boolean bl = conditionalHanging.getMultipleHangupPossible();
                boolean bl2 = conditionalHanging.getFillEmptyDisplays();
                int n = Math.min(conditionalHanging.screenCount(), list.size());
                ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>(hangingProtocolRuntime.getDisplaySets());
                int n2 = 0;
                while (n2 < n) {
                    HangingCaseScreen hangingCaseScreen = list.get(n2);
                    Iterator iterator = hangingCaseScreen.iterator();
                    ConditionalHangingScreen conditionalHangingScreen = conditionalHanging.getConditionalHangingScreen(n2);
                    int n3 = 0;
                    while (iterator.hasNext() && n3 < conditionalHangingScreen.runtimeGetDisplaySetConditionCount()) {
                        Object object;
                        Object object2;
                        DisplaySetCondition displaySetCondition2 = conditionalHangingScreen.getDisplaySetCondition(n3);
                        Object object3 = null;
                        if (displaySetCondition2 != null) {
                            if (displaySetCondition2.baseDisplaySet() == null || !arrayList.contains(displaySetCondition2.baseDisplaySet())) {
                                if (bl) {
                                    object3 = HangingUtil.getFirstMatchingDisplaySet(hangingProtocolRuntime, displaySetCondition2);
                                } else {
                                    object3 = HangingUtil.pickFirstMatchingDisplaySetConsuming(arrayList, hangingProtocolRuntime, displaySetCondition2);
                                    if (bl2 && object3 == null && displaySetCondition2.referencedDescriptorList().isEmpty()) {
                                        object2 = arrayList.iterator();
                                        while (object2.hasNext()) {
                                            object = (IDisplaySet)object2.next();
                                            if (hangingProtocolRuntime.isDisplaySetAlreadyUsed((IDisplaySet)object)) continue;
                                            object3 = object;
                                            object2.remove();
                                            break;
                                        }
                                    }
                                }
                                displaySetCondition2.runtimeSetBaseDisplaySet((IDisplaySet)object3);
                            } else {
                                object3 = displaySetCondition2.baseDisplaySet();
                                arrayList.remove(object3);
                            }
                        }
                        object2 = (HangingCaseDisplay)iterator.next();
                        if (object3 == null && (object = ((HangingCaseDisplay)object2).getLayoutRuntime().getDisplayState().getKeyImageOverviewStudyIndex()) != null && (Integer)object >= 0) {
                            IStudyContainer iStudyContainer = hangingProtocolRuntime.getStudyContainer();
                            IStudyData iStudyData = null;
                            iStudyData = (Integer)object == 0 ? iStudyContainer.getBaseStudy() : iStudyContainer.loadRelevantPrior((Integer)object - 1);
                            if (iStudyData != null) {
                                object3 = hangingProtocolRuntime.getSplitAndSortRuntime().getKeyImageDisplaySet(iStudyData);
                            }
                        }
                        if (object3 != null) {
                            this.hangDisplaySetIntoHangingCaseDisplay((IDisplaySet)object3, (HangingCaseDisplay)object2);
                            hangingProtocolRuntime.markDisplaySetAsLoaded((IDisplaySet)object3);
                        }
                        ++n3;
                    }
                    ++n2;
                }
                HangingCaseDisplay.setHPPrepareFinished();
            }
            if (hangingProtocolSnapshotRuntime.getCacheDisplaySets()) {
                hangingProtocolSnapshotRuntime.setHangingApplied(true);
                hangingProtocolSnapshotRuntime.captureAfterHangup();
            }
        } else {
            log.warn("No snapshot available for Hanging State '" + hangingProtocolRuntime.getVisibleName() + "', no hangup!");
        }
    }

    private ListIterator<IDisplaySet> getIteratorForOrderHangingStrategy(ListIterator<IDisplaySet> studyAwareIterator, OrderHangingScreenStartDSStrategy orderHangingScreenStartDSStrategy, List<IDisplaySet> list, IStudyContainer iStudyContainer, int n) {
        ListIterator<IDisplaySet> listIterator = null;
        if (orderHangingScreenStartDSStrategy == null) {
            orderHangingScreenStartDSStrategy = OrderHangingScreenStartDSStrategy.CURRENT_DISPLAY_SET;
        }
        switch (orderHangingScreenStartDSStrategy) {
            case BASE_STUDY: {
                listIterator = this.gotToFirstDisplaySetOfStudy(list.listIterator(), iStudyContainer.getBaseStudy());
                break;
            }
            case CURRENT_DISPLAY_SET: {
                listIterator = studyAwareIterator;
                break;
            }
            case CURRENT_STUDY: {
                if (studyAwareIterator instanceof StudyAwareIterator) {
                    StudyAwareIterator studyAwareIterator2 = studyAwareIterator;
                    if (!studyAwareIterator2.hasNext()) {
                        studyAwareIterator2.nextStudy();
                    }
                    listIterator = studyAwareIterator2;
                    break;
                }
                listIterator = new StudyAwareIterator(list);
                break;
            }
            case FIRST_PRIOR: {
                int n2 = iStudyContainer.getRelevantPriorCount();
                if (n2 <= 0) break;
                listIterator = this.gotToFirstDisplaySetOfStudy(list.listIterator(), iStudyContainer.loadRelevantPrior(0));
                break;
            }
            case SECOND_PRIOR: {
                int n3 = iStudyContainer.getRelevantPriorCount();
                if (n3 <= 1) break;
                listIterator = this.gotToFirstDisplaySetOfStudy(list.listIterator(), iStudyContainer.loadRelevantPrior(1));
                break;
            }
            case THIRD_PRIOR: {
                int n4 = iStudyContainer.getRelevantPriorCount();
                if (n4 <= 2) break;
                listIterator = this.gotToFirstDisplaySetOfStudy(list.listIterator(), iStudyContainer.loadRelevantPrior(2));
                break;
            }
            case FOURTH_PRIOR: {
                int n5 = iStudyContainer.getRelevantPriorCount();
                if (n5 <= 3) break;
                listIterator = this.gotToFirstDisplaySetOfStudy(list.listIterator(), iStudyContainer.loadRelevantPrior(3));
                break;
            }
            case FIFTH_PRIOR: {
                int n6 = iStudyContainer.getRelevantPriorCount();
                if (n6 <= 4) break;
                listIterator = this.gotToFirstDisplaySetOfStudy(list.listIterator(), iStudyContainer.loadRelevantPrior(4));
                break;
            }
            case OLDEST_PRIOR: {
                int n7 = iStudyContainer.getRelevantPriorCount();
                if (n7 <= 0) break;
                listIterator = this.gotToFirstDisplaySetOfStudy(list.listIterator(), iStudyContainer.loadRelevantPrior(n7 - 1));
            }
        }
        return listIterator;
    }

    private ListIterator<IDisplaySet> gotToFirstDisplaySetOfStudy(ListIterator<IDisplaySet> listIterator, IStudyData iStudyData) {
        while (listIterator.hasNext()) {
            if (listIterator.next().getOneObject().getParent().getParent() != iStudyData) continue;
            listIterator.previous();
            break;
        }
        return listIterator;
    }

    public Modes.PaletteOrientation getPaletteOrientation() {
        return this.orientation;
    }

    private void hangDisplaySetIntoHangingCaseDisplay(IDisplaySet iDisplaySet, HangingCaseDisplay hangingCaseDisplay) {
        if (iDisplaySet.getFrameCount() > 0) {
            fetcher.changeToHigherPriorityIfExists(iDisplaySet.getOneObject(), (byte)0);
        }
        DisplayState displayState = null;
        if (hangingCaseDisplay.getLayoutRuntime() != null) {
            displayState = hangingCaseDisplay.getLayoutRuntime().getDisplayState();
        }
        Integer n = null;
        if (displayState != null) {
            if (this.isJumpToFirstKeyImageEnabled || Boolean.TRUE.equals(displayState.getJumpToFirstKeyImage())) {
                n = KeyImageManager.getInstance().getFirstMarked(iDisplaySet.getObjects());
            }
            if (n == null) {
                n = (int)(displayState.getScrollPosition() * (double)iDisplaySet.getFrameCount());
            }
        }
        hangingCaseDisplay.hangup(iDisplaySet, n, false);
    }

    private List<HangingCaseScreen> establishMainFrameLayout(AbstractSnapshotRuntime abstractSnapshotRuntime) {
        HangingCaseScreen hangingCaseScreen;
        LayoutRuntime layoutRuntime = abstractSnapshotRuntime.getLayout();
        ScreenLayoutRuntime[] screenLayoutRuntimeArray = layoutRuntime.screenLayouts();
        ArrayList<HangingCaseScreen> arrayList = new ArrayList<HangingCaseScreen>();
        if (LayoutConfig.getInstance().getScreenCount() < screenLayoutRuntimeArray.length) {
            if (abstractSnapshotRuntime instanceof HangingProtocolSnapshotRuntime) {
                abstractSnapshotRuntime.setScreencountMismatch();
                log.warn("hanging monitor count mismatch");
            } else {
                HideableDialogFactory.showWarningDialog((Component)JVision2.getMainFrame(), Messages.getString("Mainframe2.ScreencountDoesNotMatch"), Config.impaxee.jvision.DIALOGS.ScreencountMismatch.getKey());
            }
        }
        if (layoutRuntime.getType() != null && this.getLytMode() != layoutRuntime.getType()) {
            this.setLytMode(layoutRuntime.getType());
        }
        Iterator<VisScreen2> iterator = new ArrayList<VisScreen2>(this.getScreens()).iterator();
        int n = 0;
        while (n < screenLayoutRuntimeArray.length && iterator.hasNext()) {
            hangingCaseScreen = new HangingCaseScreen();
            IStateLytScreen object = this.getScreenLayoutState(layoutRuntime.getType(), screenLayoutRuntimeArray[n]);
            VisScreen2 visScreen2 = iterator.next();
            if (object != null) {
                visScreen2.setLytMode(layoutRuntime.getType(), object, true);
            }
            int n2 = visScreen2.getDisplays().size();
            DisplayLayoutRuntime[] displayLayoutRuntimeArray = screenLayoutRuntimeArray[n].displayLayouts();
            int n3 = 0;
            while (n3 < displayLayoutRuntimeArray.length && n3 < n2) {
                String string;
                Dimension dimension = this.toDimension(displayLayoutRuntimeArray[n3].getHorizontalXVertical());
                VisDisplay2 visDisplay2 = visScreen2.getDisplays().get(n3);
                HangingCaseDisplay hangingCaseDisplay = new HangingCaseDisplay(visDisplay2, displayLayoutRuntimeArray[n3]);
                hangingCaseScreen.add(hangingCaseDisplay);
                visDisplay2.setLytMode(layoutRuntime.getType().getNewLytDisplay(), dimension.width, dimension.height, false, false);
                IPlugin iPlugin = null;
                if (displayLayoutRuntimeArray[n3].getPluginName() != null && !DefaultPlugin.defaultPluginName.equals(displayLayoutRuntimeArray[n3].getPluginName()) && (iPlugin = PluginManager.getPlugin(string = displayLayoutRuntimeArray[n3].getPluginName())) == null) {
                    log.error("Could not instantiate plugin " + string + " which was stored in hanging.");
                }
                visDisplay2.setDisplayTypeAfterNextReceive(iPlugin, displayLayoutRuntimeArray[n3].getSetLiveData());
                ++n3;
            }
            arrayList.add(hangingCaseScreen);
            ++n;
        }
        while (iterator.hasNext()) {
            hangingCaseScreen = new HangingCaseScreen();
            VisScreen2 visScreen2 = iterator.next();
            visScreen2.setLytMode(layoutRuntime.getType(), 1, 1, true);
            for (VisDisplay2 visDisplay2 : visScreen2.getDisplays()) {
                visDisplay2.setDisplayTypeAfterNextReceive(null, null);
                HangingCaseDisplay hangingCaseDisplay = new HangingCaseDisplay(visDisplay2, null);
                hangingCaseScreen.add(hangingCaseDisplay);
            }
            arrayList.add(hangingCaseScreen);
        }
        this.validate();
        return arrayList;
    }

    private IStateLytScreen getScreenLayoutState(MainLayoutType mainLayoutType, ScreenLayoutRuntime screenLayoutRuntime) {
        String string = null;
        if (mainLayoutType != MainLayoutType.variable) {
            if (screenLayoutRuntime.getDisplayLayoutCount() > 0) {
                string = screenLayoutRuntime.getDisplayLayout(0).getHorizontalXVertical();
            } else {
                log.warn("No display layout defined.");
            }
        }
        return StateLytScreen.parse(mainLayoutType, screenLayoutRuntime.getHorizontalXVertical(), string);
    }

    private Dimension toDimension(String string) {
        Dimension dimension = ImpaxEEUtils.horizontalXVertical2Dimension(string);
        if (dimension == null) {
            log.warn("Could not parse dimension: " + string);
            dimension = new Dimension(1, 1);
        }
        return dimension;
    }

    void setSeriesPalettesBehaviour(int n) {
        if (this.leftSeriesPalette != null) {
            this.leftSeriesPalette.setBehaviour(n);
        }
        if (this.rightSeriesPalette != null) {
            this.rightSeriesPalette.setBehaviour(n);
        }
    }

    public Point determineInitialPluginToolboxPosition(VisDisplay2 visDisplay2) {
        Integer n;
        VisScreen2 visScreen2 = visDisplay2.getVisScreen();
        Point point = null;
        Point point2 = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point2, visDisplay2);
        point = point2;
        if (Config.impaxee.jvision.STARTUP.Toolbox.StorePosition.get()) {
            int n2 = (int)Config.impaxee.local.Toolbox.storedPosition.x.get();
            int n3 = (int)Config.impaxee.local.Toolbox.storedPosition.y.get();
            if (n2 != -1 && n3 != -1) {
                point = new Point(n2, n3);
                return point;
            }
        }
        Integer n4 = this.leftSeriesPalette != null ? Integer.valueOf(this.leftSeriesPalette.getBehaviour()) : null;
        Integer n5 = n = this.rightSeriesPalette != null ? Integer.valueOf(this.rightSeriesPalette.getBehaviour()) : null;
        if (n4 != null && n4 != 8 && n4 != 1 && n4 != 16 && n != null && n != 8 && n != 1 && n4 != 16) {
            if (visScreen2 == this.allScreens.get(0)) {
                Point point3 = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point3, this.leftSeriesPalette);
                point = point3;
            } else if (visScreen2 == this.allScreens.get(this.allScreens.size() - 1)) {
                Point point4 = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point4, this.rightSeriesPalette);
                point = point4;
            } else {
                Point point5 = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point5, visDisplay2);
                point = point5;
            }
        }
        return point;
    }

    public class MainContentPane
    extends JPanel
    implements KeyListener {
        public MainContentPane() {
            if (Config.impaxee.jvision.DISPLAY.whiteBackground.get()) {
                this.setBackground(Color.white);
            } else {
                this.setBackground(Color.black);
            }
        }

        @Override
        public void repaint() {
            if (MainFrame2.this == null) {
                return;
            }
            if (MainFrame2.this.getLyt() == null) {
                return;
            }
            super.repaint();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            MainFrame2.this.processKeyEvent(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            MainFrame2.this.processKeyEvent(keyEvent);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            MainFrame2.this.processKeyEvent(keyEvent);
        }
    }

    protected static class MainEventQueue
    extends EventQueue {
        private static final long FREEZE_TIMER_PERIOD = 10000L;
        private volatile AWTEvent currentEvent;
        private volatile Thread eventDispatchThread;

        public MainEventQueue() {
            if (!ConfigUtilities.isDebug() && !Product.isRunningAutoTests()) {
                Timer timer = new Timer("Freeze Detector", true);
                timer.schedule((TimerTask)new FreezeTimerTask(), 10000L, 10000L);
            }
        }

        @Override
        protected void dispatchEvent(AWTEvent aWTEvent) {
            this.eventDispatchThread = Thread.currentThread();
            this.currentEvent = aWTEvent;
            if (aWTEvent instanceof WindowEvent && (aWTEvent.getSource() instanceof Frame || aWTEvent.getSource() instanceof Dialog && ((Dialog)aWTEvent.getSource()).isModal())) {
                Window window = (Window)aWTEvent.getSource();
                if (aWTEvent.getID() == 205) {
                    GUIMessageHandler.setParentWindow(window);
                }
            }
            try {
                try {
                    super.dispatchEvent(aWTEvent);
                }
                catch (Exception exception) {
                    log.error("Exception during dispatchEvent: ", (Throwable)exception);
                    this.currentEvent = null;
                }
            }
            finally {
                this.currentEvent = null;
            }
        }

        private class FreezeTimerTask
        extends TimerTask {
            private AWTEvent lastEvent;

            private FreezeTimerTask() {
            }

            @Override
            public void run() {
                if (this.lastEvent != null && this.lastEvent == MainEventQueue.this.currentEvent) {
                    this.printStack();
                }
                this.lastEvent = MainEventQueue.this.currentEvent;
            }

            private void printStack() {
                StackTraceElement[] stackTraceElementArray = MainEventQueue.this.eventDispatchThread.getStackTrace();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Freeze detected on EDT:");
                StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement stackTraceElement = stackTraceElementArray2[n2];
                    stringBuilder.append(stackTraceElement.toString()).append('\n');
                    ++n2;
                }
                log.error(stringBuilder.toString());
            }
        }
    }

    private static class SeriesPaletteStateListener
    implements ChangeListener {
        private SeriesPaletteStateListener() {
        }

        public void init(FlexiblePanel flexiblePanel) {
            if (flexiblePanel.getBehaviour() != 8) {
                FocusUtil.clearLTADockedWindows();
            } else {
                Window window = flexiblePanel.getRealDialog();
                if (window != null) {
                    FocusUtil.addLTADockedWindow((Window)window);
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            FlexiblePanel flexiblePanel = (FlexiblePanel)changeEvent.getSource();
            this.init(flexiblePanel);
        }
    }
}

