/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfoListener;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeInfoGlobal;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseSubModes;
import com.agfa.pacs.impaxee.mousemodeinfo.POCreationStatus;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.util.TIcon;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.IViewMouseHandler;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.fithandler.IViewportRestoreHandler;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.OverlayType;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ROIFactory;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.vecmath.Vector2d;

public abstract class AbstractMouseModeInfo
implements IMouseModeInfo {
    private static final ALogger log = ALogger.getLogger(AbstractMouseModeInfo.class);
    protected boolean areHotRegionsInside = true;
    public MouseSubModes subMode;
    public MouseSubModes lastSubMode = this.subMode = MouseSubModes.DEFAULT;
    private final List<IMouseModeInfoListener> mouseModeListeners = new CopyOnWriteArrayList<IMouseModeInfoListener>();
    protected PresentationObject poInCreation;
    private View destination;
    private boolean clone;
    private double zoomValueBeforePO;
    private Vector2d centreBeforPO;
    private IViewportRestoreHandler restoreHandler;
    boolean isROIShuttered = false;
    boolean isROIFilled = false;
    boolean isROIRelativeScreen = false;
    public static final boolean deactivateMeasurementAfterDrawing = Config.impaxee.jvision.MEASUREMENT.DeactivateMeasurementAfterDrawing.get();

    public AbstractMouseModeInfo() {
    }

    public AbstractMouseModeInfo(IMouseModeInfoListener iMouseModeInfoListener) {
        this();
        this.addMouseModeInfoListener(iMouseModeInfoListener);
    }

    @Override
    public void addMouseModeInfoListener(IMouseModeInfoListener iMouseModeInfoListener) {
        if (!this.mouseModeListeners.contains(iMouseModeInfoListener)) {
            this.mouseModeListeners.add(iMouseModeInfoListener);
        }
    }

    @Override
    public boolean allowsSelection() {
        return false;
    }

    @Override
    public boolean areHotRegionsEnabled() {
        return true;
    }

    @Override
    public boolean areHotRegionsInside() {
        return this.areHotRegionsInside;
    }

    @Override
    public void setHotRegionsInside(boolean bl) {
        if (this.areHotRegionsInside != bl) {
            this.areHotRegionsInside = bl;
            this.informHotregionOutsideModeListeners();
        }
    }

    @Override
    public MouseSubModes getSubMode() {
        return this.subMode;
    }

    @Override
    public void handleEscape() {
        if (VisData.getLastModified() != null) {
            IViewMouseHandler iViewMouseHandler = VisData.getLastModified().getView().getMouseHandler();
            if (iViewMouseHandler.roiCreationInProgress()) {
                iViewMouseHandler.onROIDelete();
            } else {
                iViewMouseHandler.deSelect();
            }
        }
        this.resetSubMode();
        this.informMouseModeListeners();
    }

    @Override
    public boolean isNavigationAllowed() {
        return false;
    }

    @Override
    public void resetSubMode() {
        this.setSubMode(MouseSubModes.DEFAULT);
    }

    @Override
    public void setLastSubMode() {
        if (this.lastSubMode == MouseSubModes.DEFAULT && this.subMode == MouseSubModes.DEFAULT) {
            return;
        }
        if (this.lastSubMode == this.subMode) {
            this.setSubMode(MouseSubModes.DEFAULT);
        } else {
            this.setSubMode(this.lastSubMode);
        }
    }

    @Override
    public void setSubMode(MouseSubModes mouseSubModes) {
        this.subMode = mouseSubModes;
        if (mouseSubModes != MouseSubModes.DEFAULT) {
            this.lastSubMode = mouseSubModes;
            this.setHotRegionsInside(false);
            if (Product.isCDViewer()) {
                JVision2.getMainFrame().setTitle(String.valueOf(Product.getProductName()) + "  " + Product.getVersionString() + Product.getReleaseConstraintsText() + " - " + Messages.getString("WindowTitleAddonTextForMeasurementInCDViewer"));
            }
        } else {
            this.setHotRegionsInside(true);
        }
        switch (mouseSubModes) {
            case DEFAULT: {
                this.placePresentationObject(null, true);
                break;
            }
            case MEASURE_DISTANCE: {
                this.placeLength();
                break;
            }
            case MEASURE_ANGLE: {
                this.placeAngle();
                break;
            }
            case MEASURE_COBB_ANGLE: {
                this.placeCobbAngle();
                break;
            }
            case MEASURE_NORMAL_DISTANCE: {
                this.placeNormalDistance();
                break;
            }
            case MEASURE_RATIO: {
                this.placeRatio();
                break;
            }
            case MEASURE_BIDIMENSIONAL_LENGTH: {
                this.placeBidimensionalLength();
                break;
            }
            case MEASURE_HORIZONTAL_DISTANCE: {
                this.placeHorizontalDistance();
                break;
            }
            case MEASURE_DOUBLE_CENTERLINE: {
                this.placeDoubleCenterline();
                break;
            }
            case DRAW_CENTERLINE: {
                this.placeCenterline();
                break;
            }
            case DRAW_ARROW: {
                this.placeArrow();
                break;
            }
            case DRAW_TEXT: {
                this.placeText();
                break;
            }
            case DRAW_CIRCLE: {
                this.placeCircle();
                break;
            }
            case DRAW_CIRCLE_3POINT: {
                this.placeCircle3Point();
                break;
            }
            case DRAW_ELLIPSE: {
                this.placeEllipse();
                break;
            }
            case DRAW_RECTANGLE: {
                this.placeRectangle();
                break;
            }
            case DRAW_POLYGON: 
            case EMPR_SEGMENTATION_DRAW_BACKGROUND_POLYGON: 
            case EMPR_SEGMENTATION_DRAW_STRUCTURE_POLYGON: {
                this.placePolygon();
                break;
            }
            case LEFT: {
                this.placeLeftPolygon();
                break;
            }
            case RIGHT: {
                this.placeRightPolygon();
                break;
            }
            case DRAW_SPLINECURVE: {
                this.placeSpline();
            }
        }
        this.informMouseModeListeners();
        if (!(this instanceof MouseModeInfoGlobal) && mouseSubModes.isPluginMouseMode()) {
            MouseModeInfoGlobal.getInstance().resetSubMode();
        }
    }

    protected void informMouseModeListeners() {
        for (IMouseModeInfoListener iMouseModeInfoListener : this.mouseModeListeners) {
            iMouseModeInfoListener.mouseModeChanged();
        }
    }

    @Override
    public void removeMouseModeInfoListener(IMouseModeInfoListener iMouseModeInfoListener) {
        this.mouseModeListeners.remove(iMouseModeInfoListener);
    }

    protected void informHotregionOutsideModeListeners() {
        for (IMouseModeInfoListener iMouseModeInfoListener : this.mouseModeListeners) {
            iMouseModeInfoListener.hotregionOutsideModeChanged(this.areHotRegionsInside);
        }
    }

    @Override
    public POCreationStatus getPresentationObjectCreationStatus() {
        return new POCreationStatus(this.poInCreation, this.destination, this.clone, this.isROIFilled, this.isROIShuttered, this.isROIRelativeScreen);
    }

    @Override
    public void setPresentationObjectCreationStatus(POCreationStatus pOCreationStatus) {
        this.poInCreation = pOCreationStatus.getPOInCreation();
        this.destination = pOCreationStatus.getDestination();
        this.clone = pOCreationStatus.isCloneMode();
        this.isROIFilled = pOCreationStatus.isROIFilled();
        this.isROIShuttered = pOCreationStatus.isROIShuttered();
        this.isROIRelativeScreen = pOCreationStatus.isROIRelativeScreen();
    }

    @Override
    public void storeStateBeforeMeasurement(IViewportRestoreHandler iViewportRestoreHandler, Vector2d vector2d, double d) {
        if (this.restoreHandler == null) {
            this.restoreHandler = iViewportRestoreHandler;
            this.centreBeforPO = new Vector2d(vector2d);
            this.zoomValueBeforePO = d;
        }
    }

    @Override
    public void restoreStateAfterMeasurement(View view) {
        if (this.restoreHandler != null) {
            TEvent tEvent = new TEvent();
            tEvent.id = 2;
            tEvent.interactionModifier = 2;
            TEventDispatch.sendEvent(view.getDisplay(), tEvent, (Object)new ZoomParameter(1.0 / this.zoomValueBeforePO), true);
            this.restoreHandler.restoreViewportCenter(view, this.centreBeforPO.x, this.centreBeforPO.y);
            this.centreBeforPO = null;
            this.restoreHandler = null;
        }
    }

    @Override
    public PresentationObject getPlacedPresentationObject() {
        return this.poInCreation;
    }

    @Override
    public void setPlacedPresentationObject(PresentationObject presentationObject) {
        this.poInCreation = presentationObject;
    }

    @Override
    public void placePresentationObject(PresentationObject presentationObject, View view, boolean bl) {
        this.poInCreation = presentationObject;
        this.destination = view;
        this.clone = bl;
    }

    @Override
    public void placePresentationObject(PresentationObject presentationObject, boolean bl) {
        this.poInCreation = presentationObject;
        this.destination = null;
        this.clone = bl;
    }

    @Override
    public PresentationObject getPresentationObjectToPlace(View view) {
        if (this.poInCreation == null) {
            return null;
        }
        if (this.validPlacementDestination(view)) {
            if (this.clone) {
                try {
                    PresentationObject presentationObject = view.getCustomizedOverlay(this.poInCreation);
                    if (presentationObject == null) {
                        presentationObject = (PresentationObject)this.poInCreation.getClass().newInstance();
                        presentationObject.setColor(this.poInCreation.objCol);
                    }
                    this.poInCreation.copySetupTo(presentationObject);
                    return presentationObject;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            PresentationObject presentationObject = this.poInCreation;
            this.poInCreation = null;
            this.destination = null;
            return presentationObject;
        }
        this.poInCreation = null;
        this.destination = null;
        return null;
    }

    private boolean validPlacementDestination(View view) {
        return this.destination == null || this.destination == view;
    }

    @Override
    public boolean isAnyPresentationObjectToPlace(View view) {
        if (this.poInCreation == null) {
            return false;
        }
        return this.validPlacementDestination(view);
    }

    private void placeSpline() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.CURVE), !deactivateMeasurementAfterDrawing);
    }

    private void placePolygon() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.POLYGON), !deactivateMeasurementAfterDrawing);
    }

    private void placeLeftPolygon() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.LEFT), !deactivateMeasurementAfterDrawing);
    }

    private void placeRightPolygon() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.RIGHT), !deactivateMeasurementAfterDrawing);
    }

    private void placeRectangle() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.RECTANGLE), !deactivateMeasurementAfterDrawing);
    }

    private void placeCircle() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.CIRCLE), !deactivateMeasurementAfterDrawing);
    }

    private void placeCircle3Point() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.CIRCLE_3POINT), !deactivateMeasurementAfterDrawing);
    }

    private void placeEllipse() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.ELLIPSE), !deactivateMeasurementAfterDrawing);
    }

    private void placeText() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.TEXT), !deactivateMeasurementAfterDrawing);
    }

    private void placeArrow() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.ARROW), !deactivateMeasurementAfterDrawing);
    }

    private void placeAngle() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.ANGLE), !deactivateMeasurementAfterDrawing);
    }

    private void placeCobbAngle() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.COBB_ANGLE), !deactivateMeasurementAfterDrawing);
    }

    private void placeLength() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.LENGTH), !deactivateMeasurementAfterDrawing);
    }

    private void placeNormalDistance() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.NORMAL_DISTANCE), !deactivateMeasurementAfterDrawing);
    }

    private void placeRatio() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.RATIO), !deactivateMeasurementAfterDrawing);
    }

    private void placeBidimensionalLength() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.BIDIMENSIONAL_LENGTH), !deactivateMeasurementAfterDrawing);
    }

    private void placeHorizontalDistance() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.HORIZONTAL_DISTANCE), !deactivateMeasurementAfterDrawing);
    }

    private void placeCenterline() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.CENTERLINE), !deactivateMeasurementAfterDrawing);
    }

    private void placeDoubleCenterline() {
        this.placePresentationObject(ROIFactory.getInstance(OverlayType.DOUBLE_CENTERLINE), !deactivateMeasurementAfterDrawing);
    }

    @Override
    public Cursor getCursor(Vis2 vis2) {
        if (this.getSubMode() == MouseSubModes.ZOOM_PAN) {
            return CursorHolder.DEFAULT_PAN_CURSOR;
        }
        if (this.getSubMode() == MouseSubModes.DEFAULT) {
            return CursorHolder.DEFAULT_CURSOR;
        }
        return CursorHolder.CROSSHAIR_CURSOR;
    }

    @Override
    public boolean isROIShuttered() {
        return this.isROIShuttered;
    }

    @Override
    public void setROIShuttered(boolean bl) {
        this.isROIShuttered = bl;
    }

    @Override
    public boolean isROIFilled() {
        return this.isROIFilled;
    }

    @Override
    public void setROIFilled(boolean bl) {
        this.isROIFilled = bl;
    }

    public boolean isROIRelativeScreen() {
        return this.isROIRelativeScreen;
    }

    public void setROIRelativeScreen(boolean bl) {
        this.isROIRelativeScreen = bl;
    }

    protected static class CursorHolder {
        public static final Cursor DEFAULT_CURSOR = new Cursor(0);
        public static final Cursor DEFAULT_PAN_CURSOR = new Cursor(13);
        public static final Cursor CROSSHAIR_CURSOR = CursorHolder.createCrosshairCursor();

        protected CursorHolder() {
        }

        private static Cursor createCrosshairCursor() {
            if (Product.isHeadless()) {
                return null;
            }
            if (Config.impaxee.jvision.MAIN.UseJavaDefaultCrosshair.get()) {
                log.debug("Using Java Default Crosshair");
                return Cursor.getPredefinedCursor(1);
            }
            TIcon tIcon = new TIcon("/icons/cursor_zoomrect.gif");
            return Toolkit.getDefaultToolkit().createCustomCursor(tIcon.getImage(), new Point(15, 15), "CROSSHAIR");
        }
    }
}

