/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.keypress.gui;

import com.agfa.pacs.impaxee.actions.PAction;
import com.tiani.jvision.plugin.PluginName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class ActionTreeModel
implements TreeModel {
    private static final ActionSorter ACTION_SORTER = new ActionSorter();
    private List<PAction> actionList;
    private List<String> simpleGroups;
    private List<PluginName> plugins;
    private Object root;
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

    ActionTreeModel(Object object, List<PAction> list) {
        this.actionList = list;
        this.root = object;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<PluginName> hashSet2 = new HashSet<PluginName>();
        for (PAction pAction : list) {
            if (pAction.getScopes() != null) {
                PluginName[] pluginNameArray = pAction.getScopes();
                int n = pluginNameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PluginName pluginName = pluginNameArray[n2];
                    if (pluginName != null) {
                        hashSet2.add(pluginName);
                    }
                    ++n2;
                }
                continue;
            }
            hashSet.add(pAction.getGroupName());
        }
        this.simpleGroups = new ArrayList<String>(hashSet);
        this.plugins = new ArrayList<PluginName>(hashSet2);
        Collections.sort(this.simpleGroups);
        Collections.sort(this.plugins, new PluginSorter());
    }

    private List<PAction> getActions(String string) {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        if (string.equals("INTERNAL")) {
            for (PAction pAction : this.actionList) {
                if (!pAction.getGroupName().equals(string) || pAction.getScopes() != null) continue;
                arrayList.add(pAction);
            }
        } else {
            for (PAction pAction : this.actionList) {
                if (!pAction.getGroupName().equals(string)) continue;
                arrayList.add(pAction);
            }
        }
        Collections.sort(arrayList, ACTION_SORTER);
        return arrayList;
    }

    private List<PAction> getActions(PluginName pluginName) {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        for (PAction pAction : this.actionList) {
            if (pAction.getScopes() == null) continue;
            PluginName[] pluginNameArray = pAction.getScopes();
            int n = pluginNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                PluginName pluginName2 = pluginNameArray[n2];
                if (pluginName2 == pluginName) {
                    arrayList.add(pAction);
                }
                ++n2;
            }
        }
        Collections.sort(arrayList, ACTION_SORTER);
        return arrayList;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object == this.root) {
            if (object2 instanceof String) {
                return this.simpleGroups.indexOf(object2);
            }
            if (object2 instanceof PluginName) {
                return this.simpleGroups.size() + this.plugins.indexOf(object2);
            }
            return -1;
        }
        if (object instanceof String) {
            return this.getActions((String)object).indexOf(object2);
        }
        if (object instanceof PluginName) {
            return this.getActions((PluginName)((Object)object)).indexOf(object2);
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object object) {
        return object instanceof PAction;
    }

    @Override
    public int getChildCount(Object object) {
        if (object == this.root) {
            return this.simpleGroups.size() + this.plugins.size();
        }
        if (object instanceof String) {
            return this.getActions((String)object).size();
        }
        if (object instanceof PluginName) {
            return this.getActions((PluginName)((Object)object)).size();
        }
        return 0;
    }

    @Override
    public Object getChild(Object object, int n) {
        if (object == this.root) {
            if (n >= this.simpleGroups.size()) {
                return this.plugins.get(n - this.simpleGroups.size());
            }
            return this.simpleGroups.get(n);
        }
        if (object instanceof String) {
            return this.getActions((String)object).get(n);
        }
        if (object instanceof PluginName) {
            return this.getActions((PluginName)((Object)object)).get(n);
        }
        return null;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    public boolean pathExists(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object object = treePath.getLastPathComponent();
        if (object == null) {
            return false;
        }
        if (object == this.root) {
            return true;
        }
        if (object instanceof String) {
            return this.simpleGroups.contains(object);
        }
        if (object instanceof PluginName) {
            return this.plugins.contains(object);
        }
        if (object instanceof PAction) {
            return this.actionList.contains(object);
        }
        return false;
    }

    private static class ActionSorter
    implements Comparator<PAction> {
        private ActionSorter() {
        }

        @Override
        public int compare(PAction pAction, PAction pAction2) {
            return pAction.getName().compareTo(pAction2.getName());
        }
    }

    private static class PluginSorter
    implements Comparator<PluginName> {
        private PluginSorter() {
        }

        @Override
        public int compare(PluginName pluginName, PluginName pluginName2) {
            return pluginName.getCaption().compareTo(pluginName2.getCaption());
        }
    }
}

