/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.keypress;

import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.keypress.ShortCut;
import com.tiani.jvision.keypress.ShortcutAction;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ShortcutBlock {
    private static final ALogger log = ALogger.getLogger(ShortcutBlock.class);
    private List<ShortCut> shortcuts;
    private BitSet[] usedKeys = new BitSet[256];

    public ShortcutBlock(boolean bl) {
        int n = 0;
        while (n < this.usedKeys.length) {
            this.usedKeys[n] = new BitSet(12);
            ++n;
        }
        this.shortcuts = new ArrayList<ShortCut>(bl ? 128 : 16);
    }

    private ShortcutBlock(ShortcutBlock shortcutBlock) {
        this.shortcuts = new ArrayList<ShortCut>(shortcutBlock.shortcuts.size());
        for (ShortCut shortCut : shortcutBlock.shortcuts) {
            this.shortcuts.add(new ShortCut(shortCut));
        }
    }

    Iterator<ShortCut> getIterator() {
        return Collections.unmodifiableList(this.shortcuts).iterator();
    }

    public ShortcutBlock clone() {
        return new ShortcutBlock(this);
    }

    public ShortcutBlock() {
        this(false);
    }

    public void clear() {
        this.usedKeys = null;
    }

    private boolean hasDefaultValue(ShortCut shortCut) {
        KeyShortcut keyShortcut = shortCut.action.getDefaultShortcut();
        if (keyShortcut == null) {
            return false;
        }
        return shortCut.getKeyCode() == keyShortcut.keyCode && this.modifiersEqual(shortCut.getModifiers(), keyShortcut.modifiers);
    }

    public List<ShortcutAction> getListOfNonDefaultShortcuts() {
        ArrayList<ShortcutAction> arrayList = new ArrayList<ShortcutAction>(32);
        for (ShortCut shortCut : this.shortcuts) {
            if (this.hasDefaultValue(shortCut)) continue;
            arrayList.add(new ShortcutAction(shortCut.action.getID(), shortCut.getKeyCode(), shortCut.getModifiers()));
        }
        return arrayList;
    }

    boolean addShortCut(KeyShortcut keyShortcut, PAction pAction) {
        BitSet bitSet = this.usedKeys[keyShortcut.keyCode];
        if (bitSet.get(keyShortcut.modifiers)) {
            log.warn("Shortcut " + keyShortcut + " of action " + pAction.getName() + " already occupied");
            return false;
        }
        this.shortcuts.add(new ShortCut(keyShortcut.modifiers, keyShortcut.keyCode, pAction));
        bitSet.set(keyShortcut.modifiers);
        return true;
    }

    public PAction isOccupied(int n, int n2) {
        for (ShortCut shortCut : this.shortcuts) {
            if (shortCut.getKeyCode() != n || !this.modifiersEqual(shortCut.getModifiers(), n2)) continue;
            return shortCut.action;
        }
        return null;
    }

    public boolean addShortCutOnRuntime(int n, int n2, PAction pAction) {
        if (this.isOccupied(n, n2) != null) {
            return false;
        }
        this.shortcuts.add(new ShortCut(n2, n, pAction));
        return true;
    }

    public void removeShortcutForAction(PAction pAction) {
        for (ShortCut shortCut : this.shortcuts) {
            if (shortCut.action != pAction) continue;
            this.shortcuts.remove(shortCut);
            return;
        }
    }

    public ShortCut getShortcutForAction(PAction pAction) {
        for (ShortCut shortCut : this.shortcuts) {
            if (shortCut.action != pAction) continue;
            return shortCut;
        }
        return null;
    }

    public boolean handle(KeyEvent keyEvent) {
        int n = 0;
        while (n < this.shortcuts.size()) {
            ShortCut shortCut = this.shortcuts.get(n);
            if (shortCut.getKeyCode() == keyEvent.getKeyCode() && this.modifiersEqual(shortCut.getModifiers(), keyEvent.getModifiers())) {
                if (shortCut.action.isEnabled()) {
                    return shortCut.action.perform(keyEvent.getComponent());
                }
                return false;
            }
            ++n;
        }
        return false;
    }

    private boolean modifiersEqual(int n, int n2) {
        if ((n & 8) != (n2 & 8)) {
            return false;
        }
        if ((n & 0x20) != (n2 & 0x20)) {
            return false;
        }
        if ((n & 2) != (n2 & 2)) {
            return false;
        }
        if ((n & 1) != (n2 & 1)) {
            return false;
        }
        if ((n & 0x10) != (n2 & 0x10)) {
            return false;
        }
        return (n & 4) == (n2 & 4);
    }
}

