/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.keypress;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionPersistenceContainer;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.keypress.ShortCut;
import com.tiani.jvision.keypress.ShortcutAction;
import com.tiani.jvision.keypress.ShortcutBlock;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.VisData;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class KeypressRegistry {
    private static final ALogger log = ALogger.getLogger(KeypressRegistry.class);
    private static KeypressRegistry instance = new KeypressRegistry();
    private ShortcutBlock globalShortCuts = new ShortcutBlock(true);
    private Map<PluginName, ShortcutBlock> shortCuts = new HashMap<PluginName, ShortcutBlock>();
    private boolean modified = false;
    private PActionPersistenceContainer<ShortcutAction> container;

    public static KeypressRegistry getInstance() {
        return instance;
    }

    public KeypressRegistry(IConfigurationProvider iConfigurationProvider) {
        this.container = new ShortcutActionPersistenceContainer(iConfigurationProvider);
    }

    private KeypressRegistry() {
        this.container = new ShortcutActionPersistenceContainer(ConfigurationProviderFactory.getConfig());
    }

    public ShortcutBlock getGlobalShortcuts() {
        return this.globalShortCuts.clone();
    }

    public Map<PluginName, ShortcutBlock> getPluginShortcuts() {
        HashMap<PluginName, ShortcutBlock> hashMap = new HashMap<PluginName, ShortcutBlock>();
        for (Map.Entry<PluginName, ShortcutBlock> entry : this.shortCuts.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().clone());
        }
        return hashMap;
    }

    public void modifyShortcuts(ShortcutBlock shortcutBlock, Map<PluginName, ShortcutBlock> map) {
        this.globalShortCuts = shortcutBlock;
        this.shortCuts = map;
        this.modified = true;
    }

    public boolean handleLTAKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 17) {
            return false;
        }
        return this.shortCuts.get((Object)PluginName.LTA).handle(keyEvent);
    }

    public void save() {
        if (!this.modified) {
            return;
        }
        log.info("Writing modified shortcuts");
        this.container.removeAll();
        for (ShortcutAction object : this.globalShortCuts.getListOfNonDefaultShortcuts()) {
            this.container.addActionRef(object);
        }
        for (ShortcutBlock shortcutBlock : this.shortCuts.values()) {
            for (ShortcutAction shortcutAction : shortcutBlock.getListOfNonDefaultShortcuts()) {
                this.container.addActionRef(shortcutAction);
            }
        }
        try {
            this.container.save(true);
        }
        catch (Exception exception) {
            log.error("Could not store user shortcuts", (Throwable)exception);
        }
    }

    public String toXML() {
        return this.container.toXML();
    }

    public void init() {
        this.init(false);
    }

    public void init(Document document) {
        this.globalShortCuts = new ShortcutBlock(true);
        this.modified = true;
        this.startInitialization(false, document);
    }

    public void reset() {
        this.modified = true;
        this.globalShortCuts = new ShortcutBlock(true);
        this.init(true);
    }

    public void resetToRole() {
        this.globalShortCuts = new ShortcutBlock(true);
        this.container.resetToRole();
        this.container.getConfigurationProvider().updateCache(this.container.getConfigurationKey());
        this.init(false);
        this.modified = false;
    }

    private void init(boolean bl) {
        this.startInitialization(bl, null);
        if (System.getProperty("shortCutsHTML.directory") != null) {
            this.printShortcutsHTML(System.getProperty("shortCutsHTML.directory"));
        }
    }

    private void startInitialization(boolean bl, Document document) {
        Object object;
        Object object2;
        Object object3 = PluginName.values();
        int n = ((PluginName[])object3).length;
        int n2 = 0;
        while (n2 < n) {
            object2 = object3[n2];
            if (object2.isPlugin()) {
                this.shortCuts.put((PluginName)((Object)object2), new ShortcutBlock());
            }
            ++n2;
        }
        this.shortCuts.put(PluginName.LTA, new ShortcutBlock());
        object2 = PActionRegistry.getShortcutActions();
        if (document != null) {
            this.container.init(document);
        } else {
            this.container.init();
        }
        HashSet<String> hashSet = new HashSet<String>(32);
        if (!bl) {
            for (ShortcutAction shortcutAction : this.container.getActionRefs()) {
                try {
                    object = PActionRegistry.getAction(shortcutAction.getActionId());
                    this.addShortCut((PAction)object, shortcutAction.getAsKeyShortcut());
                    hashSet.add(shortcutAction.getActionId());
                }
                catch (Exception exception) {
                    log.debug("Configured Shortcut action not found:" + shortcutAction.getActionId());
                }
            }
        }
        object3 = object2.iterator();
        while (object3.hasNext()) {
            PAction pAction = (PAction)object3.next();
            if (hashSet.contains(pAction.getID()) || (object = pAction.getDefaultShortcut()) == null) continue;
            this.addShortCut(pAction, (KeyShortcut)object);
        }
        this.globalShortCuts.clear();
        for (ShortcutBlock shortcutBlock : this.shortCuts.values()) {
            shortcutBlock.clear();
        }
    }

    private void addShortCut(PAction pAction, KeyShortcut keyShortcut) {
        if (keyShortcut.keyCode == 32 && keyShortcut.modifiers == 0 && !ModifierKeys.disableFastImageInteraction) {
            log.info("Pure space cannot be used as shortcut anymore");
            return;
        }
        PluginName[] pluginNameArray = pAction.getScopes();
        if (pluginNameArray == null) {
            this.globalShortCuts.addShortCut(keyShortcut, pAction);
        } else {
            PluginName[] pluginNameArray2 = pluginNameArray;
            int n = pluginNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                PluginName pluginName = pluginNameArray2[n2];
                ShortcutBlock shortcutBlock = this.shortCuts.get((Object)pluginName);
                if (shortcutBlock == null) {
                    shortcutBlock = this.globalShortCuts;
                }
                shortcutBlock.addShortCut(keyShortcut, pAction);
                ++n2;
            }
        }
    }

    public boolean handleMainFrameKeyEvent(KeyEvent keyEvent) {
        PluginName pluginName;
        if (keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 17) {
            return false;
        }
        VisData visData = VisData.getLastModified();
        boolean bl = false;
        if (visData != null && (pluginName = visData.getParent().getPlugin().getPluginName()) != PluginName.DEFAULT) {
            bl = this.shortCuts.get((Object)pluginName).handle(keyEvent);
        }
        if (!bl) {
            bl = this.globalShortCuts.handle(keyEvent);
        }
        return bl;
    }

    public void printShortcutsHTML(String string) {
        try {
            File file = new File(String.valueOf(string != null ? string : "") + "\\keyboard-shortcuts.html");
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            String string2 = System.getProperty("line.separator");
            bufferedWriter.write("<html><head><title>Shortcuts</title></head><body>");
            bufferedWriter.write(string2);
            bufferedWriter.write("<center><h1>Shortcuts</h1></center>");
            bufferedWriter.write(string2);
            bufferedWriter.write(string2);
            bufferedWriter.write("<table border='1'>");
            bufferedWriter.write(string2);
            bufferedWriter.write("<tr><th>Keystroke</th><th>Scope</th><th>ActionGroup</th><th>Action-ID</th><th>Action</th><th>Description</th></tr>");
            Iterator<ShortCut> iterator = this.globalShortCuts.getIterator();
            while (iterator.hasNext()) {
                ShortCut object = iterator.next();
                KeypressRegistry.writeTableRow(bufferedWriter, string2, object, "tr", "td");
            }
            for (ShortcutBlock shortcutBlock : this.shortCuts.values()) {
                iterator = shortcutBlock.getIterator();
                while (iterator.hasNext()) {
                    ShortCut shortCut = iterator.next();
                    KeypressRegistry.writeTableRow(bufferedWriter, string2, shortCut, "tr", "td");
                }
            }
            bufferedWriter.write("</table>");
            bufferedWriter.write(string2);
            bufferedWriter.write("</body></html>");
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void writeTableRow(Writer writer, String string, ShortCut shortCut, String string2, String string3) throws IOException {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder("");
        if (shortCut.action.getScopes() != null) {
            object2 = shortCut.action.getScopes();
            int n = ((PluginName[])object2).length;
            int n2 = 0;
            while (n2 < n) {
                object = object2[n2];
                if (object == null) {
                    stringBuilder.append("Global,");
                } else {
                    stringBuilder.append(((PluginName)((Object)object)).getCaption()).append(',');
                }
                ++n2;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
        }
        object = shortCut.action.getID();
        String string4 = shortCut.action.getGroupName();
        String string5 = shortCut.action.getCaption();
        object2 = shortCut.action.getToolTipText();
        if (object2 == null) {
            object2 = "";
        }
        writer.write("<" + string2 + "><" + string3 + ">" + KeyEvent.getKeyModifiersText(shortCut.getModifiers()) + (KeyEvent.getKeyModifiersText(shortCut.getModifiers()).length() > 0 ? "+" : "") + KeyEvent.getKeyText(shortCut.getKeyCode()) + "</" + string3 + "><" + string3 + ">" + object + "</" + string3 + "><" + string3 + ">" + stringBuilder + "</" + string3 + "><" + string3 + ">" + string4 + "</" + string3 + "><" + string3 + ">" + string5 + "</" + string3 + "></" + string3 + "><" + string3 + ">" + (String)object2 + "</" + string2 + ">");
        writer.write(string);
    }

    private static class ShortcutActionPersistenceContainer
    extends PActionPersistenceContainer<ShortcutAction> {
        public ShortcutActionPersistenceContainer(IConfigurationProvider iConfigurationProvider) {
            super(iConfigurationProvider, "impaxee.jvision.Shortcuts", null);
        }

        @Override
        protected ShortcutAction createActionRef(Node node) throws Exception {
            return ShortcutAction.create(node);
        }

        @Override
        public void save() throws Exception {
            if (this.getActionRefCount() == 0 && this.getConfigurationProvider().exists(this.getConfigurationKey())) {
                this.getConfigurationProvider().removeValue(this.getConfigurationKey());
            } else {
                super.save();
            }
        }
    }
}

