/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image.fithandler;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.math.Matrix2d;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.info.ImageState;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;

public class ImageDef {
    private static final ALogger log = ALogger.getLogger(ImageDef.class);
    private int imageColumns;
    private int imageRows;
    private Vector2d viewPortCenter;
    private double pixel_spaceX;
    private double pixel_spaceY;
    private double rowScalingFactor = 1.0;
    private boolean aspectRatioSet;
    private Matrix2d mx;

    public ImageDef(int n, int n2, double d, double d2) {
        this.imageColumns = n;
        this.imageRows = n2;
        this.viewPortCenter = new Vector2d(0.5, 0.5);
        this.setPixelSpacing(d, d2);
    }

    public double getRowScalingFactor() {
        return this.rowScalingFactor;
    }

    public void setPixelSpacing(ImageState imageState) {
        this.setPixelSpacing(imageState.getDataPixelSizeX(), imageState.getDataPixelSizeY());
    }

    public void setPixelSpacing(SpacingDef spacingDef) {
        this.setPixelSpacing(spacingDef.getDataPixelSizeX(), spacingDef.getDataPixelSizeY());
    }

    public void setPixelSpacing(double d, double d2) {
        if (this.aspectRatioSet) {
            if (Math.abs(d - 1.0) > 1.0E-4 || Math.abs(d2 - 1.0) > 1.0E-4) {
                log.warn("Pixel Spacing and Aspect ratio both specified,ignoring");
            }
            return;
        }
        if (d == 0.0) {
            this.pixel_spaceY = d2;
            this.pixel_spaceX = d2;
        } else {
            this.pixel_spaceX = d;
            this.pixel_spaceY = d2;
        }
        if (d != 0.0) {
            this.rowScalingFactor = this.pixel_spaceY / this.pixel_spaceX;
        }
    }

    public ImageDef(ImageDef imageDef) {
        this.imageColumns = imageDef.imageColumns;
        this.imageRows = imageDef.imageRows;
        this.pixel_spaceX = imageDef.pixel_spaceX;
        this.pixel_spaceY = imageDef.pixel_spaceY;
        this.rowScalingFactor = imageDef.rowScalingFactor;
        this.viewPortCenter = new Vector2d(imageDef.viewPortCenter);
        if (imageDef.mx != null) {
            this.mx = new Matrix2d(imageDef.mx);
        }
    }

    public String toString() {
        return "Img " + this.imageColumns + "/" + this.imageRows + " center:" + this.viewPortCenter;
    }

    public void setAspectRatio(int n, int n2) {
        if (n == 1 && n2 == 1) {
            return;
        }
        this.aspectRatioSet = true;
        this.rowScalingFactor = (double)n2 / (double)n;
    }

    public void resetAspectRatio() {
        this.aspectRatioSet = false;
        this.rowScalingFactor = 1.0;
    }

    public double toTrueWidth(double d) {
        if (this.isRotated()) {
            return d / this.rowScalingFactor;
        }
        return d;
    }

    public double toTrueHeight(double d) {
        if (this.isRotated()) {
            return d;
        }
        return d / this.rowScalingFactor;
    }

    public Matrix2d getTransform() {
        if (this.mx == null) {
            return Matrix2d.identity;
        }
        return this.mx;
    }

    public Matrix2d getPossibleTransform() {
        return this.mx;
    }

    public void applyTransform(Matrix2d matrix2d) {
        if (this.mx == null) {
            this.mx = new Matrix2d();
        }
        this.mx.mul(matrix2d, this.mx);
    }

    public boolean isRotated() {
        if (this.mx == null) {
            return false;
        }
        double[] dArray = new double[]{1.0, 0.0};
        this.mx.transform(dArray);
        return Math.abs(dArray[0]) <= Math.abs(dArray[1]);
    }

    public boolean isFlippedVertically() {
        if (this.mx != null && !this.mx.isIdentity()) {
            Point2d point2d = new Point2d(1.0, 1.0);
            this.mx.transform(point2d);
            return point2d.y < 0.0;
        }
        return false;
    }

    public boolean isFlippedHorizontally() {
        if (this.mx != null && !this.mx.isIdentity()) {
            Point2d point2d = new Point2d(1.0, 1.0);
            this.mx.transform(point2d);
            return point2d.x < 0.0;
        }
        return false;
    }

    public boolean isIdentity() {
        if (this.mx == null) {
            return true;
        }
        return this.mx.isIdentity();
    }

    private double[] getTransformedPixelSpacing() {
        double[] dArray = new double[2];
        if (this.hasPixelSpacing()) {
            dArray[0] = this.pixel_spaceX;
            dArray[1] = this.pixel_spaceY / this.rowScalingFactor;
        } else {
            dArray[0] = 1.0;
            dArray[1] = 1.0 / this.rowScalingFactor;
        }
        if (this.mx != null) {
            this.mx.transform(dArray);
        }
        return dArray;
    }

    public double getDisplayPixelSpaceX() {
        double[] dArray = this.getTransformedPixelSpacing();
        return Math.abs(dArray[0]);
    }

    private boolean hasPixelSpacing() {
        return this.pixel_spaceX != 0.0;
    }

    public double getDisplayedPixelSpaceY() {
        double[] dArray = this.getTransformedPixelSpacing();
        return Math.abs(dArray[1]);
    }

    public int getDisplayedColumns() {
        if (this.mx == null) {
            return this.getUntransformedColumns();
        }
        double[] dArray = new double[]{this.getUntransformedColumns(), this.getUntransformedRows()};
        this.mx.transform(dArray);
        if (Math.abs(dArray[0]) > 10240.0) {
            log.warn("ImageDef: Cols huge:" + this.imageColumns);
        }
        return (int)Math.abs(dArray[0]);
    }

    public int getDisplayedRows() {
        if (this.mx == null) {
            return this.getUntransformedRows();
        }
        double[] dArray = new double[]{this.getUntransformedColumns(), this.getUntransformedRows()};
        this.mx.transform(dArray);
        return (int)Math.abs(dArray[1]);
    }

    public int getUntransformedColumns() {
        return this.imageColumns;
    }

    public int getUntransformedRows() {
        return (int)((double)this.imageRows * this.rowScalingFactor);
    }

    public int getRowCount() {
        return this.imageRows;
    }

    public int getColumnCount() {
        return this.imageColumns;
    }

    public Vector2d getViewportCenter() {
        return this.viewPortCenter;
    }

    public double[] getTransformedViewportCenter() {
        double[] dArray = new double[2];
        if (this.mx == null) {
            dArray[0] = this.viewPortCenter.x;
            dArray[1] = this.viewPortCenter.y;
        } else {
            dArray[0] = this.viewPortCenter.x - 0.5;
            dArray[1] = this.viewPortCenter.y - 0.5;
            this.mx.transform(dArray);
            dArray[0] = dArray[0] + 0.5;
            dArray[1] = dArray[1] + 0.5;
        }
        return dArray;
    }

    public double[] getInterchangeableViewportCenter() {
        return this.getTransformedViewportCenter();
    }

    public void setInterchangeableViewportCenter(double d, double d2) {
        this.setTransformedViewportCenter(d, d2);
    }

    public void setTransform(Matrix2d matrix2d) {
        if (this.mx == null) {
            this.mx = new Matrix2d(matrix2d);
        } else {
            this.mx.set(matrix2d);
        }
    }

    public void setTransformedViewportCenter(double d, double d2) {
        if (this.mx == null) {
            this.viewPortCenter.x = d;
            this.viewPortCenter.y = d2;
        } else {
            double[] dArray = new double[]{d - 0.5, d2 - 0.5};
            Matrix2d matrix2d = new Matrix2d(this.mx);
            matrix2d.invert();
            matrix2d.transform(dArray);
            this.viewPortCenter.x = dArray[0] + 0.5;
            this.viewPortCenter.y = dArray[1] + 0.5;
        }
    }

    public void resetTransformedViewportCenter() {
        if (this.mx == null) {
            this.viewPortCenter.x = 0.5;
            this.viewPortCenter.y = 0.5;
        } else {
            double[] dArray = new double[]{0.0, 0.0};
            Matrix2d matrix2d = this.mx != null ? new Matrix2d(this.mx) : new Matrix2d();
            matrix2d.invert();
            matrix2d.transform(dArray);
            this.viewPortCenter.x = dArray[0] + 0.5;
            this.viewPortCenter.y = dArray[1] + 0.5;
        }
    }

    public void setViewportCenter(Vector2d vector2d) {
        this.viewPortCenter = vector2d;
    }

    public static boolean hasPixelSpacing(IImageInformation iImageInformation) {
        double[] dArray = iImageInformation.getPixelSpacing();
        return dArray != null && dArray.length > 0 && dArray[0] != 0.0;
    }

    public static boolean hasProjectiveSpacing(IImageInformation iImageInformation) {
        double[] dArray = iImageInformation.getImagerPixelSpacing();
        return dArray != null && dArray.length == 2 && dArray[0] != 0.0;
    }

    public static boolean hasImagePlanePixelSpacing(IImageInformation iImageInformation) {
        double[] dArray = iImageInformation.getImagePlanePixelSpacing();
        return dArray != null && dArray.length > 0 && dArray[0] != 0.0;
    }

    public static boolean hasPixelAspectRatioOtherThan1to1(IImageInformation iImageInformation) {
        if (ImageDef.hasPixelSpacing(iImageInformation)) {
            return false;
        }
        int[] nArray = iImageInformation.getPixelAspectRatio();
        return nArray != null && nArray[0] != nArray[1];
    }

    public static boolean hasQuadraticPixels(IImageInformation iImageInformation) {
        if (ImageDef.hasPixelSpacing(iImageInformation)) {
            double[] dArray = iImageInformation.getPixelSpacing();
            return dArray.length == 1 || dArray[0] == dArray[1];
        }
        int[] nArray = iImageInformation.getPixelAspectRatio();
        return nArray == null || nArray[0] == nArray[1];
    }

    static boolean hasEstimation(IImageInformation iImageInformation) {
        return iImageInformation.getEstimatedRadiographicMagnificationFactor() != null;
    }

    static boolean isProjectiveModality(IImageInformation iImageInformation) {
        return iImageInformation.getImageClass() == IImageInformation.ImageClass.CR || iImageInformation.getImageClass() == IImageInformation.ImageClass.MG || iImageInformation.getImageClass() == IImageInformation.ImageClass.XA || iImageInformation.getImageClass() == IImageInformation.ImageClass.TOMO;
    }
}

