/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image.fithandler;

import com.tiani.jvision.image.OutputDeviceMetric;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.image.fithandler.ViewPort;
import java.awt.Rectangle;

public abstract class AreaFitHandler
implements Cloneable {
    private ViewportCenterAlignmentX vpCenterAlignX = ViewportCenterAlignmentX.CENTER;
    protected double viewScaleX;
    protected double viewScaleY = 0.0;
    protected OutputDeviceMetric outputDevice;
    protected boolean borderLockMode = true;
    protected ImageDef lastCalledActivedef;
    protected int lastCalledCwidth;
    protected int lastCalledCheight;
    protected double zoomFactor = 1.0;

    public AreaFitHandler() {
        this.outputDevice = OutputDeviceMetric.screen;
    }

    AreaFitHandler(OutputDeviceMetric outputDeviceMetric) {
        this.outputDevice = outputDeviceMetric;
    }

    AreaFitHandler(AreaFitHandler areaFitHandler) {
        this.set(areaFitHandler);
    }

    public AreaFitHandler getClone() throws CloneNotSupportedException {
        return (AreaFitHandler)super.clone();
    }

    public void set(AreaFitHandler areaFitHandler) {
        this.viewScaleX = areaFitHandler.viewScaleX;
        this.viewScaleY = areaFitHandler.viewScaleY;
        this.borderLockMode = areaFitHandler.borderLockMode;
        this.outputDevice = areaFitHandler.outputDevice;
        this.vpCenterAlignX = areaFitHandler.vpCenterAlignX;
        this.setZoomFactor(areaFitHandler.zoomFactor);
        if (this.outputDevice.screenAR > 1.0) {
            this.viewScaleX *= this.outputDevice.screenAR;
        }
        if (this.outputDevice.screenAR < 1.0) {
            this.viewScaleY /= this.outputDevice.screenAR;
        }
    }

    public void setBorderLockMode(boolean bl) {
        this.borderLockMode = bl;
    }

    public ViewportCenterAlignmentX getViewportCenterAlignmentX() {
        return this.vpCenterAlignX;
    }

    public void setViewportCenterAlignmentX(ViewportCenterAlignmentX viewportCenterAlignmentX) {
        this.vpCenterAlignX = viewportCenterAlignmentX;
    }

    public void updateViewPort(ImageDef imageDef, ViewPort viewPort, Rectangle rectangle, int n, int n2) {
        if (imageDef == null) {
            return;
        }
        ViewPort viewPort2 = viewPort;
        this.lastCalledActivedef = imageDef;
        this.lastCalledCwidth = n;
        this.lastCalledCheight = n2;
        int n3 = n / 2;
        int n4 = n2 / 2;
        if (ViewportCenterAlignmentX.LEFT.equals((Object)this.vpCenterAlignX)) {
            n3 = 0;
        } else if (ViewportCenterAlignmentX.RIGHT.equals((Object)this.vpCenterAlignX)) {
            n3 = n;
        }
        double[] dArray = imageDef.getTransformedViewportCenter();
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = this.viewScaleX * this.zoomFactor;
        double d4 = this.viewScaleY * this.zoomFactor;
        rectangle.x = (int)Math.round((double)n3 - d * (double)imageDef.getDisplayedColumns() * d3);
        if (rectangle.x < 0) {
            viewPort2.x = (double)(-rectangle.x) / d3;
            rectangle.x = 0;
        } else {
            viewPort2.x = 0.0;
        }
        rectangle.y = (int)Math.round((double)n4 - d2 * (double)imageDef.getDisplayedRows() * d4);
        if (rectangle.y <= 0) {
            viewPort2.y = (double)(-rectangle.y) / d4;
            rectangle.y = 0;
        } else {
            viewPort2.y = 0.0;
        }
        rectangle.width = (int)Math.round((double)imageDef.getDisplayedColumns() * d3);
        if (rectangle.width > n - rectangle.x) {
            viewPort2.width = (double)(n - rectangle.x) / d3;
            rectangle.width = n - rectangle.x;
        } else {
            viewPort2.width = imageDef.getDisplayedColumns();
        }
        rectangle.height = (int)Math.round((double)imageDef.getDisplayedRows() * d4);
        if (rectangle.height > n2 - rectangle.y) {
            viewPort2.height = (double)(n2 - rectangle.y) / d4;
            rectangle.height = n2 - rectangle.y;
        } else {
            viewPort2.height = imageDef.getDisplayedRows();
        }
        if (this.borderLockMode) {
            if (viewPort2.height + viewPort2.y > (double)imageDef.getDisplayedRows()) {
                viewPort2.y = (double)imageDef.getDisplayedRows() - viewPort2.height;
            }
            if (viewPort2.width + viewPort2.x > (double)imageDef.getDisplayedColumns()) {
                viewPort2.x = (double)imageDef.getDisplayedColumns() - viewPort2.width;
            }
        } else {
            double d5;
            if (viewPort2.height + viewPort2.y > (double)imageDef.getDisplayedRows()) {
                d5 = viewPort2.height;
                viewPort2.height = (double)imageDef.getDisplayedRows() - viewPort2.y;
                d5 = viewPort2.height / d5;
                rectangle.height = (int)Math.round(d5 * (double)rectangle.height);
            }
            if (viewPort2.width + viewPort2.x > (double)imageDef.getDisplayedColumns()) {
                d5 = viewPort2.width;
                viewPort2.width = (double)imageDef.getDisplayedColumns() - viewPort2.x;
                d5 = viewPort2.width / d5;
                rectangle.width = (int)Math.round(d5 * (double)rectangle.width);
            }
        }
        if (Math.abs(viewPort2.width - (double)rectangle.width) <= 1.0 && (double)rectangle.width + viewPort2.x < (double)imageDef.getDisplayedColumns()) {
            viewPort2.width = rectangle.width;
        }
        if (Math.abs(viewPort2.height - (double)rectangle.height) <= 1.0 && (double)rectangle.height + viewPort2.y < (double)imageDef.getDisplayedRows()) {
            viewPort2.height = rectangle.height;
        }
    }

    protected abstract double restrictZoom(double var1);

    public abstract double getViewScale(ImageDef var1, int var2, int var3);

    public void setViewScale(ImageDef imageDef, int n, int n2) {
        double d = this.getViewScale(imageDef, n, n2);
        if (this.outputDevice.screenAR > 1.0) {
            this.viewScaleX = d / this.outputDevice.screenAR;
            this.viewScaleY = d;
        } else {
            this.viewScaleX = d;
            this.viewScaleY = d * this.outputDevice.screenAR;
        }
    }

    public double getViewScaleX() {
        return this.viewScaleX;
    }

    public double getViewScaleY() {
        return this.viewScaleY;
    }

    public void checkViewPortCenter(ImageDef imageDef, int n, int n2) {
        this._checkViewPortCenter(imageDef, n, n2);
    }

    protected void _checkViewPortCenter(ImageDef imageDef, int n, int n2) {
        if (imageDef == null || !this.borderLockMode) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        d = this.zoomFactor * this.viewScaleX * (double)imageDef.getDisplayedColumns();
        d2 = this.zoomFactor * this.viewScaleY * (double)imageDef.getDisplayedRows();
        double d3 = imageDef.getTransformedViewportCenter()[0];
        double d4 = imageDef.getTransformedViewportCenter()[1];
        if (d < (double)n) {
            bl = true;
            d3 = 0.5;
        }
        if (d2 < (double)n2) {
            d4 = 0.5;
            bl2 = true;
        }
        double d5 = 0.0;
        d5 = d3 < 0.5 ? d3 * d : (1.0 - d3) * d;
        if (d5 < (double)(n / 2) && !bl) {
            d3 = d3 < 0.5 ? (double)(n / 2) / d : 1.0 - (double)(n / 2) / d;
        }
        double d6 = 0.0;
        d6 = d4 < 0.5 ? d4 * d2 : (1.0 - d4) * d2;
        if (d6 < (double)(n2 / 2) && !bl2) {
            d4 = d4 < 0.5 ? (double)(n2 / 2) / d2 : 1.0 - (double)(n2 / 2) / d2;
        }
        imageDef.setTransformedViewportCenter(d3, d4);
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public double getAbsoluteZoomFactor() {
        return this.zoomFactor * this.viewScaleX;
    }

    public void setZoomFactor(double d) {
        this.zoomFactor = this.restrictZoom(d);
    }

    public void setOutputDevice(OutputDeviceMetric outputDeviceMetric) {
        this.outputDevice = outputDeviceMetric;
    }

    public OutputDeviceMetric getOutputDevice() {
        return this.outputDevice;
    }

    public boolean isUnrestrictedZoom() {
        return false;
    }

    public static enum ViewportCenterAlignmentX {
        CENTER{

            @Override
            public double calculateViewportCenterX(int n, int n2, int n3) {
                return (double)(n + n2 - 1) / (double)(2 * n3);
            }
        }
        ,
        LEFT{

            @Override
            public double calculateViewportCenterX(int n, int n2, int n3) {
                return (double)n / (double)n3;
            }
        }
        ,
        RIGHT{

            @Override
            public double calculateViewportCenterX(int n, int n2, int n3) {
                return (double)n2 / (double)n3;
            }
        };


        public abstract double calculateViewportCenterX(int var1, int var2, int var3);
    }
}

