/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.AnonymousPAction;
import com.agfa.pacs.impaxee.gsts.GrayScaleTransformationSequence;
import com.agfa.pacs.impaxee.gsts.IWindowPreset;
import com.agfa.pacs.impaxee.gsts.WindowLevelPreset;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.WindowTransferFunction;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WindowPresetSelectorDataAction
extends AbstractPDataAction {
    public static final String ID = "WINDOW_PRESET_SELECTOR";
    private static final ALogger LOGGER = ALogger.getLogger(WindowPresetSelectorAction.class);
    private static final String CAPTION_PRESET = Messages.getString("WindowPresetSelectorAction.Caption.WindowPreset");
    private static final String CAPTION_VOILUT = Messages.getString("WindowPresetSelectorAction.Caption.VOILUT");

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay};
    }

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new WindowPresetSelectorAction(pDataScope, pDataProvider);
    }

    static GrayScaleTransformationSequence getGSTS(VisData visData) {
        if (visData == null) {
            return null;
        }
        View view = visData.getView();
        if (!(view instanceof ImgView2)) {
            return null;
        }
        ImgView2 imgView2 = (ImgView2)view;
        TransferFunction transferFunction = imgView2.getTransferFunction();
        if (transferFunction == null) {
            return null;
        }
        return ((WindowTransferFunction)transferFunction).getGSTS();
    }

    static <T> int getArraySize(T[] TArray) {
        if (TArray == null) {
            return 0;
        }
        return TArray.length;
    }

    static Set<String> collectLUTExplanations(IWindowPreset[] iWindowPresetArray) {
        if (iWindowPresetArray == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        IWindowPreset[] iWindowPresetArray2 = iWindowPresetArray;
        int n = iWindowPresetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWindowPreset iWindowPreset = iWindowPresetArray2[n2];
            hashSet.add(iWindowPreset.getDescription());
            ++n2;
        }
        return hashSet;
    }

    private static class ApplyWindowPresetAction
    extends AnonymousPAction {
        private final VisData visData;
        private final IWindowPreset preset;
        private final boolean isSelected;

        ApplyWindowPresetAction(VisData visData, IWindowPreset iWindowPreset, boolean bl) {
            this.visData = visData;
            this.preset = iWindowPreset;
            this.isSelected = bl;
        }

        @Override
        public String getCaption() {
            return this.getPresetDescription();
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public boolean isSelected() {
            return this.isSelected;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed(WindowPresetSelectorDataAction.ID);
            LOGGER.debug("Activating window level preset: " + this.getCaption());
            TEventDispatch.sendEvent(this.visData.getParent().getVisDisplay(), new TEvent(64), (Object)this.getPresetDescription(), false);
            return true;
        }

        String getPresetDescription() {
            if (this.preset == null) {
                return null;
            }
            return this.preset.getDescription();
        }
    }

    private static class DisableVOILUTAction
    extends ApplyWindowPresetAction {
        DisableVOILUTAction(VisData visData, boolean bl) {
            super(visData, null, bl);
        }

        @Override
        public String getCaption() {
            return Messages.getString("WindowPresetSelectorAction.VOILUT.None");
        }
    }

    private class WindowPresetSelectorAction
    extends AbstractPDataAction.AbstractInnerPAction {
        private PAction[] subActions;
        private String caption;
        private long cacheTimestamp;

        public WindowPresetSelectorAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(pDataScope, pDataProvider);
        }

        @Override
        public PAction.ActionType getActionType() {
            return PAction.ActionType.SubmenuExclusive;
        }

        @Override
        public PAction[] getSubactions() {
            if (this.subActions != null && System.currentTimeMillis() - this.cacheTimestamp < CACHING_TIMEOUT) {
                return this.subActions;
            }
            this.subActions = this.getSubactionsImpl();
            this.cacheTimestamp = System.currentTimeMillis();
            return this.subActions;
        }

        private PAction[] getSubactionsImpl() {
            IWindowPreset iWindowPreset;
            this.caption = CAPTION_VOILUT;
            VisData visData = this.getVisData();
            GrayScaleTransformationSequence grayScaleTransformationSequence = WindowPresetSelectorDataAction.getGSTS(visData);
            if (grayScaleTransformationSequence == null) {
                return null;
            }
            WindowLevelPreset[] windowLevelPresetArray = grayScaleTransformationSequence.getWindowLevelPresets();
            IWindowPreset[] iWindowPresetArray = grayScaleTransformationSequence.getOriginalVOILUTs();
            int n = WindowPresetSelectorDataAction.getArraySize(windowLevelPresetArray);
            int n2 = WindowPresetSelectorDataAction.getArraySize(iWindowPresetArray);
            if (n2 == 0 && n <= 1) {
                return null;
            }
            ArrayList<ApplyWindowPresetAction> arrayList = new ArrayList<ApplyWindowPresetAction>(n + n2);
            if (windowLevelPresetArray != null) {
                Set<String> set = WindowPresetSelectorDataAction.collectLUTExplanations(iWindowPresetArray);
                WindowLevelPreset[] windowLevelPresetArray2 = windowLevelPresetArray;
                int n3 = windowLevelPresetArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    iWindowPreset = windowLevelPresetArray2[n4];
                    if (!set.contains(iWindowPreset.getDescription())) {
                        arrayList.add(new ApplyWindowPresetAction(visData, iWindowPreset, grayScaleTransformationSequence.isWindowPresetActive(iWindowPreset.getDescription())));
                        this.caption = CAPTION_PRESET;
                    }
                    ++n4;
                }
            }
            if (iWindowPresetArray != null) {
                if (arrayList.isEmpty()) {
                    arrayList.add(new DisableVOILUTAction(visData, !grayScaleTransformationSequence.isVOILUTEnabled()));
                }
                int n5 = 0;
                while (n5 < iWindowPresetArray.length) {
                    iWindowPreset = iWindowPresetArray[n5];
                    arrayList.add(new ApplyWindowPresetAction(visData, iWindowPreset, grayScaleTransformationSequence.isWindowPresetActive(iWindowPreset.getDescription())));
                    ++n5;
                }
            }
            return arrayList.toArray(new PAction[arrayList.size()]);
        }

        @Override
        public String getCaption() {
            return this.caption;
        }

        @Override
        public String getName() {
            return Messages.getString("WindowPresetSelectorAction.Name");
        }

        @Override
        protected boolean isEnabledImpl() {
            return this.getSubactions() != null;
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public String getGroupName() {
            return WINDOW_LEVEL_GROUP;
        }

        @Override
        public String getID() {
            return WindowPresetSelectorDataAction.ID;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            throw new UnsupportedOperationException();
        }

        private VisDisplay2 getVisDisplay() {
            List<VisDisplay2> list = this.scope != null ? WindowPresetSelectorDataAction.getVisDisplays(this.scope) : this.provider.getVisDisplays();
            if (list != null && list.size() == 1) {
                return list.get(0);
            }
            return null;
        }

        private VisData getVisData() {
            VisDisplay2 visDisplay2 = this.getVisDisplay();
            if (visDisplay2 == null) {
                return null;
            }
            return visDisplay2.getVis(visDisplay2.getNavigPos());
        }
    }
}

