/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gsts.GrayScaleTransformationSequence;
import com.agfa.pacs.impaxee.gsts.IWindowPreset;
import com.agfa.pacs.impaxee.gsts.WindowLevelPreset;
import com.agfa.pacs.listtext.dicomobject.module.image.IHistogram;
import com.agfa.pacs.listtext.dicomobject.module.image.IHistogramProvider;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.RescaleType;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILUTFunction;
import com.agfa.pacs.listtext.dicomobject.presentation.ILUTContainer;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.Histogram;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.ITransferFunctionDefinition;
import com.tiani.base.data.RawDataContainer;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.GeneralWindowTransferFunction;
import com.tiani.jvision.image.SegmentedPaletteColorLUT;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewEventHandler;
import com.tiani.jvision.image.WindowDef;
import com.tiani.jvision.image.WindowHandler;
import com.tiani.jvision.image.WindowHandlerNuk;
import com.tiani.jvision.image.WindowHandlerVOILUT;
import com.tiani.jvision.image.WindowTransferFunction;
import com.tiani.jvision.image.WindowValue;
import com.tiani.jvision.main.VisInfoManager;
import com.tiani.jvision.renderer.IRDCRenderer;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.net.URL;
import org.apache.commons.lang3.ArrayUtils;

public abstract class WindowHandlerBase
implements ViewEventHandler {
    protected static final ALogger log = ALogger.getLogger(WindowHandlerBase.class);
    protected static final Cursor voiLUTCursor;
    protected static final int wcSign;
    protected static final int wwSign;
    protected static Cursor nonWindowingCursor;
    protected static float clickCenter;
    protected static float clickWidth;
    protected static int clickPosX;
    protected static int clickPosY;
    private static boolean winStarted;
    protected static double ccl;
    protected static double ccu;
    protected static double cwl;
    protected WindowDef window;
    protected int myNodeID;
    protected WindowTransferFunction tf;
    protected WindowDef origWindowDef;
    protected WindowTransferFunction origtf;
    private View view;
    protected boolean performRelativeWindowing = true;
    protected boolean localEffect;
    private WeakReference<IHistogramProvider> dataRef;
    private boolean firstMousePress = true;
    private boolean isProgressEventHandlingEnabled;
    protected float mouseWindowSens = 1200.0f;

    static {
        wcSign = Config.impaxee.jvision.DISPLAY.InvertWindowCenter.get() ? -1 : 1;
        wwSign = Config.impaxee.jvision.DISPLAY.InvertWindowWidth.get() ? -1 : 1;
        nonWindowingCursor = null;
        URL uRL = WindowHandlerBase.class.getClassLoader().getResource("/icons/voilutCursor.gif");
        Image image = Toolkit.getDefaultToolkit().createImage(uRL);
        voiLUTCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(12, 12), "voiLutWindowing");
    }

    protected WindowHandlerBase(IImageInformation iImageInformation, ILUTContainer iLUTContainer, boolean bl, boolean bl2, WindowDef windowDef) {
        this.tf = new WindowTransferFunction(iLUTContainer, iImageInformation.getHighBit(), iImageInformation.getBitsStored(), bl, bl2);
        this.window = windowDef;
        this.tf.setWindow(this.window);
        this.origWindowDef = new WindowDef(windowDef);
        this.initWindowSens(iImageInformation);
    }

    private void decideRelativeWindowing(IImageInformation iImageInformation) {
        ModalityLUT modalityLUT;
        this.performRelativeWindowing = true;
        if (iImageInformation.getImageClass() == IImageInformation.ImageClass.CT) {
            this.performRelativeWindowing = false;
        } else if (iImageInformation.getModalityLUT() != null && (modalityLUT = iImageInformation.getModalityLUT()).getRescaleType() == RescaleType.HounsfieldUnits) {
            this.performRelativeWindowing = false;
        }
    }

    protected WindowHandlerBase(IImageInformation iImageInformation, ILUTContainer iLUTContainer, boolean bl, boolean bl2, IHistogramProvider iHistogramProvider) {
        this.tf = new WindowTransferFunction(iLUTContainer, iImageInformation, bl, bl2, iHistogramProvider);
        this.window = this.tf.getGSTS().getWindowDef();
        this.origWindowDef = new WindowDef(this.window);
        if (iHistogramProvider != null) {
            this.dataRef = new WeakReference<IHistogramProvider>(iHistogramProvider);
        }
        this.decideRelativeWindowing(iImageInformation);
        this.initWindowSens(iImageInformation);
    }

    protected WindowHandlerBase(WindowHandlerBase windowHandlerBase) {
        IHistogramProvider iHistogramProvider;
        WindowTransferFunction windowTransferFunction = windowHandlerBase.getTransferFunction();
        this.performRelativeWindowing = windowHandlerBase.performRelativeWindowing;
        this.isProgressEventHandlingEnabled = windowHandlerBase.isProgressEventHandlingEnabled;
        try {
            this.origtf = windowHandlerBase.origtf;
            this.tf = windowTransferFunction.getClone();
        }
        catch (Exception exception) {
            log.error("WindowHandlerBase", (Throwable)exception);
        }
        this.window = this.tf.getGSTS() == null ? windowHandlerBase.getWindow() : this.tf.getGSTS().getWindowDef();
        this.origWindowDef = new WindowDef(windowHandlerBase.origWindowDef);
        this.mouseWindowSens = windowHandlerBase.mouseWindowSens;
        if (windowHandlerBase.dataRef != null && (iHistogramProvider = (IHistogramProvider)windowHandlerBase.dataRef.get()) != null) {
            this.dataRef = new WeakReference<IHistogramProvider>(iHistogramProvider);
        }
    }

    protected void initWindowSens(IImageInformation iImageInformation) {
        if (iImageInformation.getImageClass() == IImageInformation.ImageClass.CT) {
            this.mouseWindowSens = (float)this.tf.getGrays() * 600.0f / 4096.0f;
        }
    }

    public void setNodeID(int n) {
        this.myNodeID = n;
    }

    public GrayScaleTransformationSequence getGSTS() {
        return this.tf.getGSTS();
    }

    public void setLocalEffect(boolean bl) {
        this.localEffect = bl;
    }

    public void setProgressEventHandlingEnabled(boolean bl) {
        this.isProgressEventHandlingEnabled = bl;
    }

    public void autoMouseRange(IImageInformation iImageInformation, Histogram histogram, TEvent tEvent, Object object) {
        if (this.firstMousePress && tEvent.id == 62 && ((MouseEvent)object).getID() == 501 && (iImageInformation.getImageClass() == IImageInformation.ImageClass.MR || iImageInformation.getImageClass() == IImageInformation.ImageClass.NM || iImageInformation.getImageClass() == IImageInformation.ImageClass.PT)) {
            this.setMouseSensitivity(histogram);
            this.firstMousePress = false;
        }
    }

    public void setTransferFunction(WindowTransferFunction windowTransferFunction) {
        this.setTransferFunction(windowTransferFunction, false);
    }

    private void setTransferFunction(WindowTransferFunction windowTransferFunction, boolean bl) {
        if (windowTransferFunction != null) {
            windowTransferFunction.setUpdateID(Math.max(windowTransferFunction.getUpdateID(), this.tf.getUpdateID()) + 1);
            this.tf = windowTransferFunction;
            this.origtf = this.tf.getClone();
            this.origWindowDef = new WindowDef(this.tf.getWindowDef());
            this.tf.setUpdateID(Math.max(this.tf.getUpdateID(), windowTransferFunction.getUpdateID()) + 1);
            if (this.tf.getGSTS() != null) {
                WindowDef windowDef = this.tf.getGSTS().getWindowDef();
                if (bl) {
                    windowDef.setCenter(this.window.getCenter());
                    windowDef.setWidth(this.window.getWidth());
                }
                windowDef.setIntercept(this.window.getIntercept());
                windowDef.setSlope(this.window.getSlope());
                windowDef.setUnit(this.window.getUnit());
                this.window = windowDef;
                this.tf.setWindow(windowDef);
            }
        }
    }

    public IVOILUT getVOILUTForPresentationState(boolean bl) {
        if (this.getGSTS() != null && this.getGSTS().hasVOILUT()) {
            return null;
        }
        IVOILUT iVOILUT = this.getWindowLevelPresetsForPresentationStateImpl();
        if (iVOILUT == null) {
            iVOILUT = VOILUT.create((double)this.getCenter(), (double)this.getWidth(), this.getGSTS() == null ? null : this.getGSTS().getVOILUTFunction());
        }
        return iVOILUT;
    }

    protected IVOILUT getWindowLevelPresetsForPresentationStateImpl() {
        Object[] objectArray;
        GrayScaleTransformationSequence grayScaleTransformationSequence = this.getGSTS();
        if (grayScaleTransformationSequence != null && (objectArray = grayScaleTransformationSequence.getWindowLevelPresets()) != null && objectArray.length > 0) {
            int n = objectArray.length;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            String[] stringArray = new String[n];
            IWindowPreset iWindowPreset = grayScaleTransformationSequence.getCurrentWindowPreset();
            int n2 = 0;
            if (ArrayUtils.contains((Object[])objectArray, (Object)iWindowPreset)) {
                dArray[n2] = this.getCenter();
                dArray2[n2] = this.getWidth();
                stringArray[n2] = iWindowPreset.getDescription();
                ++n2;
            }
            Object[] objectArray2 = objectArray;
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object object = objectArray2[n4];
                if (!CompareUtils.equals((Object)object, (Object)iWindowPreset)) {
                    dArray[n2] = ((WindowLevelPreset)object).getWindowCenter();
                    dArray2[n2] = ((WindowLevelPreset)object).getWindowWidth();
                    stringArray[n2] = ((WindowLevelPreset)object).getDescription();
                    ++n2;
                }
                ++n4;
            }
            return VOILUT.create((double[])dArray, (double[])dArray2, (String[])stringArray, (VOILUTFunction)grayScaleTransformationSequence.getVOILUTFunction());
        }
        return null;
    }

    public WindowTransferFunction getTransferFunction() {
        return this.tf;
    }

    public WindowDef getWindow() {
        return this.window;
    }

    public double dataToLogical(double d) {
        return this.window.dataToLogical(d);
    }

    public double getCenter() {
        return this.window.getCenter();
    }

    public int getDataCenter() {
        return this.window.getDataCenter();
    }

    public int getDataWidth() {
        return this.window.getDataWidth();
    }

    public int getGrays() {
        return this.window.getGrays();
    }

    public boolean canPerformLocalWindowing() {
        return this.getGSTS() != null ? !this.getGSTS().isVOILUTEnabled() : true;
    }

    protected boolean canWindowVOILUT() {
        return false;
    }

    public double getNormalizedCenter() {
        return this.window.getNormalizedCenter();
    }

    public double getNormalizedWidth() {
        return this.window.getNormalizedWidth();
    }

    public String getUnit() {
        return this.window.getUnit();
    }

    public double getWidth() {
        return this.window.getWidth();
    }

    String formatWindowValue(double d) {
        return this.window.formatWindowValue(d);
    }

    public void setCenter(double d) {
        this.window.setCenter(d);
    }

    public void setWidth(double d) {
        this.window.setWidth(d);
    }

    public void setDataCenter(double d) {
        this.window.setDataCenter(d);
    }

    public void setDataWidth(double d) {
        this.window.setDataWidth(d);
    }

    public double logicalToData(double d) {
        return this.window.logicalToData(d);
    }

    public abstract String getWindowDescription();

    private void setMouseSensitivity(IHistogram iHistogram) {
        if (iHistogram.getMax() - iHistogram.getMin() != 0.0) {
            this.mouseWindowSens = (float)this.window.getGrays() * 600.0f / (float)(iHistogram.getMax() - iHistogram.getMin());
        }
    }

    public void lowerMouseSensitivity(int n) {
        if (this.mouseWindowSens < (float)n) {
            this.mouseWindowSens = n;
        }
    }

    @Override
    public int handleTEvent(TEvent tEvent, Object object, int n, View view) {
        this.view = view;
        switch (tEvent.id) {
            case 6: {
                if (this.getGSTS() != null) {
                    this.getGSTS().setInversion(!this.getGSTS().getInversion());
                }
                this.tf.recalc();
                return 1;
            }
            case 64: {
                GrayScaleTransformationSequence grayScaleTransformationSequence = this.getGSTS();
                if (grayScaleTransformationSequence != null) {
                    grayScaleTransformationSequence.activateWindowPreset((String)object);
                    this.handleRepaint(view);
                }
                return 1;
            }
            case 62: {
                MouseEvent mouseEvent = (MouseEvent)object;
                if (mouseEvent.getID() == 501) {
                    if (this.firstMousePress) {
                        IHistogramProvider iHistogramProvider;
                        if (this.dataRef != null && (iHistogramProvider = (IHistogramProvider)this.dataRef.get()) != null) {
                            IHistogram iHistogram = iHistogramProvider.getHistogram();
                            this.dataRef = null;
                            this.setMouseSensitivity(iHistogram);
                        }
                        this.firstMousePress = false;
                    }
                    if (this.getGSTS() != null && this.getGSTS().isVOILUTEnabled() && !this.canWindowVOILUT()) {
                        nonWindowingCursor = mouseEvent.getComponent().getCursor();
                        mouseEvent.getComponent().setCursor(voiLUTCursor);
                        return 0;
                    }
                    this.mousePressed(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isControlDown(), mouseEvent.isShiftDown(), view);
                    VisInfoManager.setVisInfoText(this.getWindowDescription());
                    this.broadcastWindowValue(0, view, null);
                } else if (mouseEvent.getID() == 506) {
                    if (this.getGSTS() != null && this.getGSTS().isVOILUTEnabled() && !this.canWindowVOILUT()) {
                        return 0;
                    }
                    WindowValue windowValue = this.mouseDragged(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isControlDown(), mouseEvent.isShiftDown(), view);
                    VisInfoManager.setVisInfoText(this.getWindowDescription());
                    this.broadcastWindowValue(1, view, windowValue);
                    this.handleRepaint(view);
                } else if (mouseEvent.getID() == 502) {
                    if (this.getGSTS() != null && this.getGSTS().isVOILUTEnabled() && !this.canWindowVOILUT()) {
                        if (nonWindowingCursor != null) {
                            mouseEvent.getComponent().setCursor(nonWindowingCursor);
                            nonWindowingCursor = null;
                        } else {
                            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
                        }
                        return 0;
                    }
                    VisInfoManager.setVisInfoText("");
                    WindowValue windowValue = this.mouseReleased(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isControlDown(), mouseEvent.isShiftDown(), view);
                    this.broadcastWindowValue(2, view, windowValue);
                    if (this.myNodeID != 0) {
                        if (view != null) {
                            view.delayedRepaintBroadcast();
                        }
                    } else if (view != null) {
                        view.invalidate();
                        view.repaint();
                    }
                }
                return 1;
            }
            case 63: {
                if (tEvent.source == view && view != null) {
                    return 0;
                }
                if (tEvent.interactionModifier == 0 || tEvent.interactionModifier == 1 && !this.isProgressEventHandlingEnabled) {
                    return 1;
                }
                if (tEvent.interactionModifier != 2 && (tEvent.interactionModifier != 1 || !this.isProgressEventHandlingEnabled)) break;
                if (this.window != null && this.window != object) {
                    if (object instanceof WindowDef) {
                        this.window.setCW((WindowDef)object);
                        this.tf.setWindow(this.window);
                    } else if (object instanceof WindowValue) {
                        this.handleBroadCastedWindowValue((WindowValue)object);
                    } else {
                        WindowTransferFunction windowTransferFunction = this.origtf;
                        WindowDef windowDef = this.origWindowDef;
                        if (object instanceof ITransferFunctionDefinition) {
                            this.handleTransferFunctionUpdate((ITransferFunctionDefinition)object);
                        } else if (object instanceof com.tiani.jvision.tf.function.TransferFunction) {
                            this.handleTransferFunctionUpdate((com.tiani.jvision.tf.function.TransferFunction)object);
                        } else {
                            this.tf.set((TransferFunction)object);
                        }
                        this.origtf = windowTransferFunction;
                        this.origWindowDef = windowDef;
                    }
                    if (tEvent.interactionModifier == 2) {
                        this.onEndWindowing(view);
                    }
                    if (view != null && (tEvent.destinationNodeID == 0 || view.repaintViewAfterEachWindowingEvent())) {
                        view.invalidate();
                        view.delayedRepaint();
                    }
                }
                return 1;
            }
        }
        return 0;
    }

    protected void handleBroadCastedWindowValue(WindowValue windowValue) {
        if (windowValue.isRelative()) {
            if (this.origWindowDef.isSigned()) {
                this.window.setNormalizedCenter((this.origWindowDef.getNormalizedCenter() - 0.5) * windowValue.getCenter() + 0.5);
            } else {
                this.window.setNormalizedCenter(this.origWindowDef.getNormalizedCenter() * windowValue.getCenter());
            }
            this.window.setNormalizedWidth(this.origWindowDef.getNormalizedWidth() * windowValue.getWidth());
        } else {
            this.window.setCenter(windowValue.getCenter());
            this.window.setWidth(windowValue.getWidth());
        }
        this.tf.setWindow(this.window);
    }

    private void handleTransferFunctionUpdate(ITransferFunctionDefinition iTransferFunctionDefinition) {
        IImageInformation iImageInformation = this.view.getImageInformation();
        GeneralWindowTransferFunction generalWindowTransferFunction = new GeneralWindowTransferFunction(iImageInformation, iTransferFunctionDefinition, iImageInformation.getHighBit(), iImageInformation.isInverse(), iImageInformation.isSigned(), iImageInformation.is3D());
        generalWindowTransferFunction.setSOPInstanceUID(iTransferFunctionDefinition.getSOPInstanceUID());
        this.setTransferFunction(generalWindowTransferFunction, !iImageInformation.is3D());
    }

    private void handleTransferFunctionUpdate(com.tiani.jvision.tf.function.TransferFunction transferFunction) {
        com.tiani.jvision.tf.function.TransferFunction transferFunction2 = transferFunction.clone();
        if (this.tf instanceof GeneralWindowTransferFunction) {
            GeneralWindowTransferFunction generalWindowTransferFunction = (GeneralWindowTransferFunction)this.tf;
            generalWindowTransferFunction.set(transferFunction2);
            generalWindowTransferFunction.scaleToCurrentWindow();
        } else {
            IImageInformation iImageInformation = this.view.getImageInformation();
            this.setTransferFunction(new GeneralWindowTransferFunction(transferFunction2, iImageInformation, iImageInformation.getHighBit(), iImageInformation.isSigned()), !iImageInformation.is3D());
        }
    }

    private void handleRepaint(View view) {
        if (view != null) {
            if (this.myNodeID != 0) {
                view.delayedRepaint();
            } else {
                view.invalidate();
                view.repaint();
            }
        }
    }

    public void setWindow(WindowDef windowDef) {
        this.window.setIntercept(windowDef.getIntercept());
        this.window.setSlope(windowDef.getSlope());
        this.window.setCW(windowDef);
        this.tf.setWindow(this.window);
    }

    private void broadcastWindowValue(int n, View view, WindowValue windowValue) {
        TEvent tEvent = new TEvent();
        tEvent.id = 63;
        tEvent.interactionModifier = n;
        tEvent.source = view;
        tEvent.destinationNodeID = this.myNodeID;
        if (!this.localEffect) {
            TEventDispatch.sendEvent(tEvent, windowValue == null ? this.window : windowValue, false);
        } else {
            this.view.handleTEvent(tEvent, windowValue == null ? this.window : windowValue, n);
        }
    }

    protected abstract WindowValue mWindow(int var1, int var2, boolean var3, boolean var4);

    private void mousePressed(int n, int n2, boolean bl, boolean bl2, View view) {
        if (!winStarted) {
            ccl = 0.0;
            cwl = 0.0;
            ccu = 1.0;
            clickPosX = n;
            clickPosY = n2;
            this.onStartWindowing(view);
            clickWidth = (float)this.window.getNormalizedWidth();
            clickCenter = (float)this.window.getNormalizedCenter();
            this.mWindow(n, n2, bl, bl2);
            winStarted = true;
        }
    }

    private WindowValue mouseDragged(int n, int n2, boolean bl, boolean bl2, View view) {
        if (winStarted) {
            return this.mWindow(n, n2, bl, bl2);
        }
        return null;
    }

    public WindowValue mouseReleased(int n, int n2, boolean bl, boolean bl2, View view) {
        WindowValue windowValue = null;
        if (winStarted) {
            windowValue = this.mWindow(n, n2, bl, bl2);
        }
        winStarted = false;
        this.onEndWindowing(view);
        return windowValue;
    }

    protected void updateWindow(double d, double d2) {
        this.window.setNormalizedCenter(d);
        this.window.setNormalizedWidth(d2);
        this.tf.setWindow(this.window);
    }

    public void setDataWindow(double d, double d2) {
        this.setDataWindow(d, d2, true);
    }

    public void setDataWindow(double d, double d2, boolean bl) {
        double d3 = this.dataToLogical(d - d2 / 2.0);
        double d4 = this.dataToLogical(d + d2 / 2.0);
        this.window.setCenter((d4 + d3) / 2.0);
        this.window.setWidth(d4 - d3);
        this.tf.setWindow(this.window);
        if (bl) {
            this.broadcastWindowValue(2, this.view, null);
        }
    }

    protected void onStartWindowing(View view) {
        if (view != null) {
            view.actionStarted(this);
        }
    }

    public void onEndWindowing(View view) {
        if (this.myNodeID == 0 && view != null) {
            view.actionFinished(this);
        }
    }

    private void resetLegacy() {
        if (this.origtf != null) {
            this.tf = this.origtf.getClone();
            this.window = this.tf.getWindowDef();
        } else {
            this.tf.getGSTS().reset(null);
            this.window = new WindowDef(this.origWindowDef);
        }
    }

    public void reset(ILUTContainer iLUTContainer) {
        if (this.origtf instanceof SegmentedPaletteColorLUT) {
            iLUTContainer = null;
        }
        if (iLUTContainer != null) {
            double d = 0.0;
            double d2 = 1.0;
            if (iLUTContainer.getModalityLUT() != null) {
                if (iLUTContainer.getModalityLUT().getRescaleIntercept() != null) {
                    d = iLUTContainer.getModalityLUT().getRescaleIntercept();
                }
                if (iLUTContainer.getModalityLUT().getRescaleSlope() != null) {
                    d2 = iLUTContainer.getModalityLUT().getRescaleSlope();
                }
            }
            this.window.setIntercept(d);
            this.window.setSlope(d2);
            IVOILUT iVOILUT = iLUTContainer.getVOILUT();
            if (iVOILUT != null && iVOILUT.hasWindow()) {
                this.window.setCenter(iVOILUT.getWindowCenter());
                this.window.setWidth(iVOILUT.getWindowWidth());
            } else {
                this.resetLegacy();
            }
        } else {
            this.resetLegacy();
        }
        this.tf.setWindow(this.window);
        GrayScaleTransformationSequence grayScaleTransformationSequence = this.tf.getGSTS();
        if (grayScaleTransformationSequence != null) {
            grayScaleTransformationSequence.setUserInversion(false);
        }
        if (this.tf instanceof GeneralWindowTransferFunction && this.tf.isInverted()) {
            ((GeneralWindowTransferFunction)this.tf).setInverted(false);
            TEvent tEvent = new TEvent();
            tEvent.id = 6;
            TEventDispatch.sendEvent(tEvent, (Object)Boolean.FALSE, TEventDispatch.REGISTERED_LISTENERS);
        }
    }

    public static WindowHandlerBase getInstance(IImageInformation iImageInformation) {
        IImageInformation.ImageClass imageClass = iImageInformation.getImageClass();
        if (imageClass == IImageInformation.ImageClass.NM || imageClass == IImageInformation.ImageClass.PT) {
            return new WindowHandlerNuk(iImageInformation);
        }
        WindowHandler windowHandler = new WindowHandler(iImageInformation);
        return WindowHandlerBase.checkVOILUTWindowing(windowHandler);
    }

    public static WindowHandlerBase getInstance(IImageInformation iImageInformation, WindowDef windowDef) {
        IImageInformation.ImageClass imageClass = iImageInformation.getImageClass();
        if (imageClass == IImageInformation.ImageClass.NM || imageClass == IImageInformation.ImageClass.PT) {
            return new WindowHandlerNuk(iImageInformation, windowDef);
        }
        WindowHandler windowHandler = new WindowHandler(iImageInformation, windowDef);
        return WindowHandlerBase.checkVOILUTWindowing(windowHandler);
    }

    public static WindowHandlerBase getInstance(IImageInformation iImageInformation, ILUTContainer iLUTContainer, boolean bl, boolean bl2, IRDCRenderer iRDCRenderer) {
        WindowHandlerBase windowHandlerBase;
        IImageInformation.ImageClass imageClass = iImageInformation.getImageClass();
        RawDataContainer rawDataContainer = null;
        if (iRDCRenderer != null) {
            rawDataContainer = iRDCRenderer.getRawDataContainer();
        }
        if (imageClass == IImageInformation.ImageClass.NM || imageClass == IImageInformation.ImageClass.PT) {
            windowHandlerBase = new WindowHandlerNuk(iImageInformation, iLUTContainer, bl, bl2, rawDataContainer);
        } else {
            windowHandlerBase = new WindowHandler(iImageInformation, iLUTContainer, bl, bl2, rawDataContainer);
            windowHandlerBase = WindowHandlerBase.checkVOILUTWindowing((WindowHandler)windowHandlerBase);
        }
        return windowHandlerBase;
    }

    private static WindowHandlerBase checkVOILUTWindowing(WindowHandler windowHandler) {
        if (!windowHandler.getGSTS().hasVOILUT()) {
            return windowHandler;
        }
        if (Config.impaxee.jvision.DISPLAY.WindowVOILUT.get()) {
            return new WindowHandlerVOILUT(windowHandler);
        }
        return windowHandler;
    }

    public static WindowHandlerBase getInstance(WindowHandlerBase windowHandlerBase) {
        if (windowHandlerBase instanceof WindowHandlerNuk) {
            return new WindowHandlerNuk(windowHandlerBase);
        }
        if (windowHandlerBase instanceof WindowHandlerVOILUT) {
            return new WindowHandlerVOILUT(windowHandlerBase);
        }
        return new WindowHandler(windowHandlerBase);
    }
}

