/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayInformationID;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.JOptionPane;

public class VolumeCalculationAction
extends AbstractPAction {
    private static final String ID = "VOLUME_CALCULATION";
    private static final ALogger LOG = ALogger.getLogger(VolumeCalculationAction.class);
    private static final double MIN_ROI_OVERLAP = 0.15;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getGroupName() {
        return PAction.MARKUPS_GROUP;
    }

    @Override
    public String getCaption() {
        return "Calculate volume";
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public boolean isAvailable() {
        return !Product.isReleasedVersion();
    }

    private double getAreaOfPO(List<IOverlayInformation> list) {
        for (IOverlayInformation iOverlayInformation : list) {
            if (iOverlayInformation.getID() != OverlayInformationID.AREA) continue;
            return iOverlayInformation.getFirstValue();
        }
        throw new RuntimeException("No area available");
    }

    private boolean areaIsInMM(List<IOverlayInformation> list) {
        for (IOverlayInformation iOverlayInformation : list) {
            if (iOverlayInformation.getID() != OverlayInformationID.AREA) continue;
            return iOverlayInformation.getFirstUnit().equalsIgnoreCase("mm2");
        }
        return false;
    }

    private double getArea(Rectangle2D rectangle2D) {
        return rectangle2D.getWidth() * rectangle2D.getHeight();
    }

    private double errorMargin(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        return this.getArea(rectangle2D2) / this.getArea(rectangle2D);
    }

    private double addVolume(List<VisData> list, int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
        if (n < 0 || n >= list.size()) {
            return 0.0;
        }
        SyncablePresentationObject syncablePresentationObject = null;
        list.get(n).getView().getRenderer().setGeometry(rectangle2.width, rectangle2.height, 0, rectangle2.width);
        for (Overlay overlay : list.get(n).getView().getPresentationObjects()) {
            if (!(overlay instanceof StatisticsPresentationObject)) continue;
            StatisticsPresentationObject statisticsPresentationObject = (StatisticsPresentationObject)overlay;
            statisticsPresentationObject.updateLegend();
            Rectangle2D rectangle2D = rectangle.createIntersection(statisticsPresentationObject.getBoundingBox());
            if (!(this.errorMargin(rectangle, rectangle2D) > 0.15)) continue;
            syncablePresentationObject = statisticsPresentationObject;
            break;
        }
        double d = 0.0;
        if (syncablePresentationObject != null) {
            d = this.getAreaOfPO(syncablePresentationObject.getOverlayInformation()) * this.getSliceDistance(list, n);
            d += this.addVolume(list, n + n2, n2, syncablePresentationObject.getBoundingBox(), rectangle2);
        }
        return d;
    }

    private double getSliceDistance(List<VisData> list, int n) {
        IDisplaySet iDisplaySet = list.get(0).getParent().getDisplaySet();
        if (!iDisplaySet.hasLocationInformation()) {
            throw new RuntimeException("Slide distance not computable");
        }
        return iDisplaySet.getSliceDistance(n);
    }

    @Override
    public boolean perform(Component component) {
        double d;
        this.notifyActionPerformed();
        VisData visData = VisData.getLastModified();
        Rectangle rectangle = visData.getVisual().getBounds();
        PresentationObject presentationObject = visData.getView().getMouseHandler().getActivePO();
        if (presentationObject == null) {
            return false;
        }
        if (!(presentationObject instanceof StatisticsPresentationObject)) {
            return false;
        }
        StatisticsPresentationObject statisticsPresentationObject = (StatisticsPresentationObject)presentationObject;
        List<VisData> list = visData.getParent().getVis();
        int n = list.indexOf(visData);
        double d2 = 0.0;
        if (!this.areaIsInMM(statisticsPresentationObject.getOverlayInformation())) {
            LOG.error("Area not in mm2");
            return false;
        }
        try {
            d = d2 = this.getAreaOfPO(statisticsPresentationObject.getOverlayInformation()) * this.getSliceDistance(list, n);
            d2 += this.addVolume(list, n + 1, 1, statisticsPresentationObject.getBoundingBox(), rectangle);
        }
        catch (Exception exception) {
            LOG.warn("Could not compute volume", (Throwable)exception);
            return false;
        }
        if ((d2 += this.addVolume(list, n - 1, -1, statisticsPresentationObject.getBoundingBox(), rectangle)) == d) {
            LOG.error("just single roi found");
            return false;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        JOptionPane.showMessageDialog(component, "Calculated volume:" + numberFormat.format(d2 / 1000.0) + "cm3");
        return true;
    }
}

