/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.tiani.gui.dialog.StandardDialog;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.LengthOverlay;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PixelSizeCalibrationDialog
extends StandardDialog
implements KeyListener {
    private JTextField calTF;
    private double result = 0.0;
    private LengthOverlay refPO;
    private ImgView2 parent;

    public PixelSizeCalibrationDialog(ImgView2 imgView2, String string, LengthOverlay lengthOverlay) {
        super((Frame)JVision2.getMainFrame(), string);
        this.parent = imgView2;
        this.refPO = lengthOverlay;
        this.addOKButton(new OKAction(Messages.getString("VISPOPUP_IMAGE_CALIBRATION_DLG_APPLY")));
        this.addCancelButton(new CancelAction(Messages.getString("VISPOPUP_IMAGE_CALIBRATION_DLG_CANCEL")));
        this.setContent(this.createMainPanel());
        this.pack();
        this.initLocation();
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)ComponentFactory.instance.createLabel(Messages.getString("VISPOPUP_IMAGE_CALIBRATION_DLG_REFERENCE")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = ComponentFactory.instance.createLabel(PresentationObject.formatValue(this.refPO.getLength()));
        jLabel.setHorizontalAlignment(4);
        jLabel.setPreferredSize(new Dimension(Math.max(GUI.getScaledDiagnosticInt((int)50), jLabel.getPreferredSize().width), jLabel.getPreferredSize().width));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        JLabel jLabel2 = ComponentFactory.instance.createLabel(" " + this.refPO.dimensionUnit());
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)ComponentFactory.instance.createLabel(Messages.getString("VISPOPUP_IMAGE_CALIBRATION_DLG_CALIBRATED")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.calTF = ComponentFactory.instance.createTextField();
        this.calTF.setHorizontalAlignment(4);
        this.calTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PixelSizeCalibrationDialog.this.setResult();
            }
        });
        jPanel.add((Component)this.calTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        JLabel jLabel3 = ComponentFactory.instance.createLabel(" mm (" + SpacingDef.Unit.mm_man.commentPart() + ")");
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                PixelSizeCalibrationDialog.this.calTF.requestFocus();
            }
        });
        this.calTF.addKeyListener(this);
        return jPanel;
    }

    private void setResult() {
        this.result = Double.parseDouble(this.calTF.getText().replace(",", "."));
        if (this.result > 0.0) {
            this.setVisible(false);
            this.parent.setCalibration(this.result, this.refPO);
        } else {
            String string = Messages.getString("VISPOPUP_IMAGE_CALIBRATION_ERR_TITLE");
            String string2 = Messages.getString("VISPOPUP_IMAGE_CALIBRATION_ERR_MESSAGE");
            Message.error(string, (Object)string2);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction(String string) {
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PixelSizeCalibrationDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction(String string) {
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PixelSizeCalibrationDialog.this.setResult();
        }
    }
}

