/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.impaxee.frameofreference.FrameOfReferenceManager;
import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransform;
import com.tiani.base.data.IImageInformation;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class PickingResult {
    protected Point3d entry;
    protected Point3d exit;
    protected Point3d point;
    public final String frameOfReferenceUID;

    public PickingResult(Point3d point3d, Point3d point3d2, Point3d point3d3, String string) {
        this.entry = point3d;
        this.exit = point3d2;
        this.point = point3d3;
        this.frameOfReferenceUID = string == null || string.isEmpty() ? null : string;
    }

    public Point3d getPoint(String string) {
        Point3d point3d = new Point3d(this.point);
        if (this.frameOfReferenceUID == null || string == null) {
            return point3d;
        }
        if (this.frameOfReferenceUID != null && this.frameOfReferenceUID.equals(string)) {
            return point3d;
        }
        if (this.convertPoint(point3d, string)) {
            return point3d;
        }
        return null;
    }

    public Point3d getRayEntry() {
        return new Point3d(this.entry);
    }

    public Point3d getRayExit() {
        return new Point3d(this.exit);
    }

    public Point3d getRayHit() {
        return new Point3d(this.point);
    }

    public boolean isCompatibleFrameOfReference(String string) {
        return FrameOfReferenceManager.hasWorldToWorldTransform(this.frameOfReferenceUID, string);
    }

    public boolean hasFrameOfReference() {
        return this.frameOfReferenceUID != null;
    }

    public final Vector3d projectToPlane(IImageInformation iImageInformation) {
        Point3d point3d = new Point3d(this.point);
        if (!this.frameOfReferenceUID.equals(iImageInformation.getFrameOfReferenceUID()) && !this.convertPoint(point3d, iImageInformation.getFrameOfReferenceUID())) {
            return null;
        }
        Vector3d vector3d = iImageInformation.getPlaneNormalUV();
        if (iImageInformation.getVectorOrigin() == null || vector3d == null) {
            return null;
        }
        Vector3d vector3d2 = new Vector3d((Tuple3d)point3d);
        vector3d2.sub((Tuple3d)iImageInformation.getVectorOrigin());
        Vector3d vector3d3 = new Vector3d(vector3d);
        vector3d3.normalize();
        double d = vector3d3.dot(vector3d2);
        vector3d3.scale(d);
        vector3d2.set((Tuple3d)point3d);
        vector3d2.sub((Tuple3d)vector3d3);
        return vector3d2;
    }

    public final Double getDistanceFromPlane(IImageInformation iImageInformation) {
        Point3d point3d = new Point3d(this.point);
        if (!this.frameOfReferenceUID.equals(iImageInformation.getFrameOfReferenceUID()) && !this.convertPoint(point3d, iImageInformation.getFrameOfReferenceUID())) {
            return null;
        }
        Vector3d vector3d = this.projectToPlane(iImageInformation);
        if (vector3d == null) {
            return null;
        }
        vector3d.sub((Tuple3d)point3d);
        return vector3d.length();
    }

    public static final Vector2d worldToImage(Tuple3d tuple3d, IImageInformation iImageInformation) {
        Vector3d vector3d = iImageInformation.getScaledVectorU();
        Vector3d vector3d2 = iImageInformation.getScaledVectorV();
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d2, vector3d);
        Matrix3d matrix3d = new Matrix3d(vector3d.x, vector3d2.x, vector3d3.x, vector3d.y, vector3d2.y, vector3d3.y, vector3d.z, vector3d2.z, vector3d3.z);
        matrix3d.invert();
        tuple3d.sub((Tuple3d)iImageInformation.getVectorOrigin());
        matrix3d.transform(tuple3d);
        return new Vector2d(tuple3d.x, tuple3d.y);
    }

    private boolean convertPoint(Point3d point3d, String string) {
        IWorldToWorldTransform iWorldToWorldTransform = FrameOfReferenceManager.getWorldToWorldTransform(this.frameOfReferenceUID, string);
        if (iWorldToWorldTransform == null) {
            return false;
        }
        iWorldToWorldTransform.transform(point3d);
        return true;
    }
}

