/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.listtext.dicomobject.lut.IColorLookupTableSource;
import com.agfa.pacs.listtext.dicomobject.lut.ILookupTable;
import com.agfa.pacs.listtext.dicomobject.module.ps.PaletteColorLUTModule;
import com.tiani.jvision.image.WindowDef;
import com.tiani.jvision.image.WindowTransferFunction;
import org.dcm4che3.data.Attributes;

public class PaletteColorLUT
extends WindowTransferFunction {
    protected byte[] ccRed;
    protected byte[] ccGreen;
    protected byte[] ccBlue;
    protected int paddingValue = -1;
    protected ILookupTable redLUT;
    protected ILookupTable greenLUT;
    protected ILookupTable blueLUT;

    PaletteColorLUT(IColorLookupTableSource iColorLookupTableSource, int n) {
        super(1 << n);
        this.redLUT = iColorLookupTableSource.getLookupTable(IColorLookupTableSource.Channel.Red);
        this.greenLUT = iColorLookupTableSource.getLookupTable(IColorLookupTableSource.Channel.Green);
        this.blueLUT = iColorLookupTableSource.getLookupTable(IColorLookupTableSource.Channel.Blue);
        int[] nArray = this.redLUT.getFullLUT(n, false);
        int[] nArray2 = this.greenLUT.getFullLUT(n, false);
        int[] nArray3 = this.blueLUT.getFullLUT(n, false);
        this.ccRed = this.convert(nArray, this.redLUT.getOutputBits() - 8);
        this.ccGreen = this.convert(nArray2, this.greenLUT.getOutputBits() - 8);
        this.ccBlue = this.convert(nArray3, this.blueLUT.getOutputBits() - 8);
    }

    PaletteColorLUT(PaletteColorLUT paletteColorLUT) {
        super(paletteColorLUT);
        this.redLUT = paletteColorLUT.redLUT;
        this.greenLUT = paletteColorLUT.greenLUT;
        this.blueLUT = paletteColorLUT.blueLUT;
        this.ccRed = paletteColorLUT.ccRed;
        this.ccGreen = paletteColorLUT.ccGreen;
        this.ccBlue = paletteColorLUT.ccBlue;
    }

    private byte[] convert(int[] nArray, int n) {
        byte[] byArray = new byte[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            byArray[n2] = (byte)(nArray[n2] >> n & 0xFF);
            ++n2;
        }
        return byArray;
    }

    @Override
    public int[] getRGB(boolean bl) {
        if (this.rgb == null) {
            this.rgb = new int[this.ccRed.length];
            this.modified = true;
        }
        if (bl != this.inverted || this.modified) {
            ++this.tusi;
            if (!bl) {
                int n = 0;
                while (n < this.ccRed.length) {
                    this.rgb[n] = (this.ccRed[n] & 0xFF) << 16 | (this.ccGreen[n] & 0xFF) << 8 | this.ccBlue[n] & 0xFF;
                    ++n;
                }
                if (this.paddingValue != -1 && this.paddingValue < this.ccRed.length) {
                    this.rgb[this.paddingValue] = 0;
                }
            } else {
                int n = 0;
                while (n < this.ccRed.length) {
                    this.rgb[n] = 255 - (this.ccRed[n] & 0xFF) << 16 | 255 - (this.ccGreen[n] & 0xFF) << 8 | 255 - (this.ccBlue[n] & 0xFF);
                    ++n;
                }
                if (this.paddingValue != -1 && this.paddingValue < this.ccRed.length) {
                    this.rgb[this.paddingValue] = 0xFFFFFF;
                }
            }
            this.inverted = bl;
        }
        return this.rgb;
    }

    @Override
    public void storeTo(Attributes attributes) {
        PaletteColorLUTModule paletteColorLUTModule = new PaletteColorLUTModule();
        int[] nArray = new int[3];
        nArray[0] = this.ccRed.length;
        nArray[2] = 8;
        paletteColorLUTModule.setRedPaletteColorLookupTableDescriptor(nArray);
        paletteColorLUTModule.setRedPaletteColorLookupTableData(this.ccRed);
        int[] nArray2 = new int[3];
        nArray2[0] = this.ccGreen.length;
        nArray2[2] = 8;
        paletteColorLUTModule.setGreenPaletteColorLookupTableDescriptor(nArray2);
        paletteColorLUTModule.setGreenPaletteColorLookupTableData(this.ccGreen);
        int[] nArray3 = new int[3];
        nArray3[0] = this.ccBlue.length;
        nArray3[2] = 8;
        paletteColorLUTModule.setBluePaletteColorLookupTableDescriptor(nArray3);
        paletteColorLUTModule.setBluePaletteColorLookupTableData(this.ccBlue);
        paletteColorLUTModule.writeTo(attributes);
    }

    @Override
    public WindowDef getWindowDef() {
        return null;
    }
}

