/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateSource;
import com.agfa.pacs.listtext.dicomobject.presentationstate.IPresentationStateInfo;
import com.agfa.pacs.listtext.dicomobject.presentationstate.ImagePresentationStateInfo;
import com.tiani.jvision.image.AbstractPresentationStateAction;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class PSChooserAction
extends AbstractPresentationStateAction {
    public PSChooserAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        super(pDataScope, pDataProvider);
    }

    @Override
    public String getCaption() {
        if (this.scope == PDataScope.CurrentImage || this.provider != null) {
            return Messages.getString("ImgView2.PresentationStates");
        }
        return Messages.getString("PSChooserAction.DisplayPresentationState");
    }

    @Override
    public boolean isUpdatingListeners() {
        return this.provider != null;
    }

    @Override
    int getMinimumRequiredPresentationStateCount() {
        return 2;
    }

    @Override
    boolean isSubmenuExclusive() {
        return this.scope == PDataScope.CurrentImage || this.provider != null;
    }

    @Override
    List<PAction> getSubactionsImpl() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        List<IPresentationStateInfo> list = this.getPresentationStates();
        if (this.scope == PDataScope.CurrentDisplay) {
            int n = 0;
            while (n < list.size()) {
                arrayList.add(new ApplyPresentationStateAction(list.get(n)));
                ++n;
            }
        } else if (this.scope == PDataScope.CurrentImage) {
            for (IPresentationStateInfo iPresentationStateInfo : list) {
                arrayList.add(new SelectPresentationStateAction(iPresentationStateInfo));
            }
        } else if (this.provider != null) {
            int n = 0;
            while (n < list.size()) {
                arrayList.add(new SelectDisplayPresentationStateAction(list.get(n), n + 1));
                ++n;
            }
            if (arrayList.isEmpty()) {
                arrayList.add(new SelectDisplayPresentationStateAction((IPresentationStateInfo)ImagePresentationStateInfo.staticInstance, 0));
            }
        }
        return arrayList;
    }

    private void updatePSSelection(VisDisplay2 visDisplay2) {
        if (visDisplay2 == null) {
            visDisplay2 = AbstractPDataAction.getCurrentDisplay();
        }
        if (visDisplay2.hasAction("PS_CHOOSER")) {
            ((PSChooserAction)visDisplay2.getAction("PS_CHOOSER")).selectionChanged();
        }
    }

    @Override
    String getDataActionID() {
        return "PS_CHOOSER";
    }

    private class ApplyPresentationStateAction
    extends AbstractPresentationStateAction.AbstractAnonymousPSAction {
        public ApplyPresentationStateAction(IPresentationStateInfo iPresentationStateInfo) {
            super(PSChooserAction.this, iPresentationStateInfo);
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("PS_CHOOSER");
            List<VisData> list = AbstractPDataAction.getVisDatas(PSChooserAction.this.scope);
            if (list.isEmpty()) {
                Message.info(Messages.getString("VISPOPUP_NO_SELECTED_IMAGES"));
                return false;
            }
            for (VisData visData : list) {
                View view = visData.getView();
                view.applyPresentationState((IFramePresentationStateSource)this.ps);
            }
            PSChooserAction.this.updatePSSelection(null);
            return true;
        }
    }

    private class SelectDisplayPresentationStateAction
    extends AbstractPresentationStateAction.AbstractAnonymousPSAction {
        public SelectDisplayPresentationStateAction(IPresentationStateInfo iPresentationStateInfo, int n) {
            super(PSChooserAction.this, iPresentationStateInfo, n);
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public boolean isSelected() {
            List<VisData> list = PSChooserAction.this.provider.getVisDatas();
            if (list.isEmpty()) {
                return !this.ps.isExternal();
            }
            IFramePresentationState iFramePresentationState = null;
            View view = list.get(0).getView();
            int n = 0;
            while (n < list.size()) {
                IFramePresentationState iFramePresentationState2;
                View view2 = list.get(n).getView();
                if (view2 instanceof ImgView2 && (iFramePresentationState2 = ((ImgView2)view2).getCurrentFramePresentationState()) != null && iFramePresentationState2.isExternal()) {
                    view = view2;
                    break;
                }
                ++n;
            }
            if (view instanceof ImgView2) {
                iFramePresentationState = ((ImgView2)view).getCurrentFramePresentationState();
            }
            if (iFramePresentationState == null) {
                return !this.ps.isExternal();
            }
            if (this.ps.isExternal()) {
                return this.ps.contains(iFramePresentationState.getProviderUID());
            }
            return !iFramePresentationState.isExternal();
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("PS_CHOOSER");
            List<VisData> list = PSChooserAction.this.provider.getVisDatas();
            for (VisData visData : list) {
                View view = visData.getView();
                view.applyPresentationState((IFramePresentationStateSource)this.ps);
            }
            PSChooserAction.this.updatePSSelection((VisDisplay2)PSChooserAction.this.provider);
            return true;
        }
    }

    private class SelectPresentationStateAction
    extends AbstractPresentationStateAction.AbstractAnonymousPSAction {
        public SelectPresentationStateAction(IPresentationStateInfo iPresentationStateInfo) {
            super(PSChooserAction.this, iPresentationStateInfo);
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public boolean isSelected() {
            View view = AbstractPDataAction.getCurrentImage().getView();
            if (view instanceof ImgView2) {
                ImgView2 imgView2 = (ImgView2)view;
                IFramePresentationState iFramePresentationState = imgView2.getCurrentFramePresentationState();
                if (iFramePresentationState == null) {
                    return false;
                }
                if (this.ps.isExternal()) {
                    return this.ps.contains(iFramePresentationState.getProviderUID());
                }
                return !iFramePresentationState.isExternal();
            }
            return false;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("PS_CHOOSER");
            View view = AbstractPDataAction.getCurrentImage().getView();
            view.applyPresentationState((IFramePresentationStateSource)this.ps);
            return true;
        }
    }
}

