/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.menu.IMenuEntry;
import com.agfa.pacs.impaxee.presentationstate.IPresentationStateProvider;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateSource;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.MousePositionDestination;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewMouseHandler;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.OrientationMapping;
import com.tiani.jvision.overlay.OrientationMapping2D;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.RulerMapping;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.ImageFilterNode;
import com.tiani.jvision.renderer.IntermediateNode;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.renderer.RendererTree;
import com.tiani.jvision.vis.VisData;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public abstract class LayeredView
extends View {
    protected RendererTree renderert = new RendererTree();
    private int eventInProcessRepaintLock = 0;
    protected boolean updateMappingOnPaint = false;

    public LayeredView() {
    }

    public LayeredView(IFrameObjectData iFrameObjectData) {
        super(iFrameObjectData);
    }

    @Override
    public IImageInformation getImageInformation() {
        if (this.renderert.getEventRoot() != null) {
            return this.renderert.getEventRoot().getImageInformation();
        }
        return super.getImageInformation();
    }

    @Override
    public IPresentationStateProvider getPresentationStateProvider() {
        if (this.renderert.getEventRoot() != null) {
            Renderer renderer = this.renderert.getEventRoot();
            if (!(renderer instanceof IPresentationStateProvider)) {
                return null;
            }
            this.ensureInitializationForPS();
            return (IPresentationStateProvider)((Object)renderer);
        }
        return super.getPresentationStateProvider();
    }

    private void ensureInitializationForPS() {
        Renderer renderer = this.getRenderer();
        if (renderer != null) {
            Rectangle rectangle = this.getBounds();
            renderer.setGeometry(rectangle.width, rectangle.height, 0, rectangle.width);
        }
    }

    private IFramePresentationState getPresentationState(IFramePresentationStateSource iFramePresentationStateSource, IFrameObjectData iFrameObjectData, IPixelDataFrame<?> iPixelDataFrame) {
        String string = iFrameObjectData.getSOPInstanceUID();
        int n = iFrameObjectData.getFrameNumber();
        Attributes attributes = iFrameObjectData.getDicomObject();
        IFramePresentationState iFramePresentationState = null;
        if (iFramePresentationStateSource != null) {
            iFramePresentationState = iFramePresentationStateSource.getFramePresentationState(string, attributes, n, iPixelDataFrame);
        }
        if (iFramePresentationState == null) {
            iFramePresentationState = iFrameObjectData.getMainFrame().getFramePresentationState(n, iPixelDataFrame);
        }
        return iFramePresentationState;
    }

    @Override
    public void applyPresentationState(IFramePresentationStateSource iFramePresentationStateSource) {
        Renderer renderer = this.getRenderer();
        if (renderer instanceof IRDCRenderer) {
            IPixelDataFrame<?> iPixelDataFrame;
            IRDCRenderer iRDCRenderer = (IRDCRenderer)((Object)renderer);
            IFrameObjectData iFrameObjectData = iRDCRenderer.getFrameObjectData();
            IFramePresentationState iFramePresentationState = this.getPresentationState(iFramePresentationStateSource, iFrameObjectData, iPixelDataFrame = iRDCRenderer.getRawDataContainer().getPixelDataFrame());
            if (iFramePresentationState == null) {
                iRDCRenderer.clearPresentationState(iFramePresentationState);
            } else {
                List<PresentationObject> list = this.applyPresentationState(iRDCRenderer, iFramePresentationState);
                for (Overlay overlay : list) {
                    this.addOverlay(overlay);
                }
            }
            this.invalidate();
            this.repaint();
        }
    }

    protected List<PresentationObject> applyPresentationState(IRDCRenderer iRDCRenderer, IFramePresentationState iFramePresentationState) {
        return iRDCRenderer.applyPresentationState(iFramePresentationState);
    }

    public RendererTree getRendererTree() {
        return this.renderert;
    }

    @Override
    public TransferFunction getTransferFunction() {
        if (this.renderert.getEventRoot() != null) {
            return this.renderert.getEventRoot().getTransferFunction();
        }
        return null;
    }

    @Override
    public List<Overlay> getPresentationObjects() {
        if (this.renderert.getPaintRoot() != null) {
            ArrayList<Overlay> arrayList = new ArrayList<Overlay>(this.renderert.getPaintRoot().getOverlays());
            arrayList.addAll(super.getPresentationObjects());
            return arrayList;
        }
        return super.getPresentationObjects();
    }

    @Override
    public List<Overlay> getOverlays() {
        return this.getPresentationObjects();
    }

    public void removeOverlays(List<? extends Overlay> list) {
        for (Overlay overlay : list) {
            this.removeOverlay(overlay);
        }
    }

    @Override
    public void removeOverlay(Overlay overlay) {
        if (this.renderert.getRoot() != null) {
            this.renderert.getRoot().removeOverlay(overlay);
        }
        super.removeOverlay(overlay);
    }

    @Override
    public void removeAllOverlays() {
        this.removeOverlays(this.getOverlays());
    }

    public void addGlobalOverlays(List<Overlay> list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            this.addGlobalOverlay(list.get(n2));
            ++n2;
        }
    }

    public void addGlobalOverlay(Overlay overlay) {
        super.addOverlay(overlay);
    }

    void addGlobalOverlay(Overlay overlay, int n) {
        super.addOverlay(overlay, n);
    }

    @Override
    public void addOverlay(Overlay overlay) {
        if (overlay instanceof Mapping || overlay instanceof RulerMapping || overlay instanceof OrientationMapping) {
            super.addOverlay(overlay);
        } else {
            if (this.renderert.getEventRoot() == null) {
                return;
            }
            this.renderert.getEventRoot().addOverlay(overlay);
            if (overlay instanceof PresentationObject) {
                ((PresentationObject)overlay).presentationObjectAdded(this);
            } else {
                overlay.setOwner(this);
            }
            if (this.lockBackground) {
                if (this.excludeFromLock == null) {
                    this.excludeFromLock = new HashSet(3);
                }
                this.excludeFromLock.add(overlay);
            }
            overlay.setSize(this.getcwidth(), this.getcheight(), overlay.getImageState());
            this.invalidate();
        }
    }

    @Override
    public void paintOverlays(RGBBufferedImageHolder rGBBufferedImageHolder) {
        if (paintOverlays && this.renderert.getPaintRoot() != null) {
            this.renderert.getPaintRoot().paintOverlays(rGBBufferedImageHolder, this.excludeFromLock, this.lockBackground);
        }
        super.paintOverlays(rGBBufferedImageHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshPresentationObjects() {
        if (this.getcwidth() == 1) {
            return;
        }
        List list = this.overlays;
        synchronized (list) {
            for (Overlay overlay : this.overlays) {
                overlay.setSize(this.getcwidth(), this.getcheight(), overlay.getImageState());
            }
        }
        if (this.getMapping() != null) {
            this.getMapping().updateContent(this.getEvaluationContext(), true, true);
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.renderert != null) {
            this.renderert.cleanUp();
        }
    }

    @Override
    public String getInfoAt(int n, int n2) {
        if (!this.isFunctional() || this.getMouseFollower() == null) {
            return "";
        }
        return this.getMouseFollower().getInfoAt(n, n2, this.getcwidth(), this.getcheight());
    }

    @Override
    public void broadcastPointOfInterest(int n, int n2) {
        if (broadcastPointOfInterest && this.isFunctional()) {
            PickingResult pickingResult = this.renderert.getEventRoot().pick(n, n2);
            if (pickingResult != null && !pickingResult.hasFrameOfReference()) {
                pickingResult = null;
            }
            TEvent tEvent = new TEvent(57);
            tEvent.source = this;
            TEventDispatch.sendEvent(tEvent, (Object)pickingResult, TEventDispatch.ALL_DISPLAYS | TEventDispatch.ALL_VISUALS);
        }
    }

    @Override
    protected MousePositionDestination getMouseFollower() {
        if (this.renderert.getEventRoot() != null) {
            return this.renderert.getEventRoot().getMouseFollower();
        }
        return null;
    }

    @Override
    public void localWindow(int n, int n2) {
        if (!this.isFunctional()) {
            return;
        }
        TEvent tEvent = new TEvent();
        tEvent.id = 69;
        tEvent.source = null;
        tEvent.interactionModifier = 2;
        tEvent.destinationNodeID = 0;
        this.handleTEvent(tEvent, new Point(n, n2), 0);
    }

    @Override
    public List<IMenuEntry> getLegacyMenuEntries() {
        return this.renderert.getLegacyMenuEntries(this);
    }

    @Override
    public ViewSnapshot renderToSnapshot(int n, int n2, int n3, int n4, double d, double d2, View.OverlayMode overlayMode, boolean bl) {
        ViewSnapshot viewSnapshot;
        if (overlayMode == View.OverlayMode.PRINT_OVERLAY_ALL_AND_ROI) {
            overlayMode = View.OverlayMode.PRINT_OVERLAY_ROI;
            viewSnapshot = this.renderert.renderToSnapshot(n, n2, n3, n4, d, d2, overlayMode, bl);
            viewSnapshot.setOverlayMode(View.OverlayMode.PRINT_OVERLAY_ALL);
        } else {
            viewSnapshot = this.renderert.renderToSnapshot(n, n2, n3, n4, d, d2, overlayMode, bl);
        }
        this.snapGlobalOverlays(viewSnapshot);
        this.addGlobalTags(viewSnapshot);
        return viewSnapshot;
    }

    private void snapGlobalOverlays(ViewSnapshot viewSnapshot) {
        int n = this.cwidth;
        int n2 = this.cheight;
        this.cwidth = viewSnapshot.getWidth();
        this.cheight = viewSnapshot.getHeight();
        super.refreshPresentationObjects();
        viewSnapshot.applyOverlays(super.getOverlays());
        this.cwidth = n;
        this.cheight = n2;
        super.refreshPresentationObjects();
    }

    @Override
    public int getOptimumViewingWidth() {
        return 10000;
    }

    @Override
    public int getOptimumViewingHeight() {
        return 10000;
    }

    @Override
    public ImageState getImageState() {
        ImageState imageState = this.renderert.getImageState();
        if (imageState == null) {
            imageState = ImageState.getDefaultImageState();
        }
        return imageState;
    }

    protected OrientationMapping getOrientation() {
        return Overlay.find(OrientationMapping.class, super.getOverlays());
    }

    private void addGlobalTags(ViewSnapshot viewSnapshot) {
        Vector3d vector3d;
        Vector3d vector3d2;
        ImageState imageState = this.getImageState();
        boolean bl = false;
        boolean bl2 = false;
        SpacingDef spacingDef = imageState.getCurrentSpacingDef();
        if (spacingDef.getDataPixelSizeY() != 0.0) {
            if (spacingDef.isProjectiveSpacing()) {
                viewSnapshot.getDataset().remove(2621488);
            } else {
                viewSnapshot.getDataset().setDouble(2621488, VR.DS, new double[]{imageState.pixelSizeY / imageState.getDataPixelSizeY() * spacingDef.getDataPixelSizeY(), imageState.pixelSizeX / imageState.getDataPixelSizeX() * spacingDef.getDataPixelSizeX()});
            }
            bl = true;
        } else {
            viewSnapshot.getDataset().remove(2621488);
        }
        OrientationMapping orientationMapping = this.getOrientation();
        if (orientationMapping != null) {
            vector3d2 = new Vector3d();
            vector3d = new Vector3d();
            ((OrientationMapping2D)orientationMapping).getImageOrientation(imageState.transform, vector3d2, vector3d);
            if (vector3d2.length() > 0.0 && vector3d.length() > 0.0) {
                bl2 = true;
                viewSnapshot.getDataset().setDouble(2097207, VR.DS, new double[]{vector3d2.x, vector3d2.y, vector3d2.z, vector3d.x, vector3d.y, vector3d.z});
            }
        } else {
            viewSnapshot.getDataset().remove(2097207);
        }
        if (bl && bl2 && !viewSnapshot.getDataset().containsValue(0x200032)) {
            vector3d2 = this.getImageInformation().getVectorOrigin();
            vector3d = this.getImageInformation().getScaledVectorU();
            Vector3d vector3d3 = this.getImageInformation().getScaledVectorV();
            if (vector3d.length() > 0.0 && vector3d3.length() > 0.0) {
                vector3d.scale(imageState.visOrig[0]);
                vector3d3.scale(imageState.visOrig[1]);
                vector3d2.add((Tuple3d)vector3d, (Tuple3d)vector3d3);
                viewSnapshot.getDataset().setDouble(0x200032, VR.DS, new double[]{vector3d2.x, vector3d2.y, vector3d2.z});
            }
        }
    }

    @Override
    public void handleTEvent(TEvent tEvent, Object object, int n) {
        ++this.eventInProcessRepaintLock;
        try {
            switch (tEvent.id) {
                case 81: {
                    if (tEvent.source != this) {
                        this.invalidate();
                        this.repaint();
                    }
                    break;
                }
                case 90: {
                    this.renderert.syncAll((Map)object);
                    break;
                }
                default: {
                    if (tEvent.source != this && this.renderert.handleTEvent(tEvent, object, n, this)) {
                        if (tEvent.interactionModifier == 2) {
                            this.invalidate();
                            if (tEvent.id != 62 || object instanceof MouseEvent && ((MouseEvent)object).getID() == 502) {
                                this.actionFinished(null);
                            }
                        }
                        break;
                    }
                    super.handleTEvent(tEvent, object, n);
                    break;
                }
            }
        }
        finally {
            --this.eventInProcessRepaintLock;
        }
        if (tEvent.source != this) {
            if (tEvent.interactionModifier == 2 && this.getMapping() != null && this.isInView()) {
                this.getMapping().updateContent(this.getEvaluationContext(), true, false);
            }
            this.handleDelayedRepaint(true);
        }
    }

    public boolean layerOnHotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
        return false;
    }

    public boolean layerOnHotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
        return false;
    }

    public boolean layerOnHotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    @Override
    public final void handleHotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
        if (!this.isFunctional() || this.renderert.getRoot() == null) {
            return;
        }
        ++this.eventInProcessRepaintLock;
        try {
            if ((this.layerOnHotRegionPressed(hotRegion, mouseEvent) || this.renderert.handleHotRegionPressed(hotRegion.getName(), hotRegion.getBounds(), mouseEvent, this)) && !this.isInteraction()) {
                this.actionStarted(null);
                this.invalidate();
                this.repaint();
            }
        }
        finally {
            --this.eventInProcessRepaintLock;
        }
        this.handleDelayedRepaint(true);
    }

    @Override
    public final void handleHotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2) {
        block12: {
            if (!this.isFunctional() || this.renderert.getRoot() == null) {
                return;
            }
            ++this.eventInProcessRepaintLock;
            try {
                if (hotRegion.getName().equals("RESET")) {
                    TEvent tEvent = new TEvent();
                    tEvent.id = 66;
                    TEventDispatch.sendEvent(tEvent, null);
                    VisData visData = this.getVis();
                    if (!visData.isSelected()) {
                        visData.handleTEvent(tEvent, null, 0);
                    }
                    break block12;
                }
                if (hotRegion.getName().equals("DELETE_ROI")) {
                    VisData visData = VisData.getLastModified();
                    if (visData == null || visData.getView() == null) break block12;
                    try {
                        try {
                            ViewMouseHandler viewMouseHandler = (ViewMouseHandler)visData.getView().getMouseHandler();
                            viewMouseHandler.onROIDeleteAll(true);
                        }
                        catch (Exception exception) {
                            this.actionFinished();
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        this.actionFinished();
                        throw throwable;
                    }
                    this.actionFinished();
                    break block12;
                }
                if (this.layerOnHotRegionReleased(hotRegion, mouseEvent, n, n2) || this.renderert.handleHotRegionReleased(hotRegion.getName(), mouseEvent, n, n2, this)) {
                    this.actionFinished(null);
                }
            }
            finally {
                --this.eventInProcessRepaintLock;
            }
        }
        this.handleDelayedRepaint(true);
    }

    @Override
    public final void handleHotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
        Mapping mapping;
        if (!this.isFunctional() || this.renderert.getRoot() == null) {
            return;
        }
        ++this.eventInProcessRepaintLock;
        try {
            if (this.layerOnHotRegionDragged(hotRegion, mouseEvent, n, n2, n3, n4) || this.renderert.handleHotRegionDragged(hotRegion.getName(), mouseEvent, n, n2, n3, n4, this)) {
                this.invalidate();
                this.delayedRepaint |= 1;
            }
        }
        finally {
            --this.eventInProcessRepaintLock;
        }
        if (hotRegion.getName().equals("ZOOM") && (mapping = this.getMapping()) != null) {
            mapping.updateContent(this.getEvaluationContext(), false, false);
        }
        this.handleDelayedRepaint(true);
    }

    @Override
    public boolean wantsMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        if (!this.isFunctional() || this.renderert.getRoot() == null) {
            return false;
        }
        return this.renderert.wantsMouseWheelEvent(mouseWheelEvent);
    }

    @Override
    public boolean handleMouseWheel(MouseWheelEvent mouseWheelEvent) {
        if (!this.isFunctional() || this.renderert.getRoot() == null) {
            return false;
        }
        ++this.eventInProcessRepaintLock;
        try {
            if (this.renderert.handleMouseWheel(mouseWheelEvent, this)) {
                this.invalidate();
                this.delayedRepaint |= 1;
            }
        }
        finally {
            --this.eventInProcessRepaintLock;
        }
        this.handleDelayedRepaint(true);
        return true;
    }

    protected void handleDelayedRepaint(boolean bl) {
        if (this.eventInProcessRepaintLock > 0) {
            return;
        }
        if (this.delayedRepaint > 1) {
            this.delayedRepaint = 0;
            if (bl) {
                this.invalidate();
                this.repaint();
            }
            TEvent tEvent = new TEvent();
            tEvent.id = 81;
            tEvent.source = this;
            TEventDispatch.sendEvent(tEvent, null);
        }
        if (this.delayedRepaint > 0) {
            this.delayedRepaint = 0;
            if (bl) {
                this.invalidate();
                this.repaint();
            }
        }
    }

    @Override
    public void onCanvasSizeChanged(boolean bl) {
        if (!this.isFunctional()) {
            return;
        }
        this.refreshPresentationObjects();
        if (this.getMapping() != null) {
            this.getMapping().setSize(this.getcwidth(), this.getcheight(), null);
            this.updateMappingOnPaint = true;
            this.getMapping().updateContent(this.getEvaluationContext(), true, false);
        }
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder) {
        rGBBufferedImageHolder.imgInvalid |= this.imgInvalid;
        if (!rGBBufferedImageHolder.imgInvalid) {
            return;
        }
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        this.renderert.paint(rGBBufferedImageHolder, n, n2, rGBBufferedImageHolder.iofs, rGBBufferedImageHolder.stride, this.isPreviewRendering());
        if (this.updateMappingOnPaint && this.getMapping() != null) {
            this.updateMappingOnPaint = false;
            this.getMapping().updateContent(this.getEvaluationContext(), true, false);
        }
        this.paintOverlays(rGBBufferedImageHolder);
        this.imgInvalid = false;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isFunctional() {
        return this.renderert.getRoot() != null;
    }

    @Override
    public Color getBackground() {
        if (this.renderert.getPaintRoot() != null) {
            return this.renderert.getPaintRoot().getBackgroundColor();
        }
        return super.getBackground();
    }

    private ImageFilterNode getFilterNode(Renderer renderer) {
        if (renderer instanceof ImageFilterNode) {
            return (ImageFilterNode)renderer;
        }
        if (renderer instanceof IntermediateNode) {
            IntermediateNode intermediateNode = (IntermediateNode)renderer;
            for (Renderer renderer2 : intermediateNode.getChildren()) {
                ImageFilterNode imageFilterNode = this.getFilterNode(renderer2);
                if (imageFilterNode == null) continue;
                return imageFilterNode;
            }
        }
        return null;
    }

    public String getFilterName() {
        Renderer renderer = this.renderert.getRoot();
        ImageFilterNode imageFilterNode = this.getFilterNode(renderer);
        return imageFilterNode != null ? imageFilterNode.getFilterName() : null;
    }
}

