/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.AgeUtil;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.valuemapping.IValueMappingFactory;
import com.agfa.pacs.data.shared.valuemapping.IValueMappingProperties;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.config.ConfigUtils;
import com.agfa.pacs.impaxee.data.fetcher.FetcherUtils;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseSubModes;
import com.agfa.pacs.impaxee.presentationstate.IPresentationState;
import com.agfa.pacs.impaxee.valuemapping.ValueMappingProperties;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateSource;
import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameListener;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.RawDataContainer;
import com.tiani.gui.util.TIcon;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.FakePresentationState;
import com.tiani.jvision.image.FrameListenerAdapter;
import com.tiani.jvision.image.IEarlyEvent;
import com.tiani.jvision.image.ImgViewCCI;
import com.tiani.jvision.image.LayeredView;
import com.tiani.jvision.image.LossyFramePresentationState;
import com.tiani.jvision.image.ViewEventHandler;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.WindowHandlerNuk;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.image.fithandler.ViewportDefinition;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.LeftMarkerPolygonOverlay;
import com.tiani.jvision.overlay.LengthOverlay;
import com.tiani.jvision.overlay.Localizer;
import com.tiani.jvision.overlay.LocalizerHighlight;
import com.tiani.jvision.overlay.LocalizerLineOverlay;
import com.tiani.jvision.overlay.MagnifierOverlay;
import com.tiani.jvision.overlay.MagnifyingGlassOverlay2;
import com.tiani.jvision.overlay.MiniLocalizerOverlay;
import com.tiani.jvision.overlay.OrientationMapping2D;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.PictureInPictureOverlay;
import com.tiani.jvision.overlay.PictureInPictureOverlaySyncData;
import com.tiani.jvision.overlay.RightMarkerPolygonOverlay;
import com.tiani.jvision.overlay.RulerMapping;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.overlay.demographics.MappingFactory;
import com.tiani.jvision.overlay.localizer.ActiveLocalizerHandler;
import com.tiani.jvision.overlay.localizer.DisplayLocalizerInfo;
import com.tiani.jvision.overlay.localizer.LocalizerFactory;
import com.tiani.jvision.overlay.localizer.LocalizerManager;
import com.tiani.jvision.overlay.localizer.MiniLocalizerSyncData;
import com.tiani.jvision.overlay.provider.IOverlayProvider;
import com.tiani.jvision.overlay.provider.OverlayProviderFactory;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsAction;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.IntermediateNode;
import com.tiani.jvision.renderer.RDCRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.renderer.ResultCacheNode;
import com.tiani.jvision.toptoolbar.MagnifierAction;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.jvision.vis.VisHRSetDefault;
import com.tiani.jvision.vis.VisMouseHandler;
import com.tiani.util.expressions.EvaluationContext;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import org.dcm4che3.data.Attributes;

public class ImgView2
extends LayeredView
implements ImgViewCCI,
IFrameListener {
    private static final ALogger log = ALogger.getLogger(ImgView2.class);
    public static final EnumSet<IImageInformation.ImageClass> LOCALIZER_IMAGE_CLASSES = EnumSet.of(IImageInformation.ImageClass.CT, IImageInformation.ImageClass.MR, IImageInformation.ImageClass.OPT2D);
    private static final IFetcher fetcher = DataManager.getInstance().getFetcher();
    private static final String SELECTION_CONDITION = Config.impaxee.jvision.AUTO.SelectOnLoadCondition.get();
    private static PAction localizerMRDisplay = PActionRegistry.getAction("LOCALIZER_CALCULATION");
    private static final boolean SELECTED_BY_DEFAULT = SELECTION_CONDITION.equals("1==1");
    private static final TIcon videoIcon = new TIcon("/icons/VideoPlayPoster.gif");
    private static final TIcon USVolumeIcon = new TIcon("/icons/USVolumePoster.png");
    protected static final int ST_EMPTY = 0;
    protected static final int ST_POSTER = 1;
    protected static final int ST_COMPLETE = 4;
    protected static final int ST_DESTROYED = 5;
    protected static final int ST_FAILED = 6;
    protected int state = 0;
    protected RDCRenderer renderer;
    private Localizer topo;
    private PictureInPictureOverlay pip;
    protected MagnifierOverlay magnifyingGlass = null;
    private List<IEarlyEvent> earlyEvents = new ArrayList<IEarlyEvent>(5);
    private List<Object> earlyPayloads = new ArrayList<Object>(5);
    private volatile boolean frameAlreadyAdded = false;

    public ImgView2(IFrameObjectData iFrameObjectData) {
        super(iFrameObjectData);
        this.evaluationContext = new EvaluationContext(iFrameObjectData, this);
        this.addOverlay(new OrientationMapping2D(this));
        this.addOverlay(new RulerMapping(this));
        this.setSelectionDefault(iFrameObjectData, false);
    }

    @Override
    public void notifyHasError(String string) {
        this.state = 6;
        this.invalidate();
        if (this.vis != null && this.vis.isInView()) {
            this.repaint();
        }
    }

    protected ImgView2(IFrameObjectData iFrameObjectData, boolean bl) {
        super(iFrameObjectData);
        this.evaluationContext = new EvaluationContext(iFrameObjectData, this);
        this.addOverlay(new OrientationMapping2D(this));
        this.addOverlay(new RulerMapping(this));
        this.setSelectionDefault(iFrameObjectData, false);
    }

    protected void addData(IFrameObjectData iFrameObjectData) {
        if (iFrameObjectData.getRawDataContainer() != null) {
            if (DataManager.RETRIEVE_LOSSY && iFrameObjectData.isBeingLossyPrefetched()) {
                this.frameAvailable(iFrameObjectData, null);
                iFrameObjectData.addListener(this);
            } else {
                this.frameAvailable(iFrameObjectData, null);
            }
        } else {
            iFrameObjectData.addListener(this);
        }
    }

    public void addData(IFrameObjectData iFrameObjectData, String string) {
        if (iFrameObjectData.getRawDataContainer() != null) {
            this.frameAvailable(iFrameObjectData, string);
            return;
        }
        iFrameObjectData.addListener(new FrameListenerAdapter(string, this));
    }

    private void setSelectionDefault(IFrameObjectData iFrameObjectData, boolean bl) {
        boolean bl2 = SELECTED_BY_DEFAULT;
        if (!bl2) {
            bl2 = this.isSelectOnLoadAndHavingDisplay(iFrameObjectData);
        }
        if (this.vis != null) {
            this.vis.setSelected(bl2, bl);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void setVis(VisData visData) {
        super.setVis(visData);
        this.frameData = visData.getFrameData();
        this.addData(visData.getFrameData());
        this.setSelectionDefault(this.frameData, true);
    }

    @Override
    public void visSet(Vis2 vis2) {
        super.visSet(vis2);
        if (vis2 != null && this.magnifyingGlass != null) {
            int n = 0;
            int n2 = 0;
            if (vis2.getMouseHandler() != null && vis2.getMouseHandler().getMousePosition() != null) {
                n = vis2.getMouseHandler().getMousePosition().x;
                n2 = vis2.getMouseHandler().getMousePosition().y;
            }
            this.enableMagnifyingGlassInternal(n, n2);
        }
    }

    private boolean isSelectOnLoadAndHavingDisplay(IFrameObjectData iFrameObjectData) {
        return this.getDisplay() != null && ConfigUtils.evaluate(SELECTION_CONDITION, iFrameObjectData, Config.impaxee.jvision.AUTO.SelectOnLoadCondition.getKey());
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isFunctional() {
        if (this.frameData == null) {
            return false;
        }
        return this.state > 0;
    }

    public boolean canHaveLocalizer() {
        IImageInformation.ImageClass imageClass = this.getImageInformation().getImageClass();
        return LOCALIZER_IMAGE_CLASSES.contains((Object)imageClass);
    }

    public boolean isLocalizerEnabled() {
        return this.topo != null && this.topo.isVisible();
    }

    public void toggleMiniLocalizer() {
        Cloneable cloneable;
        Object object;
        if (this.topo == null) {
            object = new ActiveLocalizerHandler(this);
            cloneable = new Localizer((ActiveLocalizerHandler)object, this.getImageInformation(), this.getDisplayData().getDisplaySetID());
            cloneable.setVisible(false);
            this.activateLocalizer((Localizer)cloneable);
        }
        this.topo.setMiniLocalizer(!this.topo.isMiniLocalizer());
        object = new TEvent();
        ((TEvent)object).source = this;
        ((TEvent)object).id = 92;
        cloneable = null;
        try {
            cloneable = (Renderer)this.renderert.getPaintRoot().clone();
            cloneable = new ResultCacheNode((Renderer)cloneable);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            log.error("cannot clone renderer", (Throwable)cloneNotSupportedException);
        }
        MiniLocalizerSyncData miniLocalizerSyncData = new MiniLocalizerSyncData((Renderer)cloneable, this.topo);
        TEventDispatch.sendEvent((TEvent)object, (Object)miniLocalizerSyncData, TEventDispatch.SELECTED_VISUALS | TEventDispatch.ALL_DISPLAYS);
    }

    public void togglePictureInPicture() {
        TEvent tEvent = new TEvent();
        tEvent.source = this;
        tEvent.id = 119;
        PictureInPictureOverlaySyncData pictureInPictureOverlaySyncData = this.pip == null ? new PictureInPictureOverlaySyncData() : null;
        TEventDispatch.sendEvent(this.getDisplay(), tEvent, (Object)pictureInPictureOverlaySyncData, false);
    }

    public boolean isMiniLocalizerEnabled() {
        if (this.topo == null) {
            return false;
        }
        return this.topo.isMiniLocalizer();
    }

    protected BufferedImage getPoster() {
        Image image = null;
        UIDType uIDType = UIDUtilities.getBaseType((String)this.frameData.getSOPClassUID());
        if (uIDType == UIDType.Video) {
            image = videoIcon.getImage();
        } else if (uIDType == UIDType.USVolume) {
            image = USVolumeIcon.getImage();
        }
        if (image != null) {
            Image image2 = IconUtil.scaleImage((Image)image, (int)this.cwidth, (int)this.cheight);
            if (image2 instanceof BufferedImage) {
                return (BufferedImage)image2;
            }
            BufferedImage bufferedImage = new BufferedImage(image2.getWidth(null), image2.getHeight(null), 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image2, 0, 0, null);
            graphics.dispose();
            return bufferedImage;
        }
        return null;
    }

    protected void addToRendererTree(IFrameObjectData iFrameObjectData, boolean bl, String string) {
        this.renderer = RDCRenderer.createRenderer(iFrameObjectData, !bl, ZoomMode.NORMAL);
        if (this.renderer != null) {
            this.renderer.setNodeID(1);
            this.renderer.setBorderLockMode(false);
            this.renderert.setRoot(this.renderer, this);
        }
    }

    protected void initMapping(EvaluationContext evaluationContext) {
        Mapping mapping = MappingFactory.getMapping(evaluationContext, false);
        this.setMapping(mapping);
        this.addOverlay(mapping);
    }

    private void initInternal() {
        if (this.state == 6) {
            return;
        }
        try {
            if (this.getMapping() == null) {
                if (this.evaluationContext == null) {
                    log.error("evaluation context null");
                }
                this.initMapping(this.evaluationContext);
            } else {
                this.getMapping().updateContent(this.getEvaluationContext(), true, true);
            }
            this.getMapping().setSize(this.getcwidth(), this.getcheight(), super.getImageState());
            this.initLocalizer();
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    ImgView2.this.sendEarlyEvents();
                }
            });
        }
        catch (Exception exception) {
            log.error("Load failed", (Throwable)exception);
            this.state = 6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEarlyEvents() {
        ImgView2 imgView2 = this;
        synchronized (imgView2) {
            if (this.earlyEvents != null) {
                this.state = 4;
                if (this.earlyEvents.size() > 0) {
                    List<IEarlyEvent> list = this.earlyEvents;
                    List<Object> list2 = this.earlyPayloads;
                    this.earlyEvents = null;
                    this.earlyPayloads = null;
                    int n = 0;
                    ImgView2.setGlobalEnabled(false);
                    while (n < list.size()) {
                        try {
                            IEarlyEvent iEarlyEvent;
                            Object object = list2.get(n);
                            IEarlyEvent iEarlyEvent2 = list.get(n);
                            ++n;
                            if (iEarlyEvent2.isPresentationState()) {
                                iEarlyEvent = (EarlyPresentationState)iEarlyEvent2;
                                this.applyPresentationStateGeneral(iEarlyEvent.presState);
                                continue;
                            }
                            iEarlyEvent = (TEvent)iEarlyEvent2;
                            if (((TEvent)iEarlyEvent).id == 81) continue;
                            this.handleTEvent((TEvent)iEarlyEvent, object, 0);
                        }
                        catch (Exception exception) {
                            log.error("Error applying presentation state/early event.", (Throwable)exception);
                        }
                    }
                    ImgView2.setGlobalEnabled(true);
                } else {
                    this.earlyEvents = null;
                }
            } else {
                this.state = 4;
            }
            this.canvasSizeChanged();
            this.invalidate();
            if (this.vis != null && this.vis.isInView()) {
                this.repaint();
            }
            this.actionFinished(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean frameAvailable(IFrameObjectData iFrameObjectData, String string) {
        IPresentationState iPresentationState = null;
        IFramePresentationState iFramePresentationState = null;
        Object object = this;
        synchronized (object) {
            if (iFrameObjectData == this.frameData && this.frameAlreadyAdded) {
                if (!this.allowInstanceDataTwiceInRendererTree()) {
                    if (this.state < 4) {
                        this.initInternal();
                        return false;
                    }
                    if (this.renderer == null || this.renderer.getRawDataContainer() == null) {
                        return false;
                    }
                    if (FetcherUtils.isLossyPrefetchData(iFrameObjectData.getRawDataContainer().getPixelDataFrame())) {
                        return false;
                    }
                    iPresentationState = this.renderer.getPresentationState(this.cwidth, this.cheight);
                    iFramePresentationState = this.renderer.getCurrentFramePresentationState();
                }
            } else {
                this.frameAlreadyAdded = true;
            }
        }
        if (this.state == 5) {
            return true;
        }
        try {
            if (!iFrameObjectData.getImageInformation().containsRenderInformation()) {
                try {
                    log.debug("Fixing ImageInformation.");
                    iFrameObjectData.getImageInformation().reinit(iFrameObjectData.getMainFrame().getDicomObject());
                }
                catch (Exception exception) {
                    log.error("Error fixing ImageInformation.", (Throwable)exception);
                }
            }
            this.addToRendererTree(iFrameObjectData, iPresentationState != null, string);
            this.initValueMapping();
            this.initInternal();
            this.initOverlays();
            if (iPresentationState == null) return this.isInView();
            object = this.applyPresentationState(this.renderer, new LossyFramePresentationState(iPresentationState, iFramePresentationState, iFrameObjectData.getFramePresentationState()));
            Iterator iterator = object.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.invalidate();
                    if (!this.vis.isInView()) return this.isInView();
                    this.repaint();
                    return this.isInView();
                }
                Overlay overlay = (Overlay)iterator.next();
                this.addOverlay(overlay);
            }
        }
        catch (Exception exception) {
            log.error("Load failed", (Throwable)exception);
            this.state = 6;
            return true;
        }
    }

    private void initOverlays() {
        for (IOverlayProvider iOverlayProvider : OverlayProviderFactory.getInstance().getOverlayProviders()) {
            this.initOverlays(iOverlayProvider);
        }
    }

    private void initOverlays(IOverlayProvider iOverlayProvider) {
        Collection<Overlay> collection = iOverlayProvider.createOverlays(this);
        if (collection != null) {
            for (Overlay overlay : collection) {
                this.addOverlay(overlay);
            }
        }
    }

    protected void initValueMapping() {
        if (this.renderer != null) {
            this.renderer.initValueMappings(this.getDisplay());
        }
    }

    protected boolean allowInstanceDataTwiceInRendererTree() {
        return false;
    }

    private void applyPresentationStateGeneral(IFramePresentationStateSource iFramePresentationStateSource) {
        super.applyPresentationState(iFramePresentationStateSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyPresentationState(IFramePresentationStateSource iFramePresentationStateSource) {
        if (iFramePresentationStateSource != null) {
            if (this.state < 4) {
                ImgView2 imgView2 = this;
                synchronized (imgView2) {
                    if (this.state < 4) {
                        this.earlyEvents.add(new EarlyPresentationState(iFramePresentationStateSource));
                        this.earlyPayloads.add(null);
                    } else {
                        super.applyPresentationState(iFramePresentationStateSource);
                    }
                }
            } else {
                super.applyPresentationState(iFramePresentationStateSource);
            }
        }
    }

    @Override
    public boolean allowROIs() {
        return this.state == 4;
    }

    @Override
    public void loadFinal() {
        if (this.state >= 4) {
            return;
        }
        if (this.state < 4 && !this.frameData.isStartedBeingLoaded()) {
            fetcher.changeToHigherPriority(this.frameData, (byte)0);
        }
    }

    private void activateLocalizer(Localizer localizer) {
        this.addGlobalOverlay(localizer);
        LocalizerHighlight localizerHighlight = new LocalizerHighlight(localizer);
        localizer.setLocalizerHighlight(localizerHighlight);
        this.addGlobalOverlay(localizerHighlight);
        this.topo = localizer;
    }

    protected void initLocalizer() {
        IImageInformation iImageInformation = this.frameData.getImageInformation();
        ActiveLocalizerHandler activeLocalizerHandler = LocalizerFactory.getHandler(iImageInformation, this);
        try {
            if (activeLocalizerHandler != null) {
                Localizer localizer = new Localizer(activeLocalizerHandler, iImageInformation, this.getVis().getParent().getDisplaySetID());
                if (iImageInformation.getImageClass() == IImageInformation.ImageClass.MR && !localizerMRDisplay.isSelected()) {
                    localizer.setVisible(false);
                }
                this.activateLocalizer(localizer);
            }
        }
        catch (Exception exception) {
            log.warn("Incomplete or missing localizer data. Omitting.", (Throwable)exception);
        }
    }

    public boolean isFetchingFinal() {
        return this.state > 1;
    }

    public void paintPoster(Graphics graphics) {
        double d;
        if (this.state == 6) {
            this.paintFailed((Graphics2D)graphics, this.cwidth, this.cheight);
            return;
        }
        BufferedImage bufferedImage = this.getPoster();
        if (bufferedImage == null) {
            return;
        }
        double d2 = (double)bufferedImage.getWidth() / (double)this.cwidth;
        if (d2 > (d = (double)bufferedImage.getHeight() / (double)this.cheight)) {
            int n = (this.cheight - (int)((double)bufferedImage.getHeight() / d2)) / 2;
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, this.cwidth, n);
            graphics.fillRect(0, this.cheight - n, this.cwidth, n);
            graphics.drawImage(bufferedImage, 0, n, this.cwidth, (int)((double)bufferedImage.getHeight() / d2), null);
        } else {
            int n = (this.cwidth - (int)((double)bufferedImage.getWidth() / d)) / 2;
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, n, this.cheight);
            graphics.fillRect(this.cwidth - n, 0, n, this.cheight);
            graphics.drawImage(bufferedImage, n, 0, (int)((double)bufferedImage.getWidth() / d), this.cheight, null);
        }
    }

    private void paintFailed(Graphics2D graphics2D, int n, int n2) {
        double d;
        int n3;
        graphics2D.setColor(Color.black);
        graphics2D.fillRect(0, 0, n, n2);
        int n4 = n3 = Math.min(n, n2);
        if (n3 > 256) {
            d = (double)n3 / 256.0;
            n3 = 256;
            n4 = (int)((double)n4 / d);
        }
        if (n4 > 256) {
            d = (double)n4 / 256.0;
            n4 = 256;
            n3 = (int)((double)n3 / d);
        }
        int n5 = (n - n3) / 2;
        int n6 = (n2 - n4) / 2;
        graphics2D.drawImage(failIcon, n5, n6, n3, n4, null);
    }

    private void paintFailed(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2) {
        this.paintFailed(rGBBufferedImageHolder.graphics, n, n2);
    }

    private void reinitFrame() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ImgView2.this.state < 4) {
                    ImgView2.this.frameAvailable(ImgView2.this.frameData, null);
                    log.error("STATE: " + ImgView2.this.state);
                    ImgView2.this.invalidate();
                    ImgView2.this.repaint();
                }
            }
        });
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder) {
        if (this.state < 4 && this.frameData.getRawDataContainer() != null) {
            EventUtil.invokeSynchronous((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ImgView2.this.state < 4) {
                        ImgView2.this.reinitFrame();
                    }
                }
            });
        }
        if (this.state == 6) {
            this.paintFailed(rGBBufferedImageHolder, this.cwidth, this.cheight);
            return;
        }
        if (this.state < 4) {
            return;
        }
        if (this.state == 0 || this.renderert.getRoot() == null) {
            return;
        }
        rGBBufferedImageHolder.imgInvalid |= this.imgInvalid;
        super.paint(rGBBufferedImageHolder);
        if (this.isLocalizerEnabled()) {
            int n = this.cwidth / 2 - 5;
            int n2 = this.cheight - 18;
            rGBBufferedImageHolder.graphics.setColor(OverlayConfig.mappingColor);
            rGBBufferedImageHolder.graphics.drawLine(n, n2, n + 10, n2 + 10);
            rGBBufferedImageHolder.graphics.drawLine(n, n2 + 4, n + 10, n2 + 14);
            rGBBufferedImageHolder.graphics.drawLine(n, n2 + 8, n + 10, n2 + 18);
        }
        this.imgInvalid = false;
    }

    @Override
    public void cleanUp() {
        this.state = 5;
        super.cleanUp();
        this.renderer = null;
        this.topo = null;
        this.pip = null;
    }

    @Override
    public void actionStarted(ViewEventHandler viewEventHandler) {
        super.actionStarted(viewEventHandler);
    }

    @Override
    public void actionFinished(ViewEventHandler viewEventHandler) {
        if (this.magnifyingGlass != null) {
            MagnifierOverlay magnifierOverlay = this.magnifyingGlass;
            this.magnifyingGlass = null;
            HashSet<Overlay> hashSet = new HashSet<Overlay>();
            hashSet.add(magnifierOverlay);
            this.lockBackground(true, hashSet);
            this.magnifyingGlass = magnifierOverlay;
            return;
        }
        super.actionFinished(viewEventHandler);
    }

    @Override
    public void onCanvasSizeChanged(boolean bl) {
        int n = this.getcwidth();
        int n2 = this.getcheight();
        if (this.state <= 1 || this.state > 4) {
            if (this.state == 1 && this.getMapping() != null) {
                this.getMapping().setSize(n, n2, null);
            }
            return;
        }
        try {
            if (this.getMapping() != null) {
                this.getMapping().setSize(n, n2, null);
            }
            this.updateMappingOnPaint = true;
            if (this.topo != null) {
                this.topo.setSize(n, n2, this.renderert.getImageState());
            }
            if (this.pip != null) {
                this.pip.getRendererRef().invalidate();
            }
            this.refreshPresentationObjects();
            this.invalidate();
        }
        catch (Exception exception) {
            log.error("ex in state " + this.state, (Throwable)exception);
        }
    }

    @Override
    public ImageState getImageState() {
        if (this.state < 4) {
            return ImageState.getDefaultImageState();
        }
        return this.renderert.getImageState();
    }

    @Override
    public RawDataContainer getRawDataContainer() {
        return this.frameData.getRawDataContainer();
    }

    @Override
    public List<PAction> getMenuEntries() {
        List<PAction> list = super.getMenuEntries();
        List<Overlay> list2 = this.getOverlays();
        for (Overlay overlay : list2) {
            StatisticsPresentationObject statisticsPresentationObject;
            if (!(overlay instanceof StatisticsPresentationObject) || !(statisticsPresentationObject = (StatisticsPresentationObject)overlay).supportsHistogram()) continue;
            list = new ArrayList<PAction>(list);
            list.add(new OverlayStatisticsAction());
            break;
        }
        return list;
    }

    @Override
    public boolean onEnterView() {
        boolean bl = super.onEnterView();
        if (bl) {
            if (MagnifierAction.isMagnifierEnabled()) {
                this.enableMagnifyingGlass();
            }
            if (this.topo != null) {
                LocalizerManager.notifyLocalizersOfView(this);
            }
        }
        return bl;
    }

    @Override
    public void onExitView() {
        super.onExitView();
        if (this.isMagnifierOn()) {
            this.disableMagnifyingGlass(true);
        }
        if (this.topo != null) {
            this.topo.exitView();
        }
    }

    @Override
    public String getVisualType() {
        return "IMAGE";
    }

    @Override
    public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2) {
        if (this.renderert.getEventRoot() != null) {
            return this.renderert.getEventRoot().getHRSet(visHRSet, vis2, this);
        }
        if (visHRSet != null && visHRSet.getType().equals("DEF")) {
            return visHRSet;
        }
        return new VisHRSetDefault(vis2);
    }

    @Override
    public Renderer getRenderer() {
        return this.renderert.getRoot();
    }

    public void localizerHandleUpdate(VisDisplayData visDisplayData, DisplayLocalizerInfo.ParallelityCheckResult parallelityCheckResult) {
        if (this.topo != null) {
            this.topo.handleUpdate(visDisplayData, parallelityCheckResult, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTEvent(TEvent tEvent, Object object, int n) {
        Cloneable cloneable;
        if (this.state < 4) {
            if (tEvent.interactionModifier == 2) {
                cloneable = this;
                synchronized (cloneable) {
                    if (this.state < 4) {
                        if (tEvent.id != 21) {
                            this.earlyEvents.add(tEvent);
                            this.earlyPayloads.add(object);
                        }
                        return;
                    }
                }
            } else {
                return;
            }
        }
        if (this.state > 4) {
            return;
        }
        switch (tEvent.id) {
            case 107: {
                if (!this.hasColorPalette()) break;
                cloneable = this.renderer.getCurrentFramePresentationState();
                Boolean bl = (Boolean)object;
                cloneable.setForceLUT(bl);
                this.applyPresentationState(this.renderer, (IFramePresentationState)cloneable);
                this.invalidate();
                this.repaint();
                break;
            }
            case 116: {
                this.setLocalizer((Localizer.LocalizerState)((Object)object));
                break;
            }
            case 92: {
                cloneable = ((MiniLocalizerSyncData)object).localizer;
                LocalizerLineOverlay localizerLineOverlay = ((Localizer)cloneable).getImageRepresentation(this.frameData.getImageInformation());
                if (localizerLineOverlay != null) {
                    if (((Localizer)cloneable).isMiniLocalizer()) {
                        Cloneable cloneable2;
                        MiniLocalizerSyncData miniLocalizerSyncData = LocalizerManager.getMiniLocalizerSyncData(this.getDisplay(), (MiniLocalizerSyncData)object);
                        if (miniLocalizerSyncData.renderer == null && miniLocalizerSyncData.localizer.getView() instanceof LayeredView) {
                            cloneable2 = null;
                            LayeredView layeredView = (LayeredView)miniLocalizerSyncData.localizer.getView();
                            try {
                                cloneable2 = (Renderer)layeredView.renderert.getPaintRoot().clone();
                                cloneable2 = new ResultCacheNode((Renderer)cloneable2);
                            }
                            catch (CloneNotSupportedException cloneNotSupportedException) {
                                log.error("cannot clone renderer", (Throwable)cloneNotSupportedException);
                            }
                            miniLocalizerSyncData.renderer = cloneable2;
                        }
                        cloneable2 = new MiniLocalizerOverlay(miniLocalizerSyncData, localizerLineOverlay);
                        this.addGlobalOverlay((Overlay)cloneable2, 0);
                    } else {
                        for (MiniLocalizerOverlay miniLocalizerOverlay : Overlay.filter(MiniLocalizerOverlay.class, super.getOverlays())) {
                            if (((MiniLocalizerSyncData)object).localizer != miniLocalizerOverlay.getSync().localizer) continue;
                            this.removeOverlay(miniLocalizerOverlay);
                        }
                    }
                }
                this.invalidate();
                this.repaint();
                break;
            }
            case 119: {
                if (object != null) {
                    try {
                        RDCRenderer rDCRenderer = ((RDCRenderer)this.getLeafRDC()).clone();
                        rDCRenderer.getAreaFitHandler().setZoomFactor(1.0);
                        rDCRenderer.getAreaFitHandler().setViewportCenterAlignmentX(AreaFitHandler.ViewportCenterAlignmentX.CENTER);
                        ImageDef imageDef = rDCRenderer.getActiveImageDef();
                        imageDef.resetTransformedViewportCenter();
                        this.pip = new PictureInPictureOverlay(rDCRenderer, this, (PictureInPictureOverlaySyncData)object);
                        this.addGlobalOverlay(this.pip);
                        EventUtil.invoke((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ImgView2.this.pip.getRendererRef().invalidate();
                                ImgView2.this.repaint();
                            }
                        });
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                } else {
                    this.removeOverlay(this.pip);
                    this.pip = null;
                }
                this.invalidate();
                this.repaint();
                break;
            }
            case 95: {
                SpacingDef spacingDef = (SpacingDef)object;
                if (!this.getImageState().spacingDefs().contains(spacingDef)) break;
                this.getImageState().pixelSizeX = spacingDef.getDataPixelSizeX();
                this.getImageState().pixelSizeY = spacingDef.getDataPixelSizeY();
                this.resetOverlayCachedValues();
                this.getImageState().updated();
                RGBBufferedImageHolder rGBBufferedImageHolder = this.getImageReference();
                if (rGBBufferedImageHolder != null) {
                    this.paintOverlays(rGBBufferedImageHolder);
                }
                if (this.getRenderer() != null) {
                    this.getRenderer().handleTEvent(tEvent, object, n, this);
                }
                this.getImageState().updated();
                this.refresh();
                this.invalidate();
                this.repaint();
                break;
            }
            case 120: {
                RDCRenderer rDCRenderer = this.renderer;
                if (rDCRenderer == null) break;
                this.getImageState().setCurrentValueMapping(((IValueMappingFactory)object).createValueMapping((IValueMappingProperties)new ValueMappingProperties(rDCRenderer)));
                this.resetOverlayCachedValues();
                this.getImageState().updated();
                RGBBufferedImageHolder rGBBufferedImageHolder = this.getImageReference();
                if (rGBBufferedImageHolder != null) {
                    this.paintOverlays(rGBBufferedImageHolder);
                }
                this.getImageState().updated();
                if (this.isInView()) {
                    this.refresh();
                }
                this.invalidate();
                this.repaint();
                break;
            }
            case 135: {
                this.initOverlays((IOverlayProvider)object);
                this.invalidate();
                this.repaint();
                break;
            }
            default: {
                if (this.magnifyingGlass != null && this.magnifyingGlass.handleTEvent(tEvent, object, n, this)) {
                    return;
                }
                if (this.pip != null) {
                    this.pip.propagateTEvent(tEvent, object, n, this);
                }
                if (object instanceof ViewportDefinition) {
                    ((ViewportDefinition)object).cwidth = this.getcwidth();
                    ((ViewportDefinition)object).cheight = this.getcheight();
                }
                super.handleTEvent(tEvent, object, n);
            }
        }
    }

    public void setLocalizer(Localizer.LocalizerState localizerState) {
        VisDisplayData visDisplayData = this.getDisplayData();
        if (this.topo != null) {
            if (this.topo.isVisible() != localizerState.isVisible()) {
                this.topo.setVisible(localizerState.isVisible());
            }
        } else if (localizerState.isForced() && visDisplayData != null) {
            ActiveLocalizerHandler activeLocalizerHandler = new ActiveLocalizerHandler(this);
            Localizer localizer = new Localizer(activeLocalizerHandler, this.getImageInformation(), visDisplayData.getDisplaySetID());
            if (localizerState == Localizer.LocalizerState.ForceOn && this.getImageInformation().getImageClass() == IImageInformation.ImageClass.MR && !localizerMRDisplay.isSelected()) {
                localizer.setVisible(false);
            }
            this.activateLocalizer(localizer);
        }
        this.invalidate();
        if (this.isInView()) {
            this.repaint();
        }
    }

    @Override
    public int[] getImageCoordsAtScreenPosition(int n, int n2) {
        double[] dArray = new double[]{n, n2};
        double[] dArray2 = new double[2];
        this.getImageState().screenToImage(dArray, dArray2, null);
        int n3 = (int)dArray2[0] + 1;
        int n4 = (int)dArray2[1] + 1;
        return new int[]{n3, n4};
    }

    public String getWindowNukMaxAsString() {
        if (this.getWindowHandler() instanceof WindowHandlerNuk) {
            return this.getPercentageOfMaxString(this.getWindowHandler(), this.getWindowHandler().getCenter() + this.getWindowHandler().getWidth() / 2.0);
        }
        return null;
    }

    public String getWindowNukMinAsString() {
        if (this.getWindowHandler() instanceof WindowHandlerNuk) {
            return this.getPercentageOfMaxString(this.getWindowHandler(), this.getWindowHandler().getCenter() - this.getWindowHandler().getWidth() / 2.0);
        }
        return null;
    }

    private String getPercentageOfMaxString(WindowHandlerBase windowHandlerBase, double d) {
        DecimalFormat decimalFormat = new DecimalFormat("#0.0");
        double d2 = this.renderer.getRawDataContainer().getHistogram().getMax();
        double d3 = windowHandlerBase.dataToLogical(d2);
        double d4 = 100.0 * d / d3;
        return d4 >= 0.0 ? String.valueOf(decimalFormat.format(d4)) : "-";
    }

    private Double getZoomFactor() {
        IRDCRenderer iRDCRenderer = this.getLeafRDC();
        double d = iRDCRenderer.getAreaFitHandler().getAbsoluteZoomFactor();
        if (Double.isNaN(d)) {
            return null;
        }
        return d;
    }

    private String calculatePatientAge() {
        Attributes attributes = this.getImageInformation().getDataset();
        Date date = DateTimeUtils.getStudyDateTime((Attributes)attributes);
        Date date2 = attributes.getDate(0x100030);
        if (date != null && date2 != null) {
            return AgeUtil.getAgeLocalized((Date)date2, (Date)date);
        }
        if (attributes.containsValue(0x101010)) {
            return attributes.getString(0x101010);
        }
        return null;
    }

    @Override
    public Object resolveString(String string) {
        WindowHandlerBase windowHandlerBase = this.getWindowHandler();
        if (windowHandlerBase != null) {
            if (string.equals("WINDOW_CENTER")) {
                return windowHandlerBase.getCenter();
            }
            if (string.equals("WINDOW_WIDTH")) {
                return windowHandlerBase.getWidth();
            }
            if (string.equals("WINDOW_NUK_MAX")) {
                return this.getWindowNukMaxAsString();
            }
            if (string.equals("WINDOW_NUK_MIN")) {
                return this.getWindowNukMinAsString();
            }
            if (string.equals("MPI_ID")) {
                return Base.determineMPI_ID((Attributes)this.getImageInformation().getDataset());
            }
            if (string.equals("PATIENT_AGE")) {
                String string2 = this.calculatePatientAge();
                if (string2 != null) {
                    return string2;
                }
                return null;
            }
            if (string.equals("DISPLAY_SET_TYPE")) {
                try {
                    return this.getDisplayData().getDisplaySet().getDisplaySetType().getValue();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        if (string.equals("ZOOM_FACTOR")) {
            return this.getZoomFactor();
        }
        if (string.equals("CURRENT_STUDY")) {
            boolean bl = false;
            IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
            if (iHanging != null && this.getFrameData().getParent().getParent() == iHanging.getStudyContainer().getBaseStudy()) {
                bl = true;
            }
            if (bl) {
                return " ";
            }
            return null;
        }
        return super.resolveString(string);
    }

    @Override
    public boolean handleMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 503: {
                if (this.magnifyingGlass == null) break;
                this.magnifyingGlass.setLocation(mouseEvent.getX(), mouseEvent.getY());
                this.repaint();
                return false;
            }
            case 505: {
                if (this.magnifyingGlass == null) break;
                this.disableMagnifyingGlass();
                break;
            }
            case 504: {
                if (!MagnifierAction.isMagnifierEnabled()) break;
                this.enableMagnifyingGlassInternal(mouseEvent.getX(), mouseEvent.getY());
            }
        }
        return super.handleMouseEvent(mouseEvent);
    }

    @Override
    public boolean addingHRsAllowed() {
        return this.magnifyingGlass == null;
    }

    public void enableMagnifyingGlass() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, this.getVisView());
        this.enableMagnifyingGlassInternal(point.x, point.y);
    }

    protected void enableMagnifyingGlassInternal(int n, int n2) {
        if (this.renderert.getPaintRoot() == null) {
            return;
        }
        if (this.isCursorInView()) {
            PActionRegistry.getAction("MOUSE_MODE_NORMAL").perform(null);
            if (this.magnifyingGlass == null) {
                try {
                    this.magnifyingGlass = new MagnifyingGlassOverlay2(this.renderert.getPaintRoot(), this.renderert.cloneTree());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    log.error("Unable to create MagnifyingGlass for renderertree", (Throwable)cloneNotSupportedException);
                    return;
                }
                this.addOverlay(this.magnifyingGlass);
                this.magnifyingGlass.setOwner(this);
            }
            Image image = new ImageIcon("").getImage();
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "invisible");
            VisMouseHandler visMouseHandler = this.getVis().getVisual().getMouseHandler();
            visMouseHandler.setCursor(cursor);
            visMouseHandler.enableDensityToolTipText(false);
            HashSet<Overlay> hashSet = new HashSet<Overlay>();
            hashSet.add(this.magnifyingGlass);
            this.getVis().getVisual().removeHRs();
            this.lockBackground(false);
            this.lockBackground(true, hashSet);
            this.magnifyingGlass.setLocation(n - 1, n2 - 1);
            this.repaint();
            this.magnifyingGlass.setLocation(n, n2);
            this.repaint();
        }
    }

    public void disableMagnifyingGlass() {
        this.disableMagnifyingGlass(false);
    }

    private void disableMagnifyingGlass(boolean bl) {
        if (!bl || this.isCursorInView()) {
            try {
                if (this.getDisplayData() != null) {
                    Cursor cursor = this.getDisplayData().getDisplayPlugin().getMouseModeInfo().getCursor(this.getVis().getVisual());
                    VisMouseHandler visMouseHandler = this.getVis().getVisual().getMouseHandler();
                    visMouseHandler.setCursor(cursor);
                    visMouseHandler.enableDensityToolTipText(Config.impaxee.jvision.DISPLAY.DensityValueTooltip.get());
                }
            }
            catch (Exception exception) {
                log.warn("Error on magnifier disable", (Throwable)exception);
            }
            this.removeOverlay(this.magnifyingGlass);
            this.magnifyingGlass = null;
            this.canvasSizeChanged();
            this.actionFinished(null);
            this.lockBackground(false);
            if (this.getVis() != null) {
                this.getVis().getVisual().addHRs();
            }
            this.repaint();
        }
    }

    private boolean isCursorInView() {
        if (this.getVisView() == null) {
            return false;
        }
        Point point = MouseInfo.getPointerInfo().getLocation();
        Point point2 = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point2, this.getVisView());
        Rectangle rectangle = new Rectangle(point2, this.getVisView().getBounds().getSize());
        return rectangle.contains(point);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = this.getBounds().width;
        int n6 = this.getBounds().height;
        super.setBounds(n, n2, n3, n4);
        if ((n5 != this.getBounds().width || n6 != this.getBounds().height) && this.magnifyingGlass != null) {
            MagnifierOverlay magnifierOverlay = this.magnifyingGlass;
            this.magnifyingGlass = null;
            this.lockBackground(false);
            HashSet<Overlay> hashSet = new HashSet<Overlay>();
            hashSet.add(magnifierOverlay);
            this.lockBackground(true, hashSet);
            this.magnifyingGlass = magnifierOverlay;
            return;
        }
    }

    @Override
    public void applyLUT() {
        this.invalidate();
        this.repaint();
    }

    /*
     * Unable to fully structure code
     */
    protected IRDCRenderer getLeafRDC() {
        if (this.renderert == null) {
            return null;
        }
        var1_1 = this.renderert.getPaintRoot();
        if (!(var1_1 instanceof IRDCRenderer)) ** GOTO lbl7
        return (IRDCRenderer)var1_1;
lbl-1000:
        // 1 sources

        {
            var1_1 = ((IntermediateNode)var1_1).getChildren().get(0);
lbl7:
            // 2 sources

            ** while (var1_1 instanceof IntermediateNode)
        }
lbl8:
        // 1 sources

        if (var1_1 instanceof IRDCRenderer) {
            return (IRDCRenderer)var1_1;
        }
        return null;
    }

    @Override
    public WindowHandlerBase getWindowHandler() {
        IRDCRenderer iRDCRenderer;
        if (this.renderert != null && (iRDCRenderer = this.getLeafRDC()) != null) {
            return iRDCRenderer.getWindowHandler();
        }
        return null;
    }

    public void setCalibration(double d, LengthOverlay lengthOverlay) {
        this.getImageState().updated();
        TEvent tEvent = new TEvent();
        tEvent.id = 65;
        tEvent.source = null;
        tEvent.destinationNodeID = 0;
        double d2 = d;
        double[] dArray = lengthOverlay.getXCoordinates();
        double[] dArray2 = lengthOverlay.getYCoordinates();
        double d3 = dArray[1] - dArray[0];
        double d4 = dArray2[1] - dArray2[0];
        this.renderert.handleTEvent(tEvent, new Point3d(d3, d4, d2), 0, this);
        this.onCanvasSizeChanged(true);
        this.resetOverlayCachedValues();
        this.invalidate();
        this.repaint();
        this.getRenderer().paintOverlays(this.getImageReference(), null, false);
        this.paintOverlays(this.getImageReference());
    }

    @Override
    public void addOverlay(Overlay overlay) {
        super.addOverlay(overlay);
        if (overlay instanceof LeftMarkerPolygonOverlay || overlay instanceof RightMarkerPolygonOverlay) {
            this.getDisplay().getData().getDisplayPlugin().getMouseModeInfo().setSubMode(MouseSubModes.DEFAULT);
        }
    }

    @Override
    public void removeOverlay(Overlay overlay) {
        super.removeOverlay(overlay);
        if (overlay == this.pip) {
            this.pip = null;
        }
    }

    public boolean isMagnifierOn() {
        return this.magnifyingGlass != null;
    }

    public MagnifierOverlay getMagnifier() {
        return this.magnifyingGlass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFramePresentationState getCurrentFramePresentationState() {
        if (this.renderer == null) {
            ImgView2 imgView2 = this;
            synchronized (imgView2) {
                if (this.earlyEvents != null) {
                    for (IEarlyEvent iEarlyEvent : this.earlyEvents) {
                        if (!iEarlyEvent.isPresentationState()) continue;
                        return new FakePresentationState(((EarlyPresentationState)iEarlyEvent).presState, this.frameData.getSOPInstanceUID(), this.frameData.getFrameNumber());
                    }
                }
            }
            return null;
        }
        return this.renderer.getCurrentFramePresentationState();
    }

    public boolean hasColorPalette() {
        if (this.renderer == null) {
            return false;
        }
        return this.renderer.getImageInformation().hasColorPaletteLUT();
    }

    @Override
    public synchronized IVOILUT createVOILUTForHijackedPresentationState(boolean bl, IPixelDataFrame<?> iPixelDataFrame) {
        IImageInformation iImageInformation;
        if (this.state == 4) {
            IPresentationState iPresentationState;
            if (this.renderer != null && (iPresentationState = this.renderer.getPresentationState()) != null) {
                return iPresentationState.getVOILUT(bl);
            }
            log.error("Runtime inconsitency");
            return null;
        }
        IImageInformation iImageInformation2 = iImageInformation = this.frameData.getImageInformation();
        for (IEarlyEvent object2 : this.earlyEvents) {
            if (!object2.isPresentationState()) continue;
            iImageInformation2 = ((EarlyPresentationState)object2).presState.getFramePresentationState(iImageInformation.getSOPInstanceUID(), this.getFrameData().getDicomObject(), this.frameData.getFrameNumber(), iPixelDataFrame);
            break;
        }
        WindowHandlerBase windowHandlerBase = WindowHandlerBase.getInstance(iImageInformation, iImageInformation2, iImageInformation.isInverse(), iImageInformation.isSigned(), null);
        int n = 0;
        while (n < this.earlyEvents.size()) {
            if (!this.earlyEvents.get(n).isPresentationState()) {
                TEvent tEvent = (TEvent)this.earlyEvents.get(n);
                int n2 = tEvent.id;
                if (n2 == 62 || n2 == 63 || n2 == 64) {
                    windowHandlerBase.handleTEvent(tEvent, this.earlyPayloads.get(n), 0, this);
                }
            }
            ++n;
        }
        return windowHandlerBase.getVOILUTForPresentationState(bl);
    }

    public boolean isComplete() {
        return this.state == 4;
    }

    private static class EarlyPresentationState
    implements IEarlyEvent {
        public final IFramePresentationStateSource presState;

        EarlyPresentationState(IFramePresentationStateSource iFramePresentationStateSource) {
            this.presState = iFramePresentationStateSource;
        }

        @Override
        public boolean isPresentationState() {
            return true;
        }
    }
}

