/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.impaxee.gsts.GrayScaleTransformationSequence;
import com.agfa.pacs.impaxee.gsts.ILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PaletteColorLUTModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.TianiPaletteColorLUTModule;
import com.agfa.pacs.listtext.dicomobject.presentation.ILUTContainer;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.WindowDef;
import com.tiani.jvision.image.WindowTransferFunction;
import com.tiani.jvision.tf.function.ControlHandle;
import com.tiani.jvision.tf.function.TransferFunction;
import com.tiani.jvision.tf.function.TransferFunctionFactory;
import com.tiani.util.TicketOffice;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Iterator;
import org.dcm4che3.data.Attributes;

public class GeneralWindowTransferFunction
extends WindowTransferFunction
implements Serializable {
    private static final long serialVersionUID = -809283826003587180L;
    private TransferFunction transferFunction;
    private boolean windowModified = false;

    public GeneralWindowTransferFunction(ILUTContainer iLUTContainer, int n, boolean bl, boolean bl2) {
        this(iLUTContainer, iLUTContainer, n, bl, bl2, false);
    }

    public GeneralWindowTransferFunction(ILUTContainer iLUTContainer, ILUTContainer iLUTContainer2, int n, boolean bl, boolean bl2, boolean bl3) {
        this.gsts = new GrayScaleTransformationSequence(iLUTContainer, n, bl, bl2);
        this.transferFunction = TransferFunctionFactory.createTransferFunction(iLUTContainer2.getPaletteColorLUT());
        this.gsts.setInversion(this.transferFunction.isInverted());
        this.setInverted(this.transferFunction.isInverted());
        if (iLUTContainer2 != iLUTContainer) {
            if (iLUTContainer2.getVOILUT() != null && iLUTContainer2.getVOILUT().hasWindow() && bl3) {
                WindowDef windowDef = new WindowDef(iLUTContainer2, n, bl2);
                this.gsts.getWindowDef().setCenter(windowDef.getCenter());
                this.gsts.getWindowDef().setWidth(windowDef.getWidth());
            } else {
                int n2 = this.transferFunction.getMaxPosition();
                int n3 = this.transferFunction.getMinPosition();
                this.gsts.getWindowDef().setCenter((double)(n2 + n3) / 2.0);
                this.gsts.getWindowDef().setWidth(n2 - n3);
            }
            this.setWindow(this.gsts.getWindowDef());
        }
        this.makeLut(this.transferFunction.getArgbLut(), this.transferFunction.getOffset());
    }

    public GeneralWindowTransferFunction(GeneralWindowTransferFunction generalWindowTransferFunction) {
        if (this.rgb == null || this.rgb.length != generalWindowTransferFunction.rgb.length) {
            this.rgb = new int[generalWindowTransferFunction.rgb.length];
        }
        System.arraycopy(generalWindowTransferFunction.rgb, 0, this.rgb, 0, this.rgb.length);
        this.transferFunction = generalWindowTransferFunction.transferFunction.clone();
        this.gsts = new GrayScaleTransformationSequence(generalWindowTransferFunction.gsts);
    }

    public GeneralWindowTransferFunction(TransferFunction transferFunction, ILUTContainer iLUTContainer, int n, boolean bl) {
        boolean bl2 = false;
        if (iLUTContainer instanceof IImageInformation) {
            bl2 = ((IImageInformation)iLUTContainer).isInverse();
        }
        this.gsts = new GrayScaleTransformationSequence(iLUTContainer, n, bl2, bl);
        if (!bl2) {
            this.gsts.setInversion(transferFunction.isInverted());
        }
        this.setInverted(transferFunction.isInverted());
        this.transferFunction = transferFunction;
        this.makeLut(transferFunction.getArgbLut(), transferFunction.getOffset());
    }

    public String getUID() {
        return this.transferFunction.getInstanceUID();
    }

    @Override
    public int getGrays() {
        return this.gsts.getWindowDef().getGrays();
    }

    public void setModified(boolean bl) {
        this.windowModified = bl;
    }

    @Override
    public void setWindow(WindowDef windowDef) {
        this.gsts.setWindow(windowDef);
        this.scaleTransferFunction(windowDef);
    }

    private void scaleTransferFunction(WindowDef windowDef) {
        this.transferFunction.scale((int)(windowDef.getCenter() + 0.5), (int)(windowDef.getWidth() + 0.5));
        this.windowModified = true;
        this.tusi = (int)TicketOffice.getNewStamp();
    }

    public void scaleToCurrentWindow() {
        this.scaleTransferFunction(this.getWindowDef());
    }

    @Override
    public GrayScaleTransformationSequence getGSTS() {
        return this.gsts;
    }

    public TransferFunction getFunction() {
        return this.transferFunction;
    }

    @Override
    public int[] getRGB(boolean bl) {
        if (this.windowModified) {
            this.makeLut(this.transferFunction.getArgbLut(), this.transferFunction.getOffset());
            this.windowModified = false;
        }
        return this.rgb;
    }

    @Override
    public int getMinimumRampColor() {
        if (this.windowModified) {
            this.makeLut(this.transferFunction.getArgbLut(), this.transferFunction.getOffset());
            this.windowModified = false;
        }
        if (this.rgb != null && this.rgb.length > 0) {
            return this.rgb[0];
        }
        return super.getMinimumRampColor();
    }

    public void set(TransferFunction transferFunction) {
        this.transferFunction = transferFunction;
        this.gsts.setInversion(transferFunction.isInverted());
        this.setInverted(transferFunction.isInverted());
        this.windowModified = true;
        this.tusi = (int)TicketOffice.getNewStamp();
    }

    @Override
    public int getUpdateID() {
        return this.tusi;
    }

    private void makeLut(int[] nArray, int n) {
        int n2;
        int n3;
        WindowDef windowDef = this.gsts.getWindowDef();
        int n4 = -this.gsts.getOffset();
        int n5 = windowDef.getGrays() - this.gsts.getOffset();
        int n6 = n5 - n4;
        int n7 = n;
        int n8 = nArray.length;
        int n9 = n7 + n8;
        int n10 = (int)windowDef.logicalToData(n7);
        int n11 = (int)windowDef.logicalToData(n9);
        if (n10 > n5) {
            n10 = n5;
        }
        if (n11 > n5) {
            n11 = n5;
        }
        if (this.rgb == null || this.rgb.length != n6) {
            this.rgb = new int[n6];
        }
        if (n4 < n10) {
            n3 = n4;
            while (n3 < n10) {
                this.rgb[n3 - n4] = nArray[0];
                ++n3;
            }
        }
        if (n5 > n11) {
            n3 = n11;
            while (n3 < n5) {
                this.rgb[n3 - n4] = nArray[nArray.length - 1];
                ++n3;
            }
        }
        n3 = Math.min(n11, n5);
        double d = windowDef.dataToLogical(n10) - (double)n;
        double d2 = windowDef.dataToLogical(n3) - (double)n;
        double d3 = d2 - d;
        double d4 = n3 - n10;
        int n12 = n2 = Math.max(n10, n4);
        while (n12 < n3) {
            int n13 = (int)(d + d3 * (double)(n12 - n10) / d4);
            this.rgb[n12 - n4] = n13 < 0 ? nArray[0] : (n13 >= nArray.length ? nArray[nArray.length - 1] : nArray[n13]);
            ++n12;
        }
        if (this.isInverted()) {
            n12 = 0;
            while (n12 < this.rgb.length) {
                int n14 = n12++;
                this.rgb[n14] = this.rgb[n14] ^ 0xFFFFFF;
            }
        }
        this.applyPresentationLut();
    }

    private void applyPresentationLut() {
        ILUT iLUT = this.gsts.getPresentationLUT();
        if (iLUT == null) {
            return;
        }
        int n = this.gsts.getWindowDef().getDataWidth() >> 1;
        int n2 = this.gsts.getWindowDef().getDataCenter();
        int n3 = n2 - n;
        int n4 = n2 + n;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 > this.rgb.length) {
            n4 = this.rgb.length;
        }
        int[] nArray = new int[this.rgb.length];
        short[] sArray = iLUT.getData();
        double d = (double)(n4 - n3 - 1) / (double)((sArray[sArray.length - 1] & 0xFFFF) - (sArray[0] & 0xFFFF));
        double d2 = (double)(sArray.length - 1) / (double)(n4 - n3 - 1);
        int n5 = n3;
        while (n5 < n4) {
            nArray[n5] = (int)((double)n3 + (double)(sArray[(int)((double)(n5 - n3) * d2)] & 0xFFFF) * d);
            ++n5;
        }
        int[] nArray2 = new int[this.rgb.length];
        System.arraycopy(this.rgb, 0, nArray2, 0, this.rgb.length);
        int n6 = n3;
        while (n6 < n4) {
            this.rgb[n6] = nArray2[nArray[n6]];
            ++n6;
        }
    }

    public void setInverted(boolean bl) {
        this.inverted = bl;
    }

    private char[] getSegmentedLut(int[] nArray, int n, int n2) {
        int n3;
        ControlHandle controlHandle;
        nArray[0] = this.rgb.length;
        nArray[1] = 0;
        nArray[2] = 16;
        Collection<ControlHandle> collection = this.transferFunction.getHandles(n2);
        char[] cArray = new char[collection.size() * 3];
        Iterator<ControlHandle> iterator = collection.iterator();
        int n4 = 0;
        int n5 = 0;
        if (iterator.hasNext()) {
            controlHandle = iterator.next();
            n3 = controlHandle.getValue();
            cArray[n4] = '\u0000';
            cArray[n4 + 1] = '\u0001';
            cArray[n4 + 2] = (char)(n3 >> TransferFunction.SHIFT[n] & 0xFF);
            int n6 = n4 + 2;
            cArray[n6] = (char)(cArray[n6] | cArray[n4 + 2] << 8);
            nArray[1] = n5 = controlHandle.getPosition();
            n4 += 3;
        }
        nArray[1] = n5;
        while (iterator.hasNext()) {
            controlHandle = iterator.next();
            n3 = controlHandle.getPosition();
            int n7 = controlHandle.getValue();
            cArray[n4] = '\u0001';
            cArray[n4 + 1] = (char)(n3 - n5 & 0xFFFF);
            cArray[n4 + 2] = (char)(n7 >> TransferFunction.SHIFT[n] & 0xFF);
            int n8 = n4 + 2;
            cArray[n8] = (char)(cArray[n8] | cArray[n4 + 2] << 8);
            n5 = n3;
            n4 += 3;
        }
        return cArray;
    }

    @Override
    public WindowTransferFunction getClone() {
        return new GeneralWindowTransferFunction(this);
    }

    private void storeTo(PaletteColorLUTModule paletteColorLUTModule) {
        if (paletteColorLUTModule == null) {
            return;
        }
        int[] nArray = new int[3];
        char[] cArray = null;
        cArray = this.getSegmentedLut(nArray, 4, 7);
        paletteColorLUTModule.setRedPaletteColorLookupTableDescriptor(nArray);
        paletteColorLUTModule.setSegmentedRedPaletteColorLookupTableData(this.toBytesLE(cArray));
        cArray = this.getSegmentedLut(nArray, 2, 7);
        paletteColorLUTModule.setGreenPaletteColorLookupTableDescriptor(nArray);
        paletteColorLUTModule.setSegmentedGreenPaletteColorLookupTableData(this.toBytesLE(cArray));
        cArray = this.getSegmentedLut(nArray, 1, 7);
        paletteColorLUTModule.setBluePaletteColorLookupTableDescriptor(nArray);
        paletteColorLUTModule.setSegmentedBluePaletteColorLookupTableData(this.toBytesLE(cArray));
    }

    private TianiPaletteColorLUTModule createTianiLUT() {
        TianiPaletteColorLUTModule tianiPaletteColorLUTModule = new TianiPaletteColorLUTModule();
        this.storeTo((PaletteColorLUTModule)tianiPaletteColorLUTModule);
        int[] nArray = new int[3];
        char[] cArray = null;
        cArray = this.getSegmentedLut(nArray, 8, 8);
        tianiPaletteColorLUTModule.setAlphaPaletteColorLookupTableDescriptor(nArray);
        tianiPaletteColorLUTModule.setSegmentedAlphaPaletteColorLookupTableData(this.toBytesLE(cArray));
        return tianiPaletteColorLUTModule;
    }

    private byte[] toBytesLE(char[] cArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(cArray.length * 2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asCharBuffer().put(cArray);
        return byteBuffer.array();
    }

    @Override
    public void storeTo(Attributes attributes) {
        super.storeTo(attributes);
        TianiPaletteColorLUTModule tianiPaletteColorLUTModule = this.createTianiLUT();
        if (tianiPaletteColorLUTModule != null) {
            tianiPaletteColorLUTModule.writeTo(attributes);
        }
    }

    public void setSOPInstanceUID(String string) {
        this.transferFunction.setSOPInstanceUID(string);
    }
}

