/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.swing.layout.RowLayout;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.gui.selection.DisplaySetSelectionData;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.StudyType;
import com.agfa.pacs.impaxee.utils.GuiUtil;
import com.agfa.pacs.listtext.swingx.controls.ArrowIcon;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.overlay.demographics.PriorStudyColoring;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.DisplaySetLabelGroup;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.lang3.StringUtils;

public class DisplaySetSelectionPanel
extends JPanel {
    private static final Color BRIGHT_BLUE = new Color(175, 201, 240);
    private static final int MAX_DISPLAYSETS_PER_ROW = 8;
    private static final int MINIMAL_WIDTH = GUI.getScaledDiagnosticInt((int)400);
    private static final int VERTICAL_GAP = GUI.getScaledDiagnosticInt((int)5);
    private static final String SEPARATOR = " | ";
    private static final String ETC = " ...";
    private final OrderedMap<String, StudyPanel> studiesToPanels = new ListOrderedMap();
    private final IDisplaySetSelectionListener listener;
    private final MouseWheelHandler mouseWheelHandler = new MouseWheelHandler();
    private String currentStudyKey = null;

    private DisplaySetSelectionPanel(IDisplaySet[] iDisplaySetArray, IDisplaySetSelectionListener iDisplaySetSelectionListener) {
        this.listener = iDisplaySetSelectionListener;
        this.init(iDisplaySetArray);
        this.addMouseWheelListener(this.mouseWheelHandler);
    }

    public static void showAsPopup(final MouseEvent mouseEvent, final VisDisplay2 visDisplay2) {
        EventUtil.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                final JPopupMenu jPopupMenu = new JPopupMenu();
                DisplaySetSelectionPanel displaySetSelectionPanel = new DisplaySetSelectionPanel(DataSelectionManager.getInstance().getActiveHanging().getSplitAndSortRuntime().getDisplaySets(), new IDisplaySetSelectionListener(){

                    @Override
                    public void selectionChanged(IDisplaySet iDisplaySet) {
                        visDisplay2.initVisDisplay(iDisplaySet, null, true, ActivationMode.MANUAL);
                        jPopupMenu.setVisible(false);
                    }
                }, null);
                JScrollPane jScrollPane = ComponentFactory.instance.createScrollPane(displaySetSelectionPanel, 20, 31, true, null);
                jScrollPane.setWheelScrollingEnabled(false);
                jPopupMenu.add(jScrollPane);
                int n = visDisplay2.getVisScreen().getSize().height / 2;
                Dimension dimension = displaySetSelectionPanel.getPreferredPopupSize();
                jPopupMenu.setPreferredSize(new Dimension(dimension.width, Math.min(n, dimension.height)));
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                jPopupMenu.revalidate();
                displaySetSelectionPanel.postShow();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void init(IDisplaySet[] iDisplaySetArray) {
        void var7_10;
        ArrayList<Object> arrayList;
        Object object;
        Object object2;
        this.studiesToPanels.clear();
        ListOrderedMap listOrderedMap = new ListOrderedMap();
        int n = 1;
        IDisplaySet[] object32 = iDisplaySetArray;
        int n2 = iDisplaySetArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object2 = object32[n3];
            object = object2.getStudy();
            arrayList = (ArrayList<Object>)listOrderedMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                listOrderedMap.put(object, arrayList);
            }
            arrayList.add(object2);
            if (arrayList.size() > n) {
                n = arrayList.size();
            }
            ++n3;
        }
        this.setLayout((LayoutManager)new RowLayout(VERTICAL_GAP));
        if (n > 8) {
            n = 8;
        }
        n3 = (int)(((JComponent)(object2 = DisplaySetSelectionData.getDisplaySetIcon(iDisplaySetArray[0], false, true))).getPreferredSize().getWidth() > 0.0 ? ((JComponent)object2).getPreferredSize().getWidth() : 64.0);
        n2 = Math.max(n * n3, MINIMAL_WIDTH);
        for (Map.Entry entry : listOrderedMap.entrySet()) {
            arrayList = (IStudyData)entry.getKey();
            List list = (List)entry.getValue();
            StudyPanel studyPanel = new StudyPanel(Math.min(8, list.size()), (IStudyData)((Object)arrayList), list, n2);
            studyPanel.addMouseWheelListener(this.mouseWheelHandler);
            this.studiesToPanels.put((Object)arrayList.getKey(), (Object)studyPanel);
            this.add(studyPanel);
        }
        Object var7_7 = null;
        if (VisData.getLastModified() != null) {
            String string = VisData.getLastModified().getStudyData().getKey();
        } else {
            object = DataSelectionManager.getInstance().getActiveHanging();
            if (object != null && (arrayList = object.getStudyContainer()) != null) {
                String string = arrayList.getBaseStudy().getKey();
            }
        }
        if (var7_10 != null) {
            this.setCurrentStudy((String)var7_10);
        }
    }

    private Dimension getPreferredPopupSize() {
        Insets insets = this.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (!this.studiesToPanels.isEmpty()) {
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = new Dimension(0, 0);
            for (StudyPanel studyPanel : this.studiesToPanels.values()) {
                Dimension dimension3 = studyPanel.getPreferredExpandedSize();
                Dimension dimension4 = studyPanel.getPreferredCollapsedSize();
                dimension.width = Math.max(dimension.width, dimension3.width);
                dimension.height = Math.max(dimension.height, dimension3.height);
                dimension2.width = Math.max(dimension2.width, dimension4.width);
                dimension2.height = Math.max(dimension2.height, dimension4.height);
            }
            n += Math.max(dimension2.width, dimension.width);
            n += GUI.getScaledDiagnosticInt((int)20);
            n = Math.max(n, MINIMAL_WIDTH);
            n2 += this.studiesToPanels.size() - 1;
            n2 += VERTICAL_GAP;
            n2 += dimension.height;
            n2 += (dimension2.height + VERTICAL_GAP) * Math.min(this.studiesToPanels.size(), 10);
        }
        return new Dimension(n, n2);
    }

    private void postShow() {
        final StudyPanel studyPanel = (StudyPanel)this.studiesToPanels.get((Object)this.currentStudyKey);
        if (studyPanel != null) {
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    DisplaySetSelectionPanel.this.scrollRectToVisible(studyPanel.getBounds());
                }
            });
        }
    }

    private void setCurrentStudy(String string) {
        if (!StringUtils.equals((CharSequence)string, (CharSequence)this.currentStudyKey)) {
            for (Object object : this.studiesToPanels.entrySet()) {
                if (StringUtils.equals((CharSequence)string, (CharSequence)((CharSequence)object.getKey()))) continue;
                ((StudyPanel)object.getValue()).collapse();
            }
            this.currentStudyKey = null;
            if (string != null) {
                Object object;
                this.currentStudyKey = string;
                object = (StudyPanel)this.studiesToPanels.get((Object)string);
                if (object != null) {
                    ((StudyPanel)object).expand();
                    this.scrollRectToVisible(((Component)object).getBounds());
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    private String getPreviousStudyKey() {
        return (String)this.studiesToPanels.previousKey((Object)this.currentStudyKey);
    }

    private String getNextStudyKey() {
        return (String)this.studiesToPanels.nextKey((Object)this.currentStudyKey);
    }

    private void fireDisplaySetSelected(IDisplaySet iDisplaySet) {
        if (this.listener != null) {
            this.listener.selectionChanged(iDisplaySet);
        }
    }

    /* synthetic */ DisplaySetSelectionPanel(IDisplaySet[] iDisplaySetArray, IDisplaySetSelectionListener iDisplaySetSelectionListener, DisplaySetSelectionPanel displaySetSelectionPanel) {
        this(iDisplaySetArray, iDisplaySetSelectionListener);
    }

    public static interface IDisplaySetSelectionListener {
        public void selectionChanged(IDisplaySet var1);
    }

    private class MouseWheelHandler
    extends MouseAdapter {
        private MouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            try {
                if (mouseWheelEvent.getScrollType() == 0 && Math.abs(mouseWheelEvent.getWheelRotation()) != 0) {
                    String string;
                    String string2 = string = mouseWheelEvent.getWheelRotation() < 0 ? DisplaySetSelectionPanel.this.getPreviousStudyKey() : DisplaySetSelectionPanel.this.getNextStudyKey();
                    if (string != null) {
                        DisplaySetSelectionPanel.this.setCurrentStudy(string);
                    }
                }
                mouseWheelEvent.consume();
            }
            catch (Exception exception) {
                ALogger.getLogger(DisplaySetSelectionPanel.class).error(null, (Throwable)exception);
            }
        }
    }

    private class StudyPanel
    extends JPanel {
        private JLabel titleLabel;
        private JComponent indicator;
        private JPanel displaySetsPanel;
        private TableLayout displaySetsLayout = new TableLayout();
        private int currentColumnIndex = 0;
        private int maxColumnIndex;
        private int currentRowIndex = 0;
        private Icon expandedIcon = null;
        private Icon collapsedIcon = null;
        private Color collapsedBackground = null;
        private Color expandedBackground = null;
        private Dimension prefCollapsedSize = null;
        private Dimension prefExpandedSize = null;

        public StudyPanel(int n, final IStudyData iStudyData, List<IDisplaySet> list, int n2) {
            this.displaySetsPanel = ComponentFactory.instance.createPanel((LayoutManager)this.displaySetsLayout);
            this.maxColumnIndex = n - 1;
            int n3 = 0;
            while (n3 < n) {
                this.displaySetsLayout.insertColumn(n3, -2.0);
                ++n3;
            }
            this.displaySetsLayout.insertRow(0, -2.0);
            this.displaySetsLayout.setVGap(2);
            this.displaySetsLayout.setHGap(2);
            for (IDisplaySet iDisplaySet : list) {
                this.appendDisplaySet(iDisplaySet);
            }
            Color color = this.getPriorColor(iStudyData);
            String string = DisplaySetLabelGroup.getStudyDigest(iStudyData);
            String string2 = iStudyData.getDicomObject().getString(528432);
            this.titleLabel = new JLabel();
            String string3 = this.getTitleLabelText(string, string2, n2);
            this.titleLabel.setText(string3);
            if (!string3.equals(string)) {
                this.titleLabel.setToolTipText(String.valueOf(string) + DisplaySetSelectionPanel.SEPARATOR + string2);
            }
            this.titleLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() <= 1) {
                        DisplaySetSelectionPanel.this.setCurrentStudy(iStudyData.getKey());
                    }
                }
            });
            this.titleLabel.setCursor(Cursor.getPredefinedCursor(12));
            if (color != null) {
                this.titleLabel.setForeground(color);
            }
            this.expandedBackground = ColorUtils.brighter((Color)UIManager.getColor("color.primary.1"), (float)0.75f);
            this.collapsedBackground = this.getBackground();
            this.expandedIcon = ArrowIcon.getDownArrowIcon((Color)this.titleLabel.getForeground(), (int)GUI.getScaledDiagnosticInt((int)10), (int)GUI.getScaledDiagnosticInt((int)5));
            this.collapsedIcon = ArrowIcon.getRightArrowIcon((Color)this.titleLabel.getForeground(), (int)GUI.getScaledDiagnosticInt((int)6), (int)GUI.getScaledDiagnosticInt((int)12));
            this.titleLabel.setIcon(this.expandedIcon);
            this.setBackground(this.expandedBackground);
            this.indicator = (JComponent)Box.createHorizontalStrut(GUI.getScaledDiagnosticInt((int)5));
            this.indicator.setOpaque(true);
            this.indicator.setBackground(this.titleLabel.getForeground());
            JPanel jPanel = ComponentFactory.instance.createPanel((LayoutManager)new RowLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, GUI.getScaledDiagnosticInt((int)5), 0, GUI.getScaledDiagnosticInt((int)10)));
            jPanel.add(this.titleLabel);
            jPanel.add(this.displaySetsPanel);
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.indicator);
            this.add(jPanel);
            this.add(Box.createHorizontalGlue());
            this.prefExpandedSize = this.getPreferredSize();
            this.prefCollapsedSize = this.titleLabel.getPreferredSize();
            this.prefCollapsedSize.width += this.getInsets().left + this.getInsets().right + this.indicator.getPreferredSize().width;
            this.prefCollapsedSize.height += this.getInsets().top + this.getInsets().bottom;
        }

        private String getTitleLabelText(String string, String string2, int n) {
            this.titleLabel.setText(string);
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
            Font font = this.titleLabel.getFont();
            if (string2 != null) {
                int n2 = (int)font.getStringBounds(String.valueOf(string) + DisplaySetSelectionPanel.SEPARATOR, fontRenderContext).getWidth();
                if (n2 > n) {
                    string = String.valueOf(string) + DisplaySetSelectionPanel.ETC;
                } else {
                    String string3 = DisplaySetSelectionPanel.SEPARATOR + string2;
                    int n3 = (int)font.getStringBounds(string3, fontRenderContext).getWidth();
                    int n4 = (int)font.getStringBounds(DisplaySetSelectionPanel.ETC, fontRenderContext).getWidth();
                    double d = n - n2 - n4;
                    if (d < (double)n3) {
                        int n5 = DisplaySetSelectionPanel.SEPARATOR.length();
                        while (n5 < string3.length()) {
                            String string4 = string3.substring(0, n5);
                            int n6 = (int)font.getStringBounds(string4, fontRenderContext).getWidth();
                            if ((double)n6 >= d) {
                                string = String.valueOf(string) + (string4.equals(DisplaySetSelectionPanel.SEPARATOR) ? DisplaySetSelectionPanel.ETC : String.valueOf(string4) + DisplaySetSelectionPanel.ETC);
                                break;
                            }
                            ++n5;
                        }
                    } else {
                        string = String.valueOf(string) + string3;
                    }
                }
            }
            return string;
        }

        public void collapse() {
            this.displaySetsPanel.setVisible(false);
            this.indicator.setVisible(false);
            this.titleLabel.setIcon(this.collapsedIcon);
            this.setBackground(this.collapsedBackground);
        }

        public void expand() {
            this.displaySetsPanel.setVisible(true);
            this.indicator.setVisible(true);
            this.titleLabel.setIcon(this.expandedIcon);
            this.setBackground(this.expandedBackground);
        }

        public Dimension getPreferredCollapsedSize() {
            return this.prefCollapsedSize;
        }

        public Dimension getPreferredExpandedSize() {
            return this.prefExpandedSize;
        }

        private void appendDisplaySet(final IDisplaySet iDisplaySet) {
            if (this.currentColumnIndex > this.maxColumnIndex) {
                this.currentColumnIndex = 0;
                ++this.currentRowIndex;
                this.displaySetsLayout.insertRow(this.currentRowIndex, -2.0);
            }
            final JComponent jComponent = DisplaySetSelectionData.getDisplaySetIcon(iDisplaySet, false, true);
            jComponent.setToolTipText(DisplaySetSelectionData.getDisplaySetLabel(iDisplaySet));
            jComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    jComponent.setBorder(BorderFactory.createLineBorder(BRIGHT_BLUE, 2));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    jComponent.setBorder(BorderFactory.createEmptyBorder());
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    DisplaySetSelectionPanel.this.fireDisplaySetSelected(iDisplaySet);
                }
            });
            this.displaySetsPanel.add((Component)jComponent, String.valueOf(this.currentColumnIndex) + "," + this.currentRowIndex);
            ++this.currentColumnIndex;
        }

        private Color getPriorColor(IStudyData iStudyData) {
            if (PriorStudyColoring.useDifferentColorsForPriors && GuiUtil.isOnColorMonitor()) {
                StudyType studyType = StudyType.UNKNOWN;
                IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
                if (iHanging != null && iHanging.getStudyContainer() != null) {
                    studyType = iHanging.getStudyContainer().getStudyType(iStudyData.getKey());
                }
                if (studyType != null && !studyType.equals((Object)StudyType.UNKNOWN)) {
                    switch (studyType) {
                        case BASE_STUDY: 
                        case UNKNOWN: {
                            return null;
                        }
                        case FIRST_PRIOR: {
                            return PriorStudyColoring.mappingColorPrior1;
                        }
                        case MERGED: {
                            return PriorStudyColoring.mappingColorMergedStudies;
                        }
                    }
                    return PriorStudyColoring.mappingColorPriorX;
                }
            }
            return null;
        }
    }
}

