/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeFillActionProvider;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseSubModes;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class CRMarkersAction
implements PActionProvider {
    public static final String LEFT_MARKER = "LEFT_CR_MARKER";
    public static final String RIGHT_MARKER = "RIGHT_CR_MARKER";

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new CRMarkerAction(false));
        arrayList.add(new CRMarkerAction(true));
        return arrayList;
    }

    private static class CRMarkerAction
    extends AbstractPAction {
        private boolean right;

        public CRMarkerAction(boolean bl) {
            this.right = bl;
        }

        @Override
        public String getCaption() {
            if (this.right) {
                return Messages.getString("ImgView2.AddRightMarker");
            }
            return Messages.getString("ImgView2.AddLeftMarker");
        }

        @Override
        public String getGroupName() {
            return "INTERNAL";
        }

        @Override
        public String getID() {
            if (this.right) {
                return CRMarkersAction.RIGHT_MARKER;
            }
            return CRMarkersAction.LEFT_MARKER;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        protected boolean isEnabledImpl() {
            VisData visData = AbstractPDataAction.getCurrentImage();
            if (visData == null) {
                return false;
            }
            return visData.getImageInformation().getImageClass() == IImageInformation.ImageClass.CR;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            VisDisplay2 visDisplay2 = AbstractPDataAction.getCurrentDisplay();
            if (visDisplay2 == null) {
                return false;
            }
            MouseSubModes mouseSubModes = this.right ? MouseSubModes.RIGHT : MouseSubModes.LEFT;
            IMouseModeInfo iMouseModeInfo = visDisplay2.getData().getDisplayPlugin().getMouseModeInfo();
            iMouseModeInfo.setSubMode(mouseSubModes);
            PAction pAction = PActionRegistry.getAction(MouseModeFillActionProvider.getIDForMode(MouseModeFillActionProvider.FillMode.Normal));
            if (!pAction.isSelected()) {
                pAction.perform(null);
            }
            return true;
        }
    }
}

