/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.toptoolbar.PluginActions;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisHRSet;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractWaitingView
extends View {
    private volatile List<IFrameObjectData> fods;
    private boolean destroyed;
    private boolean started = false;
    private boolean failed = false;
    public boolean exportFinished = false;
    private boolean exportStarted = false;

    protected AbstractWaitingView(List<IFrameObjectData> list) {
        super(list.get(0));
        this.fods = new ArrayList<IFrameObjectData>(list);
        this.destroyed = false;
    }

    protected List<IFrameObjectData> getFrames() {
        return this.fods;
    }

    protected void dataFetchFinished() {
        View[] viewArray = this.createDisplayViews(this.fods);
        this.replaceWaitingView(viewArray);
    }

    protected void replaceWaitingView(final View[] viewArray) {
        final VisDisplay2 visDisplay2 = this.getDisplay();
        if (visDisplay2 == null) {
            this.failed = true;
            return;
        }
        if (viewArray == null || viewArray.length == 0) {
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (AbstractWaitingView.this.fods != null) {
                        visDisplay2.getAction(PluginActions.PLUGIN_OFF).perform(null);
                        View[] viewArray = new View[AbstractWaitingView.this.fods.size()];
                        int n = 0;
                        while (n < AbstractWaitingView.this.fods.size()) {
                            viewArray[n] = new ImgView2((IFrameObjectData)AbstractWaitingView.this.fods.get(n));
                            ++n;
                        }
                        visDisplay2.replaceView((View)AbstractWaitingView.this, viewArray);
                    }
                }
            });
            return;
        }
        visDisplay2.replaceView((View)this, viewArray);
        this.onAppendViews(viewArray);
        if (VisData.getLastModified() != null && VisData.getLastModified().getView() == this && viewArray.length > 0) {
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    viewArray[0].getVis().makeTheLastModified();
                }
            });
        }
    }

    public abstract View[] createDisplayViews(List<IFrameObjectData> var1);

    public void onAppendViews(View[] viewArray) {
    }

    @Override
    public ImageState getImageState() {
        return ImageState.getDefaultImageState();
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder) {
        if (this.failed) {
            int n = this.getBounds().width;
            int n2 = this.getBounds().height;
            rGBBufferedImageHolder.graphics.setColor(Color.black);
            rGBBufferedImageHolder.graphics.fillRect(0, 0, n, n2);
            rGBBufferedImageHolder.graphics.drawImage(failIcon, 0, 0, n, n2, null);
            return;
        }
        if (!this.started) {
            this.started = true;
            this.startDataFetching(this.fods);
        }
        rGBBufferedImageHolder.graphics.clearRect(0, 0, rGBBufferedImageHolder.width - 1, rGBBufferedImageHolder.height - 1);
    }

    protected abstract void startDataFetching(List<IFrameObjectData> var1);

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.fods != null) {
            this.fods.clear();
        }
        this.destroyed = true;
    }

    public final boolean doFetch() {
        return !this.destroyed;
    }

    public final void dataFetchFailed(String string) {
        this.failed = true;
    }

    @Override
    public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2) {
        return null;
    }

    @Override
    public final String getVisualType() {
        return "";
    }

    @Override
    public void handleHotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
    }

    @Override
    public void handleHotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
    }

    @Override
    public void handleHotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2) {
    }

    @Override
    public final boolean isFunctional() {
        return true;
    }

    @Override
    public final void onCanvasSizeChanged(boolean bl) {
    }

    @Override
    public final void reset() {
    }

    @Override
    public void progressNotification(String string, double d) {
        if (!this.exportStarted) {
            this.exportStarted = true;
        }
        super.progressNotification(string, d);
        if (d == 1.0) {
            this.exportFinished = true;
        }
    }

    @Override
    public boolean isCine() {
        return true;
    }
}

