/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionIconModifier;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.AnonymousPAction;
import com.agfa.pacs.impaxee.plugin.IconDefinition;
import com.agfa.pacs.listtext.dicomobject.presentationstate.ExternalPresentationStateInfo;
import com.agfa.pacs.listtext.dicomobject.presentationstate.FramePresentationStateProviderContainer;
import com.agfa.pacs.listtext.dicomobject.presentationstate.IPresentationStateInfo;
import com.agfa.pacs.listtext.dicomobject.presentationstate.ImagePresentationStateInfo;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;

abstract class AbstractPresentationStateAction
extends AbstractPAction {
    protected final PDataScope scope;
    protected final PDataProvider provider;
    private PAction[] subActions;
    private long cacheTimestamp;

    AbstractPresentationStateAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        this.scope = pDataScope;
        this.provider = pDataProvider;
    }

    @Override
    public String getID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getDataActionID());
        if (this.scope != null) {
            stringBuilder.append('@');
            stringBuilder.append(this.scope.name());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getGroupName() {
        return IMAGE_DISPLAY_GROUP;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    protected boolean isEnabledImpl() {
        List<IPresentationStateInfo> list = this.getPresentationStates();
        return list != null && list.size() >= this.getMinimumRequiredPresentationStateCount();
    }

    @Override
    public boolean perform(Component component) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PAction.ActionType getActionType() {
        if (this.isSubmenuExclusive()) {
            return PAction.ActionType.SubmenuExclusive;
        }
        return PAction.ActionType.Submenu;
    }

    abstract int getMinimumRequiredPresentationStateCount();

    abstract boolean isSubmenuExclusive();

    private List<IPresentationStateInfo> getSelectablePresStates(VisDisplay2 visDisplay2, boolean bl) {
        List<VisData> list = bl ? visDisplay2.getSelectedVis() : visDisplay2.getVis();
        List<IPresentationStateInfo> list2 = new ArrayList<IPresentationStateInfo>();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        FramePresentationStateProviderContainer framePresentationStateProviderContainer = list.get(0).getStudyData().getFramePresentationStateProviderContainer();
        List list3 = framePresentationStateProviderContainer.getAllPresentationStateInfos();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            ExternalPresentationStateInfo externalPresentationStateInfo;
            IPresentationStateInfo object = (IPresentationStateInfo)iterator.next();
            if (!(object instanceof ExternalPresentationStateInfo) || !(externalPresentationStateInfo = (ExternalPresentationStateInfo)object).isTemporary() || visDisplay2.getData().getDisplaySet().getID() == externalPresentationStateInfo.getDisplaySetID()) continue;
            iterator.remove();
        }
        for (VisData visData : list) {
            iterator = list3.iterator();
            String string = visData.getFrameData().getSOPInstanceUID();
            while (iterator.hasNext()) {
                IPresentationStateInfo iPresentationStateInfo = (IPresentationStateInfo)iterator.next();
                if (!iPresentationStateInfo.containsFrame(string, -1)) continue;
                list2.add(iPresentationStateInfo);
                iterator.remove();
            }
            if (list3.isEmpty()) break;
        }
        list2.add((IPresentationStateInfo)ImagePresentationStateInfo.staticInstance);
        list2 = this.getSelectablePresStates(list2);
        Collections.sort(list2, new PSComparator());
        return list2;
    }

    private List<IPresentationStateInfo> getSelectablePresStates(List<IPresentationStateInfo> list) {
        IPresentationStateInfo iPresentationStateInfo = null;
        ArrayList<IPresentationStateInfo> arrayList = new ArrayList<IPresentationStateInfo>();
        for (IPresentationStateInfo iPresentationStateInfo2 : list) {
            if (iPresentationStateInfo2.isTemporary()) {
                if (iPresentationStateInfo != null && !iPresentationStateInfo.getCreationDateTime().before(iPresentationStateInfo2.getCreationDateTime())) continue;
                iPresentationStateInfo = iPresentationStateInfo2;
                continue;
            }
            arrayList.add(iPresentationStateInfo2);
        }
        if (iPresentationStateInfo != null) {
            arrayList.add(iPresentationStateInfo);
        }
        return arrayList;
    }

    public void selectionChanged() {
        this.subActions = null;
        this.getSubactions();
        this.forcedSelectionChanged();
    }

    @Override
    public PAction[] getSubactions() {
        if (this.provider != null) {
            if (this.subActions != null) {
                return this.subActions;
            }
        } else {
            if (this.subActions != null && System.currentTimeMillis() - this.cacheTimestamp < CACHING_TIMEOUT) {
                return this.subActions;
            }
            this.subActions = null;
            this.cacheTimestamp = 0L;
        }
        List<PAction> list = this.getSubactionsImpl();
        this.subActions = list.toArray(new PAction[list.size()]);
        this.cacheTimestamp = System.currentTimeMillis();
        return this.subActions;
    }

    List<IPresentationStateInfo> getPresentationStates() {
        if (this.scope == PDataScope.CurrentDisplay) {
            return this.getSelectablePresStates(AbstractPDataAction.getCurrentDisplay(), false);
        }
        if (this.scope == PDataScope.CurrentImage) {
            VisData visData = AbstractPDataAction.getCurrentImage();
            if (visData == null) {
                return Collections.emptyList();
            }
            IFrameObjectData iFrameObjectData = visData.getFrameData();
            FramePresentationStateProviderContainer framePresentationStateProviderContainer = iFrameObjectData.getMainFrame().getParent().getParent().getFramePresentationStateProviderContainer();
            List list = framePresentationStateProviderContainer.getPresentationStateInfo(iFrameObjectData.getSOPInstanceUID(), iFrameObjectData.getFrameNumber());
            return this.getSelectablePresStates(list);
        }
        if (this.provider != null) {
            return this.getSelectablePresStates(this.provider.getVisDisplays().get(0), false);
        }
        return Collections.emptyList();
    }

    abstract List<PAction> getSubactionsImpl();

    abstract String getDataActionID();

    private String createLabel(IPresentationStateInfo iPresentationStateInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(iPresentationStateInfo.toString());
        if (!iPresentationStateInfo.isExternal() && iPresentationStateInfo.getCreationDateTime() != null) {
            stringBuilder.append(" (");
            stringBuilder.append(DateTimeUtils.dateTime2String((Date)iPresentationStateInfo.getCreationDateTime()));
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private IconDefinition getIconImpl(IPresentationStateInfo iPresentationStateInfo, int n) {
        if (!iPresentationStateInfo.isExternal()) {
            return new IconDefinition("image_presstate_hr.svg", this.getClass());
        }
        if (iPresentationStateInfo.isTemporary()) {
            return new IconDefinition("temp_presstate_hr.svg", this.getClass());
        }
        return new IconDefinition("neutral_presstate_hr.svg", this.getClass(), new PSIconModifier(n));
    }

    abstract class AbstractAnonymousPSAction
    extends AnonymousPAction {
        protected IPresentationStateInfo ps;
        private String caption;

        AbstractAnonymousPSAction(IPresentationStateInfo iPresentationStateInfo) {
            this.ps = iPresentationStateInfo;
            this.caption = AbstractPresentationStateAction.this.createLabel(iPresentationStateInfo);
        }

        AbstractAnonymousPSAction(IPresentationStateInfo iPresentationStateInfo, int n) {
            super(AbstractPresentationStateAction.this.getIconImpl(iPresentationStateInfo, n));
            this.ps = iPresentationStateInfo;
            this.caption = AbstractPresentationStateAction.this.createLabel(iPresentationStateInfo);
        }

        @Override
        public String getCaption() {
            return this.caption;
        }

        @Override
        public String getToolTipText() {
            return this.caption;
        }
    }

    private static class PSComparator
    implements Comparator<IPresentationStateInfo> {
        private PSComparator() {
        }

        @Override
        public int compare(IPresentationStateInfo iPresentationStateInfo, IPresentationStateInfo iPresentationStateInfo2) {
            return CompareUtils.compareAdvanced((Comparable)iPresentationStateInfo2.getCreationDateTime(), (Comparable)iPresentationStateInfo.getCreationDateTime());
        }
    }

    private static class PSIconModifier
    implements PActionIconModifier {
        private final int number;

        public PSIconModifier(int n) {
            this.number = n;
        }

        @Override
        public ImageIcon modifyIcon(ImageIcon imageIcon) {
            int n = imageIcon.getIconWidth();
            int n2 = imageIcon.getIconHeight();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(imageIcon.getImage(), 0, 0, null);
            String string = Integer.toString(this.number);
            Font font = graphics.getFont();
            Font font2 = new Font(font.getName(), font.getStyle(), n2 / 2);
            graphics.setFont(font2);
            int n3 = graphics.getFontMetrics().stringWidth(string);
            graphics.drawString(Integer.toString(this.number), n - n3 - 2, n2 - 2);
            return new ImageIcon(bufferedImage);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PSIconModifier)) {
                return false;
            }
            PSIconModifier pSIconModifier = (PSIconModifier)object;
            return this.number == pSIconModifier.number;
        }

        public int hashCode() {
            return this.number;
        }
    }
}

