/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.event;

import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.renderer.IRDCRenderer;

public class ZoomParameter {
    public final double zoom;
    public final double density;
    public final SpacingDef spacing;
    public final boolean matchForced;

    public ZoomParameter(IRDCRenderer iRDCRenderer, boolean bl) {
        this.zoom = 1.0 / iRDCRenderer.getAreaFitHandler().getZoomFactor();
        this.density = ZoomParameter.getDensity(iRDCRenderer);
        this.spacing = iRDCRenderer.getImageState().getCurrentSpacingDef();
        this.matchForced = bl;
    }

    public ZoomParameter(IRDCRenderer iRDCRenderer) {
        this(iRDCRenderer, false);
    }

    public static double getDensity(IRDCRenderer iRDCRenderer) {
        return iRDCRenderer.getPixelSizeX();
    }

    public ZoomParameter(double d) {
        this.zoom = d;
        this.density = Double.NaN;
        this.spacing = null;
        this.matchForced = false;
    }

    public boolean isRelative() {
        return this.spacing != null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ZoomParameter)) {
            return false;
        }
        ZoomParameter zoomParameter = (ZoomParameter)object;
        return this.zoom == zoomParameter.zoom && this.density == zoomParameter.density;
    }

    public int hashCode() {
        return new Double(this.zoom).hashCode() ^ new Double(this.density).hashCode();
    }
}

