/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.event;

import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.event.EventDispatchInterface;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.VisScreen2;
import java.util.ArrayList;
import java.util.List;

public class JVEventDispatch
implements EventDispatchInterface {
    private static final ALogger log = ALogger.getLogger(JVEventDispatch.class);

    @Override
    public void sendEvent(TEvent tEvent, Object object, boolean bl) {
        this.sendEvent(null, tEvent, object, bl);
    }

    @Override
    public void sendEvent(VisDisplay2 visDisplay2, TEvent tEvent, Object object, boolean bl) {
        VisDisplayData visDisplayData = null;
        if (visDisplay2 == null) {
            VisData visData = VisData.getLastModified();
            if (visData == null) {
                return;
            }
            visDisplayData = visData.getParent();
            if (visDisplayData == null) {
                return;
            }
        } else {
            visDisplayData = visDisplay2.getData();
            if (visDisplayData == null) {
                return;
            }
        }
        int n = 0;
        if (bl && visDisplayData.isSynchronized()) {
            n = TEventDispatch.SYNCHRONIZED_DISPLAYS | TEventDispatch.SELECTED_VISUALS;
            this.sendEvent(tEvent, object, n);
        } else {
            n = TEventDispatch.SELECTED_VISUALS;
            this.sendEventToVis(visDisplayData.getVisDisplay(), tEvent, object, n);
        }
    }

    @Override
    public void sendEvent(TEvent tEvent, Object object, int n) {
        this.sendEventToVisScreens(tEvent, object, n);
    }

    @Override
    public void sendEventToVisScreens(TEvent tEvent, Object object, int n) {
        ArrayList<VisScreen2> arrayList = new ArrayList<VisScreen2>(JVision2.getMainFrame().getScreens());
        for (VisScreen2 visScreen2 : arrayList) {
            this.sendEventToVisDisplays(visScreen2, tEvent, object, n);
        }
    }

    private void sendEventToVisDisplays(VisScreen2 visScreen2, TEvent tEvent, Object object, int n) {
        block4: {
            ArrayList<VisDisplay2> arrayList;
            block3: {
                if (visScreen2 == null) {
                    log.info("sendEventToVisDisplays: vs is null!");
                    return;
                }
                arrayList = new ArrayList<VisDisplay2>(visScreen2.getDisplays());
                if ((n & TEventDispatch.ALL_DISPLAYS) != TEventDispatch.ALL_DISPLAYS) break block3;
                for (VisDisplay2 visDisplay2 : arrayList) {
                    visDisplay2.handleTEvent(tEvent, object, n);
                    this.sendEventToVis(visDisplay2, tEvent, object, n);
                }
                break block4;
            }
            if ((n & TEventDispatch.SYNCHRONIZED_DISPLAYS) != TEventDispatch.SYNCHRONIZED_DISPLAYS) break block4;
            for (VisDisplay2 visDisplay2 : arrayList) {
                if (!visDisplay2.getData().isSynchronized()) continue;
                visDisplay2.handleTEvent(tEvent, object, n);
                this.sendEventToVis(visDisplay2, tEvent, object, n);
            }
        }
    }

    @Override
    public void sendEventToVis(VisDisplay2 visDisplay2, TEvent tEvent, Object object, int n) {
        block4: {
            List<VisData> list;
            block3: {
                if (visDisplay2 == null) {
                    log.info("sendEventToVis: vd is null!");
                    return;
                }
                list = visDisplay2.getVis();
                if ((n & TEventDispatch.ALL_VISUALS) != TEventDispatch.ALL_VISUALS) break block3;
                for (VisData visData : list) {
                    visData.handleTEvent(tEvent, object, n);
                }
                break block4;
            }
            if ((n & TEventDispatch.SELECTED_VISUALS) != TEventDispatch.SELECTED_VISUALS) break block4;
            for (VisData visData : list) {
                if (!visData.isSelected()) continue;
                visData.handleTEvent(tEvent, object, n);
            }
        }
    }
}

