/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.panel.flexible.behaviourcontrol;

import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.tiani.config.resources.ResourceManager;
import com.tiani.gui.util.event.RecursivelyInstallableMouseListenerMixin;
import com.tiani.gui.util.panel.flexible.AbstractBehaviourControl;
import com.tiani.gui.util.panel.flexible.FlexiblePanel;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorMenuItem;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class PopupMenuBehaviourControl
extends AbstractBehaviourControl {
    private RecursivelyInstallableMouseListenerMixin popupMenuTrigger;

    public PopupMenuBehaviourControl(FlexiblePanel flexiblePanel, int n) {
        super(flexiblePanel, n);
        final JPopupMenu jPopupMenu = this.createPopup();
        this.popupMenuTrigger = new RecursivelyInstallableMouseListenerMixin(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.trigger(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.trigger(mouseEvent);
            }

            private void trigger(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.installListener(this.popupMenuTrigger, flexiblePanel);
    }

    protected void installListener(RecursivelyInstallableMouseListenerMixin recursivelyInstallableMouseListenerMixin, FlexiblePanel flexiblePanel) {
        recursivelyInstallableMouseListenerMixin.installOn(flexiblePanel);
    }

    @Override
    protected Icon loadIcon(String string) {
        return ResourceManager.icon(PopupMenuBehaviourControl.class, string);
    }

    protected JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        int n = 0;
        while (n < this.orderedActions.length) {
            if (this.orderedActions[n] != null) {
                MultiMonitorMenuItem multiMonitorMenuItem = ComponentFactory.instance.createMultiMonitorMenuItem(this.orderedActions[n]);
                jPopupMenu.add(multiMonitorMenuItem);
            }
            ++n;
        }
        return jPopupMenu;
    }

    @Override
    public void close() {
        this.popupMenuTrigger.deinstallFrom(this.flexiblePanel);
        super.close();
    }
}

