/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.panel.flexible.behaviourcontrol;

import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.util.LocationUtil;
import com.tiani.gui.util.event.MouseKnocking;
import com.tiani.gui.util.event.RecursivelyInstallableMouseListenerMixin;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

class MouseOverVisibilityTrigger
extends RecursivelyInstallableMouseListenerMixin {
    private static final KeyStroke TOGGLE_KEYSTROKE = KeyStroke.getKeyStroke(119, 8);
    private static final KeyStroke HIDE_KEYSTROKE = KeyStroke.getKeyStroke(27, 0);
    private static final ALogger log = ALogger.getLogger(MouseOverVisibilityTrigger.class);
    private final Component flexiblePanel;
    private final Component stateControl;
    private final Action toggleAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MouseOverVisibilityTrigger.this.toggleControl();
        }
    };
    private final Action hideAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MouseOverVisibilityTrigger.this.hideControl();
        }
    };

    MouseOverVisibilityTrigger(Component component, Component component2) {
        this.flexiblePanel = component;
        this.stateControl = component2;
        component2.setVisible(false);
    }

    @Override
    protected void handleMouseListenerRecursive(Component component, boolean bl, Class<?> clazz, ContainerListener containerListener) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            String string = "ToggleStateControlPanel";
            Object object = jComponent.getInputMap().get(TOGGLE_KEYSTROKE);
            if (object != null && !object.equals(string)) {
                log.warn("MouseOverVisibiltyTrigger: Could not " + (bl ? "" : "de-") + "install " + TOGGLE_KEYSTROKE + " to state control, occupied by: " + object);
            } else {
                jComponent.getInputMap().remove(TOGGLE_KEYSTROKE);
                jComponent.getActionMap().remove(string);
                if (bl) {
                    jComponent.getInputMap().put(TOGGLE_KEYSTROKE, string);
                    jComponent.getActionMap().put(string, this.toggleAction);
                }
            }
            if (this.isDescendingFromStateControl(jComponent)) {
                String string2 = "HideStateControlPanel";
                jComponent.getInputMap().remove(HIDE_KEYSTROKE);
                jComponent.getActionMap().remove(string2);
                if (bl) {
                    jComponent.getInputMap().put(HIDE_KEYSTROKE, string2);
                    jComponent.getActionMap().put(string2, this.hideAction);
                }
            }
        }
        super.handleMouseListenerRecursive(component, bl, clazz, containerListener);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.isEventFromStateControl(mouseEvent)) {
            this.adjustControlVisibility(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.isEventFromStateControl(mouseEvent)) {
            this.adjustControlVisibility(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isEventFromStateControl(mouseEvent) && new MouseKnocking(this.stateControl, mouseEvent).getSide() != null) {
            this.hideControl();
        }
    }

    private boolean isEventFromStateControl(MouseEvent mouseEvent) {
        return this.isDescendingFromStateControl(mouseEvent.getComponent());
    }

    private boolean isDescendingFromStateControl(Component component) {
        return component == this.stateControl || SwingUtilities.isDescendingFrom(component, this.stateControl);
    }

    private void toggleControl() {
        if (this.stateControl.isVisible()) {
            this.hideControl();
        } else {
            this.showControl();
        }
    }

    private void adjustControlVisibility(MouseEvent mouseEvent) {
        Rectangle rectangle;
        Point point = mouseEvent.getPoint();
        if (mouseEvent.getComponent() != this.flexiblePanel) {
            point = SwingUtilities.convertPoint(mouseEvent.getComponent(), point, this.flexiblePanel);
        }
        Rectangle rectangle2 = null;
        if (!this.stateControl.isVisible() && (rectangle = this.getControlBounds()).contains(point)) {
            rectangle2 = rectangle;
        }
        if (rectangle2 != null) {
            this.showControl(rectangle2);
        } else {
            this.hideControl();
        }
    }

    private void showControl() {
        Rectangle rectangle = this.getControlBounds();
        this.showControl(rectangle);
    }

    private void showControl(Rectangle rectangle) {
        if (this.isOnDialog()) {
            return;
        }
        JLayeredPane jLayeredPane = this.getLayeredPane();
        Point point = SwingUtilities.convertPoint(this.flexiblePanel, rectangle.x, rectangle.y, jLayeredPane);
        this.stateControl.setBounds(point.x, point.y, rectangle.width, rectangle.height);
        jLayeredPane.add(this.stateControl, JLayeredPane.DRAG_LAYER);
        this.stateControl.setVisible(true);
    }

    private void hideControl() {
        if (!this.stateControl.isVisible()) {
            return;
        }
        this.stateControl.setVisible(false);
        this.stateControl.getParent().remove(this.stateControl);
    }

    private Rectangle getControlBounds() {
        Dimension dimension = LocationUtil.getSize(this.flexiblePanel);
        Dimension dimension2 = LocationUtil.getSize(this.stateControl);
        return new Rectangle(dimension.width - dimension2.width, 0, dimension2.width, dimension2.height);
    }

    private JLayeredPane getLayeredPane() {
        JRootPane jRootPane = SwingUtilities.getRootPane(this.flexiblePanel);
        return jRootPane.getLayeredPane();
    }

    private boolean isOnDialog() {
        Window window = SwingUtilities.getWindowAncestor(this.flexiblePanel);
        return window instanceof JDialog && !((JDialog)window).isUndecorated();
    }
}

