/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.panel.flexible;

import com.agfa.pacs.tools.CompareUtils;
import com.tiani.gui.util.KeyStrokeUtil;
import com.tiani.gui.util.LocationUtil;
import com.tiani.gui.util.panel.flexible.AbstractBehaviourControl;
import com.tiani.gui.util.panel.flexible.AbstractPopupVisualizer;
import com.tiani.gui.util.panel.flexible.AbstractVisualizer;
import com.tiani.gui.util.panel.flexible.DialogVisualizer;
import com.tiani.gui.util.panel.flexible.MouseClickPopupVisualizer;
import com.tiani.gui.util.panel.flexible.MouseKnockPopupVisualizer;
import com.tiani.gui.util.panel.flexible.Visualizer;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorPanel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FlexiblePanel
extends MultiMonitorPanel {
    public static final int MOUSE_KNOCK_POPUP = 1;
    public static final int DOCKED = 2;
    public static final int MOUSE_CLICK_POPUP = 4;
    public static final int DIALOG = 8;
    public static final int INVISIBLE = 16;
    protected static final int UNDEF = 0;
    public static final int dialogTitleBarHeight = 28;
    public static final int dialogWindowBorder = 2;
    private int behaviour = 0;
    protected int dialogCloseBehaviour = 1;
    private String title;
    protected int previousBehaviour = this.behaviour;
    private Component mouseSensor;
    private JComponent parentContainer;
    private String alignment;
    protected Visualizer visualizer;
    private Rectangle dialogBounds;
    private List<ChangeListener> listeners;
    private Component currentTriggerComponent;

    public FlexiblePanel(String string, JComponent jComponent, Component component) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        if (jComponent == null) {
            throw new IllegalArgumentException("Parent container must not be null! A dialog needs a parent, and a popup is implemented as undecorated dialog.");
        }
        this.title = string;
        this.parentContainer = jComponent;
        this.mouseSensor = component;
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlexiblePanel.this.setHidden(true);
            }
        };
        KeyStrokeUtil.installKeyStroke(this, "hide_flexpanel", abstractAction, 27, 0);
    }

    public FlexiblePanel(String string, JComponent jComponent, Component component, String string2) {
        this(string, jComponent, component);
        if (string2 == null) {
            throw new IllegalArgumentException("Alignment edge of a three-behaviour-panel must not be null!");
        }
        this.alignment = string2;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        if (this.listeners.indexOf(changeListener) < 0) {
            this.listeners.add(changeListener);
        }
    }

    protected int getBehaviourAfterDialogClose() {
        return this.getPreviousBehaviour() > 0 && this.getPreviousBehaviour() != 8 ? this.getPreviousBehaviour() : this.getPopupBehaviour();
    }

    protected int getPopupBehaviour() {
        return this.isPopupOnMouseKnock() ? 1 : 4;
    }

    private boolean isPopupOnMouseKnock() {
        return this.alignment != null;
    }

    public int getBehaviour() {
        return this.behaviour;
    }

    public int getPreviousBehaviour() {
        return this.previousBehaviour;
    }

    public synchronized void setBehaviour(int n) {
        assert (n == 8 || n == 2 || n == 4 || n == 1 || n == 16) : "The passed behaviour is not valid: " + n;
        assert (this.isPopupOnMouseKnock() || n != 1) : "Must not set MOUSE_KNOCK_POPUP behaviour when no alignment was given: " + this.alignment;
        if (this.getBehaviour() == n) {
            return;
        }
        this.previousBehaviour = this.getBehaviour();
        this.behaviour = n;
        this.resolveOldBehaviour(this.previousBehaviour);
        this.acquireNewBehaviour();
        this.fireChangeEvent();
    }

    public void setVisibleOnEventSource(AWTEvent aWTEvent) {
        if (AbstractVisualizer.getPreferredPanelSize(this) == null) {
            return;
        }
        this.setCurrentEvent(aWTEvent);
        this.setHidden(false);
    }

    public boolean isHidden() {
        return this.visualizer != null ? this.visualizer.isHidden() : !super.isShowing();
    }

    public void setHidden(boolean bl) {
        if (this.visualizer != null) {
            if (!bl && this.visualizer instanceof DialogVisualizer && this.dialogBounds == null) {
                ((DialogVisualizer)this.visualizer).refresh();
            }
            this.visualizer.setHidden(bl);
        }
    }

    public void refresh() {
        this.revalidate();
        switch (this.getBehaviour()) {
            case 1: 
            case 4: {
                AbstractPopupVisualizer abstractPopupVisualizer;
                if (!(this.visualizer instanceof AbstractPopupVisualizer) || (abstractPopupVisualizer = (AbstractPopupVisualizer)this.visualizer).isHidden()) break;
                abstractPopupVisualizer.showPopupWindow();
                break;
            }
            case 2: {
                this.refreshParentContainer();
                break;
            }
            case 8: {
                if (!(this.visualizer instanceof DialogVisualizer)) break;
                DialogVisualizer dialogVisualizer = (DialogVisualizer)this.visualizer;
                dialogVisualizer.refresh();
            }
        }
    }

    public void setCurrentEvent(AWTEvent aWTEvent) {
        if (this.visualizer instanceof AbstractPopupVisualizer) {
            AbstractPopupVisualizer abstractPopupVisualizer = (AbstractPopupVisualizer)this.visualizer;
            this.currentTriggerComponent = (Component)aWTEvent.getSource();
            if (aWTEvent instanceof MouseEvent) {
                abstractPopupVisualizer.setCurrentMousePoint(this.currentTriggerComponent, ((MouseEvent)aWTEvent).getPoint());
            } else {
                abstractPopupVisualizer.setCurrentMousePoint(this.currentTriggerComponent, new Point(0, this.currentTriggerComponent.getHeight()));
            }
        }
    }

    public void setCurrentPosition(Component component) {
        if (this.visualizer instanceof AbstractPopupVisualizer) {
            AbstractPopupVisualizer abstractPopupVisualizer = (AbstractPopupVisualizer)this.visualizer;
            this.currentTriggerComponent = component;
            abstractPopupVisualizer.setCurrentMousePoint(this.currentTriggerComponent, new Point(0, this.currentTriggerComponent.getHeight()));
        }
    }

    public Point getDialogLocation() {
        Rectangle rectangle = this.retrieveDialogBounds();
        return rectangle != null ? new Point(rectangle.x, rectangle.y) : null;
    }

    public void setDialogLocation(Point point) {
        if (this.dialogBounds != null) {
            this.dialogBounds.x = point.x;
            this.dialogBounds.y = point.y;
        } else {
            this.dialogBounds = new Rectangle(point.x, point.y, 0, 0);
        }
        this.setDialogBounds(this.dialogBounds, true);
    }

    public Rectangle getDialogBounds() {
        Rectangle rectangle = this.retrieveDialogBounds();
        return rectangle != null ? (Rectangle)rectangle.clone() : null;
    }

    public void setDialogBounds(Rectangle rectangle, boolean bl) {
        if (!bl) {
            this.dialogBounds = this.ensureDialogSizeOnRectangle(rectangle, false);
        }
        if (this.visualizer instanceof DialogVisualizer && (this.dialogBounds != null || bl)) {
            Rectangle rectangle2 = null;
            rectangle2 = bl ? rectangle : this.dialogBounds;
            ((DialogVisualizer)this.visualizer).setRealDialogBounds(rectangle2, bl);
        }
    }

    public void close() {
        this.setHidden(true);
        this.removeAll();
        if (this.listeners != null) {
            for (ChangeListener changeListener : this.listeners) {
                if (!(changeListener instanceof AbstractBehaviourControl)) continue;
                ((AbstractBehaviourControl)changeListener).close();
            }
        }
        this.listeners = null;
        this.closeVisualizer();
    }

    boolean isCurrentTriggerComponent(Component component) {
        return CompareUtils.equals((Object)component, (Object)this.currentTriggerComponent);
    }

    void updateWindowLocation() {
        if (this.visualizer instanceof AbstractPopupVisualizer) {
            ((AbstractPopupVisualizer)this.visualizer).setCurrentMousePoint(this, new Point(0, 0));
        }
    }

    public Window getRealDialog() {
        if (this.visualizer instanceof DialogVisualizer) {
            return ((DialogVisualizer)this.visualizer).getRealDialog();
        }
        return null;
    }

    protected void saveRealDialogBounds() {
        Rectangle rectangle = ((DialogVisualizer)this.visualizer).getRealDialogBounds();
        if (rectangle != null) {
            this.dialogBounds = rectangle;
        }
    }

    protected Visualizer newMouseKnockPopupVisualizer(Container container, Container container2, String string, Component component) {
        return new MouseKnockPopupVisualizer(container, container2, string, component);
    }

    protected Visualizer newDialogVisualizer(FlexiblePanel flexiblePanel, Component component, Rectangle rectangle, String string, boolean bl) {
        return new DialogVisualizer(flexiblePanel, component, rectangle, string, bl, this.dialogCloseBehaviour);
    }

    protected Visualizer newMouseClickPopupVisualizer(Container container, Container container2, Component component) {
        return new MouseClickPopupVisualizer(container, container2, component, this.getMouseClickEventCondition());
    }

    protected MouseClickPopupVisualizer.EventCondition getMouseClickEventCondition() {
        return null;
    }

    protected Rectangle computeAppliedDialogBounds(Rectangle rectangle) {
        return rectangle;
    }

    protected boolean shouldSaveDialogBoundsOnBehaviourChanged(int n, Rectangle rectangle) {
        return true;
    }

    private void resolveOldBehaviour(int n) {
        switch (n) {
            case 8: {
                this.saveRealDialogBounds();
                break;
            }
            case 2: {
                if (this.shouldSaveDialogBoundsOnBehaviourChanged(2, this.dialogBounds)) {
                    this.dialogBounds = this.makeDialogBounds(new Rectangle(this.getLocationOnScreen(), LocationUtil.getSize(this)));
                }
                this.parentContainer.remove(this);
                this.refreshParentContainer();
                break;
            }
            case 0: {
                break;
            }
            default: {
                Rectangle rectangle;
                if (!this.shouldSaveDialogBoundsOnBehaviourChanged(n, this.dialogBounds) || !(this.visualizer instanceof AbstractPopupVisualizer) || (rectangle = this.makeDialogBounds(((AbstractPopupVisualizer)this.visualizer).calculateActualAbsolutePopupBounds())) == null) break;
                this.dialogBounds = rectangle;
            }
        }
        this.closeVisualizer();
    }

    private void acquireNewBehaviour() {
        switch (this.getBehaviour()) {
            case 1: {
                this.visualizer = this.newMouseKnockPopupVisualizer(this, this.parentContainer, this.alignment, this.mouseSensor);
                break;
            }
            case 4: {
                this.visualizer = this.newMouseClickPopupVisualizer(this, this.parentContainer, this.mouseSensor);
                break;
            }
            case 2: {
                this.parentContainer.add((Component)this, this.alignment);
                this.refreshParentContainer();
                break;
            }
            case 8: {
                boolean bl = true;
                Rectangle rectangle = this.computeAppliedDialogBounds(this.dialogBounds);
                rectangle = this.ensureDialogSizeOnRectangle(rectangle, bl);
                this.visualizer = this.newDialogVisualizer(this, this.parentContainer, rectangle, this.title, bl);
            }
        }
        if (this.visualizer != null) {
            this.visualizer.setVisualStateListener(new CloseAndHideHandler());
        }
    }

    private Rectangle ensureDialogSizeOnRectangle(Rectangle rectangle, boolean bl) {
        if (rectangle != null && (rectangle.width <= 0 || rectangle.height <= 0)) {
            Dimension dimension = AbstractVisualizer.getPreferredPanelSize(this);
            if (bl) assert (dimension != null) : "Need a valid size for showing as dialog! Either no components are contained, or they did not layout upon pack().";
            if (dimension != null) {
                rectangle.width = dimension.width;
                rectangle.height = dimension.height;
                if (bl) {
                    assert (rectangle.width > 0) : "Need a valid width for showing as dialog!";
                    assert (rectangle.height > 0) : "Need a valid height for showing as dialog!";
                }
            } else {
                return rectangle;
            }
        }
        return this.ensureVisibleLocation(rectangle);
    }

    protected Rectangle ensureVisibleLocation(Rectangle rectangle) {
        return rectangle != null ? LocationUtil.ensureVisibleLocation(rectangle) : rectangle;
    }

    private void refreshParentContainer() {
        this.parentContainer.revalidate();
        Window window = SwingUtilities.getWindowAncestor(this.parentContainer);
        if (window != null) {
            window.repaint();
        }
    }

    private void fireChangeEvent() {
        int n = 0;
        while (this.listeners != null && n < this.listeners.size()) {
            ChangeListener changeListener = this.listeners.get(n);
            changeListener.stateChanged(new ChangeEvent(this));
            ++n;
        }
    }

    protected Rectangle makeDialogBounds(Rectangle rectangle) {
        boolean bl;
        boolean bl2 = bl = rectangle != null && rectangle.width > 0 && rectangle.height > 0;
        if (!bl) {
            return null;
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.height += 32;
        rectangle2.y -= 30;
        rectangle2.width += 4;
        rectangle2.x -= 2;
        return LocationUtil.ensureVisibleLocation(rectangle2);
    }

    private Rectangle retrieveDialogBounds() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.dialogBounds;
        if (this.visualizer instanceof DialogVisualizer && (rectangle = ((DialogVisualizer)this.visualizer).getRealDialogBounds()) != null) {
            rectangle2 = rectangle;
        }
        return rectangle2;
    }

    private void closeVisualizer() {
        if (this.visualizer != null) {
            this.visualizer.deinstall();
            this.visualizer = null;
        }
    }

    private class CloseAndHideHandler
    implements Visualizer.VisualStateListener {
        private CloseAndHideHandler() {
        }

        @Override
        public void visualizerWasClosed() {
            this.visualizerWasHidden();
            if (FlexiblePanel.this.getBehaviour() == 8 && FlexiblePanel.this.getBehaviourAfterDialogClose() != 8) {
                FlexiblePanel.this.setBehaviour(FlexiblePanel.this.getBehaviourAfterDialogClose());
            }
        }

        @Override
        public void visualizerWasHidden() {
            this.visualizerLostFocus();
            if (FlexiblePanel.this.visualizer instanceof DialogVisualizer) {
                FlexiblePanel.this.saveRealDialogBounds();
            }
        }

        @Override
        public void visualizerGainedFocus() {
        }

        @Override
        public void visualizerLostFocus() {
        }
    }
}

