/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.panel.flexible;

import com.tiani.gui.util.panel.flexible.Visualizer;
import java.awt.Container;
import java.awt.Dimension;

public abstract class AbstractVisualizer
implements Visualizer {
    protected Container flexiblePanel;
    private Visualizer.VisualStateListener visualizerStateListener;

    protected AbstractVisualizer(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("Panel to visualize is null");
        }
        this.flexiblePanel = container;
    }

    protected Dimension getPreferredPanelSize() {
        return AbstractVisualizer.getPreferredPanelSize(this.flexiblePanel);
    }

    public static Dimension getPreferredPanelSize(Container container) {
        return container.getComponentCount() > 0 ? container.getPreferredSize() : null;
    }

    @Override
    public void setVisualStateListener(Visualizer.VisualStateListener visualStateListener) {
        this.visualizerStateListener = visualStateListener;
    }

    protected void notifyWasClosed() {
        if (this.visualizerStateListener != null) {
            this.visualizerStateListener.visualizerWasClosed();
        }
    }

    protected void notifyWasHidden() {
        if (this.visualizerStateListener != null) {
            this.visualizerStateListener.visualizerWasHidden();
        }
    }

    protected void notifyGainedFocus() {
        if (this.visualizerStateListener != null) {
            this.visualizerStateListener.visualizerGainedFocus();
        }
    }

    protected void notifyLostFocus() {
        if (this.visualizerStateListener != null) {
            this.visualizerStateListener.visualizerLostFocus();
        }
    }

    @Override
    public void deinstall() {
        this.setVisualStateListener(null);
    }
}

