/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.dialog;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.tiani.gui.dialog.GUIMessageHandler;
import com.tiani.gui.dialog.ImageAreaDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class StandardDialog
extends ImageAreaDialog {
    private static final Icon iconApply = IAIconFactory.DEFAULT_FACTORY.loadIcon("606_okay.svg");
    private static final Icon iconExit = IAIconFactory.DEFAULT_FACTORY.loadIcon("019_cancel.svg");
    private JPanel panelButtons;
    private int result = 2;
    private boolean locationCalled;
    private IComponentFactory componentFactory;

    public StandardDialog(Dialog dialog2, String string, IComponentFactory iComponentFactory) {
        super(dialog2, string, true);
        this.componentFactory = iComponentFactory == null ? ComponentFactory.instance : iComponentFactory;
        this.init();
    }

    public StandardDialog(Frame frame, String string, IComponentFactory iComponentFactory) {
        super(frame, string, true);
        this.componentFactory = iComponentFactory == null ? ComponentFactory.instance : iComponentFactory;
        this.init();
    }

    public StandardDialog(Dialog dialog2, String string) {
        this(dialog2, string, null);
    }

    public StandardDialog(Frame frame, String string) {
        this(frame, string, null);
    }

    private void init() {
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.panelButtons = new JPanel(new GridLayout(1, 0, 5, 5));
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.panelButtons);
        super.getContentPane().add((Component)jPanel, "South");
        String string = "escape_action";
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StandardDialog.this.setDialogResult(2);
                StandardDialog.this.setVisible(false);
            }
        };
        JComponent jComponent = (JComponent)super.getContentPane();
        jComponent.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), string);
        jComponent.getActionMap().put(string, abstractAction);
    }

    protected void initLocation() {
        this.locationCalled = true;
        GUIMessageHandler.centerSizedWindow(this);
    }

    protected void addButton(Action action) {
        this.panelButtons.add(this.componentFactory.createButton(action));
    }

    protected void addOKButton(Action action) {
        action.putValue("SmallIcon", iconApply);
        this.addButton(action);
    }

    protected void addCancelButton(Action action) {
        action.putValue("SmallIcon", iconExit);
        this.addButton(action);
    }

    public void setContent(JComponent jComponent) {
        if (jComponent == null) {
            super.getContentPane().removeAll();
        } else {
            super.getContentPane().add((Component)jComponent, "Center");
        }
    }

    protected void setDialogResult(int n) {
        assert (n == 0 || n == 1 || n == 2 || n == 0);
        this.result = n;
    }

    public int getDialogResult() {
        return this.result;
    }

    @Override
    public void setVisible(boolean bl) {
        if (!this.locationCalled) {
            this.initLocation();
        }
        super.setVisible(bl);
    }

    @Override
    public final Container getContentPane() {
        return super.getContentPane();
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            super.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }
}

