/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.controls.hotregion;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.tiani.gui.util.TIcon;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;

public class HotRegionImage {
    private Image image;
    private final Dimension actualImageSize = new Dimension();
    private final Dimension maximumImageSize = new Dimension();

    public HotRegionImage(TIcon tIcon) {
        this(tIcon.getImage(), false);
    }

    public HotRegionImage(PIcon pIcon) {
        this(pIcon.getImage(), true);
    }

    HotRegionImage(Image image, boolean bl) {
        this.image = image;
        this.updateImageSize(bl);
    }

    private void updateImageSize(boolean bl) {
        int n = this.image.getWidth(null);
        int n2 = this.image.getHeight(null);
        if (n < 1 || n2 < 1) {
            this.image = null;
            this.actualImageSize.width = 0;
            this.actualImageSize.height = 0;
        } else {
            this.actualImageSize.width = n;
            this.actualImageSize.height = n2;
            if (bl) {
                this.setImageMaxSize(n, n2);
            } else {
                this.setImageMaxSize(GUI.getScaledDiagnosticInt((int)n), GUI.getScaledDiagnosticInt((int)n2));
            }
        }
    }

    private void setImageMaxSize(int n, int n2) {
        this.maximumImageSize.width = n;
        this.maximumImageSize.height = n2;
    }

    Image getImage() {
        return this.image;
    }

    int getImageMaxWidth() {
        return this.maximumImageSize.width;
    }

    int getImageMaxHeight() {
        return this.maximumImageSize.height;
    }

    Dimension calculateImageDimension(Rectangle rectangle) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = this.maximumImageSize.width;
        int n4 = this.maximumImageSize.height;
        float f = (float)this.actualImageSize.width / (float)this.actualImageSize.height;
        if (n3 > n) {
            n3 = n;
            n4 = Math.round((float)n3 / f);
        }
        if (n4 > n2) {
            n4 = n2;
            n3 = Math.round((float)n4 * f);
        }
        return new Dimension(n3, n4);
    }
}

