/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.controls.basic;

import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.utils.GuiUtil;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorProgressBar;
import java.awt.Color;
import javax.swing.border.LineBorder;

public class TProgressBar
extends MultiMonitorProgressBar {
    private static Color COLOR_BORDER = new Color(60, 60, 60);
    private static Color COLOR_PROG_NIMBUS = Color.white;
    private static Color COLOR_PROG_MONO = Color.lightGray;
    protected int min = 0;
    protected int max = 100;
    protected int val = 0;
    float t = 0.0f;
    String progressText = null;

    public TProgressBar() {
        super(0, 100);
        this.setVal(0);
        this.setBorder(new LineBorder(COLOR_BORDER));
        if (GuiUtil.isOnColorMonitor()) {
            this.setForeground(COLOR_PROG_NIMBUS);
        } else {
            this.setForeground(COLOR_PROG_MONO);
        }
        ComponentFactory.instance.scaleFont(this);
        this.setOpaque(false);
    }

    public void setShowProgressText(boolean bl) {
        this.setStringPainted(bl);
        this.repaint();
    }

    public void setProgressText(String string) {
        this.progressText = string;
    }

    public float getFloatVal() {
        return this.t;
    }

    private String getValStr() {
        if (this.progressText == null) {
            return String.valueOf(Math.round(this.t * 100.0f)) + " %";
        }
        return String.valueOf(this.progressText) + " " + Math.round(this.t * 100.0f) + " %";
    }

    public void setVal(int n) {
        if (n < this.min) {
            n = this.min;
        }
        if (n > this.max) {
            n = this.max;
        }
        this.val = n;
        this.t = (float)(n - this.min) / (float)(this.max - this.min);
        this.setValue(n);
        this.setString(this.getValStr());
        this.repaint();
    }

    public void setPercentage(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.t = f;
        this.val = Math.round((float)this.min + (float)(this.max - this.min) * this.t);
        this.setValue(this.val);
        this.setString(this.getValStr());
        this.repaint();
    }

    @Override
    public void setMaximum(int n) {
        super.setMaximum(n);
        this.max = n;
    }

    @Override
    public void setMinimum(int n) {
        super.setMinimum(n);
        this.min = n;
    }
}

