/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.config.xml.minijaxb;

import com.agfa.pacs.base.swing.util.FileFilterUtil;
import com.agfa.pacs.base.util.PasswordUtility;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.model.xml.shared.AbstractReferencedDescriptorsContainer;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.ExportParameter;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlLoadable;
import com.tiani.config.xml.minijaxb.XmlLoader;
import java.awt.Component;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public abstract class AbstractXmlFileLoader {
    private static final ALogger log = ALogger.getLogger(AbstractXmlFileLoader.class);
    private final ExportParameter param;
    private final String fileExtension;

    public AbstractXmlFileLoader(ExportParameter exportParameter, String string) {
        this.param = exportParameter;
        this.fileExtension = string;
    }

    private File showImportFileChooser(Component component, File file) {
        JFileChooser jFileChooser = file == null || !file.canRead() ? new JFileChooser() : new JFileChooser(file);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(FileFilterUtil.createFileFilter((String)this.fileExtension));
        jFileChooser.setDialogTitle(Messages.getString("AbstractXmlFileLoader.FileChooser.DialogTitle"));
        int n = jFileChooser.showDialog(component, Messages.getString("AbstractXmlFileLoader.FileChooser.ConfirmButtonText"));
        if (n != 0) {
            return null;
        }
        return jFileChooser.getSelectedFile();
    }

    public boolean importFromFile(File file) {
        if (file.exists()) {
            return this.importFromFile(null, file, false);
        }
        return false;
    }

    private boolean importFromFile(Component component, File file, boolean bl) {
        XmlLoadable xmlLoadable;
        block23: {
            log.debug("Importing XML configuration from file: " + file.getAbsolutePath());
            xmlLoadable = null;
            FilterInputStream filterInputStream = null;
            try {
                filterInputStream = new DataInputStream(new FileInputStream(file));
                int n = ((DataInputStream)filterInputStream).readInt();
                if (n == this.param.getVersionID()) {
                    int n2 = ((DataInputStream)filterInputStream).readInt();
                    byte[] byArray = new byte[n2];
                    ((DataInputStream)filterInputStream).read(byArray);
                    int n3 = ((DataInputStream)filterInputStream).readInt();
                    byte[] byArray2 = new byte[n3];
                    ((DataInputStream)filterInputStream).read(byArray2);
                    filterInputStream.close();
                    byte[] byArray3 = PasswordUtility.calcSMD5((byte[])byArray2, (byte[])this.param.getSalt());
                    if (Arrays.equals(byArray, byArray3)) {
                        String string = new String(byArray2, StandardCharsets.UTF_8);
                        AbstractReferencedDescriptorsContainer.ignoreUnregisteredDescriptors = false;
                        xmlLoadable = (XmlLoadable)new XmlLoader().load(string, this.getXmlLoadableClass());
                        AbstractReferencedDescriptorsContainer.ignoreUnregisteredDescriptors = true;
                        if (xmlLoadable == null) {
                            throw new MarshalException("Empty XML data.");
                        }
                    } else {
                        this.showErrorDialog(component, bl, "CorruptedFile");
                        log.error("Error parsing XML file: The file is corrupted.");
                    }
                } else {
                    this.showErrorDialog(component, bl, "NotSupportedVersion");
                    log.error("Error parsing XML file: wrong version " + n);
                }
            }
            catch (MarshalException marshalException) {
                this.showErrorDialog(component, bl, "Parse");
                log.error("Error parsing XML file", (Throwable)marshalException);
                if (filterInputStream != null) {
                    try {
                        filterInputStream.close();
                    }
                    catch (IOException iOException) {
                        log.debug("Closing stream failed.", (Throwable)iOException);
                    }
                }
                break block23;
            }
            catch (Exception exception) {
                try {
                    this.showErrorDialog(component, bl, "General");
                    log.error("Error while importing XML file", (Throwable)exception);
                    break block23;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (filterInputStream != null) {
                        try {
                            filterInputStream.close();
                        }
                        catch (IOException iOException) {
                            log.debug("Closing stream failed.", (Throwable)iOException);
                        }
                    }
                }
            }
            if (filterInputStream == null) break block23;
            try {
                filterInputStream.close();
            }
            catch (IOException iOException) {
                log.debug("Closing stream failed.", (Throwable)iOException);
            }
        }
        if (xmlLoadable == null) {
            return false;
        }
        return this.importSelectedXmlData(component, xmlLoadable, bl);
    }

    private void showErrorDialog(Component component, boolean bl, String string) {
        if (bl) {
            JOptionPane.showMessageDialog(component, Messages.getString("AbstractXmlFileLoader.Error." + string + ".Message"), Messages.getString("AbstractXmlFileLoader.Error." + string + ".Title"), 0);
        }
    }

    protected abstract boolean importSelectedXmlData(Component var1, XmlLoadable var2, boolean var3);

    protected abstract Class<? extends XmlLoadable> getXmlLoadableClass();

    public File chooseFileAndImport(Component component, File file) {
        File file2 = this.showImportFileChooser(component, file);
        if (file2 == null) {
            return null;
        }
        this.importFromFile(component, file2, true);
        return file2.getParentFile();
    }
}

